/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import org.apache.lucene.search.ScoreDoc;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.search.RescoreDocIds;
import org.opensearch.search.dfs.AggregatedDfs;
import org.opensearch.search.fetch.ShardFetchRequest;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;

public class ShardFetchSearchRequest
extends ShardFetchRequest
implements IndicesRequest {
    private final OriginalIndices originalIndices;
    private final ShardSearchRequest shardSearchRequest;
    private final RescoreDocIds rescoreDocIds;
    private final AggregatedDfs aggregatedDfs;

    public ShardFetchSearchRequest(OriginalIndices originalIndices, ShardSearchContextId id, ShardSearchRequest shardSearchRequest, IntArrayList list, ScoreDoc lastEmittedDoc, RescoreDocIds rescoreDocIds, AggregatedDfs aggregatedDfs) {
        super(id, list, lastEmittedDoc);
        this.originalIndices = originalIndices;
        this.shardSearchRequest = shardSearchRequest;
        this.rescoreDocIds = rescoreDocIds;
        this.aggregatedDfs = aggregatedDfs;
    }

    public ShardFetchSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_10_0)) {
            this.shardSearchRequest = (ShardSearchRequest)in.readOptionalWriteable(ShardSearchRequest::new);
            this.rescoreDocIds = new RescoreDocIds(in);
            this.aggregatedDfs = (AggregatedDfs)in.readOptionalWriteable(AggregatedDfs::new);
        } else {
            this.shardSearchRequest = null;
            this.rescoreDocIds = RescoreDocIds.EMPTY;
            this.aggregatedDfs = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_10_0)) {
            out.writeOptionalWriteable((Writeable)this.shardSearchRequest);
            this.rescoreDocIds.writeTo(out);
            out.writeOptionalWriteable((Writeable)this.aggregatedDfs);
        }
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    @Override
    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    @Override
    public RescoreDocIds getRescoreDocIds() {
        return this.rescoreDocIds;
    }

    @Override
    public AggregatedDfs getAggregatedDfs() {
        return this.aggregatedDfs;
    }
}

