/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.common.xyshape;

import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;

public class XYShapeConverter {
    public static XYLine toXYLine(@NonNull Line line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        float[] x = XYShapeConverter.toFloatArray(line.getX());
        float[] y = XYShapeConverter.toFloatArray(line.getY());
        return new XYLine(x, y);
    }

    public static XYPolygon toXYPolygon(@NonNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("rectangle is marked non-null but is null");
        }
        double[] x = new double[]{rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMaxX(), rectangle.getMinX(), rectangle.getMinX()};
        double[] y = new double[]{rectangle.getMinY(), rectangle.getMinY(), rectangle.getMaxY(), rectangle.getMaxY(), rectangle.getMinY()};
        return new XYPolygon(XYShapeConverter.toFloatArray(x), XYShapeConverter.toFloatArray(y), new XYPolygon[0]);
    }

    public static XYPolygon toXYPolygon(@NonNull Polygon polygon) {
        if (polygon == null) {
            throw new NullPointerException("polygon is marked non-null but is null");
        }
        XYPolygon[] holes = XYShapeConverter.extractXYPolygonsFromHoles(polygon);
        LinearRing line = polygon.getPolygon();
        XYLine polygonLine = XYShapeConverter.toXYLine((Line)line);
        return new XYPolygon(polygonLine.getX(), polygonLine.getY(), holes);
    }

    public static XYCircle toXYCircle(@NonNull Circle circle) {
        if (circle == null) {
            throw new NullPointerException("circle is marked non-null but is null");
        }
        return new XYCircle(Double.valueOf(circle.getX()).floatValue(), Double.valueOf(circle.getY()).floatValue(), Double.valueOf(circle.getRadiusMeters()).floatValue());
    }

    public static XYPoint toXYPoint(@NonNull Point point) {
        if (point == null) {
            throw new NullPointerException("point is marked non-null but is null");
        }
        float x = Double.valueOf(point.getX()).floatValue();
        float y = Double.valueOf(point.getY()).floatValue();
        return new XYPoint(x, y);
    }

    public static XYRectangle toXYRectangle(@NonNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("rectangle is marked non-null but is null");
        }
        float minX = Double.valueOf(rectangle.getMinX()).floatValue();
        float maxX = Double.valueOf(rectangle.getMaxX()).floatValue();
        float minY = Double.valueOf(rectangle.getMinY()).floatValue();
        float maxY = Double.valueOf(rectangle.getMaxY()).floatValue();
        return new XYRectangle(minX, maxX, minY, maxY);
    }

    private static XYPolygon[] extractXYPolygonsFromHoles(Polygon polygon) {
        return (XYPolygon[])IntStream.range(0, polygon.getNumberOfHoles()).mapToObj(arg_0 -> ((Polygon)polygon).getHole(arg_0)).map(XYShapeConverter::toXYLine).map(line -> new XYPolygon(line.getX(), line.getY(), new XYPolygon[0])).collect(Collectors.toList()).toArray(XYPolygon[]::new);
    }

    private static float[] toFloatArray(double[] input) {
        Float[] floatRefArray = (Float[])DoubleStream.of(input).boxed().map(Double::floatValue).toArray(Float[]::new);
        return ArrayUtils.toPrimitive((Float[])floatRefArray);
    }

    @Generated
    private XYShapeConverter() {
    }
}

