/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.plugin;

import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.inject.Injector;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.exception.UnsupportedCursorRequestException;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.opensearch.security.SecurityAccess;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.CommandResponseFormatter;
import org.opensearch.sql.protocol.response.format.CsvResponseFormatter;
import org.opensearch.sql.protocol.response.format.Format;
import org.opensearch.sql.protocol.response.format.JdbcResponseFormatter;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.RawResponseFormatter;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;
import org.opensearch.sql.sql.SQLService;
import org.opensearch.sql.sql.domain.SQLQueryRequest;

public class RestSQLQueryAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger();
    public static final BaseRestHandler.RestChannelConsumer NOT_SUPPORTED_YET = null;
    private final Injector injector;

    public RestSQLQueryAction(Injector injector) {
        this.injector = injector;
    }

    public String getName() {
        return "sql_query_action";
    }

    public List<RestHandler.Route> routes() {
        throw new UnsupportedOperationException("New SQL handler is not ready yet");
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) {
        throw new UnsupportedOperationException("New SQL handler is not ready yet");
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(SQLQueryRequest request, BiConsumer<RestChannel, Exception> fallbackHandler, BiConsumer<RestChannel, Exception> executionErrorHandler) {
        if (!request.isSupported()) {
            return channel -> fallbackHandler.accept((RestChannel)channel, new IllegalStateException("not supported"));
        }
        SQLService sqlService = (SQLService)SecurityAccess.doPrivileged(() -> (SQLService)this.injector.getInstance(SQLService.class));
        if (request.isExplainRequest()) {
            return channel -> sqlService.explain(request, this.fallBackListener((RestChannel)channel, (ResponseListener)this.createExplainResponseListener((RestChannel)channel, executionErrorHandler), fallbackHandler));
        }
        return channel -> sqlService.execute(request, this.fallBackListener((RestChannel)channel, (ResponseListener)this.createQueryResponseListener((RestChannel)channel, request, executionErrorHandler), fallbackHandler));
    }

    private <T> ResponseListener<T> fallBackListener(final RestChannel channel, final ResponseListener<T> next, final BiConsumer<RestChannel, Exception> fallBackHandler) {
        return new ResponseListener<T>(){

            public void onResponse(T response) {
                LOG.info("[{}] Request is handled by new SQL query engine", (Object)QueryContext.getRequestId());
                next.onResponse(response);
            }

            public void onFailure(Exception e) {
                if (e instanceof SyntaxCheckException || e instanceof UnsupportedCursorRequestException) {
                    fallBackHandler.accept(channel, e);
                } else {
                    next.onFailure(e);
                }
            }
        };
    }

    private ResponseListener<ExecutionEngine.ExplainResponse> createExplainResponseListener(final RestChannel channel, final BiConsumer<RestChannel, Exception> errorHandler) {
        return new ResponseListener<ExecutionEngine.ExplainResponse>(){

            public void onResponse(ExecutionEngine.ExplainResponse response) {
                JsonResponseFormatter<ExecutionEngine.ExplainResponse> formatter = new JsonResponseFormatter<ExecutionEngine.ExplainResponse>(JsonResponseFormatter.Style.PRETTY){

                    protected Object buildJsonObject(ExecutionEngine.ExplainResponse response) {
                        return response;
                    }
                };
                RestSQLQueryAction.this.sendResponse(channel, RestStatus.OK, formatter.format((Object)response), formatter.contentType());
            }

            public void onFailure(Exception e) {
                errorHandler.accept(channel, e);
            }
        };
    }

    private ResponseListener<ExecutionEngine.QueryResponse> createQueryResponseListener(final RestChannel channel, SQLQueryRequest request, BiConsumer<RestChannel, Exception> errorHandler) {
        Format format = request.format();
        Object formatter = request.isCursorCloseRequest() ? new CommandResponseFormatter() : (format.equals((Object)Format.CSV) ? new CsvResponseFormatter(request.sanitize()) : (format.equals((Object)Format.RAW) ? new RawResponseFormatter() : new JdbcResponseFormatter(JsonResponseFormatter.Style.PRETTY)));
        return new ResponseListener<ExecutionEngine.QueryResponse>((ResponseFormatter)formatter, errorHandler){
            final /* synthetic */ ResponseFormatter val$formatter;
            final /* synthetic */ BiConsumer val$errorHandler;
            {
                this.val$formatter = responseFormatter;
                this.val$errorHandler = biConsumer;
            }

            public void onResponse(ExecutionEngine.QueryResponse response) {
                RestSQLQueryAction.this.sendResponse(channel, RestStatus.OK, this.val$formatter.format((Object)new QueryResult(response.getSchema(), (Collection)response.getResults(), response.getCursor())), this.val$formatter.contentType());
            }

            public void onFailure(Exception e) {
                this.val$errorHandler.accept(channel, e);
            }
        };
    }

    private void sendResponse(RestChannel channel, RestStatus status, String content, String contentType) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, contentType, content));
    }

    private static void logAndPublishMetrics(Exception e) {
        LOG.error("Server side error during query execution", (Throwable)e);
        Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
    }
}

