/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.framelist;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.framelist.OWLFrameListPopupMenuAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class MoveAxiomsToOntologyAction<R>
extends OWLFrameListPopupMenuAction<R> {
    @Override
    protected String getName() {
        return "Move axiom(s) to ontology...";
    }

    @Override
    protected void initialise() throws Exception {
    }

    @Override
    protected void dispose() throws Exception {
    }

    @Override
    protected void updateState() {
        this.setEnabled(this.getState());
    }

    private boolean getState() {
        Object[] sel = this.getFrameList().getSelectedValues();
        boolean isEnabled = sel.length > 0;
        for (Object val : sel) {
            if (!(val instanceof OWLFrameSectionRow)) {
                return false;
            }
            if (((OWLFrameSectionRow)val).getOntology() != null) continue;
            return false;
        }
        return isEnabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OWLOntology ont = new UIHelper(this.getOWLEditorKit()).pickOWLOntology();
        if (ont != null) {
            this.moveAxiomsToOntology(ont);
        }
    }

    public void ontologySelected(OWLOntology ontology) {
        this.moveAxiomsToOntology(ontology);
    }

    private void moveAxiomsToOntology(OWLOntology ontology) {
        ArrayList<Object> changes = new ArrayList<Object>();
        for (OWLFrameSectionRow row : this.getSelectedRows()) {
            OWLAxiom ax = row.getAxiom();
            OWLOntology currentOnt = row.getOntology();
            changes.add(new RemoveAxiom(currentOnt, ax));
            changes.add(new AddAxiom(ontology, ax));
        }
        this.getOWLModelManager().applyChanges(changes);
    }
}

