"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HookStatus = exports.StackDriftStatus = exports.StackDriftDetectionStatus = exports.PublisherStatus = exports.IdentityProvider = exports.OrganizationStatus = exports.RegistryType = exports.StackSetNotEmptyException = exports.InvalidChangeSetStatusException = exports.NameAlreadyExistsException = exports.PermissionModels = exports.CreatedButModifiedException = exports.StaleRequestException = exports.StackSetNotFoundException = exports.OperationInProgressException = exports.OperationIdAlreadyExistsException = exports.RegionConcurrencyType = exports.OnFailure = exports.LimitExceededException = exports.InsufficientCapabilitiesException = exports.OnStackFailure = exports.ChangeSetType = exports.ExecutionStatus = exports.ChangeSetStatus = exports.ChangeSetNotFoundException = exports.ChangeSetHooksStatus = exports.HookTargetType = exports.HookInvocationPoint = exports.HookFailureMode = exports.ChangeType = exports.Replacement = exports.RequiresRecreation = exports.ResourceAttribute = exports.EvaluationType = exports.ChangeSource = exports.ChangeAction = exports.Category = exports.Capability = exports.TokenAlreadyExistsException = exports.CallAs = exports.TypeConfigurationNotFoundException = exports.AlreadyExistsException = exports.TypeNotFoundException = exports.CFNRegistryException = exports.VersionBump = exports.ThirdPartyType = exports.OperationNotFoundException = exports.InvalidOperationException = exports.AccountGateStatus = exports.AccountFilterType = void 0;
exports.ResourceSignalStatus = exports.HandlerErrorCode = exports.OperationStatus = exports.OperationStatusCheckFailedException = exports.InvalidStateTransitionException = exports.StackSetOperationResultStatus = exports.OperationResultFilterName = exports.StackInstanceFilterName = exports.StackNotFoundException = exports.TemplateStage = exports.RegistrationStatus = exports.Visibility = exports.TypeTestsStatus = exports.ProvisioningType = exports.DeprecatedStatus = exports.StackSetOperationStatus = exports.StackSetOperationAction = exports.StackSetStatus = exports.StackSetDriftStatus = exports.StackSetDriftDetectionStatus = exports.StackStatus = exports.DifferenceType = exports.StackResourceDriftStatus = exports.StackInstanceNotFoundException = exports.StackInstanceStatus = exports.StackInstanceDetailedStatus = exports.ResourceStatus = void 0;
const CloudFormationServiceException_1 = require("./CloudFormationServiceException");
exports.AccountFilterType = {
    DIFFERENCE: "DIFFERENCE",
    INTERSECTION: "INTERSECTION",
    NONE: "NONE",
    UNION: "UNION",
};
exports.AccountGateStatus = {
    FAILED: "FAILED",
    SKIPPED: "SKIPPED",
    SUCCEEDED: "SUCCEEDED",
};
class InvalidOperationException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "InvalidOperationException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOperationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOperationException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidOperationException = InvalidOperationException;
class OperationNotFoundException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "OperationNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.OperationNotFoundException = OperationNotFoundException;
exports.ThirdPartyType = {
    HOOK: "HOOK",
    MODULE: "MODULE",
    RESOURCE: "RESOURCE",
};
exports.VersionBump = {
    MAJOR: "MAJOR",
    MINOR: "MINOR",
};
class CFNRegistryException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "CFNRegistryException",
            $fault: "client",
            ...opts,
        });
        this.name = "CFNRegistryException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CFNRegistryException.prototype);
        this.Message = opts.Message;
    }
}
exports.CFNRegistryException = CFNRegistryException;
class TypeNotFoundException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "TypeNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "TypeNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TypeNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.TypeNotFoundException = TypeNotFoundException;
class AlreadyExistsException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.AlreadyExistsException = AlreadyExistsException;
class TypeConfigurationNotFoundException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "TypeConfigurationNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "TypeConfigurationNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TypeConfigurationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.TypeConfigurationNotFoundException = TypeConfigurationNotFoundException;
exports.CallAs = {
    DELEGATED_ADMIN: "DELEGATED_ADMIN",
    SELF: "SELF",
};
class TokenAlreadyExistsException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "TokenAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "TokenAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TokenAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.TokenAlreadyExistsException = TokenAlreadyExistsException;
exports.Capability = {
    CAPABILITY_AUTO_EXPAND: "CAPABILITY_AUTO_EXPAND",
    CAPABILITY_IAM: "CAPABILITY_IAM",
    CAPABILITY_NAMED_IAM: "CAPABILITY_NAMED_IAM",
};
exports.Category = {
    ACTIVATED: "ACTIVATED",
    AWS_TYPES: "AWS_TYPES",
    REGISTERED: "REGISTERED",
    THIRD_PARTY: "THIRD_PARTY",
};
exports.ChangeAction = {
    Add: "Add",
    Dynamic: "Dynamic",
    Import: "Import",
    Modify: "Modify",
    Remove: "Remove",
};
exports.ChangeSource = {
    Automatic: "Automatic",
    DirectModification: "DirectModification",
    ParameterReference: "ParameterReference",
    ResourceAttribute: "ResourceAttribute",
    ResourceReference: "ResourceReference",
};
exports.EvaluationType = {
    Dynamic: "Dynamic",
    Static: "Static",
};
exports.ResourceAttribute = {
    CreationPolicy: "CreationPolicy",
    DeletionPolicy: "DeletionPolicy",
    Metadata: "Metadata",
    Properties: "Properties",
    Tags: "Tags",
    UpdatePolicy: "UpdatePolicy",
};
exports.RequiresRecreation = {
    Always: "Always",
    Conditionally: "Conditionally",
    Never: "Never",
};
exports.Replacement = {
    Conditional: "Conditional",
    False: "False",
    True: "True",
};
exports.ChangeType = {
    Resource: "Resource",
};
exports.HookFailureMode = {
    FAIL: "FAIL",
    WARN: "WARN",
};
exports.HookInvocationPoint = {
    PRE_PROVISION: "PRE_PROVISION",
};
exports.HookTargetType = {
    RESOURCE: "RESOURCE",
};
exports.ChangeSetHooksStatus = {
    PLANNED: "PLANNED",
    PLANNING: "PLANNING",
    UNAVAILABLE: "UNAVAILABLE",
};
class ChangeSetNotFoundException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "ChangeSetNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ChangeSetNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ChangeSetNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.ChangeSetNotFoundException = ChangeSetNotFoundException;
exports.ChangeSetStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    CREATE_PENDING: "CREATE_PENDING",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    DELETE_PENDING: "DELETE_PENDING",
    FAILED: "FAILED",
};
exports.ExecutionStatus = {
    AVAILABLE: "AVAILABLE",
    EXECUTE_COMPLETE: "EXECUTE_COMPLETE",
    EXECUTE_FAILED: "EXECUTE_FAILED",
    EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS",
    OBSOLETE: "OBSOLETE",
    UNAVAILABLE: "UNAVAILABLE",
};
exports.ChangeSetType = {
    CREATE: "CREATE",
    IMPORT: "IMPORT",
    UPDATE: "UPDATE",
};
exports.OnStackFailure = {
    DELETE: "DELETE",
    DO_NOTHING: "DO_NOTHING",
    ROLLBACK: "ROLLBACK",
};
class InsufficientCapabilitiesException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "InsufficientCapabilitiesException",
            $fault: "client",
            ...opts,
        });
        this.name = "InsufficientCapabilitiesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InsufficientCapabilitiesException.prototype);
        this.Message = opts.Message;
    }
}
exports.InsufficientCapabilitiesException = InsufficientCapabilitiesException;
class LimitExceededException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.LimitExceededException = LimitExceededException;
exports.OnFailure = {
    DELETE: "DELETE",
    DO_NOTHING: "DO_NOTHING",
    ROLLBACK: "ROLLBACK",
};
exports.RegionConcurrencyType = {
    PARALLEL: "PARALLEL",
    SEQUENTIAL: "SEQUENTIAL",
};
class OperationIdAlreadyExistsException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "OperationIdAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationIdAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationIdAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.OperationIdAlreadyExistsException = OperationIdAlreadyExistsException;
class OperationInProgressException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "OperationInProgressException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationInProgressException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationInProgressException.prototype);
        this.Message = opts.Message;
    }
}
exports.OperationInProgressException = OperationInProgressException;
class StackSetNotFoundException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "StackSetNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackSetNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackSetNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.StackSetNotFoundException = StackSetNotFoundException;
class StaleRequestException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "StaleRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "StaleRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StaleRequestException.prototype);
        this.Message = opts.Message;
    }
}
exports.StaleRequestException = StaleRequestException;
class CreatedButModifiedException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "CreatedButModifiedException",
            $fault: "client",
            ...opts,
        });
        this.name = "CreatedButModifiedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CreatedButModifiedException.prototype);
        this.Message = opts.Message;
    }
}
exports.CreatedButModifiedException = CreatedButModifiedException;
exports.PermissionModels = {
    SELF_MANAGED: "SELF_MANAGED",
    SERVICE_MANAGED: "SERVICE_MANAGED",
};
class NameAlreadyExistsException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "NameAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "NameAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NameAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.NameAlreadyExistsException = NameAlreadyExistsException;
class InvalidChangeSetStatusException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "InvalidChangeSetStatusException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidChangeSetStatusException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidChangeSetStatusException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidChangeSetStatusException = InvalidChangeSetStatusException;
class StackSetNotEmptyException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "StackSetNotEmptyException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackSetNotEmptyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackSetNotEmptyException.prototype);
        this.Message = opts.Message;
    }
}
exports.StackSetNotEmptyException = StackSetNotEmptyException;
exports.RegistryType = {
    HOOK: "HOOK",
    MODULE: "MODULE",
    RESOURCE: "RESOURCE",
};
exports.OrganizationStatus = {
    DISABLED: "DISABLED",
    DISABLED_PERMANENTLY: "DISABLED_PERMANENTLY",
    ENABLED: "ENABLED",
};
exports.IdentityProvider = {
    AWS_Marketplace: "AWS_Marketplace",
    Bitbucket: "Bitbucket",
    GitHub: "GitHub",
};
exports.PublisherStatus = {
    UNVERIFIED: "UNVERIFIED",
    VERIFIED: "VERIFIED",
};
exports.StackDriftDetectionStatus = {
    DETECTION_COMPLETE: "DETECTION_COMPLETE",
    DETECTION_FAILED: "DETECTION_FAILED",
    DETECTION_IN_PROGRESS: "DETECTION_IN_PROGRESS",
};
exports.StackDriftStatus = {
    DRIFTED: "DRIFTED",
    IN_SYNC: "IN_SYNC",
    NOT_CHECKED: "NOT_CHECKED",
    UNKNOWN: "UNKNOWN",
};
exports.HookStatus = {
    HOOK_COMPLETE_FAILED: "HOOK_COMPLETE_FAILED",
    HOOK_COMPLETE_SUCCEEDED: "HOOK_COMPLETE_SUCCEEDED",
    HOOK_FAILED: "HOOK_FAILED",
    HOOK_IN_PROGRESS: "HOOK_IN_PROGRESS",
};
exports.ResourceStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    DELETE_SKIPPED: "DELETE_SKIPPED",
    IMPORT_COMPLETE: "IMPORT_COMPLETE",
    IMPORT_FAILED: "IMPORT_FAILED",
    IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
    IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
    IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
    IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
    ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
    ROLLBACK_FAILED: "ROLLBACK_FAILED",
    ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
    UPDATE_COMPLETE: "UPDATE_COMPLETE",
    UPDATE_FAILED: "UPDATE_FAILED",
    UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
    UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
    UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
    UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS",
};
exports.StackInstanceDetailedStatus = {
    CANCELLED: "CANCELLED",
    FAILED: "FAILED",
    INOPERABLE: "INOPERABLE",
    PENDING: "PENDING",
    RUNNING: "RUNNING",
    SKIPPED_SUSPENDED_ACCOUNT: "SKIPPED_SUSPENDED_ACCOUNT",
    SUCCEEDED: "SUCCEEDED",
};
exports.StackInstanceStatus = {
    CURRENT: "CURRENT",
    INOPERABLE: "INOPERABLE",
    OUTDATED: "OUTDATED",
};
class StackInstanceNotFoundException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "StackInstanceNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackInstanceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackInstanceNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.StackInstanceNotFoundException = StackInstanceNotFoundException;
exports.StackResourceDriftStatus = {
    DELETED: "DELETED",
    IN_SYNC: "IN_SYNC",
    MODIFIED: "MODIFIED",
    NOT_CHECKED: "NOT_CHECKED",
};
exports.DifferenceType = {
    ADD: "ADD",
    NOT_EQUAL: "NOT_EQUAL",
    REMOVE: "REMOVE",
};
exports.StackStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    IMPORT_COMPLETE: "IMPORT_COMPLETE",
    IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
    IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
    IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
    IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
    REVIEW_IN_PROGRESS: "REVIEW_IN_PROGRESS",
    ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
    ROLLBACK_FAILED: "ROLLBACK_FAILED",
    ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
    UPDATE_COMPLETE: "UPDATE_COMPLETE",
    UPDATE_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS",
    UPDATE_FAILED: "UPDATE_FAILED",
    UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
    UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
    UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS",
    UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
    UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS",
};
exports.StackSetDriftDetectionStatus = {
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    PARTIAL_SUCCESS: "PARTIAL_SUCCESS",
    STOPPED: "STOPPED",
};
exports.StackSetDriftStatus = {
    DRIFTED: "DRIFTED",
    IN_SYNC: "IN_SYNC",
    NOT_CHECKED: "NOT_CHECKED",
};
exports.StackSetStatus = {
    ACTIVE: "ACTIVE",
    DELETED: "DELETED",
};
exports.StackSetOperationAction = {
    CREATE: "CREATE",
    DELETE: "DELETE",
    DETECT_DRIFT: "DETECT_DRIFT",
    UPDATE: "UPDATE",
};
exports.StackSetOperationStatus = {
    FAILED: "FAILED",
    QUEUED: "QUEUED",
    RUNNING: "RUNNING",
    STOPPED: "STOPPED",
    STOPPING: "STOPPING",
    SUCCEEDED: "SUCCEEDED",
};
exports.DeprecatedStatus = {
    DEPRECATED: "DEPRECATED",
    LIVE: "LIVE",
};
exports.ProvisioningType = {
    FULLY_MUTABLE: "FULLY_MUTABLE",
    IMMUTABLE: "IMMUTABLE",
    NON_PROVISIONABLE: "NON_PROVISIONABLE",
};
exports.TypeTestsStatus = {
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    NOT_TESTED: "NOT_TESTED",
    PASSED: "PASSED",
};
exports.Visibility = {
    PRIVATE: "PRIVATE",
    PUBLIC: "PUBLIC",
};
exports.RegistrationStatus = {
    COMPLETE: "COMPLETE",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
exports.TemplateStage = {
    Original: "Original",
    Processed: "Processed",
};
class StackNotFoundException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "StackNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "StackNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, StackNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.StackNotFoundException = StackNotFoundException;
exports.StackInstanceFilterName = {
    DETAILED_STATUS: "DETAILED_STATUS",
    DRIFT_STATUS: "DRIFT_STATUS",
    LAST_OPERATION_ID: "LAST_OPERATION_ID",
};
exports.OperationResultFilterName = {
    OPERATION_RESULT_STATUS: "OPERATION_RESULT_STATUS",
};
exports.StackSetOperationResultStatus = {
    CANCELLED: "CANCELLED",
    FAILED: "FAILED",
    PENDING: "PENDING",
    RUNNING: "RUNNING",
    SUCCEEDED: "SUCCEEDED",
};
class InvalidStateTransitionException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "InvalidStateTransitionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidStateTransitionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidStateTransitionException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidStateTransitionException = InvalidStateTransitionException;
class OperationStatusCheckFailedException extends CloudFormationServiceException_1.CloudFormationServiceException {
    constructor(opts) {
        super({
            name: "OperationStatusCheckFailedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OperationStatusCheckFailedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OperationStatusCheckFailedException.prototype);
        this.Message = opts.Message;
    }
}
exports.OperationStatusCheckFailedException = OperationStatusCheckFailedException;
exports.OperationStatus = {
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    PENDING: "PENDING",
    SUCCESS: "SUCCESS",
};
exports.HandlerErrorCode = {
    AccessDenied: "AccessDenied",
    AlreadyExists: "AlreadyExists",
    GeneralServiceException: "GeneralServiceException",
    HandlerInternalFailure: "HandlerInternalFailure",
    InternalFailure: "InternalFailure",
    InvalidCredentials: "InvalidCredentials",
    InvalidRequest: "InvalidRequest",
    InvalidTypeConfiguration: "InvalidTypeConfiguration",
    NetworkFailure: "NetworkFailure",
    NonCompliant: "NonCompliant",
    NotFound: "NotFound",
    NotUpdatable: "NotUpdatable",
    ResourceConflict: "ResourceConflict",
    ServiceInternalError: "ServiceInternalError",
    ServiceLimitExceeded: "ServiceLimitExceeded",
    ServiceTimeout: "NotStabilized",
    Throttling: "Throttling",
    Unknown: "Unknown",
    UnsupportedTarget: "UnsupportedTarget",
};
exports.ResourceSignalStatus = {
    FAILURE: "FAILURE",
    SUCCESS: "SUCCESS",
};
