import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { EstimateTemplateCostInput, EstimateTemplateCostOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link EstimateTemplateCostCommand}.
 */
export interface EstimateTemplateCostCommandInput extends EstimateTemplateCostInput {
}
/**
 * @public
 *
 * The output of {@link EstimateTemplateCostCommand}.
 */
export interface EstimateTemplateCostCommandOutput extends EstimateTemplateCostOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly
 *    Calculator URL with a query string that describes the resources required to run the template.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, EstimateTemplateCostCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, EstimateTemplateCostCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // EstimateTemplateCostInput
 *   TemplateBody: "STRING_VALUE",
 *   TemplateURL: "STRING_VALUE",
 *   Parameters: [ // Parameters
 *     { // Parameter
 *       ParameterKey: "STRING_VALUE",
 *       ParameterValue: "STRING_VALUE",
 *       UsePreviousValue: true || false,
 *       ResolvedValue: "STRING_VALUE",
 *     },
 *   ],
 * };
 * const command = new EstimateTemplateCostCommand(input);
 * const response = await client.send(command);
 * // { // EstimateTemplateCostOutput
 * //   Url: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param EstimateTemplateCostCommandInput - {@link EstimateTemplateCostCommandInput}
 * @returns {@link EstimateTemplateCostCommandOutput}
 * @see {@link EstimateTemplateCostCommandInput} for command's `input` shape.
 * @see {@link EstimateTemplateCostCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class EstimateTemplateCostCommand extends $Command<EstimateTemplateCostCommandInput, EstimateTemplateCostCommandOutput, CloudFormationClientResolvedConfig> {
    readonly input: EstimateTemplateCostCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: EstimateTemplateCostCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudFormationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<EstimateTemplateCostCommandInput, EstimateTemplateCostCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
