import { YAMLError } from "yaml";
import { IModuleDocumentation, IModuleMetadata, IOption } from "../interfaces/module";
import { IPluginRoutesByType } from "../interfaces/pluginRouting";
export declare function processDocumentationFragments(module: IModuleMetadata, docFragments: Map<string, IModuleMetadata>): void;
export declare function processRawDocumentation(moduleDocParts: Map<string, Record<string, unknown>>): IModuleDocumentation | undefined;
export declare function processRawOptions(rawOptions: unknown): Map<string, IOption>;
export declare function parseRawRouting(rawDoc: unknown): IPluginRoutesByType;
export declare class LazyModuleDocumentation implements IModuleMetadata {
    static docsRegex: RegExp;
    source: string;
    sourceLineRange: [number, number];
    fqcn: string;
    namespace: string;
    collection: string;
    name: string;
    errors: YAMLError[];
    private _contents;
    constructor(source: string, fqcn: string, namespace: string, collection: string, name: string);
    get rawDocumentationFragments(): Map<string, Record<string, unknown>>;
    set rawDocumentationFragments(value: Map<string, Record<string, unknown>>);
}
