/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;

public class CtSym {
    private static final char JAVA_11 = 'B';
    public static final boolean DISABLE_CACHE = Boolean.getBoolean("org.eclipse.jdt.disable_CTSYM_cache");
    static boolean VERBOSE = false;
    private final Map<Path, Optional<byte[]>> fileCache = new ConcurrentHashMap<Path, Optional<byte[]>>(10007);
    private final Path jdkHome;
    private final Path ctSymFile;
    private FileSystem fs;
    Path root;
    private boolean isJRE12Plus;
    private final Map<String, List<Path>> releaseRootPaths = new ConcurrentHashMap<String, List<Path>>();
    private final Map<String, Map<String, Path>> allReleasesPaths = new ConcurrentHashMap<String, Map<String, Path>>();

    CtSym(Path path) throws IOException {
        this.jdkHome = path;
        this.ctSymFile = path.resolve("lib/ct.sym");
        this.init();
    }

    private void init() throws IOException {
        boolean bl = Files.exists(this.ctSymFile, new LinkOption[0]);
        if (!bl) {
            throw new FileNotFoundException("File " + this.ctSymFile + " does not exist");
        }
        FileSystem fileSystem = null;
        URI uRI = URI.create("jar:file:" + this.ctSymFile.toUri().getRawPath());
        try {
            fileSystem = FileSystems.getFileSystem(uRI);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileSystem == null) {
            try {
                fileSystem = FileSystems.newFileSystem(uRI, new HashMap(), ClassLoader.getSystemClassLoader());
            }
            catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                fileSystem = FileSystems.getFileSystem(uRI);
            }
            catch (ProviderNotFoundException providerNotFoundException) {
                throw new IOException("Failed to create ct.sym file system for " + this.ctSymFile, providerNotFoundException);
            }
        }
        this.fs = fileSystem;
        if (fileSystem == null) {
            throw new IOException("Failed to create ct.sym file system for " + this.ctSymFile);
        }
        this.root = fileSystem.getPath("/", new String[0]);
        this.isJRE12Plus = this.isCurrentRelease12plus();
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public boolean isJRE12Plus() {
        return this.isJRE12Plus;
    }

    public Path getRoot() {
        return this.root;
    }

    public List<Path> releaseRoots(String string) {
        List list = this.releaseRootPaths.computeIfAbsent(string, string2 -> {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.root);){
                for (Path path : directoryStream) {
                    String string3 = path.getFileName().toString();
                    if (string3.contains("-") || !string3.contains(string)) continue;
                    arrayList.add(path);
                }
            }
            catch (IOException iOException) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(arrayList);
        });
        return list;
    }

    public Path getFullPath(String string, String string2, String string3) {
        Path path;
        String string4 = this.fs.getSeparator();
        if (DISABLE_CACHE) {
            List<Path> list = this.releaseRoots(string);
            for (Path path2 : list) {
                Path path3 = null;
                if (this.isJRE12Plus()) {
                    if (string3 == null) {
                        string3 = this.getModuleInJre12plus(string, string2);
                    }
                    path3 = path2.resolve(string3 + string4 + string2);
                } else {
                    path3 = path2.resolve(string2);
                }
                if (!Files.exists(path3, new LinkOption[0])) continue;
                if (VERBOSE) {
                    System.out.println("found: " + string2 + " in " + path3 + " for module " + string3 + "\n");
                }
                return path3;
            }
            if (VERBOSE) {
                System.out.println("not found: " + string2 + " for module " + string3);
            }
            return null;
        }
        Map<String, Path> map = this.getCachedReleasePaths(string);
        if (string3 != null) {
            path = map.get(string3 + string4 + string2);
            if (path == null && !this.isJRE12Plus() && "A".equals(string)) {
                path = map.get(string2);
            }
        } else {
            path = map.get(string2);
        }
        if (VERBOSE) {
            if (path != null) {
                System.out.println("found: " + string2 + " in " + path + " for module " + string3 + "\n");
            } else {
                System.out.println("not found: " + string2 + " for module " + string3);
            }
        }
        return path;
    }

    public String getModuleInJre12plus(String string, String string2) {
        if (DISABLE_CACHE) {
            return this.findModuleForFileInJre12plus(string, string2);
        }
        Map<String, Path> map = this.getCachedReleasePaths(string);
        Path path = map.get(string2);
        if (path != null && path.getNameCount() > 2) {
            return path.getName(1).toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findModuleForFileInJre12plus(String string, String string2) {
        Iterator<Path> iterator = this.releaseRoots(string).iterator();
        block8: while (iterator.hasNext()) {
            Path path = iterator.next();
            try {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                try {
                    Path path2;
                    Path path3;
                    Iterator<Path> iterator2 = directoryStream.iterator();
                    do {
                        if (!iterator2.hasNext()) continue block8;
                    } while (!Files.exists(path3 = (path2 = iterator2.next()).resolve(string2), new LinkOption[0]) || path2.getNameCount() != 2);
                    String string3 = path2.getName(1).toString();
                    return string3;
                }
                finally {
                    if (directoryStream == null) continue;
                    directoryStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private Map<String, Path> getCachedReleasePaths(String string) {
        Map map = this.allReleasesPaths.computeIfAbsent(string, string2 -> {
            List<Path> list = this.releaseRoots(string);
            HashMap hashMap = new HashMap(4999);
            for (Path path2 : list) {
                try {
                    Files.walk(path2, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(path -> {
                        if (this.isJRE12Plus()) {
                            String string = path.subpath(2, path.getNameCount()).toString();
                            hashMap.put(string, path);
                            String string2 = path.subpath(1, path.getNameCount()).toString();
                            hashMap.put(string2, path);
                        } else {
                            String string = path.subpath(1, path.getNameCount()).toString();
                            hashMap.put(string, path);
                        }
                    });
                }
                catch (IOException iOException) {}
            }
            return Collections.unmodifiableMap(hashMap);
        });
        return map;
    }

    public byte[] getFileBytes(Path path2) throws IOException {
        if (DISABLE_CACHE) {
            return JRTUtil.safeReadBytes(path2);
        }
        Optional optional = this.fileCache.computeIfAbsent(path2, path -> {
            try {
                return Optional.ofNullable(JRTUtil.safeReadBytes(path));
            }
            catch (IOException iOException) {
                return Optional.empty();
            }
        });
        if (VERBOSE) {
            System.out.println("got bytes: " + path2);
        }
        return optional.orElse(null);
    }

    private boolean isCurrentRelease12plus() throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.root, path -> path.toString().length() == 2);){
            for (Path path2 : directoryStream) {
                String string = JRTUtil.sanitizedFileName(path2);
                if (string.length() != 1) continue;
                try {
                    char c = string.charAt(0);
                    if (c <= 'B' || !Files.exists(this.fs.getPath(string, "system-modules"), new LinkOption[0])) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return false;
    }

    public int hashCode() {
        return this.jdkHome.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CtSym)) {
            return false;
        }
        CtSym ctSym = (CtSym)object;
        return this.jdkHome.equals(ctSym.jdkHome);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CtSym [");
        stringBuilder.append("file=");
        stringBuilder.append(this.ctSymFile);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String getReleaseCode(String string) {
        int n = Integer.parseInt(string);
        if (n < 10) {
            return String.valueOf(n);
        }
        return String.valueOf((char)(65 + (n - 10)));
    }
}

