/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.compiler.util.CharArrayMapper;

public final class CharArrayMap<P>
implements CharArrayMapper<P> {
    private char[][] keyTable;
    private P[] valueTable;
    private int size;

    public CharArrayMap() {
        this(0);
    }

    public CharArrayMap(int n) {
        int n2 = n > 0 ? n : 0;
        this.size = 0;
        this.keyTable = new char[n2][];
        Object[] objectArray = new Object[n2];
        this.valueTable = objectArray;
    }

    @Override
    public Collection<P> values() {
        return Arrays.stream(this.valueTable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Collection<char[]> keys() {
        return Arrays.stream(this.keyTable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean containsKey(char[] cArray) {
        for (int i = 0; i < this.size; ++i) {
            if (!Arrays.equals(this.keyTable[i], cArray)) continue;
            return true;
        }
        return false;
    }

    @Override
    public P get(char[] cArray) {
        for (int i = 0; i < this.size; ++i) {
            if (!Arrays.equals(this.keyTable[i], cArray)) continue;
            return this.valueTable[i];
        }
        return null;
    }

    @Override
    public P put(char[] cArray, P p) {
        int n;
        for (n = 0; n < this.size; ++n) {
            if (!Arrays.equals(this.keyTable[n], cArray)) continue;
            P p2 = this.valueTable[n];
            this.valueTable[n] = p;
            return p2;
        }
        if (n >= this.keyTable.length) {
            this.grow();
        }
        this.keyTable[n] = cArray;
        this.valueTable[n] = p;
        ++this.size;
        return null;
    }

    void transferTo(CharArrayMapper<P> charArrayMapper) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keyTable[i] == null) continue;
            charArrayMapper.put(this.keyTable[i], this.valueTable[i]);
        }
    }

    private void grow() {
        int n = this.keyTable.length > 1 ? this.keyTable.length : 1;
        int n2 = n * 2;
        this.keyTable = (char[][])Arrays.copyOfRange(this.keyTable, 0, n2);
        this.valueTable = Arrays.copyOfRange(this.valueTable, 0, n2);
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }
}

