Object.assign(window.search, {"doc_urls":["introduction.html#a-syntax-highlighting-pager-for-git-diff-and-grep-output","get-started.html#get-started","features.html#features","installation.html#installation","configuration.html#configuration","configuration.html#git-config-file","environment-variables.html#environment-variables","environment-variables.html#git-environment-variables","environment-variables.html#pager-environment-variables","environment-variables.html#delta-specific-environment-variables","how-delta-works.html#how-delta-works","usage.html#usage","choosing-colors-styles.html#choosing-colors-styles","line-numbers.html#line-numbers","side-by-side-view.html#side-by-side-view","grep.html#grep","features-named-groups-of-settings.html#features-named-groups-of-settings","custom-themes.html#custom-themes","diff-highlight-and-diff-so-fancy-emulation.html#diff-highlight-and-diff-so-fancy-emulation","color-moved-support.html#--color-moved-support","navigation-keybindings-for-large-diffs.html#navigation-keybindings-for-large-diffs","merge-conflicts.html#merge-conflicts","git-blame.html#git-blame","supported-languages-and-themes.html#supported-languages-and-themes","tips-and-tricks.html#tips--tricks","tips-and-tricks/24-bit-color-truecolor.html#24-bit-color-truecolor","tips-and-tricks/mouse-scrolling.html#mouse-scrolling","tips-and-tricks/export-to-html.html#save-output-with-colors-to-htmlpdf-etc","tips-and-tricks/using-delta-on-windows.html#using-delta-on-windows","tips-and-tricks/using-delta-with-gnu-screen.html#using-delta-with-gnu-screen","tips-and-tricks/using-delta-with-magit.html#using-delta-with-magit","tips-and-tricks/using-delta-with-tmux.html#using-delta-with-tmux","tips-and-tricks/using-delta-with-vscode.html#using-delta-with-vscode","comparisons-with-other-tools.html#comparisons-with-other-tools","build-delta-from-source.html#build-delta-from-source","related-projects.html#related-projects","related-projects.html#used-by-delta","related-projects.html#using-delta","related-projects.html#similar-projects","full---help-output.html#full---help-output","delta-configs-used-in-screenshots.html#delta-configs-used-in-screenshots","delta-configs-used-in-screenshots.html#side-by-side-view"],"index":{"documentStore":{"docInfo":{"0":{"body":37,"breadcrumbs":8,"title":7},"1":{"body":20,"breadcrumbs":2,"title":1},"10":{"body":84,"breadcrumbs":4,"title":2},"11":{"body":66,"breadcrumbs":2,"title":1},"12":{"body":48,"breadcrumbs":7,"title":3},"13":{"body":25,"breadcrumbs":5,"title":2},"14":{"body":143,"breadcrumbs":7,"title":3},"15":{"body":150,"breadcrumbs":3,"title":1},"16":{"body":141,"breadcrumbs":9,"title":4},"17":{"body":119,"breadcrumbs":5,"title":2},"18":{"body":101,"breadcrumbs":11,"title":5},"19":{"body":275,"breadcrumbs":7,"title":3},"2":{"body":153,"breadcrumbs":2,"title":1},"20":{"body":29,"breadcrumbs":9,"title":4},"21":{"body":56,"breadcrumbs":5,"title":2},"22":{"body":20,"breadcrumbs":5,"title":2},"23":{"body":82,"breadcrumbs":7,"title":3},"24":{"body":0,"breadcrumbs":4,"title":2},"25":{"body":69,"breadcrumbs":10,"title":4},"26":{"body":45,"breadcrumbs":6,"title":2},"27":{"body":38,"breadcrumbs":12,"title":5},"28":{"body":28,"breadcrumbs":8,"title":3},"29":{"body":131,"breadcrumbs":10,"title":4},"3":{"body":176,"breadcrumbs":2,"title":1},"30":{"body":12,"breadcrumbs":8,"title":3},"31":{"body":56,"breadcrumbs":8,"title":3},"32":{"body":37,"breadcrumbs":8,"title":3},"33":{"body":14,"breadcrumbs":4,"title":2},"34":{"body":27,"breadcrumbs":6,"title":3},"35":{"body":0,"breadcrumbs":4,"title":2},"36":{"body":7,"breadcrumbs":4,"title":2},"37":{"body":9,"breadcrumbs":4,"title":2},"38":{"body":16,"breadcrumbs":4,"title":2},"39":{"body":3341,"breadcrumbs":6,"title":3},"4":{"body":0,"breadcrumbs":2,"title":1},"40":{"body":0,"breadcrumbs":8,"title":4},"41":{"body":67,"breadcrumbs":7,"title":3},"5":{"body":164,"breadcrumbs":4,"title":3},"6":{"body":0,"breadcrumbs":4,"title":2},"7":{"body":51,"breadcrumbs":5,"title":3},"8":{"body":173,"breadcrumbs":5,"title":3},"9":{"body":24,"breadcrumbs":6,"title":4}},"docs":{"0":{"body":"Code evolves, and we all spend time studying diffs. Delta aims to make this both efficient and enjoyable: it allows you to make extensive changes to the layout and styling of diffs, as well as allowing you to stay arbitrarily close to the default git/diff output. delta with line-numbers activated delta with side-by-side and line-numbers activated","breadcrumbs":"Introduction » A syntax-highlighting pager for git, diff, and grep output","id":"0","title":"A syntax-highlighting pager for git, diff, and grep output"},"1":{"body":"Install delta and add this to your ~/.gitconfig: [core] pager = delta [interactive] diffFilter = delta --color-only [delta] navigate = true [merge] conflictstyle = diff3 [diff] colorMoved = default","breadcrumbs":"Get started » Get started","id":"1","title":"Get started"},"10":{"body":"If you configure delta in gitconfig as above, then git will automatically send its output to delta. Delta in turn passes its own output on to a \"real\" pager. Note that git will only send its output to delta if git believes that its output is going to a terminal (a \"tty\") for a human to read. In other words, if you do something like git diff | grep ... then you don't have to worry about delta changing the output from git, because delta will never be invoked at all. If you need to force delta to be invoked when git itself would not invoke it, then you can always pipe to delta explicitly. For example, git diff | delta | something-that-expects-delta-output-with-colors (in this example, git's output is being sent to a pipe, so git itself will not invoke delta). In general however, delta's output is intended for humans, not machines. If you are interested in the implementation of delta, please see ARCHITECTURE.md .","breadcrumbs":"How delta works » How delta works","id":"10","title":"How delta works"},"11":{"body":"The main way to use delta is to configure it as the pager for git: see Configuration . Delta can also be used as a shorthand for diffing two files, even if they are not in a git repo: the following two commands do the same thing: delta /somewhere/a.txt /somewhere/else/b.txt git diff /somewhere/a.txt /somewhere/else/b.txt You can also use process substitution shell syntax with delta, e.g. delta <(sort file1) <(sort file2) In addition to git output, delta handles standard unified diff format, e.g. diff -u a.txt b.txt | delta. For Mercurial, you can add delta, with its command line options, to the [pager] section of .hgrc.","breadcrumbs":"Usage » Usage","id":"11","title":"Usage"},"12":{"body":"All options that have a name like --*-style work in the same way. It is very similar to how colors/styles are specified in a gitconfig file: https://git-scm.com/docs/git-config#Documentation/git-config.txt-color Here's an example: [delta] minus-style = red bold ul \"#ffeeee\" That means: For removed lines, set the foreground (text) color to 'red', make it bold and underlined, and set the background color to #ffeeee. For full details, see the STYLES section in delta --help .","breadcrumbs":"Usage » Choosing colors (styles) » Choosing colors (styles)","id":"12","title":"Choosing colors (styles)"},"13":{"body":"[delta] line-numbers = true The numbers are displayed in two columns and there are several configuration options: see the LINE NUMBERS section in delta --help for details, and see the next section for an example of configuring line numbers.","breadcrumbs":"Usage » Line numbers » Line numbers","id":"13","title":"Line numbers"},"14":{"body":"[delta] side-by-side = true By default, side-by-side view has line-numbers activated, and has syntax highlighting in both the left and right panels: [ config ] To activate and deactivate side-by-side view from the command line, consider using the DELTA_FEATURES environment variable. For example: export DELTA_FEATURES=+side-by-side # activate\nexport DELTA_FEATURES=+ # deactivate To disable the line numbers in side-by-side view, but keep a vertical delimiter line between the left and right panels, use the line-numbers format options. For example: [delta] side-by-side = true line-numbers-left-format = \"\" line-numbers-right-format = \"│ \" Long lines are wrapped if they do not fit in side-by-side mode. In the image below, the long deleted line in the left panel overflows by a small amount, and the wrapped content is right-aligned in the next line. In contrast, the long replacement line in the right panel overflows by almost an entire line, and so the wrapped content is left aligned in the next line. The arrow markers and ellipsis explain when and how text has been wrapped. For control over the details of line wrapping, see --wrap-max-lines, --wrap-left-symbol, --wrap-right-symbol, --wrap-right-percent, --wrap-right-prefix-symbol, --inline-hint-style. Line wrapping was implemented by @th1000s.","breadcrumbs":"Usage » Side-by-side view » Side-by-side view","id":"14","title":"Side-by-side view"},"15":{"body":"Delta applies syntax-highlighting and other enhancements to standard grep output such as from ripgrep (aka rg), git grep, grep, etc. If you don't need special features of git grep, then for best results pipe rg --json output to delta: this avoids parsing ambiguities that are inevitable with the output of git grep and grep. To customize the colors and syntax highlighting, see the grep-* options in delta --help. Note that git grep can display the \"function context\" for matches and that delta handles this output specially: see the -p and -W options of git grep. rg --json -C 2 handle | delta If you enable hyperlinks then grep hits will be formatted as OSC8 hyperlinks in terminal emulators that support the feature. If you're using VSCode, IntelliJ, or PyCharm, then use the dedicated URL handlers. I.e. one of the following lines: [delta] hyperlinks = true hyperlinks-file-link-format = \"vscode://file/{path}:{line}\" # or: hyperlinks-file-link-format = \"idea://open?file={path}&line={line}\" # or: hyperlinks-file-link-format = \"pycharm://open?file={path}&line={line}\" For editors that don't have special URL handlers, it is possible to use a tool like https://github.com/dandavison/open-in-editor/ to make your OS handle a click on those links by opening your editor at the correct file and line number, e.g. [delta] hyperlinks = true hyperlinks-file-link-format = \"file-line://{path}:{line}\" # Now configure your OS to handle \"file-line\" URLs","breadcrumbs":"Usage » Grep » Grep","id":"15","title":"Grep"},"16":{"body":"All delta options can go under the [delta] section in your git config file. However, you can also use named \"features\" to keep things organized: these are sections in git config like [delta \"my-feature\"]. Here's an example using two custom features: [delta] features = unobtrusive-line-numbers decorations whitespace-error-style = 22 reverse [delta \"unobtrusive-line-numbers\"] line-numbers = true line-numbers-minus-style = \"#444444\" line-numbers-zero-style = \"#444444\" line-numbers-plus-style = \"#444444\" line-numbers-left-format = \"{nm:>4}┊\" line-numbers-right-format = \"{np:>4}│\" line-numbers-left-style = blue line-numbers-right-style = blue [delta \"decorations\"] commit-decoration-style = bold yellow box ul file-style = bold yellow ul file-decoration-style = none hunk-header-decoration-style = yellow box The environment variable DELTA_FEATURES can used to enable features from the command line: it should be set to a space-separated string of feature names. If you precede this with a + symbol, then the features are added to those configured elsewhere, instead of replacing them. This is very useful, for example to temporarily switch delta to side-by-side mode you can do export DELTA_FEATURES=+side-by-side and to undo that: export DELTA_FEATURES=+","breadcrumbs":"Usage » \"Features\": named groups of settings » \"Features\": named groups of settings","id":"16","title":"\"Features\": named groups of settings"},"17":{"body":"A \"theme\" in delta is just a collection of settings grouped together in a named feature . One of the available settings is syntax-theme: this dictates the colors and styles that are applied to foreground text by the syntax highlighter. Thus the concept of \"theme\" in delta encompasses not just the foreground syntax-highlighting color theme, but also background colors, decorations such as boxes and under/overlines, etc. The delta git repo contains a collection of themes created by users. These focus on the visual appearance: colors etc. If you want features like side-by-side or navigate, you would set that yourself, after selecting the color theme. To use the delta themes, clone the delta repo (or download the raw themes.gitconfig file) and add the following entry in your gitconfig: [include] path = /PATH/TO/delta/themes.gitconfig Then, add your chosen color theme to your features list, e.g. [delta] features = collared-trogon side-by-side = true ... Note that this terminology differs from bat : bat does not apply background colors, and uses the term \"theme\" to refer to what delta calls syntax-theme. Delta does not have a setting named \"theme\": a theme is a \"feature\", so one uses features to select a theme.","breadcrumbs":"Usage » Custom themes » Custom themes","id":"17","title":"Custom themes"},"18":{"body":"Use --diff-highlight or --diff-so-fancy to activate the respective emulation mode. You may want to know which delta configuration values the emulation mode has selected, so that you can adjust them. To do that, use e.g. delta --diff-so-fancy --show-config: diff-highlight is a perl script distributed with git that allows within-line edits to be identified and highlighted according to colors specified in git config. diff-so-fancy builds on diff-highlight, making various additional improvements to the default git diff output. Both tools provide very helpful ways of viewing diffs, and so delta provides emulation modes for both of them. The within-line highlighting rules employed by diff-highlight (and therefore by diff-so-fancy) are deliberately simpler than Delta's Levenshtein-type edit inference algorithm (see discussion in the diff-highlight README ). diff-highlight's rules could be added to delta as an alternative highlighting algorithm, but that hasn't been done yet.","breadcrumbs":"Usage » diff-highlight and diff-so-fancy emulation » diff-highlight and diff-so-fancy emulation","id":"18","title":"diff-highlight and diff-so-fancy emulation"},"19":{"body":"Recent versions of Git (≥ v2.17, April 2018) are able to detect moved blocks of code and style them differently from the usual removed/added lines. If you have activated this feature in Git, then Delta will automatically detect such differently-styled lines, and display them unchanged, i.e. with the raw colors it receives from Git. To activate the Git feature, use [diff] colorMoved = default and see the Git documentation for the other possible values and associated color configuration. The map-styles option allows us to transform the styles that git emits for color-moved sections into delta styles. Here's an example of using map-styles to assign delta styles to the raw color-moved styles output by git. This feature allows all of git's color-moved options to be rendered using delta styles, including with syntax highlighting. [delta] map-styles = bold purple => syntax magenta, bold cyan => syntax blue There is a pair of features provided in themes.config called zebra-dark and zebra-light which utilise the moved colors by displaying them as a faint background color on the affected lines while keeping syntax highlighting as the foreground color. You can enable one of these features by stacking it upon the theme you are using, like as follows [delta] features = my-dark-theme zebra-dark It is also possible to reference other styles. [delta] features = my-color-moved-theme [delta \"my-color-moved-theme\"] git-moved-from-style = bold purple # An ad-hoc named style (must end in \"-style\") map-styles = \"my-color-moved-theme.git-moved-from-style => red #cccccc, \\ bold cyan => syntax #cccccc\" # we could also have defined git-moved-to-style = bold cyan To make use of that, you need to know that git is emitting \"bold cyan\" and \"bold purple\". But that's not always obvious. To help with that, delta now has a --parse-ansi mode. E.g. git show --color=always | delta --parse-ansi outputs something like this: As you see above, we can now define named styles in gitconfig and refer to them in places where a style string is expected. We can also define custom named colors in git config, and styles can reference other styles; see the hoopoe theme for an example: [delta \"hoopoe\"] green = \"#d0ffd0\" # ad-hoc named color plus-style = syntax hoopoe.green # refer to named color plus-non-emph-style = plus-style # styles can reference other styles Additionally, we can now use the 140 color names that are standard in CSS. Use delta --show-colors to get a demo of the available colors, as background colors to see how they look with syntax highlighting:","breadcrumbs":"Usage » --color-moved support » --color-moved support","id":"19","title":"--color-moved support"},"2":{"body":"Language syntax highlighting with color themes Within-line highlights based on a Levenshtein edit inference algorithm Side-by-side view with line-wrapping Line numbering n and N keybindings to move between files in large diffs, and between diffs in log -p views (--navigate) Improved merge conflict display Improved git blame display (syntax highlighting; --hyperlinks formats commits as links to GitHub/GitLab/Bitbucket etc) Syntax-highlights grep output from rg, git grep, grep, etc Support for Git's --color-moved feature. Code can be copied directly from the diff (-/+ markers are removed by default). diff-highlight and diff-so-fancy emulation modes Commit hashes can be formatted as terminal hyperlinks to the GitHub/GitLab/Bitbucket page (--hyperlinks). File paths can also be formatted as hyperlinks for opening in your OS. Stylable box/line decorations to draw attention to commit, file and hunk header sections. Git style strings (foreground color, background color, font attributes) are supported for >20 stylable elements delta git diff-so-fancy / diff-highlight github/gitlab language syntax highlighting ✅ ❌ ❌ ✅ within-line insertion/deletion detection ✅ ❌ ✅ ✅ multiple insertion/deletions detected per line ✅ ❌ ❌ ✅ matching of unequal numbers of changed lines ✅ ❌ ❌ ❌ independently stylable elements ✅ ✅ ✅ ❌ line numbering ✅ ❌ ❌ ✅ side-by-side view ✅ ❌ ❌ ✅ In addition, delta handles traditional unified diff output.","breadcrumbs":"Features » Features","id":"2","title":"Features"},"20":{"body":"Use the navigate feature to activate navigation keybindings. In this mode, pressing n will jump forward to the next file in the diff, and N will jump backwards. If you are viewing multiple commits (e.g. via git log -p) then navigation will also visit commit boundaries.","breadcrumbs":"Usage » Navigation keybindings for large diffs » Navigation keybindings for large diffs","id":"20","title":"Navigation keybindings for large diffs"},"21":{"body":"Consider setting [merge] conflictstyle = diff3 With that setting, when a merge conflict is encountered, delta will display diffs between the ancestral commit and each of the two merge parents: This display can be customized using merge-conflict-begin-symbol, merge-conflict-end-symbol, merge-conflict-ours-diff-header-style, merge-conflict-ours-diff-header-decoration-style, merge-conflict-theirs-diff-header-style, merge-conflict-theirs-diff-header-decoration-style.","breadcrumbs":"Usage » Merge conflicts » Merge conflicts","id":"21","title":"Merge conflicts"},"22":{"body":"Set delta as the pager for blame in the [pager] section of your gitconfig: see the example gitconfig . If hyperlinks is enabled in the [delta] section then each blame commit will link to the commit on GitHub/GitLab/Bitbucket/etc.","breadcrumbs":"Usage » Git blame » Git blame","id":"22","title":"Git blame"},"23":{"body":"To list the supported languages and color themes, use delta --list-languages and delta --list-syntax-themes. To see a demo of the color themes, use delta --show-syntax-themes: To add your own custom color theme, or language, please follow the instructions in the Customization section of the bat documentation : Adding a custom language Adding a custom theme Delta automatically recognizes custom themes and languages added to bat. You will need to install bat in order to run the bat cache --build command. The languages and color themes that ship with delta are those that ship with bat. So, to propose a new language or color theme for inclusion in delta, it would need to be a helpful addition to bat, in which case please open a PR against bat.","breadcrumbs":"Usage » Supported languages and themes » Supported languages and themes","id":"23","title":"Supported languages and themes"},"24":{"body":"","breadcrumbs":"Tips & tricks » Tips & tricks","id":"24","title":"Tips & tricks"},"25":{"body":"Delta looks best if your terminal application supports 24 bit colors. See https://github.com/termstandard/colors#readme . For example, on MacOS, iTerm2 supports 24-bit colors but Terminal.app does not. If your terminal application does not support 24-bit color, delta will still work, by automatically choosing the closest color from those available. See the Colors section of the help output below. If 24-bit color is supported by your terminal emulator, then it should have set the COLORTERM env var to the value truecolor (or 24bit). If necessary, you can explicitly enable true color, either by using --true-color=always or by adding the following to your configuration file: [delta] true-color = always","breadcrumbs":"Tips & tricks » 24 bit color (truecolor) » 24 bit color (truecolor)","id":"25","title":"24 bit color (truecolor)"},"26":{"body":"If mouse scrolling isn't working correctly, ensure that you have the most recent version of less. For Windows you can download from https://github.com/jftuga/less-Windows/releases/latest For Mac you can install brew install less; brew link less Alternatively try setting your DELTA_PAGER environment variable to (at least) less -R. See issue #58 . See also bat README / \"Using a different pager\" , since the DELTA_PAGER environment variable functions very similarly for delta.","breadcrumbs":"Tips & tricks » Mouse scrolling » Mouse scrolling","id":"26","title":"Mouse scrolling"},"27":{"body":"Install ansifilter . git show \\ | delta --no-gitconfig --file-decoration-style blue --hunk-header-decoration-style blue \\ | ansifilter --html \\ > /tmp/diff.html Now open /tmp/diff.html in a web browser, print to PDF, etc. Remove the --no-gitconfig above to use your own delta style, but not that ansifilter does not handle hyperlinks or decoration boxes etc.","breadcrumbs":"Tips & tricks » Save output with colors to HTML/PDF etc » Save output with colors to HTML/PDF etc","id":"27","title":"Save output with colors to HTML/PDF etc"},"28":{"body":"Delta works on Windows. However, it is essential to use a recent version of less.exe: you can download one from https://github.com/jftuga/less-Windows/releases/latest . If you see incorrect colors and/or strange characters in Delta output, then it is probably because Delta is picking up an old version of less.exe on your system.","breadcrumbs":"Tips & tricks » Using Delta on Windows » Using Delta on Windows","id":"28","title":"Using Delta on Windows"},"29":{"body":"True color output in GNU Screen is currently only possible when using a development build, as support for it is not yet implemented in the (v4) release versions. A snapshot of the latest Git trunk can be obtained via https://git.savannah.gnu.org/cgit/screen.git/snapshot/screen-master.tar.gz - the required build steps are described in the src/INSTALL file. After installing the program, 24-bit color support can be activated by including truecolor on in either the system's or the user's screenrc file. When working in Screen without true color output, it might be that colors supposed to be different look the same in XTerm compatible terminals. If that is the case, make sure the following settings are included in your screenrc file: term screen-256color\ntermcapinfo xterm 'Co#256:AB=\\E[48;5;%dm:AF=\\E[38;5;%dm' # ANSI (256-color) patterns - AB: background, AF: foreground\nattrcolor b \".I\" # use bright colors for bold text If despite having those settings you still only get a limited set of colors, your build of Screen might have been configured without the --enable-colors256 flag. If this is the case, you have two options : If available for your OS, get a different package of Screen. Otherwise Build your own binary : Download and extract a release tarball from https://ftp.gnu.org/gnu/screen/ cd into the newly extracted folder Follow the instructions in the INSTALL file, and when running the ./configure command apply the --enable-colors256 flag.","breadcrumbs":"Tips & tricks » Using Delta with GNU Screen » Using Delta with GNU Screen","id":"29","title":"Using Delta with GNU Screen"},"3":{"body":"You can download an executable for your system: Linux (glibc) | Linux (musl) | MacOS | Windows | All Alternatively you can install delta using a package manager: see repology.org/git-delta . Note that the package is often called git-delta, but the executable installed is called delta. Here is a quick summary for selected package managers: Arch Linux pacman -S git-delta Cargo cargo install git-delta Fedora dnf install git-delta FreeBSD pkg install git-delta Gentoo emerge dev-util/git-delta Homebrew brew install git-delta MacPorts port install git-delta Nix nix-env -iA nixpkgs.delta OpenBSD pkg_add delta openSUSE Tumbleweed zypper install git-delta Void Linux xbps-install -S delta Windows (Chocolatey) choco install delta Windows (Scoop) scoop install delta Windows (Winget) winget install dandavison.delta Debian / Ubuntu dpkg -i file.deb .deb files are on the releases page. If you are using Ubuntu &lt;= 19.10 or are mixing apt sources, please read #504. conda conda install git-delta -c conda-forge mamba install git-delta -c conda-forge Users of older MacOS versions (e.g. 10.11 El Capitan) should install using Homebrew, Cargo, or MacPorts: the binaries on the release page will not work. Behind the scenes, delta uses less for paging. It's important to have a reasonably recent version of less installed. On MacOS, install less from Homebrew. For Windows, see Using Delta on Windows .","breadcrumbs":"Installation » Installation","id":"3","title":"Installation"},"30":{"body":"Delta can be used when displaying diffs in the Magit git client: see magit-delta . Here's a screenshot:","breadcrumbs":"Tips & tricks » Using Delta with Magit » Using Delta with Magit","id":"30","title":"Using Delta with Magit"},"31":{"body":"If you're using tmux, it's worth checking that 24 bit color is working correctly. For example, run a color test script like this one , or one of the others listed here . If you do not see smooth color gradients, see the discussion at tmux#696 . The short version is you need something like this in your ~/.tmux.conf: set -ga terminal-overrides \",xterm-256color:Tc\" and you may then need to quit tmux completely for it to take effect. If colors look wrong, then see the page on truecolor/24-bit color to ensure that this is working correctly.","breadcrumbs":"Tips & tricks » Using Delta with tmux » Using Delta with tmux","id":"31","title":"Using Delta with tmux"},"32":{"body":"All Delta features work correctly in VSCode's terminal emulator (please open an issue if that's not true). To format file links for opening in VSCode from other terminal emulators, use the VSCode URL handler : [delta] hyperlinks = true hyperlinks-file-link-format = \"vscode://file/{path}:{line}\" (To use VSCode Insiders, change that to vscode-insiders://file/{path}:{line}).","breadcrumbs":"Tips & tricks » Using Delta with VSCode » Using Delta with VSCode","id":"32","title":"Using Delta with VSCode"},"33":{"body":"(delta --light) delta vs. git delta vs. diff-so-fancy /diff-highlight delta vs. github","breadcrumbs":"Comparisons with other tools » Comparisons with other tools","id":"33","title":"Comparisons with other tools"},"34":{"body":"You'll need to install the rust tools . Then: cargo build --release and use the executable found at ./target/release/delta. Alternatively, homebrew users can do brew install --HEAD git-delta to install the development version of delta with merged but unreleased changes.","breadcrumbs":"Build delta from source » Build delta from source","id":"34","title":"Build delta from source"},"35":{"body":"","breadcrumbs":"Related projects » Related projects","id":"35","title":"Related projects"},"36":{"body":"alacritty/vte mitsuhiko/console ogham/rust-ansi-term sharkdp/bat trishume/syntect","breadcrumbs":"Related projects » Used by delta","id":"36","title":"Used by delta"},"37":{"body":"bigH/git-fuzzy dandavison/magit-delta jesseduffield/lazygit junegunn/fzf.vim ms-jpq/sad wfxr/forgit","breadcrumbs":"Related projects » Using delta","id":"37","title":"Using delta"},"38":{"body":"banga/git-split-diffs da-x/fancydiff git/diff-highlight jeffkaufman/icdiff kovidgoyal/kitty-diff mookid/diffr nkouevda/pdiff so-fancy/diff-so-fancy walles/riff Wilfred/difftastic","breadcrumbs":"Related projects » Similar projects","id":"38","title":"Similar projects"},"39":{"body":"A viewer for git and diff output Usage: delta [OPTIONS] [MINUS_FILE] [PLUS_FILE] Arguments: [MINUS_FILE] First file to be compared when delta is being used in diff mode `delta file_1 file_2` is equivalent to `diff -u file_1 file_2 | delta`. [PLUS_FILE] Second file to be compared when delta is being used in diff mode Options: --blame-code-style <STYLE> Style string for the code section of a git blame line. By default the code will be syntax-highlighted with the same background color as the blame format section of the line (the background color is determined by blame-palette). E.g. setting this option to 'syntax' will syntax-highlight the code with no background color. --blame-format <FMT> Format string for git blame commit metadata. Available placeholders are \"{timestamp}\", \"{author}\", and \"{commit}\". [default: \"{timestamp:<15} {author:<15.14} {commit:<8}\"] --blame-palette <COLORS> Background colors used for git blame lines (space-separated string). Lines added by the same commit are painted with the same color; colors are recycled as needed. --blame-separator-format <FMT> Separator between the blame format and the code section of a git blame line. Contains the line number by default. Possible values are \"none\" to disable line numbers or a format string. This may contain one \"{n:}\" placeholder and will display the line number on every line. A type may be added after all other format specifiers and can be separated by '_': If type is set to 'block' (e.g. \"{n:^4_block}\") the line number will only be shown when a new blame block starts; or if it is set to 'every-N' the line will be show with every block and every N-th (modulo) line. [default: │{n:^4}│] --blame-separator-style <STYLE> Style string for the blame-separator-format --blame-timestamp-format <FMT> Format of `git blame` timestamp in raw git output received by delta [default: \"%Y-%m-%d %H:%M:%S %z\"] --blame-timestamp-output-format <FMT> Format string for git blame timestamp output. This string is used for formatting the timestamps in git blame output. It must follow the `strftime` format syntax specification. If it is not present, the timestamps will be formatted in a human-friendly but possibly less accurate form. See: (https://docs.rs/chrono/latest/chrono/format/strftime/index.html) --color-only Do not alter the input structurally in any way. But color and highlight hunk lines according to your delta configuration. This is mainly intended for other tools that use delta. --config <PATH> Load the config file at PATH instead of ~/.gitconfig [default: ] --commit-decoration-style <STYLE> Style string for the commit hash decoration. See STYLES section. The style string should contain one of the special attributes 'box', 'ul' (underline), 'ol' (overline), or the combination 'ul ol'. [default: ] --commit-regex <REGEX> Regular expression used to identify the commit line when parsing git output [default: \"^commit \"] --commit-style <STYLE> Style string for the commit hash line. See STYLES section. The style 'omit' can be used to remove the commit hash line from the output. [default: raw] --dark Use default colors appropriate for a dark terminal background. For more control, see the style options and --syntax-theme. --default-language <LANG> Default language used for syntax highlighting. Used when the language cannot be inferred from a filename. It will typically make sense to set this in per-repository git config (.git/config) --diff-highlight Emulate diff-highlight. (https://github.com/git/git/tree/master/contrib/diff-highlight) --diff-so-fancy Emulate diff-so-fancy. (https://github.com/so-fancy/diff-so-fancy) --diff-stat-align-width <N> Width allocated for file paths in a diff stat section. If a relativized file path exceeds this width then the diff stat will be misaligned. [default: 48] --features <FEATURES> Names of delta features to activate (space-separated). A feature is a named collection of delta options in ~/.gitconfig. See FEATURES section. The environment variable DELTA_FEATURES can be set to a space-separated list of feature names. If this is preceded with a + character, the features from the environment variable will be added to those specified in git config. E.g. DELTA_FEATURES=+side-by-side can be used to activate side-by-side temporarily (use DELTA_FEATURES=+ to go back to just the features from git config). --file-added-label <STRING> Text to display before an added file path. Used in the default value of navigate-regex. [default: added:] --file-copied-label <STRING> Text to display before a copied file path [default: copied:] --file-decoration-style <STYLE> Style string for the file decoration. See STYLES section. The style string should contain one of the special attributes 'box', 'ul' (underline), 'ol' (overline), or the combination 'ul ol'. [default: \"blue ul\"] --file-modified-label <STRING> Text to display before a modified file path. Used in the default value of navigate-regex. [default: ] --file-removed-label <STRING> Text to display before a removed file path. Used in the default value of navigate-regex. [default: removed:] --file-renamed-label <STRING> Text to display before a renamed file path. Used in the default value of navigate-regex. [default: renamed:] --file-style <STYLE> Style string for the file section. See STYLES section. The style 'omit' can be used to remove the file section from the output. [default: blue] --file-transformation <SED_CMD> Sed-style command transforming file paths for display --grep-context-line-style <STYLE> Style string for non-matching lines of grep output. See STYLES section. Defaults to zero-style. --grep-file-style <STYLE> Style string for file paths in grep output. See STYLES section. [default: magenta] --grep-header-decoration-style <STYLE> Style string for the header decoration in grep output. Default is \"none\" when grep-ouput-type-is \"ripgrep\", otherwise defaults to value of header-decoration-style. See hunk-header-decoration-style. --grep-header-file-style <STYLE> Style string for the file path part of the header in grep output. See hunk_header_file_style. --grep-line-number-style <STYLE> Style string for line numbers in grep output. See STYLES section. [default: green] --grep-output-type <OUTPUT_TYPE> Grep output format. Possible values: \"ripgrep\" - file name printed once, followed by matching lines within that file, each preceded by a line number. \"classic\" - file name:line number, followed by matching line. Default is \"ripgrep\" if `rg --json` format is detected, otherwise \"classic\" --grep-match-line-style <STYLE> Style string for matching lines of grep output. See STYLES section. Defaults to plus-style. --grep-match-word-style <STYLE> Style string for the matching substrings within a matching line of grep output. See STYLES section. Defaults to plus-style. --grep-separator-symbol <STRING> Separator symbol printed after the file path and line number in grep output. Defaults to \":\" for both match and context lines, since many terminal emulators recognize constructs like \"/path/to/file:7:\". However, standard grep output uses \"-\" for context lines: set this option to \"keep\" to keep the original separator symbols. [default: :] --hunk-header-decoration-style <STYLE> Style string for the hunk-header decoration. See STYLES section. The style string should contain one of the special attributes 'box', 'ul' (underline), 'ol' (overline), or the combination 'ul ol'. [default: \"blue box\"] --hunk-header-file-style <STYLE> Style string for the file path part of the hunk-header. See STYLES section. The file path will only be displayed if hunk-header-style contains the 'file' special attribute. [default: blue] --hunk-header-line-number-style <STYLE> Style string for the line number part of the hunk-header. See STYLES section. The line number will only be displayed if hunk-header-style contains the 'line-number' special attribute. [default: blue] --hunk-header-style <STYLE> Style string for the hunk-header. See STYLES section. Special attributes 'file' and 'line-number' can be used to include the file path, and number of first hunk line, in the hunk header. The style 'omit' can be used to remove the hunk header section from the output. [default: \"line-number syntax\"] --hunk-label <STRING> Text to display before a hunk header. Used in the default value of navigate-regex. [default: ] --hyperlinks Render commit hashes, file names, and line numbers as hyperlinks. Following the hyperlink spec for terminal emulators: https://gist.github.com/egmontkob/eb114294efbcd5adb1944c9f3cb5feda. By default, file names and line numbers link to the local file using a file URL, whereas commit hashes link to the commit in GitHub, if the remote repository is hosted by GitHub. See --hyperlinks-file-link-format for full control over the file URLs emitted. Hyperlinks are supported by several common terminal emulators. To make them work, you must use less version >= 581 with the -R flag (or use -r with older less versions, but this will break e.g. --navigate). If you use tmux, then you will also need a patched fork of tmux (see https://github.com/dandavison/tmux). --hyperlinks-commit-link-format <FMT> Format string for commit hyperlinks (requires --hyperlinks). The placeholder \"{commit}\" will be replaced by the commit hash. For example: --hyperlinks-commit-link-format='https://mygitrepo/{commit}/' --hyperlinks-file-link-format <FMT> Format string for file hyperlinks (requires --hyperlinks). The placeholders \"{path}\" and \"{line}\" will be replaced by the absolute file path and the line number, respectively. The default value of this option creates hyperlinks using standard file URLs; your operating system should open these in the application registered for that file type. However, these do not make use of the line number. In order for the link to open the file at the correct line number, you could use a custom URL format such as \"file-line://{path}:{line}\" and register an application to handle the custom \"file-line\" URL scheme by opening the file in your editor/IDE at the indicated line number. See https://github.com/dandavison/open-in-editor for an example. [default: file://{path}] --inline-hint-style <STYLE> Style string for short inline hint text. This styles certain content added by delta to the original diff such as special characters to highlight tabs, and the symbols used to indicate wrapped lines. See STYLES section. [default: blue] --inspect-raw-lines <true|false> Kill-switch for --color-moved support. Whether to examine ANSI color escape sequences in raw lines received from Git and handle lines colored in certain ways specially. This is on by default: it is how Delta supports Git's --color-moved feature. Set this to \"false\" to disable this behavior. [default: true] --keep-plus-minus-markers Prefix added/removed lines with a +/- character, as git does. By default, delta does not emit any prefix, so code can be copied directly from delta's output. --light Use default colors appropriate for a light terminal background. For more control, see the style options and --syntax-theme. --line-buffer-size <N> Size of internal line buffer. Delta compares the added and removed versions of nearby lines in order to detect and highlight changes at the level of individual words/tokens. Therefore, nearby lines must be buffered internally before they are painted and emitted. Increasing this value might improve highlighting of some large diff hunks. However, setting this to a high value will adversely affect delta's performance when entire files are added/removed. [default: 32] --line-fill-method <STRING> Line-fill method in side-by-side mode. How to extend the background color to the end of the line in side-by-side mode. Can be ansi (default) or spaces (default if output is not to a terminal). Has no effect if --width=variable is given. -n, --line-numbers Display line numbers next to the diff. See LINE NUMBERS section. --line-numbers-left-format <FMT> Format string for the left column of line numbers. A typical value would be \"{nm:^4}⋮\" which means to display the line numbers of the minus file (old version), center-aligned, padded to a width of 4 characters, followed by a dividing character. See the LINE NUMBERS section. [default: {nm:^4}⋮] --line-numbers-left-style <STYLE> Style string for the left column of line numbers. See STYLES and LINE NUMBERS sections. [default: auto] --line-numbers-minus-style <STYLE> Style string for line numbers in the old (minus) version of the file. See STYLES and LINE NUMBERS sections. [default: auto] --line-numbers-plus-style <STYLE> Style string for line numbers in the new (plus) version of the file. See STYLES and LINE NUMBERS sections. [default: auto] --line-numbers-right-format <FMT> Format string for the right column of line numbers. A typical value would be \"{np:^4}│ \" which means to display the line numbers of the plus file (new version), center-aligned, padded to a width of 4 characters, followed by a dividing character, and a space. See the LINE NUMBERS section. [default: {np:^4}│] --line-numbers-right-style <STYLE> Style string for the right column of line numbers. See STYLES and LINE NUMBERS sections. [default: auto] --line-numbers-zero-style <STYLE> Style string for line numbers in unchanged (zero) lines. See STYLES and LINE NUMBERS sections. [default: auto] --list-languages List supported languages and associated file extensions --list-syntax-themes List available syntax-highlighting color themes --map-styles <STYLES_MAP> Map styles encountered in raw input to desired output styles. An example is --map-styles='bold purple => red \"#eeeeee\", bold cyan => syntax \"#eeeeee\"' --max-line-distance <DIST> Maximum line pair distance parameter in within-line diff algorithm. This parameter is the maximum distance (0.0 - 1.0) between two lines for them to be inferred to be homologous. Homologous line pairs are highlighted according to the deletion and insertion operations transforming one into the other. [default: 0.6] --max-line-length <N> Truncate lines longer than this. To prevent any truncation, set to zero. Note that delta will be slow on very long lines (e.g. minified .js) if truncation is disabled. When wrapping lines it is automatically set to fit at least all visible characters. [default: 512] --merge-conflict-begin-symbol <STRING> String marking the beginning of a merge conflict region. The string will be repeated until it reaches the required length. [default: ▼] --merge-conflict-end-symbol <STRING> String marking the end of a merge conflict region. The string will be repeated until it reaches the required length. [default: ▲] --merge-conflict-ours-diff-header-decoration-style <STYLE> Style string for the decoration of the header above the 'ours' merge conflict diff. This styles the decoration of the header above the diff between the ancestral commit and the 'ours' branch. See STYLES section. The style string should contain one of the special attributes 'box', 'ul' (underline), 'ol' (overline), or the combination 'ul ol'. [default: box] --merge-conflict-ours-diff-header-style <STYLE> Style string for the header above the 'ours' branch merge conflict diff. See STYLES section. [default: normal] --merge-conflict-theirs-diff-header-decoration-style <STYLE> Style string for the decoration of the header above the 'theirs' merge conflict diff. This styles the decoration of the header above the diff between the ancestral commit and 'their' branch. See STYLES section. The style string should contain one of the special attributes 'box', 'ul' (underline), 'ol' (overline), or the combination 'ul ol'. [default: box] --merge-conflict-theirs-diff-header-style <STYLE> Style string for the header above the 'theirs' branch merge conflict diff. This styles the header above the diff between the ancestral commit and 'their' branch. See STYLES section. [default: normal] --minus-empty-line-marker-style <STYLE> Style string for removed empty line marker. Used only if --minus-style has no background color. [default: \"normal auto\"] --minus-emph-style <STYLE> Style string for emphasized sections of removed lines. See STYLES section. [default: \"normal auto\"] --minus-non-emph-style <STYLE> Style string for non-emphasized sections of removed lines that have an emphasized section. See STYLES section. [default: minus-style] --minus-style <STYLE> Style string for removed lines. See STYLES section. [default: \"normal auto\"] --navigate Activate diff navigation. Use n to jump forwards and N to jump backwards. To change the file labels used see --file-modified-label, --file-removed-label, --file-added-label, --file-renamed-label. --navigate-regex <REGEX> Regular expression defining navigation stop points --no-gitconfig Do not read any settings from git config. See GIT CONFIG section. --pager <CMD> Which pager to use. The default pager is `less`. You can also change pager by setting the environment variables DELTA_PAGER, BAT_PAGER, or PAGER (and that is their order of priority). This option overrides all environment variables above. --paging <auto|always|never> Whether to use a pager when displaying output. Options are: auto, always, and never. [default: auto] --parse-ansi Display ANSI color escape sequences in human-readable form. Example usage: git show --color=always | delta --parse-ansi This can be used to help identify input style strings to use with map-styles. --plus-emph-style <STYLE> Style string for emphasized sections of added lines. See STYLES section. [default: \"syntax auto\"] --plus-empty-line-marker-style <STYLE> Style string for added empty line marker. Used only if --plus-style has no background color. [default: \"normal auto\"] --plus-non-emph-style <STYLE> Style string for non-emphasized sections of added lines that have an emphasized section. See STYLES section. [default: plus-style] --plus-style <STYLE> Style string for added lines. See STYLES section. [default: \"syntax auto\"] --raw Do not alter the input in any way. This is mainly intended for testing delta. --relative-paths Output all file paths relative to the current directory. This means that they will resolve correctly when clicked on or used in shell commands. --right-arrow <STRING> Text to display with a changed file path. For example, a unified diff heading, a rename, or a chmod. [default: \"⟶ \"] --show-colors Show available named colors. In addition to named colors, arbitrary colors can be specified using RGB hex codes. See COLORS section. --show-config Display the active values for all Delta options. Style string options are displayed with foreground and background colors. This can be used to experiment with colors by combining this option with other options such as --minus-style, --zero-style, --plus-style, --light, --dark, etc. --show-syntax-themes Show example diff for available syntax-highlighting themes. If diff output is supplied on standard input then this will be used for the demo. For example: `git show | delta --show-syntax-themes`. --show-themes Show example diff for available delta themes. A delta theme is a delta named feature (see --features) that sets either `light` or `dark`. See https://github.com/dandavison/delta#custom-color-themes. If diff output is supplied on standard input then this will be used for the demo. For example: `git show | delta --show-themes`. By default shows dark or light themes only, according to whether delta is in dark or light mode (as set by the user or inferred from BAT_THEME). To control the themes shown, use --dark or --light, or both, on the command line together with this option. -s, --side-by-side Display diffs in side-by-side layout --syntax-theme <SYNTAX_THEME> The syntax-highlighting theme to use. Use --show-syntax-themes to demo available themes. Defaults to the value of the BAT_THEME environment variable, if that contains a valid theme name. --syntax-theme=none disables all syntax highlighting. --tabs <N> The number of spaces to replace tab characters with. Use --tabs=0 to pass tab characters through directly, but note that in that case delta will calculate line widths assuming tabs occupy one character's width on the screen: if your terminal renders tabs as more than one character wide then delta's output will look incorrect. [default: 8] --true-color <auto|always|never> Whether to emit 24-bit (\"true color\") RGB color codes. Options are auto, always, and never. \"auto\" means that delta will emit 24-bit color codes if the environment variable COLORTERM has the value \"truecolor\" or \"24bit\". If your terminal application (the application you use to enter commands at a shell prompt) supports 24 bit colors, then it probably already sets this environment variable, in which case you don't need to do anything. [default: auto] --whitespace-error-style <STYLE> Style string for whitespace errors. Defaults to color.diff.whitespace if that is set in git config, or else 'magenta reverse'. [default: \"auto auto\"] -w, --width <N> The width of underline/overline decorations. Examples: \"72\" (exactly 72 characters), \"-2\" (auto-detected terminal width minus 2). An expression such as \"74-2\" is also valid (equivalent to 72 but may be useful if the caller has a variable holding the value \"74\"). Use --width=variable to extend decorations and background colors to the end of the text only. Otherwise background colors extend to the full terminal width. --word-diff-regex <REGEX> Regular expression defining a 'word' in within-line diff algorithm. The regular expression used to decide what a word is for the within-line highlight algorithm. For less fine-grained matching than the default try --word-diff-regex=\"\\S+\" --max-line-distance=1.0 (this is more similar to `git --word-diff`). [default: \\w+] --wrap-left-symbol <STRING> End-of-line wrapped content symbol (left-aligned). Symbol added to the end of a line indicating that the content has been wrapped onto the next line and continues left-aligned. [default: ↵] --wrap-max-lines <N> How often a line should be wrapped if it does not fit. Zero means to never wrap. Any content which does not fit after wrapping will be truncated. A value of \"unlimited\" means a line will be wrapped as many times as required. [default: 2] --wrap-right-percent <PERCENT> Threshold for right-aligning wrapped content. If the length of the remaining wrapped content, as a percentage of width, is less than this quantity it will be right-aligned. Otherwise it will be left-aligned. [default: 37.0] --wrap-right-prefix-symbol <STRING> Pre-wrapped content symbol (right-aligned). Symbol displayed before right-aligned wrapped content. [default: …] --wrap-right-symbol <STRING> End-of-line wrapped content symbol (right-aligned). Symbol added to the end of a line indicating that the content has been wrapped onto the next line and continues right-aligned. [default: ↴] --zero-style <STYLE> Style string for unchanged lines. See STYLES section. [default: \"syntax normal\"] --24-bit-color <auto|always|never> Deprecated: use --true-color -h, --help Print help (see a summary with '-h') -V, --version Print version GIT CONFIG\n---------- By default, delta takes settings from a section named \"delta\" in git config files, if one is present. The git config file to use for delta options will usually be ~/.gitconfig, but delta follows the rules given in https://git-scm.com/docs/git-config#FILES. Most delta options can be given in a git config file, using the usual option names but without the initial '--'. An example is [delta] line-numbers = true zero-style = dim syntax FEATURES\n--------\nA feature is a named collection of delta options in git config. An example is: [delta \"my-delta-feature\"] syntax-theme = Dracula plus-style = bold syntax \"#002800\" To activate those options, you would use: delta --features my-delta-feature A feature name may not contain whitespace. You can activate multiple features: [delta] features = my-highlight-styles-colors-feature my-line-number-styles-feature If more than one feature sets the same option, the last one wins. If an option is present in the [delta] section, then features are not considered at all. If you want an option to be fully overridable by a feature and also have a non default value when no features are used, then you need to define a \"default\" feature and include it in the main delta configuration. For instance: [delta]\nfeature = default-feature [delta \"default-feature\"]\nwidth = 123 At this point, you can override features set in the command line or in the environment variables and the \"last one wins\" rules will apply as expected. STYLES\n------ All options that have a name like --*-style work the same way. It is very similar to how colors/styles are specified in a gitconfig file: https://git-scm.com/docs/git-config#Documentation/git-config.txt-color Here is an example: --minus-style 'red bold ul \"#ffeeee\"' That means: For removed lines, set the foreground (text) color to 'red', make it bold and underlined, and set the background color to '#ffeeee'. See the COLORS section below for how to specify a color. In addition to real colors, there are 4 special color names: 'auto', 'normal', 'raw', and 'syntax'. Here is an example of using special color names together with a single attribute: --minus-style 'syntax bold auto' That means: For removed lines, syntax-highlight the text, and make it bold, and do whatever delta normally does for the background. The available attributes are: 'blink', 'bold', 'dim', 'hidden', 'italic', 'reverse', 'strike', and 'ul' (or 'underline'). The attribute 'omit' is supported by commit-style, file-style, and hunk-header-style, meaning to remove the element entirely from the output. A complete description of the style string syntax follows: - If the input that delta is receiving already has colors, and you want delta to output those colors unchanged, then use the special style string 'raw'. Otherwise, delta will strip any colors from its input. - A style string consists of 0, 1, or 2 colors, together with an arbitrary number of style attributes, all separated by spaces. - The first color is the foreground (text) color. The second color is the background color. Attributes can go in any position. - This means that in order to specify a background color you must also specify a foreground (text) color. - If you want delta to choose one of the colors automatically, then use the special color 'auto'. This can be used for both foreground and background. - If you want the foreground/background color to be your terminal's foreground/background color, then use the special color 'normal'. - If you want the foreground text to be syntax-highlighted according to its language, then use the special foreground color 'syntax'. This can only be used for the foreground (text). - The minimal style specification is the empty string ''. This means: do not apply any colors or styling to the element in question. COLORS\n------ There are four ways to specify a color (this section applies to foreground and background colors within a style string): 1. CSS color name Any of the 140 color names used in CSS: https://www.w3schools.com/colors/colors_groups.asp 2. RGB hex code An example of using an RGB hex code is: --file-style=\"#0e7c0e\" 3. ANSI color name There are 8 ANSI color names: black, red, green, yellow, blue, magenta, cyan, white. In addition, all of them have a bright form: brightblack, brightred, brightgreen, brightyellow, brightblue, brightmagenta, brightcyan, brightwhite. An example of using an ANSI color name is: --file-style=\"green\" Unlike RGB hex codes, ANSI color names are just names: you can choose the exact color that each name corresponds to in the settings of your terminal application (the application you use to enter commands at a shell prompt). This means that if you use ANSI color names, and you change the color theme used by your terminal, then delta's colors will respond automatically, without needing to change the delta command line. \"purple\" is accepted as a synonym for \"magenta\". Color names and codes are case-insensitive. 4. ANSI color number An example of using an ANSI color number is: --file-style=28 There are 256 ANSI color numbers: 0-255. The first 16 are the same as the colors described in the \"ANSI color name\" section above. See https://en.wikipedia.org/wiki/ANSI_escape_code#8-bit. Specifying colors like this is useful if your terminal only supports 256 colors (i.e. doesn't support 24-bit color). LINE NUMBERS\n------------ To display line numbers, use --line-numbers. Line numbers are displayed in two columns. Here's what it looks like by default: 1 ⋮ 1 │ unchanged line 2 ⋮ │ removed line ⋮ 2 │ added line In that output, the line numbers for the old (minus) version of the file appear in the left column, and the line numbers for the new (plus) version of the file appear in the right column. In an unchanged (zero) line, both columns contain a line number. The following options allow the line number display to be customized: --line-numbers-left-format: Change the contents of the left column\n--line-numbers-right-format: Change the contents of the right column\n--line-numbers-left-style: Change the style applied to the left column\n--line-numbers-right-style: Change the style applied to the right column\n--line-numbers-minus-style: Change the style applied to line numbers in minus lines\n--line-numbers-zero-style: Change the style applied to line numbers in unchanged lines\n--line-numbers-plus-style: Change the style applied to line numbers in plus lines Options --line-numbers-left-format and --line-numbers-right-format allow you to change the contents of the line number columns. Their values are arbitrary format strings, which are allowed to contain the placeholders {nm} for the line number associated with the old version of the file and {np} for the line number associated with the new version of the file. The placeholders support a subset of the string formatting syntax documented here: https://doc.rust-lang.org/std/fmt/#formatting-parameters. Specifically, you can use the alignment and width syntax. For example, the default value of --line-numbers-left-format is '{nm:^4}⋮'. This means that the left column should display the minus line number (nm), center-aligned, padded with spaces to a width of 4 characters, followed by a unicode dividing-line character (⋮). Similarly, the default value of --line-numbers-right-format is '{np:^4}│'. This means that the right column should display the plus line number (np), center-aligned, padded with spaces to a width of 4 characters, followed by a unicode dividing-line character (│). Use '<' for left-align, '^' for center-align, and '>' for right-align. If something isn't working correctly, or you have a feature request, please open an issue at https://github.com/dandavison/delta/issues. For a short help summary, please use delta -h.","breadcrumbs":"Full --help output » Full --help output","id":"39","title":"Full --help output"},"4":{"body":"","breadcrumbs":"Configuration » Configuration","id":"4","title":"Configuration"},"40":{"body":"","breadcrumbs":"Delta configs used in screenshots » Delta configs used in screenshots","id":"40","title":"Delta configs used in screenshots"},"41":{"body":"https://github.com/vuejs/vue/commit/7ec4627902020cccd7b3f4fbc63e1b0d6b9798cd [delta] features = side-by-side line-numbers decorations syntax-theme = Dracula plus-style = syntax \"#003800\" minus-style = syntax \"#3f0001\" [delta \"decorations\"] commit-decoration-style = bold yellow box ul file-style = bold yellow ul file-decoration-style = none hunk-header-decoration-style = cyan box ul [delta \"line-numbers\"] line-numbers-left-style = cyan line-numbers-right-style = cyan line-numbers-minus-style = 124 line-numbers-plus-style = 28","breadcrumbs":"Delta configs used in screenshots » Side-by-side view","id":"41","title":"Side-by-side view"},"5":{"body":"The most convenient way to configure delta is with a [delta] section in ~/.gitconfig. Here's an example: [core] pager = delta [interactive] diffFilter = delta --color-only --features=interactive [delta] features = decorations [delta \"interactive\"] keep-plus-minus-markers = false [delta \"decorations\"] commit-decoration-style = blue ol commit-style = raw file-style = omit hunk-header-decoration-style = blue box hunk-header-file-style = red hunk-header-line-number-style = \"#067a00\" hunk-header-style = file line-number syntax Use delta --help to see all the available options. Note that delta style argument values in ~/.gitconfig should be in double quotes, like --minus-style=\"syntax #340001\". For theme names and other values, do not use quotes as they will be passed on to delta, like theme = Monokai Extended. All git commands that display diff output should now display syntax-highlighted output. For example: git diff git show git log -p git stash show -p git reflog -p git add -p To change your delta options in a one-off git command, use git -c. For example git -c delta.line-numbers=false show There are several important environment variables that affect delta configuration and which can be used to configure delta dynamically. Please see Environment variables . In particular, note that delta does not currently honor all relevant git environment variables , since delta uses libgit2 to read git config.","breadcrumbs":"Configuration » Git config file","id":"5","title":"Git config file"},"6":{"body":"","breadcrumbs":"Environment variables » Environment variables","id":"6","title":"Environment variables"},"7":{"body":"The GIT_PAGER environment variable must either not be set at all, or set to the value delta (you can add argument here if you want; this env var plays the same role as the core.pager config entry). Unfortunately, delta does not currently honor all relevant git environment variables . For example, it does not honor GIT_CONFIG_GLOBAL. This is because delta uses libgit2 to read git config, whereas git uses its own code. (libgit2 is a project run by volunteers; if this affects you, please do consider contributing the required features to libgit2!)","breadcrumbs":"Environment variables » Git environment variables","id":"7","title":"Git environment variables"},"8":{"body":"A pager is a program that accepts many lines of text as input, and displays them one screenful at a time. The standard pager is less , and this is what delta uses by default (it's also what bat uses). Therefore: It is very important that you are using a recent version of less. In particular, on Windows, the installed version of less is often broken and it is usually necessary to install it yourself or use the version of less that is installed with git on Windows. The command line flags passed to less are important, and there are some environment variables that affect these (see below). By default, delta will try to ensure that they are sensible. When delta is displaying lengthy output, anything you do with the keyboard or mouse is actually received by less, and it is worth looking at less documentation (less --help or man less or online ) to discover what you can do. The exact command that delta uses to start its pager is taken from one of the following environment variables (in this order): DELTA_PAGER PAGER If none of these is set, delta uses less -R, and you should always include -R if you are setting these environment variables yourself. In addition to those *PAGER environment variables, the behavior of less is also affected by the LESS environment variable (see man less or online documentation ). This env var can contain command line options and/or interactive less-commands (prefixed by a leading + sign; these are executed every time right after less is launched). In addition to DELTA_PAGER, and PAGER, delta currently also consults $BAT_PAGER (with priority between the two). However, this is deprecated: please use DELTA_PAGER instead. No other bat environment variables are used by delta, and delta does not use bat when it is running (it does use some code from the excellent bat project, but users don't need to be aware of this).","breadcrumbs":"Environment variables » Pager environment variables","id":"8","title":"Pager environment variables"},"9":{"body":"To temporarily activate and inactivate delta features, you can use DELTA_FEATURES, e.g. export DELTA_FEATURES='+side-by-side my-feature' (The + means \"add these features to those configured in git config\".) The DELTA_PAGER env var is described above.","breadcrumbs":"Environment variables » Delta-specific environment variables","id":"9","title":"Delta-specific environment variables"}},"length":42,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"6":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"0":{"2":{"8":{"0":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"8":{"0":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"7":{"a":{"0":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"1":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"0":{".":{"1":{"1":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"39":{"tf":1.0}}},"4":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"4":{"0":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"39":{"tf":1.0}}},"9":{".":{"1":{"0":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":2.0}}},"2":{"0":{"1":{"8":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.0}}},"2":{"df":1,"docs":{"16":{"tf":1.0}}},"4":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"39":{"tf":1.0}}}}},"df":4,"docs":{"25":{"tf":2.23606797749979},"29":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":2.23606797749979}}},"5":{"5":{"df":1,"docs":{"39":{"tf":1.0}}},"6":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"41":{"tf":1.0}}},"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":2.8284271247461903}}},"3":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"4":{"0":{"0":{"0":{"1":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}},"f":{"0":{"0":{"0":{"1":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"4":{"4":{"4":{"4":{"4":{"4":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"39":{"tf":2.449489742783178}}},"5":{"0":{"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"1":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"8":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"7":{"2":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"4":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"_":{"df":1,"docs":{"39":{"tf":1.0}}},"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"29":{"tf":1.0}},"o":{"df":0,"docs":{},"v":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":3.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":2.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.449489742783178},"9":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":7,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"23":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}},"e":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":6,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"39":{"tf":4.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}},"k":{"a":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"39":{"tf":4.242640687119285}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"n":{"df":4,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":3.7416573867739413}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}},"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":2.8284271247461903}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":3.605551275463989}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"<":{"1":{"5":{".":{"1":{"4":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":1,"docs":{"39":{"tf":4.69041575982343}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"|":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.6457513110645907},"5":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":4.242640687119285}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"20":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"a":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"df":4,"docs":{"17":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"26":{"tf":1.0},"8":{"tf":2.0}}}},"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.8284271247461903}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"25":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"39":{"tf":2.23606797749979},"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"3":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":4,"docs":{"25":{"tf":2.23606797749979},"29":{"tf":1.0},"31":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"2":{"tf":1.0},"22":{"tf":1.7320508075688772},"39":{"tf":4.358898943540674}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"27":{"tf":1.4142135623730951},"39":{"tf":2.6457513110645907},"5":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"19":{"tf":2.6457513110645907},"29":{"tf":1.0},"39":{"tf":2.6457513110645907},"41":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.4142135623730951},"39":{"tf":2.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"x":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":6,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":2.8284271247461903},"41":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"39":{"tf":1.0}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":4,"docs":{"18":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":2.0},"34":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"34":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"23":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}}}},"c":{"c":{"c":{"c":{"c":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":3,"docs":{"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"2":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":3.7416573867739413},"5":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":4.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"12":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}},"m":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"o":{"#":{"2":{"5":{"6":{":":{"a":{"b":{"=":{"\\":{"df":0,"docs":{},"e":{"[":{"4":{"8":{";":{"5":{";":{"%":{"d":{"df":0,"docs":{},"m":{":":{"a":{"df":0,"docs":{},"f":{"=":{"\\":{"df":0,"docs":{},"e":{"[":{"3":{"8":{";":{"5":{";":{"%":{"d":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":3.605551275463989},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{".":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":2.0},"15":{"tf":1.0},"17":{"tf":2.6457513110645907},"18":{"tf":1.0},"19":{"tf":4.358898943540674},"2":{"tf":2.0},"23":{"tf":2.23606797749979},"25":{"tf":3.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.6457513110645907},"31":{"tf":2.23606797749979},"39":{"tf":9.219544457292887},"5":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"19":{"tf":1.0}}}}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}}}}}},"2":{"5":{"6":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"25":{"tf":1.0},"39":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"39":{"tf":3.872983346207417}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.6457513110645907},"5":{"tf":1.4142135623730951},"8":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{"<":{"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"39":{"tf":4.795831523312719},"41":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"d":{"a":{"df":1,"docs":{"3":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"#":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":9,"docs":{"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"39":{"tf":3.7416573867739413},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"21":{"tf":2.8284271247461903},"39":{"tf":3.4641016151377544}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"21":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"14":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"17":{"tf":1.0},"39":{"tf":3.605551275463989},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":2.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":2.0}}}},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"26":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":7,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":2.23606797749979},"39":{"tf":1.7320508075688772}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":2.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"d":{"0":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"d":{"0":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":1,"docs":{"38":{"tf":1.0}},"n":{"d":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"39":{"tf":2.6457513110645907}}}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"b":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"16":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"39":{"tf":4.242640687119285},"41":{"tf":2.23606797749979},"5":{"tf":2.0}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":9.9498743710662},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.0}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"t":{"a":{"'":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":2.0}}},".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"=":{"'":{"+":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"+":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"26":{"tf":1.4142135623730951},"39":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":36,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":2.0},"10":{"tf":3.605551275463989},"11":{"tf":2.8284271247461903},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":2.6457513110645907},"16":{"tf":2.6457513110645907},"17":{"tf":2.8284271247461903},"18":{"tf":2.0},"19":{"tf":3.4641016151377544},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":2.449489742783178},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"29":{"tf":1.0},"3":{"tf":4.47213595499958},"30":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"39":{"tf":7.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"5":{"tf":3.872983346207417},"7":{"tf":1.7320508075688772},"8":{"tf":2.8284271247461903},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"29":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"11":{"tf":1.0}},"f":{"3":{"df":2,"docs":{"1":{"tf":1.0},"21":{"tf":1.0}}},"df":14,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"18":{"tf":3.7416573867739413},"19":{"tf":1.0},"2":{"tf":2.8284271247461903},"20":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":6.082762530298219},"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":2.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":9,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"39":{"tf":5.0},"5":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"e":{"=":{"1":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"15":{"tf":1.4142135623730951},"39":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":5,"docs":{"17":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":2,"docs":{"39":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"2":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.7320508075688772},"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":2.449489742783178}}}},"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"18":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"15":{"tf":1.0},"18":{"tf":2.0},"2":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"39":{"tf":1.0}}}}}}},"d":{"df":3,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":2.8284271247461903}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"0":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"26":{"tf":1.0},"31":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}}},"v":{"df":5,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"39":{"tf":2.8284271247461903},"5":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":2.6457513110645907},"9":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"t":{"c":{"df":5,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"39":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":12,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":4.242640687119285},"5":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"25":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"5":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"39":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"39":{"tf":1.0},"5":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":2.23606797749979},"2":{"tf":1.4142135623730951},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"y":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"38":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":12,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":2.8284271247461903},"17":{"tf":2.449489742783178},"19":{"tf":2.6457513110645907},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":5.5677643628300215},"41":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"d":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"df":1,"docs":{"11":{"tf":1.0}}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},":":{"/":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"1":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":15,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":2.6457513110645907},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":8.717797887081348},"41":{"tf":1.4142135623730951},"5":{"tf":2.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":2.0}}}}},"t":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"29":{"tf":1.4142135623730951},"39":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":2.8284271247461903}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":3.3166247903554},"8":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"r":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":3.0}}},"df":0,"docs":{}}}}}}},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"39":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"=":{"'":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"39":{"tf":5.916079783099616}}}},"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"20":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.7320508075688772}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"g":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"'":{"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979},"5":{"tf":1.4142135623730951}}}}}}}},"df":22,"docs":{"0":{"tf":1.0},"10":{"tf":2.8284271247461903},"11":{"tf":2.0},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":3.4641016151377544},"2":{"tf":2.0},"20":{"tf":1.0},"22":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":3.1622776601683795},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":5.196152422706632},"5":{"tf":3.605551275463989},"7":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"a":{"b":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"33":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"o":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"p":{"df":5,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"15":{"tf":3.3166247903554},"2":{"tf":1.7320508075688772},"39":{"tf":4.47213595499958}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}}},"h":{":":{"%":{"df":0,"docs":{},"m":{":":{"%":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":5,"docs":{"11":{"tf":1.0},"15":{"tf":2.0},"2":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":2.449489742783178}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":1,"docs":{"39":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":2,"docs":{"34":{"tf":1.0},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":2.0},"27":{"tf":1.0},"39":{"tf":5.5677643628300215},"41":{"tf":1.0},"5":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":10,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":2.23606797749979},"5":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0}}},"df":4,"docs":{"3":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"x":{"df":1,"docs":{"39":{"tf":2.0}}}},"g":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"18":{"tf":1.0}}},"df":11,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":3.0},"19":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":4.358898943540674},"5":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"o":{"c":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"27":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"/":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"#":{"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"b":{"/":{"df":0,"docs":{},"e":{"b":{"1":{"1":{"4":{"2":{"9":{"4":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"b":{"c":{"d":{"5":{"a":{"d":{"b":{"1":{"9":{"4":{"4":{"c":{"9":{"df":0,"docs":{},"f":{"3":{"c":{"b":{"5":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"d":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"#":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"a":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"#":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"7":{"df":0,"docs":{},"e":{"c":{"4":{"6":{"2":{"7":{"9":{"0":{"2":{"0":{"2":{"0":{"c":{"c":{"c":{"d":{"7":{"b":{"3":{"df":0,"docs":{},"f":{"4":{"df":0,"docs":{},"f":{"b":{"c":{"6":{"3":{"df":0,"docs":{},"e":{"1":{"b":{"0":{"d":{"6":{"b":{"9":{"7":{"9":{"8":{"c":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"w":{"3":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":4.358898943540674},"41":{"tf":1.0},"5":{"tf":2.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":6,"docs":{"15":{"tf":2.8284271247461903},"2":{"tf":2.0},"22":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989}}}}}}}}}}},"i":{".":{"df":3,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.0}}},"a":{"df":1,"docs":{"3":{"tf":1.0}}},"d":{"df":0,"docs":{},"e":{"a":{":":{"/":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"?":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":2.8284271247461903},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":4.242640687119285},"34":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"16":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"n":{"d":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"26":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0}}}}},"t":{"'":{"df":3,"docs":{"3":{"tf":1.0},"31":{"tf":1.0},"8":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"2":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"i":{"c":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"q":{"/":{"df":0,"docs":{},"s":{"a":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"39":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"z":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.7320508075688772},"5":{"tf":1.0}}}},"y":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"2":{"tf":1.0},"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":3.3166247903554}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"/":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"39":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"23":{"tf":2.8284271247461903},"39":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":2.449489742783178},"16":{"tf":1.4142135623730951},"39":{"tf":4.123105625617661},"41":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":2.0}},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}},"df":4,"docs":{"26":{"tf":2.0},"3":{"tf":1.7320508075688772},"39":{"tf":2.449489742783178},"8":{"tf":3.872983346207417}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"2":{"tf":1.0}}}}}}}}}}}},"i":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"2":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":2.6457513110645907}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{":":{"/":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.0},"14":{"tf":4.0},"15":{"tf":1.7320508075688772},"16":{"tf":3.3166247903554},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"39":{"tf":12.609520212918492},"41":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}},"k":{"df":6,"docs":{"15":{"tf":2.23606797749979},"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":2.6457513110645907}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"23":{"tf":1.7320508075688772},"31":{"tf":1.0},"39":{"tf":2.23606797749979}}}}},"o":{"a":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"14":{"tf":1.7320508075688772},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"m":{"a":{"c":{"df":1,"docs":{"26":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":2,"docs":{"25":{"tf":1.0},"3":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"e":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.23606797749979}}}},"m":{"b":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"i":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"p":{"df":2,"docs":{"19":{"tf":2.0},"39":{"tf":2.0}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":2.23606797749979},"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":3.1622776601683795}}}},"df":0,"docs":{}},"x":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":2.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"39":{"tf":3.7416573867739413},"9":{"tf":1.0}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":3.1622776601683795},"34":{"tf":1.0},"39":{"tf":3.4641016151377544}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"m":{"df":1,"docs":{"39":{"tf":1.0}}}},"u":{"df":5,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":4.242640687119285},"41":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"x":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":2.23606797749979}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"d":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"19":{"tf":3.4641016151377544},"2":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}},"s":{"df":1,"docs":{"37":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"n":{":":{"^":{"4":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"19":{"tf":2.449489742783178},"39":{"tf":5.291502622129181},"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.0},"39":{"tf":3.1622776601683795}}}}}},"df":3,"docs":{"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"39":{"tf":3.4641016151377544}},"e":{"a":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"25":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":8,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"39":{"tf":2.23606797749979},"8":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"w":{"df":2,"docs":{"23":{"tf":1.0},"39":{"tf":2.23606797749979}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"20":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"d":{"a":{"/":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{":":{">":{"4":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"^":{"4":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.449489742783178}},"e":{"df":4,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":3.1622776601683795}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}},"w":{"df":4,"docs":{"15":{"tf":1.0},"19":{"tf":1.7320508075688772},"27":{"tf":1.0},"5":{"tf":1.0}}}},"p":{":":{">":{"4":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"^":{"4":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"14":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":3.1622776601683795},"2":{"tf":1.7320508075688772},"39":{"tf":9.055385138137417},"41":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951}},"s":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"d":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"39":{"tf":1.0}}}}},"df":2,"docs":{"39":{"tf":3.1622776601683795},"5":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":2.0},"5":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":8,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"39":{"tf":3.7416573867739413},"5":{"tf":1.0},"8":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":6,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":2.0}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":5.196152422706632},"5":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.0},"39":{"tf":2.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"s":{"c":{"8":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"15":{"tf":1.4142135623730951},"2":{"tf":1.0},"29":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":2.23606797749979}}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":14,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.8284271247461903},"11":{"tf":1.0},"15":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":5.656854249492381},"5":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"29":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"39":{"tf":1.0}},"r":{"df":9,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"39":{"tf":2.449489742783178},"5":{"tf":1.0},"8":{"tf":2.6457513110645907}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"r":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":2.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"s":{"df":3,"docs":{"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"10":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{"7":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":4.58257569495584}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":4,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"g":{"_":{"a":{"d":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":8,"docs":{"10":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"16":{"tf":1.0},"19":{"tf":1.7320508075688772},"39":{"tf":4.242640687119285},"41":{"tf":1.4142135623730951},"5":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"r":{"df":1,"docs":{"23":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"14":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}},"s":{"df":1,"docs":{"20":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":2.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"35":{"tf":1.0},"38":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951}}}}}},"y":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{":":{"/":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"?":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":4,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"39":{"tf":2.8284271247461903},"5":{"tf":1.0}}}},"df":3,"docs":{"26":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":5,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"m":{"df":2,"docs":{"18":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"39":{"tf":1.0}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"19":{"tf":1.0},"39":{"tf":2.0},"5":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":2.23606797749979}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"=":{"\"":{"\\":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":3.3166247903554}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}},"v":{"df":4,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":4.0}},"e":{"d":{"/":{"a":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":2.23606797749979},"7":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}}},"g":{"b":{"df":1,"docs":{"39":{"tf":2.23606797749979}}},"df":3,"docs":{"15":{"tf":1.7320508075688772},"2":{"tf":1.0},"39":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":2.8284271247461903},"16":{"tf":1.4142135623730951},"39":{"tf":4.795831523312719},"41":{"tf":1.0},"8":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"n":{"df":5,"docs":{"23":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.449489742783178},"7":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"m":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":2.449489742783178},"39":{"tf":1.0},"8":{"tf":1.0}},"r":{"c":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"40":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"39":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":7.3484692283495345},"5":{"tf":1.0}}}}}}},"d":{"_":{"c":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":2.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"39":{"tf":7.0710678118654755},"5":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":3.4641016151377544}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"t":{"df":12,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":1.0},"39":{"tf":4.69041575982343},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"p":{"/":{"b":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"w":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":3.872983346207417},"5":{"tf":1.7320508075688772}},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":3.872983346207417},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"2":{"tf":2.0},"39":{"tf":3.3166247903554},"41":{"tf":2.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"3":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":3.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.7320508075688772},"39":{"tf":4.0}}}},"df":0,"docs":{},"f":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"9":{"tf":1.0}},"i":{"df":3,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":3.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":2.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"y":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":8.831760866327848}}}},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"=":{"\"":{"#":{"0":{"df":0,"docs":{},"e":{"7":{"c":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"2":{"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"0":{"tf":1.0},"12":{"tf":2.0},"14":{"tf":1.0},"16":{"tf":3.1622776601683795},"17":{"tf":1.0},"19":{"tf":5.0990195135927845},"2":{"tf":1.0},"21":{"tf":2.0},"27":{"tf":1.7320508075688772},"39":{"tf":14.2828568570857},"41":{"tf":3.1622776601683795},"5":{"tf":2.8284271247461903}},"s":{"=":{"'":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":2.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":2.0},"29":{"tf":1.4142135623730951},"39":{"tf":3.0}}}},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.7320508075688772},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"39":{"tf":3.872983346207417}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":11,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":2.0},"19":{"tf":2.6457513110645907},"2":{"tf":2.0},"23":{"tf":1.4142135623730951},"39":{"tf":5.744562646538029},"41":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":3,"docs":{"28":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"39":{"tf":2.449489742783178}},"s":{"=":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"16":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":8,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":3.872983346207417},"8":{"tf":1.0}}}}},"h":{"1":{"0":{"0":{"0":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"19":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"39":{"tf":2.0}}}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":7,"docs":{"17":{"tf":3.7416573867739413},"19":{"tf":2.23606797749979},"2":{"tf":1.0},"23":{"tf":3.1622776601683795},"39":{"tf":4.58257569495584},"41":{"tf":1.0},"5":{"tf":1.4142135623730951}},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"17":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{":":{"<":{"1":{"5":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}}}}},"p":{"df":1,"docs":{"24":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"x":{"#":{"6":{"9":{"6":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"31":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":3,"docs":{"26":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"/":{"2":{"4":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":1.0}}}}}}},"df":10,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}},"|":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":2.23606797749979}}},"i":{"c":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.0}},"l":{"df":4,"docs":{"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989},"41":{"tf":1.7320508075688772}}},"n":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.449489742783178}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"16":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":2.6457513110645907}},"e":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"2":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"p":{"df":1,"docs":{"28":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"32":{"tf":1.0},"39":{"tf":2.23606797749979}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":28,"docs":{"11":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"16":{"tf":2.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":2.6457513110645907},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"3":{"tf":2.23606797749979},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":8.660254037844387},"40":{"tf":1.0},"5":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951},"8":{"tf":3.1622776601683795},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":5,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"v":{"2":{".":{"1":{"7":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":1,"docs":{"29":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":4.69041575982343},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"r":{"df":4,"docs":{"25":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"39":{"tf":3.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":2.6457513110645907},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":3.605551275463989},"8":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"a":{"df":2,"docs":{"20":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":5,"docs":{"14":{"tf":2.0},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"41":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"s":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"32":{"tf":1.0}}},":":{"/":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"15":{"tf":1.0},"32":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":1,"docs":{"33":{"tf":1.7320508075688772}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":2.23606797749979},"7":{"tf":1.0}}}},"y":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":2.23606797749979},"5":{"tf":1.0}}}},"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.4142135623730951}},"e":{"b":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"x":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"39":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":4.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":2.449489742783178}},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":10,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"31":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"14":{"tf":3.3166247903554},"2":{"tf":1.0},"39":{"tf":4.358898943540674}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"x":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"31":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"16":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"r":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"17":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}}},"z":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":3.1622776601683795}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"6":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"0":{"2":{"8":{"0":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"8":{"0":{"0":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"7":{"a":{"0":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"1":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"0":{".":{"1":{"1":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"39":{"tf":1.0}}},"4":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"4":{"0":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"39":{"tf":1.0}}},"9":{".":{"1":{"0":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":2.0}}},"2":{"0":{"1":{"8":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.0}}},"2":{"df":1,"docs":{"16":{"tf":1.0}}},"4":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"39":{"tf":1.0}}}}},"df":4,"docs":{"25":{"tf":2.6457513110645907},"29":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":2.23606797749979}}},"5":{"5":{"df":1,"docs":{"39":{"tf":1.0}}},"6":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"41":{"tf":1.0}}},"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":2.8284271247461903}}},"3":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"4":{"0":{"0":{"0":{"1":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}},"f":{"0":{"0":{"0":{"1":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"4":{"4":{"4":{"4":{"4":{"4":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"39":{"tf":2.449489742783178}}},"5":{"0":{"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"1":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"8":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"7":{"2":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"4":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"_":{"df":1,"docs":{"39":{"tf":1.0}}},"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"29":{"tf":1.0}},"o":{"df":0,"docs":{},"v":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":3.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":2.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.449489742783178},"9":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":7,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"23":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}},"e":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":6,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"39":{"tf":4.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}},"k":{"a":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"39":{"tf":4.242640687119285}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"n":{"df":4,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":3.7416573867739413}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}},"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":2.8284271247461903}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":3.605551275463989}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"<":{"1":{"5":{".":{"1":{"4":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":1,"docs":{"39":{"tf":4.69041575982343}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"|":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.6457513110645907},"5":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":4.242640687119285}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"20":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"a":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"df":4,"docs":{"17":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"26":{"tf":1.0},"8":{"tf":2.0}}}},"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.8284271247461903}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"25":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"39":{"tf":2.23606797749979},"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"3":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":4,"docs":{"25":{"tf":2.6457513110645907},"29":{"tf":1.0},"31":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"2":{"tf":1.0},"22":{"tf":2.23606797749979},"39":{"tf":4.358898943540674}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"27":{"tf":1.4142135623730951},"39":{"tf":2.6457513110645907},"5":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"19":{"tf":2.6457513110645907},"29":{"tf":1.0},"39":{"tf":2.6457513110645907},"41":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.4142135623730951},"39":{"tf":2.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"x":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":6,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":2.8284271247461903},"41":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"39":{"tf":1.0}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":4,"docs":{"18":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":2.0},"34":{"tf":2.0}}},"df":0,"docs":{}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"34":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"23":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}}}},"c":{"c":{"c":{"c":{"c":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":3,"docs":{"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"2":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":3.7416573867739413},"5":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":4.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"25":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}},"m":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"o":{"#":{"2":{"5":{"6":{":":{"a":{"b":{"=":{"\\":{"df":0,"docs":{},"e":{"[":{"4":{"8":{";":{"5":{";":{"%":{"d":{"df":0,"docs":{},"m":{":":{"a":{"df":0,"docs":{},"f":{"=":{"\\":{"df":0,"docs":{},"e":{"[":{"3":{"8":{";":{"5":{";":{"%":{"d":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":3.605551275463989},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{".":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":2.449489742783178},"15":{"tf":1.0},"17":{"tf":2.6457513110645907},"18":{"tf":1.0},"19":{"tf":4.58257569495584},"2":{"tf":2.0},"23":{"tf":2.23606797749979},"25":{"tf":3.3166247903554},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":2.6457513110645907},"31":{"tf":2.23606797749979},"39":{"tf":9.219544457292887},"5":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"19":{"tf":1.0}}}}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}}}}}},"2":{"5":{"6":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"25":{"tf":1.0},"39":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"39":{"tf":3.872983346207417}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.6457513110645907},"5":{"tf":1.4142135623730951},"8":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{"<":{"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"39":{"tf":4.795831523312719},"41":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}}}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"d":{"a":{"df":1,"docs":{"3":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"#":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":10,"docs":{"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"39":{"tf":3.7416573867739413},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"5":{"tf":2.0},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"21":{"tf":3.1622776601683795},"39":{"tf":3.4641016151377544}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"21":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"14":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"17":{"tf":1.0},"39":{"tf":3.605551275463989},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":2.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":2.0}}}},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"26":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":7,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":2.23606797749979},"39":{"tf":1.7320508075688772}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":2.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"d":{"0":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"d":{"0":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":1,"docs":{"38":{"tf":1.0}},"n":{"d":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"39":{"tf":2.6457513110645907}}}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"b":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"16":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"39":{"tf":4.242640687119285},"41":{"tf":2.23606797749979},"5":{"tf":2.0}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":9.9498743710662},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.0}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"t":{"a":{"'":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":2.0}}},".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"=":{"'":{"+":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"+":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"26":{"tf":1.4142135623730951},"39":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":36,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":2.0},"10":{"tf":3.872983346207417},"11":{"tf":2.8284271247461903},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":2.6457513110645907},"16":{"tf":2.6457513110645907},"17":{"tf":2.8284271247461903},"18":{"tf":2.0},"19":{"tf":3.4641016151377544},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":2.449489742783178},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.449489742783178},"29":{"tf":1.7320508075688772},"3":{"tf":4.47213595499958},"30":{"tf":2.23606797749979},"31":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":2.0},"34":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"39":{"tf":7.0},"40":{"tf":1.7320508075688772},"41":{"tf":2.0},"5":{"tf":3.872983346207417},"7":{"tf":1.7320508075688772},"8":{"tf":2.8284271247461903},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":3,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"29":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"11":{"tf":1.0}},"f":{"3":{"df":2,"docs":{"1":{"tf":1.0},"21":{"tf":1.0}}},"df":14,"docs":{"0":{"tf":2.0},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"18":{"tf":4.242640687119285},"19":{"tf":1.0},"2":{"tf":2.8284271247461903},"20":{"tf":2.0},"21":{"tf":2.23606797749979},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":6.082762530298219},"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":2.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":9,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"39":{"tf":5.0},"5":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"e":{"=":{"1":{".":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"15":{"tf":1.4142135623730951},"39":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":5,"docs":{"17":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":2,"docs":{"39":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"2":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.7320508075688772},"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":2.449489742783178}}}},"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"18":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"15":{"tf":1.0},"18":{"tf":2.449489742783178},"2":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"39":{"tf":1.0}}}}}}},"d":{"df":3,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":2.8284271247461903}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"0":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"26":{"tf":1.0},"31":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}}},"v":{"df":5,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"39":{"tf":2.8284271247461903},"5":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":3.0},"9":{"tf":1.7320508075688772}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"t":{"c":{"df":5,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"27":{"tf":2.23606797749979},"39":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":12,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":4.242640687119285},"5":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"25":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"5":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"39":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"39":{"tf":1.0},"5":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":2.6457513110645907},"2":{"tf":1.4142135623730951},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"y":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"38":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":12,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":3.1622776601683795},"17":{"tf":2.449489742783178},"19":{"tf":2.6457513110645907},"2":{"tf":2.0},"20":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":5.5677643628300215},"41":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"d":{"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"df":1,"docs":{"11":{"tf":1.0}}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},":":{"/":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"1":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":15,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":2.6457513110645907},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":8.717797887081348},"41":{"tf":1.4142135623730951},"5":{"tf":2.23606797749979}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":2.0}}}}},"t":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"29":{"tf":1.4142135623730951},"39":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":2.8284271247461903}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":3.3166247903554},"8":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"r":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":3.0}}},"df":0,"docs":{}}}}}}},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"39":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"=":{"'":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"39":{"tf":5.916079783099616}}}},"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"20":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":2.23606797749979}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"g":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"'":{"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979},"5":{"tf":1.4142135623730951}}}}}}}},"df":22,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.8284271247461903},"11":{"tf":2.0},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":3.4641016151377544},"2":{"tf":2.0},"20":{"tf":1.0},"22":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":3.1622776601683795},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":5.196152422706632},"5":{"tf":3.7416573867739413},"7":{"tf":2.23606797749979},"8":{"tf":1.0},"9":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"a":{"b":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"33":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":2.0}}}},"o":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"p":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"15":{"tf":3.605551275463989},"2":{"tf":1.7320508075688772},"39":{"tf":4.47213595499958}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"16":{"tf":1.7320508075688772},"17":{"tf":1.0}}}}}}},"h":{":":{"%":{"df":0,"docs":{},"m":{":":{"%":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":5,"docs":{"11":{"tf":1.0},"15":{"tf":2.0},"2":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":2.449489742783178}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":1,"docs":{"39":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":2,"docs":{"34":{"tf":1.0},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":2.0},"27":{"tf":1.0},"39":{"tf":5.5677643628300215},"41":{"tf":1.0},"5":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":10,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":2.6457513110645907},"5":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0}}},"df":4,"docs":{"3":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"x":{"df":1,"docs":{"39":{"tf":2.0}}}},"g":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"18":{"tf":1.0}}},"df":11,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":3.3166247903554},"19":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":4.358898943540674},"5":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"o":{"c":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":1,"docs":{"27":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"/":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"#":{"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"b":{"/":{"df":0,"docs":{},"e":{"b":{"1":{"1":{"4":{"2":{"9":{"4":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"b":{"c":{"d":{"5":{"a":{"d":{"b":{"1":{"9":{"4":{"4":{"c":{"9":{"df":0,"docs":{},"f":{"3":{"c":{"b":{"5":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"d":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"#":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"a":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"#":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{"7":{"df":0,"docs":{},"e":{"c":{"4":{"6":{"2":{"7":{"9":{"0":{"2":{"0":{"2":{"0":{"c":{"c":{"c":{"d":{"7":{"b":{"3":{"df":0,"docs":{},"f":{"4":{"df":0,"docs":{},"f":{"b":{"c":{"6":{"3":{"df":0,"docs":{},"e":{"1":{"b":{"0":{"d":{"6":{"b":{"9":{"7":{"9":{"8":{"c":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"w":{"3":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":4.358898943540674},"41":{"tf":1.0},"5":{"tf":2.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":6,"docs":{"15":{"tf":2.8284271247461903},"2":{"tf":2.0},"22":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989}}}}}}}}}}},"i":{".":{"df":3,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.0}}},"a":{"df":1,"docs":{"3":{"tf":1.0}}},"d":{"df":0,"docs":{},"e":{"a":{":":{"/":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"?":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":2.8284271247461903},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":4.47213595499958},"34":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"16":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"n":{"d":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"26":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0}}}}},"t":{"'":{"df":3,"docs":{"3":{"tf":1.0},"31":{"tf":1.0},"8":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"2":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"i":{"c":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"q":{"/":{"df":0,"docs":{},"s":{"a":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"39":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"z":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.7320508075688772},"5":{"tf":1.0}}}},"y":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"2":{"tf":1.0},"20":{"tf":2.0}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":3.3166247903554}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"/":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"39":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"23":{"tf":3.1622776601683795},"39":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":2.449489742783178},"16":{"tf":1.4142135623730951},"39":{"tf":4.123105625617661},"41":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":2.0}},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}},"df":4,"docs":{"26":{"tf":2.0},"3":{"tf":1.7320508075688772},"39":{"tf":2.449489742783178},"8":{"tf":3.872983346207417}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"2":{"tf":1.0}}}}}}}}}}}},"i":{"b":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"2":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":2.6457513110645907}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{":":{"/":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.449489742783178},"14":{"tf":4.0},"15":{"tf":1.7320508075688772},"16":{"tf":3.3166247903554},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"39":{"tf":12.609520212918492},"41":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}},"k":{"df":6,"docs":{"15":{"tf":2.23606797749979},"2":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":2.6457513110645907}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"23":{"tf":1.7320508075688772},"31":{"tf":1.0},"39":{"tf":2.23606797749979}}}}},"o":{"a":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"14":{"tf":1.7320508075688772},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"m":{"a":{"c":{"df":1,"docs":{"26":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":2,"docs":{"25":{"tf":1.0},"3":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":2.23606797749979}}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"k":{"df":0,"docs":{},"e":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.23606797749979}}}},"m":{"b":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"i":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"p":{"df":2,"docs":{"19":{"tf":2.0},"39":{"tf":2.0}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":2.23606797749979},"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":3.1622776601683795}}}},"df":0,"docs":{}},"x":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":2.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"39":{"tf":3.7416573867739413},"9":{"tf":1.0}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":3.4641016151377544},"34":{"tf":1.0},"39":{"tf":3.4641016151377544}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"m":{"df":1,"docs":{"39":{"tf":1.0}}}},"u":{"df":5,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":4.242640687119285},"41":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"x":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":2.23606797749979}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"d":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"26":{"tf":2.0},"8":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"19":{"tf":3.7416573867739413},"2":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}},"s":{"df":1,"docs":{"37":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"n":{":":{"^":{"4":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"19":{"tf":2.449489742783178},"39":{"tf":5.291502622129181},"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.449489742783178},"39":{"tf":3.1622776601683795}}}}}},"df":3,"docs":{"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"39":{"tf":3.4641016151377544}},"e":{"a":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"25":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":8,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"39":{"tf":2.23606797749979},"8":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"w":{"df":2,"docs":{"23":{"tf":1.0},"39":{"tf":2.23606797749979}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"20":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"d":{"a":{"/":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{":":{">":{"4":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"^":{"4":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.449489742783178}},"e":{"df":4,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":3.1622776601683795}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}},"w":{"df":4,"docs":{"15":{"tf":1.0},"19":{"tf":1.7320508075688772},"27":{"tf":1.0},"5":{"tf":1.0}}}},"p":{":":{">":{"4":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"^":{"4":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"14":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":3.1622776601683795},"2":{"tf":1.7320508075688772},"39":{"tf":9.055385138137417},"41":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951}},"s":{"=":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"d":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"39":{"tf":1.0}}}}},"df":2,"docs":{"39":{"tf":3.1622776601683795},"5":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":2.0},"5":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":8,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"39":{"tf":3.7416573867739413},"5":{"tf":1.0},"8":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":6,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":2.0}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":5.196152422706632},"5":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.0},"39":{"tf":2.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}},"s":{"c":{"8":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"15":{"tf":1.4142135623730951},"2":{"tf":1.0},"29":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":2.23606797749979}}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":14,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":2.8284271247461903},"11":{"tf":1.0},"15":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":5.830951894845301},"5":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"29":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"39":{"tf":1.0}},"r":{"df":9,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"39":{"tf":2.449489742783178},"5":{"tf":1.0},"8":{"tf":2.8284271247461903}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"r":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":2.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"s":{"df":3,"docs":{"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"10":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{"7":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":4.58257569495584}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":4,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":2,"docs":{"14":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"g":{"_":{"a":{"d":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":8,"docs":{"10":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"16":{"tf":1.0},"19":{"tf":1.7320508075688772},"39":{"tf":4.242640687119285},"41":{"tf":1.4142135623730951},"5":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"29":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"r":{"df":1,"docs":{"23":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"14":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}}},"s":{"df":1,"docs":{"20":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":2.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951}}}}}},"y":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{":":{"/":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"?":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":4,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"39":{"tf":2.8284271247461903},"5":{"tf":1.0}}}},"df":3,"docs":{"26":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":5,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"m":{"df":2,"docs":{"18":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"39":{"tf":1.0}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"19":{"tf":1.0},"39":{"tf":2.0},"5":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":2.23606797749979}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"=":{"\"":{"\\":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":3.3166247903554}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}},"v":{"df":4,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":4.0}},"e":{"d":{"/":{"a":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":2.23606797749979}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":2.23606797749979},"7":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}}},"g":{"b":{"df":1,"docs":{"39":{"tf":2.23606797749979}}},"df":3,"docs":{"15":{"tf":1.7320508075688772},"2":{"tf":1.0},"39":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":2.8284271247461903},"16":{"tf":1.4142135623730951},"39":{"tf":4.795831523312719},"41":{"tf":1.0},"8":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}},"n":{"df":5,"docs":{"23":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":2.449489742783178},"7":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"m":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":2.8284271247461903},"39":{"tf":1.0},"8":{"tf":1.0}},"r":{"c":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":2.0}}}}}}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"39":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":7.3484692283495345},"5":{"tf":1.0}}}}}}},"d":{"_":{"c":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":2.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"39":{"tf":7.0710678118654755},"5":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":3.4641016151377544}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"t":{"df":12,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":2.0},"17":{"tf":2.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":1.0},"39":{"tf":4.69041575982343},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"p":{"/":{"b":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"w":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":3.872983346207417},"5":{"tf":1.7320508075688772}},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":4.358898943540674},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"2":{"tf":2.0},"39":{"tf":3.3166247903554},"41":{"tf":2.449489742783178},"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"3":{"tf":1.0},"34":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":3.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.7320508075688772},"39":{"tf":4.0}}}},"df":0,"docs":{},"f":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}},"i":{"df":3,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":3.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":2.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.7320508075688772},"39":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"t":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"y":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":8.831760866327848}}}},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"=":{"\"":{"#":{"0":{"df":0,"docs":{},"e":{"7":{"c":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"2":{"8":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"0":{"tf":1.0},"12":{"tf":2.449489742783178},"14":{"tf":1.0},"16":{"tf":3.1622776601683795},"17":{"tf":1.0},"19":{"tf":5.0990195135927845},"2":{"tf":1.0},"21":{"tf":2.0},"27":{"tf":1.7320508075688772},"39":{"tf":14.2828568570857},"41":{"tf":3.1622776601683795},"5":{"tf":2.8284271247461903}},"s":{"=":{"'":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":2.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"15":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"23":{"tf":2.0},"25":{"tf":2.0},"29":{"tf":1.4142135623730951},"39":{"tf":3.0}}}},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.7320508075688772},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"39":{"tf":3.872983346207417}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":11,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":2.0},"19":{"tf":2.6457513110645907},"2":{"tf":2.0},"23":{"tf":1.4142135623730951},"39":{"tf":5.744562646538029},"41":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":3,"docs":{"28":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"39":{"tf":2.449489742783178}},"s":{"=":{"0":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"16":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},".":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":8,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":3.872983346207417},"8":{"tf":1.0}}}}},"h":{"1":{"0":{"0":{"0":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"19":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"39":{"tf":2.0}}}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":7,"docs":{"17":{"tf":4.0},"19":{"tf":2.23606797749979},"2":{"tf":1.0},"23":{"tf":3.4641016151377544},"39":{"tf":4.58257569495584},"41":{"tf":1.0},"5":{"tf":1.4142135623730951}},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"17":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"0":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{":":{"<":{"1":{"5":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"39":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}}}}},"p":{"df":9,"docs":{"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"x":{"#":{"6":{"9":{"6":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"31":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"39":{"tf":1.0}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":9,"docs":{"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}}}},"df":3,"docs":{"26":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"/":{"2":{"4":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"25":{"tf":2.0},"29":{"tf":1.0},"39":{"tf":1.0}}}}}}},"df":10,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"39":{"tf":2.23606797749979}},"|":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"39":{"tf":2.23606797749979}}},"i":{"c":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.0}},"l":{"df":4,"docs":{"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"39":{"tf":3.605551275463989},"41":{"tf":1.7320508075688772}}},"n":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"19":{"tf":1.0},"39":{"tf":2.449489742783178}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"16":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"39":{"tf":2.6457513110645907}},"e":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"2":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"p":{"df":1,"docs":{"28":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"32":{"tf":1.0},"39":{"tf":2.23606797749979}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":14,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":29,"docs":{"11":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"16":{"tf":2.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":2.6457513110645907},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":2.23606797749979},"3":{"tf":2.23606797749979},"30":{"tf":2.0},"31":{"tf":2.0},"32":{"tf":2.23606797749979},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"39":{"tf":8.660254037844387},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951},"8":{"tf":3.1622776601683795},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":5,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"19":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"v":{"2":{".":{"1":{"7":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":1,"docs":{"29":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":4.69041575982343},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"r":{"df":4,"docs":{"25":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"39":{"tf":3.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":3.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":3.605551275463989},"8":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"a":{"df":2,"docs":{"20":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":5,"docs":{"14":{"tf":2.449489742783178},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"41":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"s":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"32":{"tf":1.0}}},":":{"/":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"}":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"15":{"tf":1.0},"32":{"tf":2.6457513110645907}}}},"df":0,"docs":{}}},"df":1,"docs":{"33":{"tf":1.7320508075688772}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":2.23606797749979},"7":{"tf":1.0}}}},"y":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":2.23606797749979},"5":{"tf":1.0}}}},"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.4142135623730951}},"e":{"b":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"x":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"39":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":2.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":4.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"26":{"tf":1.0},"28":{"tf":2.0},"3":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"39":{"tf":2.449489742783178}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":2.449489742783178}},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":10,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"31":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"14":{"tf":3.3166247903554},"2":{"tf":1.0},"39":{"tf":4.358898943540674}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"x":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"31":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"16":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"r":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"17":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}}},"z":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":3.1622776601683795}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"title":{"root":{"2":{"4":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"40":{"tf":1.0},"5":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":11,"docs":{"10":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"0":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"t":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"2":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"0":{"tf":1.0},"15":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"18":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0}}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"23":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"23":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"24":{"tf":1.0}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":8,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"14":{"tf":1.0},"41":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});