/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor.conversion;

import java.text.DecimalFormat;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.conversion.AbstractCoordinateFormat;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class NauticalCoordinateFormat
extends AbstractCoordinateFormat {
    private static final DecimalFormat DM_MINUTE_FORMATTER = NauticalCoordinateFormat.newUnlocalizedDecimalFormat(Config.getPref() == null ? "00.000" : Config.getPref().get("latlon.dm.decimal-format", "00.000"));
    private static final String DM60 = DM_MINUTE_FORMATTER.format(60.0);
    private static final String DM00 = DM_MINUTE_FORMATTER.format(0.0);
    public static final NauticalCoordinateFormat INSTANCE = new NauticalCoordinateFormat();

    protected NauticalCoordinateFormat() {
        super("NAUTICAL", I18n.tr("deg\u00b0 min'' (Nautical)", new Object[0]));
    }

    @Override
    public String latToString(ILatLon ll) {
        return NauticalCoordinateFormat.degreesMinutes(ll.lat()) + (ll.lat() < 0.0 ? SOUTH : NORTH);
    }

    @Override
    public String lonToString(ILatLon ll) {
        return NauticalCoordinateFormat.degreesMinutes(ll.lon()) + (ll.lon() < 0.0 ? WEST : EAST);
    }

    public static String degreesMinutes(double pCoordinate) {
        double tAbsCoord = Math.abs(pCoordinate);
        int tDegree = (int)tAbsCoord;
        double tMinutes = (tAbsCoord - (double)tDegree) * 60.0;
        String sDegrees = Integer.toString(tDegree);
        String sMinutes = DM_MINUTE_FORMATTER.format(tMinutes);
        if (sMinutes.equals(DM60)) {
            sMinutes = DM00;
            sDegrees = Integer.toString(tDegree + 1);
        }
        return sDegrees + '\u00b0' + sMinutes + '\'';
    }
}

