/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable,
ProgressMonitor.CancelListener {
    private final boolean ignoreException;
    private final String title;
    protected final ProgressMonitor progressMonitor;

    protected PleaseWaitRunnable(String title) {
        this(title, false);
    }

    protected PleaseWaitRunnable(String title, boolean ignoreException) {
        this(title, new PleaseWaitProgressMonitor(title), ignoreException);
    }

    protected PleaseWaitRunnable(Component parent, String title, boolean ignoreException) {
        CheckParameterUtil.ensureParameterNotNull(parent, "parent");
        this.title = title;
        this.progressMonitor = new PleaseWaitProgressMonitor(parent, title);
        this.ignoreException = ignoreException;
    }

    protected PleaseWaitRunnable(String title, ProgressMonitor progressMonitor, boolean ignoreException) {
        this.title = title;
        this.progressMonitor = progressMonitor == null ? new PleaseWaitProgressMonitor(title) : progressMonitor;
        this.ignoreException = ignoreException;
    }

    private void doRealRun() {
        block13: {
            try {
                ProgressTaskId oldTaskId = null;
                try {
                    this.progressMonitor.addCancelListener(this);
                    this.progressMonitor.beginTask(this.title);
                    oldTaskId = this.progressMonitor.getProgressTaskId();
                    this.progressMonitor.setProgressTaskId(this.canRunInBackground());
                    try {
                        this.realRun();
                    }
                    finally {
                        if (EventQueue.isDispatchThread()) {
                            this.finish();
                        } else {
                            EventQueue.invokeAndWait(this::finish);
                        }
                    }
                }
                finally {
                    this.progressMonitor.finishTask();
                    this.progressMonitor.removeCancelListener(this);
                    this.progressMonitor.setProgressTaskId(oldTaskId);
                    if (this.progressMonitor instanceof PleaseWaitProgressMonitor) {
                        ((PleaseWaitProgressMonitor)this.progressMonitor).close();
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.afterFinish();
                    } else {
                        EventQueue.invokeAndWait(this::afterFinish);
                    }
                }
            }
            catch (IOException | InterruptedException | RuntimeException | InvocationTargetException | OsmTransferException | SAXException e) {
                if (this.ignoreException) break block13;
                SwingUtilities.invokeLater(() -> {
                    if (e instanceof RuntimeException) {
                        BugReportExceptionHandler.handleException(e);
                    } else {
                        ExceptionDialogUtil.explainException(e);
                    }
                });
            }
        }
    }

    protected void afterFinish() {
    }

    @Override
    public final void run() {
        if (EventQueue.isDispatchThread()) {
            new Thread(this::doRealRun, this.getClass().getName()).start();
        } else {
            this.doRealRun();
        }
    }

    @Override
    public void operationCanceled() {
        this.cancel();
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException, OsmTransferException;

    protected abstract void finish();

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public ProgressTaskId canRunInBackground() {
        return null;
    }
}

