/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.DrawableLabel;
import net.sf.sdedit.drawable.Strokes;

public class Figure
extends Drawable {
    private int actorHeight;
    private int actorWidth;
    private boolean shouldShadow;

    public Figure(Lifeline actor, String _label, int y, boolean underline) {
        super(actor.getDiagram());
        this.setTop(y);
        String lab = !_label.equals("") ? _label : actor.getName();
        DrawableLabel label = this.addLabel();
        label.setLabel(lab.split("\\\\n"));
        label.setUnderlined(underline);
        int width = Math.max(actor.getDiagram().getConfiguration().getActorWidth(), label.textWidth());
        this.setWidth(width);
        this.actorHeight = actor.getDiagram().getConfiguration().getHeadHeight();
        this.setHeight(this.actorHeight + 3 + label.textHeight());
        this.actorWidth = actor.getDiagram().getConfiguration().getActorWidth();
        this.shouldShadow = actor.getDiagram().getConfiguration().isShouldShadowParticipants();
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        this.getLabel().drawLabel(g2d, this.getLeft() + this.getWidth() / 2 - this.getLabel().textWidth() / 2, this.getTop() + this.getHeight() - 3, Color.BLACK, Color.WHITE);
        this.renderActor(g2d, this.getTop(), this.getTop() + this.actorHeight - 2, this.getLeft() + this.getWidth() / 2, this.actorWidth);
    }

    private void renderActor(Graphics2D g, int from, int to, int axis, int width) {
        int ofs = 4;
        int thickness = 4;
        int left = axis - width / 2;
        int right = axis + width / 2;
        int height = to - from;
        int arms = (int)((float)height * 0.4f);
        int headDiameter = (int)((float)height * 0.3f);
        int legs = (int)((float)height * 0.6f);
        if (this.shouldShadow) {
            g.fillOval(axis - headDiameter / 2 + ofs, from + ofs, headDiameter, headDiameter);
            g.setStroke(Strokes.getStroke(Strokes.StrokeType.SOLID, thickness));
            g.drawLine(axis + ofs, from + headDiameter, axis + ofs, from + legs);
            g.drawLine(left + ofs, from + arms + ofs, right + ofs, from + arms + ofs);
            g.drawLine(axis + ofs, from + legs + ofs, left + ofs, to + ofs);
            g.drawLine(axis + (int)(1.5 * (double)ofs), from + legs + ofs, right + (int)(1.5 * (double)ofs) - 1, to + 1);
            g.setStroke(Strokes.defaultStroke());
        }
        g.setColor(Color.WHITE);
        g.fillOval(axis - headDiameter / 2, from, headDiameter, headDiameter);
        g.setColor(Color.BLACK);
        g.drawOval(axis - headDiameter / 2, from, headDiameter, headDiameter);
        Polygon poly = new Polygon();
        poly.addPoint(axis - thickness / 2, from + headDiameter);
        poly.addPoint(axis - thickness / 2, from + arms);
        poly.addPoint(left, from + arms);
        poly.addPoint(left, from + arms + thickness);
        poly.addPoint(axis - thickness / 2, from + arms + thickness);
        poly.addPoint(axis - thickness / 2, from + legs);
        poly.addPoint(left, to);
        poly.addPoint(left + thickness, to + thickness);
        poly.addPoint(axis, from + legs + thickness);
        poly.addPoint(right, to + thickness);
        poly.addPoint(right + thickness, to);
        poly.addPoint(axis + thickness / 2, from + legs);
        poly.addPoint(axis + thickness / 2, from + arms + thickness);
        poly.addPoint(right + thickness, from + arms + thickness);
        poly.addPoint(right + thickness, from + arms);
        poly.addPoint(axis + thickness / 2, from + arms);
        poly.addPoint(axis + thickness / 2, from + headDiameter);
        g.setColor(Color.WHITE);
        g.fillPolygon(poly);
        g.setColor(Color.BLACK);
        g.drawPolygon(poly);
    }

    @Override
    public void computeLayoutInformation() {
    }
}

