"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Stream = require('stream');

var util = require('util');

var net = require('net');

var tls = require('tls'); // eslint-disable-next-line node/no-deprecated-api


var _require = require('url'),
    parse = _require.parse;

var process = require('process');

var semverGte = require('semver/functions/gte');

var http2;
if (semverGte(process.version, 'v10.10.0')) http2 = require('http2');else throw new Error('superagent: this version of Node.js does not support http2');
var _http2$constants = http2.constants,
    HTTP2_HEADER_PATH = _http2$constants.HTTP2_HEADER_PATH,
    HTTP2_HEADER_STATUS = _http2$constants.HTTP2_HEADER_STATUS,
    HTTP2_HEADER_METHOD = _http2$constants.HTTP2_HEADER_METHOD,
    HTTP2_HEADER_AUTHORITY = _http2$constants.HTTP2_HEADER_AUTHORITY,
    HTTP2_HEADER_HOST = _http2$constants.HTTP2_HEADER_HOST,
    HTTP2_HEADER_SET_COOKIE = _http2$constants.HTTP2_HEADER_SET_COOKIE,
    NGHTTP2_CANCEL = _http2$constants.NGHTTP2_CANCEL;

function setProtocol(protocol) {
  return {
    request: function request(options) {
      return new Request(protocol, options);
    }
  };
}

function Request(protocol, options) {
  var _this = this;

  Stream.call(this);
  var defaultPort = protocol === 'https:' ? 443 : 80;
  var defaultHost = 'localhost';
  var port = options.port || defaultPort;
  var host = options.host || defaultHost;
  delete options.port;
  delete options.host;
  this.method = options.method;
  this.path = options.path;
  this.protocol = protocol;
  this.host = host;
  delete options.method;
  delete options.path;

  var sessionOptions = _objectSpread({}, options);

  if (options.socketPath) {
    sessionOptions.socketPath = options.socketPath;
    sessionOptions.createConnection = this.createUnixConnection.bind(this);
  }

  this._headers = {};
  var session = http2.connect("".concat(protocol, "//").concat(host, ":").concat(port), sessionOptions);
  this.setHeader('host', "".concat(host, ":").concat(port));
  session.on('error', function (error) {
    return _this.emit('error', error);
  });
  this.session = session;
}
/**
 * Inherit from `Stream` (which inherits from `EventEmitter`).
 */


util.inherits(Request, Stream);

Request.prototype.createUnixConnection = function (authority, options) {
  switch (this.protocol) {
    case 'http:':
      return net.connect(options.socketPath);

    case 'https:':
      options.ALPNProtocols = ['h2'];
      options.servername = this.host;
      options.allowHalfOpen = true;
      return tls.connect(options.socketPath, options);

    default:
      throw new Error('Unsupported protocol', this.protocol);
  }
}; // eslint-disable-next-line no-unused-vars


Request.prototype.setNoDelay = function (bool) {// We can not use setNoDelay with HTTP/2.
  // Node 10 limits http2session.socket methods to ones safe to use with HTTP/2.
  // See also https://nodejs.org/api/http2.html#http2_http2session_socket
};

Request.prototype.getFrame = function () {
  var _method,
      _this2 = this;

  if (this.frame) {
    return this.frame;
  }

  var method = (_method = {}, _defineProperty(_method, HTTP2_HEADER_PATH, this.path), _defineProperty(_method, HTTP2_HEADER_METHOD, this.method), _method);
  var headers = this.mapToHttp2Header(this._headers);
  headers = Object.assign(headers, method);
  var frame = this.session.request(headers); // eslint-disable-next-line no-unused-vars

  frame.once('response', function (headers, flags) {
    headers = _this2.mapToHttpHeader(headers);
    frame.headers = headers;
    frame.statusCode = headers[HTTP2_HEADER_STATUS];
    frame.status = frame.statusCode;

    _this2.emit('response', frame);
  });
  this._headerSent = true;
  frame.once('drain', function () {
    return _this2.emit('drain');
  });
  frame.on('error', function (error) {
    return _this2.emit('error', error);
  });
  frame.on('close', function () {
    return _this2.session.close();
  });
  this.frame = frame;
  return frame;
};

Request.prototype.mapToHttpHeader = function (headers) {
  var keys = Object.keys(headers);
  var http2Headers = {};

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var key = _keys[_i];
    var value = headers[key];
    key = key.toLowerCase();

    switch (key) {
      case HTTP2_HEADER_SET_COOKIE:
        value = Array.isArray(value) ? value : [value];
        break;

      default:
        break;
    }

    http2Headers[key] = value;
  }

  return http2Headers;
};

Request.prototype.mapToHttp2Header = function (headers) {
  var keys = Object.keys(headers);
  var http2Headers = {};

  for (var _i2 = 0, _keys2 = keys; _i2 < _keys2.length; _i2++) {
    var key = _keys2[_i2];
    var value = headers[key];
    key = key.toLowerCase();

    switch (key) {
      case HTTP2_HEADER_HOST:
        key = HTTP2_HEADER_AUTHORITY;
        value = /^http:\/\/|^https:\/\//.test(value) ? parse(value).host : value;
        break;

      default:
        break;
    }

    http2Headers[key] = value;
  }

  return http2Headers;
};

Request.prototype.setHeader = function (name, value) {
  this._headers[name.toLowerCase()] = value;
};

Request.prototype.getHeader = function (name) {
  return this._headers[name.toLowerCase()];
};

Request.prototype.write = function (data, encoding) {
  var frame = this.getFrame();
  return frame.write(data, encoding);
};

Request.prototype.pipe = function (stream, options) {
  var frame = this.getFrame();
  return frame.pipe(stream, options);
};

Request.prototype.end = function (data) {
  var frame = this.getFrame();
  frame.end(data);
}; // eslint-disable-next-line no-unused-vars


Request.prototype.abort = function (data) {
  var frame = this.getFrame();
  frame.close(NGHTTP2_CANCEL);
  this.session.destroy();
};

exports.setProtocol = setProtocol;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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