/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.manager.StatusTransformer;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class StatusManagerServlet
extends HttpServlet
implements NotificationListener {
    private static final long serialVersionUID = 1L;
    protected MBeanServer mBeanServer = null;
    protected final List<ObjectName> threadPools = Collections.synchronizedList(new ArrayList());
    protected final List<ObjectName> requestProcessors = Collections.synchronizedList(new ArrayList());
    protected final List<ObjectName> globalRequestProcessors = Collections.synchronizedList(new ArrayList());
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.manager");

    public void init() throws ServletException {
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        try {
            String string = "*:type=ThreadPool,*";
            ObjectName objectName = new ObjectName(string);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance objectInstance : set) {
                this.threadPools.add(objectInstance.getObjectName());
            }
            string = "*:type=GlobalRequestProcessor,*";
            objectName = new ObjectName(string);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance objectInstance : set) {
                this.globalRequestProcessors.add(objectInstance.getObjectName());
            }
            string = "*:type=RequestProcessor,*";
            objectName = new ObjectName(string);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance objectInstance : set) {
                this.requestProcessors.add(objectInstance.getObjectName());
            }
            string = "JMImplementation:type=MBeanServerDelegate";
            objectName = new ObjectName(string);
            this.mBeanServer.addNotificationListener(objectName, this, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroy() {
        String string = "JMImplementation:type=MBeanServerDelegate";
        try {
            ObjectName objectName = new ObjectName(string);
            this.mBeanServer.removeNotificationListener(objectName, this, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Enumeration)httpServletRequest.getLocales());
        int n = 0;
        if (httpServletRequest.getParameter("XML") != null && httpServletRequest.getParameter("XML").equals("true")) {
            n = 1;
        }
        StatusTransformer.setContentType(httpServletResponse, n);
        PrintWriter printWriter = httpServletResponse.getWriter();
        boolean bl = false;
        if (httpServletRequest.getPathInfo() != null && httpServletRequest.getPathInfo().equals("/all")) {
            bl = true;
        }
        Object[] objectArray = new Object[]{this.getServletContext().getContextPath()};
        StatusTransformer.writeHeader(printWriter, objectArray, n);
        objectArray = new Object[]{this.getServletContext().getContextPath(), bl ? stringManager.getString("statusServlet.complete") : stringManager.getString("statusServlet.title")};
        StatusTransformer.writeBody(printWriter, objectArray, n);
        objectArray = new Object[9];
        objectArray[0] = stringManager.getString("htmlManagerServlet.manager");
        objectArray[1] = httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/list");
        objectArray[2] = stringManager.getString("htmlManagerServlet.list");
        objectArray[3] = this.getServletContext().getContextPath() + "/" + stringManager.getString("htmlManagerServlet.helpHtmlManagerFile");
        objectArray[4] = stringManager.getString("htmlManagerServlet.helpHtmlManager");
        objectArray[5] = this.getServletContext().getContextPath() + "/" + stringManager.getString("htmlManagerServlet.helpManagerFile");
        objectArray[6] = stringManager.getString("htmlManagerServlet.helpManager");
        if (bl) {
            objectArray[7] = httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/status");
            objectArray[8] = stringManager.getString("statusServlet.title");
        } else {
            objectArray[7] = httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/status/all");
            objectArray[8] = stringManager.getString("statusServlet.complete");
        }
        StatusTransformer.writeManager(printWriter, objectArray, n);
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.serverTitle"), stringManager.getString("htmlManagerServlet.serverVersion"), stringManager.getString("htmlManagerServlet.serverJVMVersion"), stringManager.getString("htmlManagerServlet.serverJVMVendor"), stringManager.getString("htmlManagerServlet.serverOSName"), stringManager.getString("htmlManagerServlet.serverOSVersion"), stringManager.getString("htmlManagerServlet.serverOSArch"), stringManager.getString("htmlManagerServlet.serverHostname"), stringManager.getString("htmlManagerServlet.serverIPAddress")};
        StatusTransformer.writePageHeading(printWriter, objectArray, n);
        objectArray = new Object[8];
        objectArray[0] = ServerInfo.getServerInfo();
        objectArray[1] = System.getProperty("java.runtime.version");
        objectArray[2] = System.getProperty("java.vm.vendor");
        objectArray[3] = System.getProperty("os.name");
        objectArray[4] = System.getProperty("os.version");
        objectArray[5] = System.getProperty("os.arch");
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            objectArray[6] = inetAddress.getHostName();
            objectArray[7] = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            objectArray[6] = "-";
            objectArray[7] = "-";
        }
        StatusTransformer.writeServerInfo(printWriter, objectArray, n);
        try {
            objectArray = new Object[]{stringManager.getString("htmlManagerServlet.jvmFreeMemory"), stringManager.getString("htmlManagerServlet.jvmTotalMemory"), stringManager.getString("htmlManagerServlet.jvmMaxMemory"), stringManager.getString("htmlManagerServlet.jvmTableTitleMemoryPool"), stringManager.getString("htmlManagerServlet.jvmTableTitleType"), stringManager.getString("htmlManagerServlet.jvmTableTitleInitial"), stringManager.getString("htmlManagerServlet.jvmTableTitleTotal"), stringManager.getString("htmlManagerServlet.jvmTableTitleMaximum"), stringManager.getString("htmlManagerServlet.jvmTableTitleUsed")};
            StatusTransformer.writeVMState(printWriter, n, objectArray);
            for (ObjectName objectName : this.threadPools) {
                String string = objectName.getKeyProperty("name");
                objectArray = new Object[]{stringManager.getString("htmlManagerServlet.connectorStateMaxThreads"), stringManager.getString("htmlManagerServlet.connectorStateThreadCount"), stringManager.getString("htmlManagerServlet.connectorStateThreadBusy"), stringManager.getString("htmlManagerServlet.connectorStateAliveSocketCount"), stringManager.getString("htmlManagerServlet.connectorStateMaxProcessingTime"), stringManager.getString("htmlManagerServlet.connectorStateProcessingTime"), stringManager.getString("htmlManagerServlet.connectorStateRequestCount"), stringManager.getString("htmlManagerServlet.connectorStateErrorCount"), stringManager.getString("htmlManagerServlet.connectorStateBytesReceived"), stringManager.getString("htmlManagerServlet.connectorStateBytesSent"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleStage"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleTime"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleBSent"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleBRecv"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleClientForw"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleClientAct"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleVHost"), stringManager.getString("htmlManagerServlet.connectorStateTableTitleRequest"), stringManager.getString("htmlManagerServlet.connectorStateHint")};
                StatusTransformer.writeConnectorState(printWriter, objectName, string, this.mBeanServer, this.globalRequestProcessors, this.requestProcessors, n, objectArray);
            }
            if (httpServletRequest.getPathInfo() != null && httpServletRequest.getPathInfo().equals("/all")) {
                StatusTransformer.writeDetailedState(printWriter, this.mBeanServer, n);
            }
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        StatusTransformer.writeFooter(printWriter, n);
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        if (notification instanceof MBeanServerNotification) {
            String string;
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (notification.getType().equals("JMX.mbean.registered")) {
                String string2 = objectName.getKeyProperty("type");
                if (string2 != null) {
                    if (string2.equals("ThreadPool")) {
                        this.threadPools.add(objectName);
                    } else if (string2.equals("GlobalRequestProcessor")) {
                        this.globalRequestProcessors.add(objectName);
                    } else if (string2.equals("RequestProcessor")) {
                        this.requestProcessors.add(objectName);
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered") && (string = objectName.getKeyProperty("type")) != null) {
                if (string.equals("ThreadPool")) {
                    this.threadPools.remove(objectName);
                } else if (string.equals("GlobalRequestProcessor")) {
                    this.globalRequestProcessors.remove(objectName);
                } else if (string.equals("RequestProcessor")) {
                    this.requestProcessors.remove(objectName);
                }
            }
        }
    }
}

