/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStoreException;
import org.opensearch.common.blobstore.DeleteResult;
import org.opensearch.common.blobstore.support.AbstractBlobContainer;
import org.opensearch.common.blobstore.support.PlainBlobMetadata;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.ByteSizeUnit;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.repositories.s3.AmazonS3Reference;
import org.opensearch.repositories.s3.S3BlobStore;
import org.opensearch.repositories.s3.S3Repository;
import org.opensearch.repositories.s3.S3RetryingInputStream;
import org.opensearch.repositories.s3.SocketAccess;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;

class S3BlobContainer
extends AbstractBlobContainer {
    private static final Logger logger = LogManager.getLogger(S3BlobContainer.class);
    private static final int MAX_BULK_DELETES = 1000;
    private final S3BlobStore blobStore;
    private final String keyPath;

    S3BlobContainer(BlobPath path, S3BlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
    }

    public boolean blobExists(String blobName) {
        boolean bl;
        block9: {
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.blobStore.bucket()).key(this.buildKey(blobName)).build()));
                bl = true;
                if (clientReference == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchKeyException e) {
                    return false;
                }
                catch (Exception e) {
                    throw new BlobStoreException("Failed to check if blob [" + blobName + "] exists", (Throwable)e);
                }
            }
            clientReference.close();
        }
        return bl;
    }

    public InputStream readBlob(String blobName) throws IOException {
        return new S3RetryingInputStream(this.blobStore, this.buildKey(blobName));
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (length == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new S3RetryingInputStream(this.blobStore, this.buildKey(blobName), position, Math.addExact(position, length - 1L));
    }

    public long readBlobPreferredLength() {
        return new ByteSizeValue(32L, ByteSizeUnit.MB).getBytes();
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        assert (inputStream.markSupported()) : "No mark support on inputStream breaks the S3 SDK's ability to retry requests";
        SocketAccess.doPrivilegedIOException(() -> {
            if (blobSize <= this.getLargeBlobThresholdInBytes()) {
                this.executeSingleUpload(this.blobStore, this.buildKey(blobName), inputStream, blobSize);
            } else {
                this.executeMultipartUpload(this.blobStore, this.buildKey(blobName), inputStream, blobSize);
            }
            return null;
        });
    }

    long getLargeBlobThresholdInBytes() {
        return this.blobStore.bufferSizeInBytes();
    }

    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public DeleteResult delete() throws IOException {
        AtomicLong deletedBlobs = new AtomicLong();
        AtomicLong deletedBytes = new AtomicLong();
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            ListObjectsV2Iterable listObjectsIterable = SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).listObjectsV2Paginator((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.blobStore.bucket()).prefix(this.keyPath).overrideConfiguration(o -> o.addMetricPublisher(this.blobStore.getStatsMetricPublisher().listObjectsMetricPublisher)).build()));
            Iterator listObjectsResponseIterator = listObjectsIterable.iterator();
            while (listObjectsResponseIterator.hasNext()) {
                ListObjectsV2Response listObjectsResponse = SocketAccess.doPrivileged(listObjectsResponseIterator::next);
                List<String> blobsToDelete = listObjectsResponse.contents().stream().map(s3Object -> {
                    deletedBlobs.incrementAndGet();
                    deletedBytes.addAndGet(s3Object.size());
                    return s3Object.key();
                }).collect(Collectors.toList());
                if (!listObjectsResponseIterator.hasNext()) {
                    blobsToDelete.add(this.keyPath);
                }
                this.doDeleteBlobs(blobsToDelete, false);
            }
        }
        catch (SdkException e) {
            throw new IOException("Exception when deleting blob container [" + this.keyPath + "]", e);
        }
        return new DeleteResult(deletedBlobs.get(), deletedBytes.get());
    }

    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        this.doDeleteBlobs(blobNames, true);
    }

    private void doDeleteBlobs(List<String> blobNames, boolean relative) throws IOException {
        if (blobNames.isEmpty()) {
            return;
        }
        Set<String> outstanding = relative ? blobNames.stream().map(this::buildKey).collect(Collectors.toSet()) : new HashSet<String>(blobNames);
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            ArrayList<DeleteObjectsRequest> deleteRequests = new ArrayList<DeleteObjectsRequest>();
            ArrayList<String> partition = new ArrayList<String>();
            for (String key : outstanding) {
                partition.add(key);
                if (partition.size() != 1000) continue;
                deleteRequests.add(S3BlobContainer.bulkDelete(this.blobStore.bucket(), partition));
                partition.clear();
            }
            if (!partition.isEmpty()) {
                deleteRequests.add(S3BlobContainer.bulkDelete(this.blobStore.bucket(), partition));
            }
            SocketAccess.doPrivilegedVoid(() -> {
                SdkException aex = null;
                for (DeleteObjectsRequest deleteRequest : deleteRequests) {
                    List keysInRequest = deleteRequest.delete().objects().stream().map(ObjectIdentifier::key).collect(Collectors.toList());
                    try {
                        DeleteObjectsResponse deleteObjectsResponse = ((S3Client)clientReference.get()).deleteObjects(deleteRequest);
                        outstanding.removeAll(keysInRequest);
                        outstanding.addAll(deleteObjectsResponse.errors().stream().map(S3Error::key).collect(Collectors.toSet()));
                        if (deleteObjectsResponse.errors().isEmpty()) continue;
                        logger.warn(() -> new ParameterizedMessage("Failed to delete some blobs {}", deleteObjectsResponse.errors().stream().map(s3Error -> "[" + s3Error.key() + "][" + s3Error.code() + "][" + s3Error.message() + "]").collect(Collectors.toList())));
                    }
                    catch (SdkException e) {
                        aex = (SdkException)ExceptionsHelper.useOrSuppress(aex, (Throwable)e);
                    }
                }
                if (aex != null) {
                    throw aex;
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Failed to delete blobs [" + outstanding + "]", e);
        }
        assert (outstanding.isEmpty());
    }

    private static DeleteObjectsRequest bulkDelete(String bucket, List<String> blobs) {
        return (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().objects((Collection)blobs.stream().map(blob -> (ObjectIdentifier)ObjectIdentifier.builder().key(blob).build()).collect(Collectors.toList())).quiet(Boolean.valueOf(true)).build()).build();
    }

    public void listBlobsByPrefixInSortedOrder(String blobNamePrefix, int limit, BlobContainer.BlobNameSortOrder blobNameSortOrder, ActionListener<List<BlobMetadata>> listener) {
        if (blobNameSortOrder != BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC) {
            super.listBlobsByPrefixInSortedOrder(blobNamePrefix, limit, blobNameSortOrder, listener);
        } else {
            if (limit < 0) {
                throw new IllegalArgumentException("limit should not be a negative value");
            }
            String prefix = blobNamePrefix == null ? this.keyPath : this.buildKey(blobNamePrefix);
            try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
                List blobs = S3BlobContainer.executeListing(clientReference, this.listObjectsRequest(prefix, limit), limit).stream().flatMap(listing -> listing.contents().stream()).map(s3Object -> new PlainBlobMetadata(s3Object.key().substring(this.keyPath.length()), s3Object.size().longValue())).collect(Collectors.toList());
                listener.onResponse(blobs.subList(0, Math.min(limit, blobs.size())));
            }
            catch (Exception e) {
                listener.onFailure((Exception)new IOException("Exception when listing blobs by prefix [" + prefix + "]", e));
            }
        }
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(@Nullable String blobNamePrefix) throws IOException {
        Map<String, BlobMetadata> map;
        block8: {
            String prefix = blobNamePrefix == null ? this.keyPath : this.buildKey(blobNamePrefix);
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                map = S3BlobContainer.executeListing(clientReference, this.listObjectsRequest(prefix)).stream().flatMap(listing -> listing.contents().stream()).map(s3Object -> new PlainBlobMetadata(s3Object.key().substring(this.keyPath.length()), s3Object.size().longValue())).collect(Collectors.toMap(PlainBlobMetadata::name, Function.identity()));
                if (clientReference == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SdkException e) {
                    throw new IOException("Exception when listing blobs by prefix [" + prefix + "]", e);
                }
            }
            clientReference.close();
        }
        return map;
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    public Map<String, BlobContainer> children() throws IOException {
        Map<String, BlobContainer> map;
        block8: {
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                map = S3BlobContainer.executeListing(clientReference, this.listObjectsRequest(this.keyPath)).stream().flatMap(listObjectsResponse -> {
                    assert (listObjectsResponse.contents().stream().noneMatch(s -> {
                        for (CommonPrefix commonPrefix : listObjectsResponse.commonPrefixes()) {
                            if (!s.key().substring(this.keyPath.length()).startsWith(commonPrefix.prefix())) continue;
                            return true;
                        }
                        return false;
                    })) : "Response contained children for listed common prefixes.";
                    return listObjectsResponse.commonPrefixes().stream();
                }).map(commonPrefix -> commonPrefix.prefix().substring(this.keyPath.length())).filter(name -> !name.isEmpty()).map(name -> name.substring(0, name.length() - 1)).collect(Collectors.toMap(Function.identity(), name -> this.blobStore.blobContainer(this.path().add(name))));
                if (clientReference == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SdkException e) {
                    throw new IOException("Exception when listing children of [" + this.path().buildAsString() + "]", e);
                }
            }
            clientReference.close();
        }
        return map;
    }

    private static List<ListObjectsV2Response> executeListing(AmazonS3Reference clientReference, ListObjectsV2Request listObjectsRequest) {
        return S3BlobContainer.executeListing(clientReference, listObjectsRequest, -1);
    }

    private static List<ListObjectsV2Response> executeListing(AmazonS3Reference clientReference, ListObjectsV2Request listObjectsRequest, int limit) {
        return SocketAccess.doPrivileged(() -> {
            ArrayList<ListObjectsV2Response> results = new ArrayList<ListObjectsV2Response>();
            int totalObjects = 0;
            ListObjectsV2Iterable listObjectsIterable = ((S3Client)clientReference.get()).listObjectsV2Paginator(listObjectsRequest);
            for (ListObjectsV2Response listObjectsV2Response : listObjectsIterable) {
                results.add(listObjectsV2Response);
                if (limit == -1 || (totalObjects += listObjectsV2Response.contents().size()) <= limit) continue;
                break;
            }
            return results;
        });
    }

    private ListObjectsV2Request listObjectsRequest(String keyPath) {
        return (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.blobStore.bucket()).prefix(keyPath).delimiter("/").overrideConfiguration(o -> o.addMetricPublisher(this.blobStore.getStatsMetricPublisher().listObjectsMetricPublisher)).build();
    }

    private ListObjectsV2Request listObjectsRequest(String keyPath, int limit) {
        return (ListObjectsV2Request)this.listObjectsRequest(keyPath).toBuilder().maxKeys(Integer.valueOf(Math.min(limit, 1000))).build();
    }

    private String buildKey(String blobName) {
        return this.keyPath + blobName;
    }

    void executeSingleUpload(S3BlobStore blobStore, String blobName, InputStream input, long blobSize) throws IOException {
        if (blobSize > S3Repository.MAX_FILE_SIZE.getBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than " + S3Repository.MAX_FILE_SIZE);
        }
        if (blobSize > blobStore.bufferSizeInBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than buffer size");
        }
        PutObjectRequest.Builder putObjectRequestBuilder = PutObjectRequest.builder().bucket(blobStore.bucket()).key(blobName).contentLength(Long.valueOf(blobSize)).storageClass(blobStore.getStorageClass()).acl(blobStore.getCannedACL()).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().putObjectMetricPublisher));
        if (blobStore.serverSideEncryption()) {
            putObjectRequestBuilder.serverSideEncryption(ServerSideEncryption.AES256);
        }
        PutObjectRequest putObjectRequest = (PutObjectRequest)putObjectRequestBuilder.build();
        try (AmazonS3Reference clientReference = blobStore.clientReference();){
            SocketAccess.doPrivilegedVoid(() -> ((S3Client)clientReference.get()).putObject(putObjectRequest, RequestBody.fromInputStream((InputStream)input, (long)blobSize)));
        }
        catch (SdkException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using a single upload", e);
        }
    }

    void executeMultipartUpload(S3BlobStore blobStore, String blobName, InputStream input, long blobSize) throws IOException {
        this.ensureMultiPartUploadSize(blobSize);
        long partSize = blobStore.bufferSizeInBytes();
        Tuple<Long, Long> multiparts = S3BlobContainer.numberOfMultiparts(blobSize, partSize);
        if ((Long)multiparts.v1() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many multipart upload requests, maybe try a larger buffer size?");
        }
        int nbParts = ((Long)multiparts.v1()).intValue();
        long lastPartSize = (Long)multiparts.v2();
        assert (blobSize == (long)(nbParts - 1) * partSize + lastPartSize) : "blobSize does not match multipart sizes";
        SetOnce uploadId = new SetOnce();
        String bucketName = blobStore.bucket();
        boolean success = false;
        CreateMultipartUploadRequest.Builder createMultipartUploadRequestBuilder = CreateMultipartUploadRequest.builder().bucket(bucketName).key(blobName).storageClass(blobStore.getStorageClass()).acl(blobStore.getCannedACL()).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().multipartUploadMetricCollector));
        if (blobStore.serverSideEncryption()) {
            createMultipartUploadRequestBuilder.serverSideEncryption(ServerSideEncryption.AES256);
        }
        CreateMultipartUploadRequest createMultipartUploadRequest = (CreateMultipartUploadRequest)createMultipartUploadRequestBuilder.build();
        try (AmazonS3Reference clientReference = blobStore.clientReference();){
            uploadId.set((Object)SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).createMultipartUpload(createMultipartUploadRequest).uploadId()));
            if (Strings.isEmpty((CharSequence)((CharSequence)uploadId.get()))) {
                throw new IOException("Failed to initialize multipart upload " + blobName);
            }
            ArrayList<CompletedPart> parts = new ArrayList<CompletedPart>();
            long bytesCount = 0L;
            for (int i = 1; i <= nbParts; ++i) {
                UploadPartRequest uploadPartRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(bucketName).key(blobName).uploadId((String)uploadId.get()).partNumber(Integer.valueOf(i)).contentLength(Long.valueOf(i < nbParts ? partSize : lastPartSize)).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().multipartUploadMetricCollector)).build();
                bytesCount += uploadPartRequest.contentLength().longValue();
                UploadPartResponse uploadResponse = SocketAccess.doPrivileged(() -> ((S3Client)clientReference.get()).uploadPart(uploadPartRequest, RequestBody.fromInputStream((InputStream)input, (long)uploadPartRequest.contentLength())));
                parts.add((CompletedPart)CompletedPart.builder().partNumber(uploadPartRequest.partNumber()).eTag(uploadResponse.eTag()).build());
            }
            if (bytesCount != blobSize) {
                throw new IOException("Failed to execute multipart upload for [" + blobName + "], expected " + blobSize + "bytes sent but got " + bytesCount);
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(bucketName).key(blobName).uploadId((String)uploadId.get()).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(parts).build()).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().multipartUploadMetricCollector)).build();
            SocketAccess.doPrivilegedVoid(() -> ((S3Client)clientReference.get()).completeMultipartUpload(completeMultipartUploadRequest));
            success = true;
        }
        catch (SdkException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using multipart upload", e);
        }
        finally {
            if (!success && Strings.hasLength((String)((String)uploadId.get()))) {
                AbortMultipartUploadRequest abortRequest = (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(bucketName).key(blobName).uploadId((String)uploadId.get()).build();
                try (AmazonS3Reference clientReference2 = blobStore.clientReference();){
                    SocketAccess.doPrivilegedVoid(() -> ((S3Client)clientReference2.get()).abortMultipartUpload(abortRequest));
                }
            }
        }
    }

    void ensureMultiPartUploadSize(long blobSize) {
        if (blobSize > S3Repository.MAX_FILE_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be larger than " + S3Repository.MAX_FILE_SIZE_USING_MULTIPART);
        }
        if (blobSize < S3Repository.MIN_PART_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be smaller than " + S3Repository.MIN_PART_SIZE_USING_MULTIPART);
        }
    }

    static Tuple<Long, Long> numberOfMultiparts(long totalSize, long partSize) {
        if (partSize <= 0L) {
            throw new IllegalArgumentException("Part size must be greater than zero");
        }
        if (totalSize == 0L || totalSize <= partSize) {
            return Tuple.tuple((Object)1L, (Object)totalSize);
        }
        long parts = totalSize / partSize;
        long remaining = totalSize % partSize;
        if (remaining == 0L) {
            return Tuple.tuple((Object)parts, (Object)partSize);
        }
        return Tuple.tuple((Object)(parts + 1L), (Object)remaining);
    }
}

