#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for eos_ospfv2
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


DOCUMENTATION = """
module: eos_ospfv2
short_description: OSPFv2 resource module
description: This module configures and manages the attributes of ospfv2 on Arista
  EOS platforms.
version_added: 1.0.0
author: Gomathi Selvi Srinivasan (@GomathiselviS)
notes:
- Tested against Arista EOS 4.24.6F
- This module works with connection C(network_cli). See the L(EOS Platform Options,../network/user_guide/platform_eos.html).
options:
  config:
    description: A list of configurations for ospfv2.
    type: dict
    suboptions:
      processes:
        description: A list of dictionary specifying the ospfv2 processes.
        type: list
        elements: dict
        suboptions:
          process_id:
            description: ID of OSPFV2 process.
            type: int
          vrf:
            description: VRF name .
            type: str
          traffic_engineering:
            description: Enter traffic engineering config mode
            type: bool
          adjacency:
            description: Configure adjacency options for OSPF instance.
            type: dict
            suboptions:
              exchange_start:
                description: Configure exchange-start options for OSPF instance.
                type: dict
                suboptions:
                  threshold:
                    description: Number of peers to bring up simultaneously.
                    type: int
          router_id:
            description: 32-bit number assigned to a router running OSPFv2.
            type: str
          max_lsa:
            description: Specifies the switch behavior on reaching max lsa count.
            type: dict
            suboptions:
              count:
                description: maximum count of lsas.
                type: int
              threshold:
                description: percentage of <count> , when a warning should be raised.
                type: int
              ignore_time:
                description: time in minutes, for which the switch shoud be shutdown
                  on max-lsa warning
                type: int
              ignore_count:
                description: No. of times the switch can shut down temporarily on
                  warning
                type: int
              reset_time:
                description: Time in minutes, after which the shutdown counter resets.
                type: int
              warning:
                description: Only give warning message when limit is exceeded
                type: bool
          max_metric:
            description: Set maximum metric.
            type: dict
            suboptions:
              router_lsa:
                description: Maximum metric in self-originated router-LSAs.
                type: dict
                suboptions:
                  set:
                    description:
                    - Set router-lsa attribute.
                    type: bool
                  external_lsa:
                    description: Override external-lsa metric with max-metric value.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set external-lsa attribute.
                        type: bool
                      max_metric_value:
                        description:
                        - Set max metric value for external LSAs.
                        type: int
                  include_stub:
                    description: Set maximum metric for stub links in router-LSAs.
                    type: bool
                  on_startup:
                    description: Set maximum metric temporarily after reboot.
                    type: dict
                    suboptions:
                      wait_period:
                        description:
                        - Wait period in seconds after startup.
                        type: int
                  summary_lsa:
                    description: Override summary-lsa metric with max-metric value.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set external-lsa attribute.
                        type: bool
                      max_metric_value:
                        description:
                        - Set max metric value for external LSAs.
                        type: int
          log_adjacency_changes:
            description: To configure link-state changes and transitions of OSPFv2
              neighbors.
            type: dict
            suboptions:
              detail:
                description: If true , configures the switch to log all link-state
                  changes.
                type: bool
          maximum_paths:
            description: Maximum number of next-hops in an ECMP route.
            type: int
          mpls_ldp:
            description: mpls ldp sync configuration.
            type: bool
          networks:
            description: Configure routing for a network.
            type: list
            elements: dict
            suboptions:
              network_address:
                description: Network Address.
                type: str
              prefix:
                description: Prefix.
                type: str
              mask:
                description: Network Wildcard Mask.
                type: str
              area:
                description: Configure OSPF area.
                type: str
          passive_interface:
            description: Include interface but without actively running OSPF.
            type: dict
            suboptions:
              interface_list:
                description: Interface range.
                type: str
              default:
                description: If True, Set all interfaces to passive by default
                type: bool
          point_to_point:
            description: Configure Point-to-point specific features.
            type: bool
          rfc1583compatibility:
            description: Specifies different methods for calculating summary route
              metrics.
            type: bool
          distance:
            description: Specifies the administrative distance for routes.
            type: dict
            suboptions:
              external:
                description: Routes external to the area
                type: int
              inter_area:
                description: Routes from other areas
                type: int
              intra_area:
                description: Routes with in an area
                type: int
          redistribute:
            description: Specifies the routes to be redistributed
            type: list
            elements: dict
            suboptions:
              routes:
                description: Route types (BGP,isis,connected etc)
                type: str
              route_map:
                description: Specify which route map to use.
                type: str
              isis_level:
                description: ISIS levels.
                type: str
          retransmission_threshold:
            description: Configure threshold for retransmission.
            type: int
          distribute_list:
            description: Specifies the list of routes to be filtered.
            type: dict
            suboptions:
              route_map:
                description: route map to be filtered
                type: str
              prefix_list:
                description: prefix list to be filtered
                type: str
          areas:
            description: Specifies the configuration for OSPF areas
            type: list
            elements: dict
            suboptions:
              area_id:
                description: Specifies a 32 bit number expressed in decimal or dotted-decimal
                  notation.
                type: str
              default_cost:
                description: Specify the cost for default summary route in stub/NSSA
                  area.
                type: int
              filter:
                description: Specify the filter for incoming summary LSAs.
                type: dict
                suboptions:
                  address:
                    description: IP address.
                    type: str
                  subnet_address:
                    description: IP address with mask length
                    type: str
                  subnet_mask:
                    description: IP subnet mask
                    type: str
                  prefix_list:
                    description: Specify list to filter for incoming LSAs.
                    type: str
              nssa:
                description: Configures NSSA parameters.
                type: dict
                suboptions:
                  default_information_originate:
                    description: Originate default Type 7 LSA.
                    type: dict
                    suboptions:
                      metric:
                        description: Metric for default route.
                        type: int
                      metric_type:
                        description: Metric type for default route.
                        type: int
                      nssa_only:
                        description: Limit default advertisement to this NSSA area.
                        type: bool
                  no_summary:
                    description: Filter all type-3 LSAs in the nssa area.
                    type: bool
                  nssa_only:
                    description: Disable Type-7 LSA p-bit setting
                    type: bool
                  set:
                    description: Set config up to nssa
                    type: bool
              not_so_stubby:
                description: Configures NSSA parameters.
                type: dict
                suboptions:
                  default_information_originate:
                    description: Originate default Type 7 LSA.
                    type: dict
                    suboptions:
                      metric:
                        description: Metric for default route.
                        type: int
                      metric_type:
                        description: Metric type for default route.
                        type: int
                      nssa_only:
                        description: Limit default advertisement to this NSSA area.
                        type: bool
                  lsa:
                    description: lsa parameters
                    type: bool
                  no_summary:
                    description: Filter all type-3 LSAs in the nssa area.
                    type: bool
                  nssa_only:
                    description: Disable Type-7 LSA p-bit setting
                    type: bool
                  set:
                    description: Set config up to not-so-stubby
                    type: bool
              range:
                description: Configure route summarization.
                type: dict
                suboptions:
                  address:
                    description: IP address.
                    type: str
                  subnet_address:
                    description: IP address with mask length
                    type: str
                  subnet_mask:
                    description: IP subnet mask
                    type: str
                  advertise:
                    description: Enable Advertisement of the range.
                    type: bool
                  cost:
                    description: Configures the metric.
                    type: int
              stub:
                description: Stub area.
                type: dict
                suboptions:
                  no_summary:
                    description: If False , Filter all type-3 LSAs in the stub area.
                    type: bool
                  set:
                    description: When true sets the stub config alone.
                    type: bool
          auto_cost:
            description: Set auto-cost.
            type: dict
            suboptions:
              reference_bandwidth:
                description: reference bandwidth in megabits per sec.
                type: int
          bfd:
            description: Enable BFD.
            type: dict
            suboptions:
              all_interfaces:
                description: Enable BFD on all interfaces.
                type: bool
          default_information:
            description: Control distribution of default information.
            type: dict
            suboptions:
              originate:
                description: Distribute a default route.
                type: bool
              always:
                description: Always advertise default route.
                type: bool
              metric:
                description: Metric for default route.
                type: int
              metric_type:
                description: Metric type for default route.
                type: int
              route_map:
                description: Specify which route-map to use.
                type: str
          default_metric:
            description: Configure the default metric for redistributed routes
            type: int
          dn_bit_ignore:
            description: If True, Disable dn-bit check for Type-3 LSAs in non-default
              VRFs.
            type: bool
          graceful_restart:
            description: Enable graceful restart mode.
            type: dict
            suboptions:
              grace_period:
                description: Specify maximum time to wait for graceful-restart to
                  complete.
                type: int
              set:
                description: When true sets the grace_fulrestart config alone.
                type: bool
          graceful_restart_helper:
            description: If True, Enable graceful restart helper.
            type: bool
          shutdown:
            description: Disable the OSPF instance.
            type: bool
          summary_address:
            description: Summary route configuration.
            type: dict
            suboptions:
              address:
                description: IP summary address.
                type: str
              prefix:
                description: Prefix.
                type: str
              mask:
                description: Summary Mask.
                type: str
              attribute_map:
                description: Set attributes of summary route.
                type: str
              not_advertise:
                description: Do not advertise summary route.
                type: bool
              tag:
                description: Set tag.
                type: int
          timers:
            description: Configure OSPF timers.
            type: list
            elements: dict
            suboptions:
              lsa:
                description: Configure OSPF LSA timers.
                type: dict
                suboptions:
                  rx:
                    description: Configure OSPF LSA receiving timers
                    type: dict
                    suboptions:
                      min_interval:
                        description: Configure OSPF LSA arrival timer.
                        type: int
                  tx:
                    description: Configure OSPF LSA transmission timers.
                    type: dict
                    suboptions:
                      delay:
                        description: Configure OSPF LSA transmission delay.
                        type: dict
                        suboptions:
                          initial:
                            description: Delay to generate first occurrence of LSA
                              in msecs.
                            type: int
                          min:
                            description: Min delay between originating the same LSA
                              in msecs.
                            type: int
                          max:
                            description: Maximum delay between originating the same
                              LSA in msecs.
                            type: int
              out_delay:
                description: Configure out-delay timer.
                type: int
              pacing:
                description: Configure OSPF packet pacing.
                type: int
              spf:
                description: Configure SPF timers
                type: dict
                suboptions:
                  seconds:
                    description: Seconds.
                    type: int
                  initial:
                    description: Initial SPF schedule delay in msecs.
                    type: int
                  min:
                    description: Min Hold time between two SPFs in msecs
                    type: int
                  max:
                    description: Max wait time between two SPFs in msecs.
                    type: int
              throttle:
                description: Configure throttle timers(valid only for eos version < 4.23).
                type: dict
                suboptions:
                  attr:
                    description: throttle attribute.
                    type: str
                  initial:
                    description: Initial  schedule delay in msecs.
                    type: int
                  min:
                    description: Min Hold time
                    type: int
                  max:
                    description: Max wait time
                    type: int
          fips_restrictions:
            description: Use FIPS compliant algorithms
            type: str
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the EOS device by
      executing the command B(show running-config | section ospf).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
    - The state the configuration should be left in.
    type: str
    choices: [deleted, merged, overridden, replaced, gathered, rendered, parsed]
    default: merged

"""
EXAMPLES = """
# Using merged

# Before state:
# -------------
# localhost#show running-config | section ospf
# localhost#

  - name: Merge provided config into running config
    arista.eos.eos_ospfv2:
      config:
        - processes:
            - process_id: 1
              adjacency:
                exchange_start:
                    threshold: 20045623
              areas:
                - filter:
                    address: "10.1.1.0/24"
                  id: "0.0.0.2"
                - id: "0.0.0.50"
                  range:
                    address: "172.20.0.0/16"
                    cost: 34
              default_information:
                metric: 100
                metric_type: 1
                originate: True
              distance:
                intra_area: 85
              max_lsa:
                count: 8000
                ignore_count: 3
                ignore_time: 6
                reset_time: 20
                threshold: 40
              networks:
                - area: "0.0.0.0"
                  prefix: 10.10.2.0/24
                - area: "0.0.0.0"
                  prefix: "10.10.3.0/24"
              redistribute:
                - routes: "static"
              router_id: "170.21.0.4"
            - process_id: 2
              vrf: "vrf01"
              areas:
                - id: "0.0.0.9"
                  default_cost: 20
              max_lsa:
                count: 8000
                ignore_count: 3
                ignore_time: 6
                reset_time: 20
                threshold: 40
              networks:
                - area: "0.0.0.0"
                  prefix: 10.10.2.0/24
                - area: "0.0.0.0"
                  prefix: "10.10.3.0/24"
              redistribute:
                - routes: "static"
              router_id: "170.21.0.4"
            - process_id: 2
              vrf: "vrf01"
              areas:
                - id: "0.0.0.9"
                  default_cost: 20
              max_lsa:
                count: 8000
                ignore_count: 3
                ignore_time: 6
                reset_time: 20
                threshold: 40
            - process_id: 3
              vrf: "vrf02"
              redistribute:
                - routes: "connected"

# Task output:
# ------------
#  before: {}

# commands
# - router ospf 1
# - adjacency exchange-start threshold 20045623
# - area 0.0.0.2 filter 10.1.1.0/24
# - area 0.0.0.50  range 172.20.0.0/16 cost 34
# - default-information originate metric 100 metric-type 1
# - distance ospf intra-area 85
# - max-lsa  8000 40 ignore-count 3  ignore-time 6  reset-time 20
# - network 10.10.2.0/24 area 0.0.0.0
# - network 10.10.3.0/24 area 0.0.0.0
# - redistribute static
# - router-id 170.21.0.4
# - exit
# - router ospf 2 vrf vrf01
# - area 0.0.0.9 default-cost 20
# - max-lsa  8000 40 ignore-count 3  ignore-time 6  reset-time 20
# - network 10.10.2.0/24 area 0.0.0.0
# - network 10.10.3.0/24 area 0.0.0.0
# - redistribute static
# - router-id 170.21.0.4
# - exit
# - router ospf 2 vrf vrf01
# - area 0.0.0.9 default-cost 20
# - max-lsa  8000 40 ignore-count 3  ignore-time 6  reset-time 20
# - exit
# - router ospf 3 vrf vrf02
# - redistribute connected
# - exit
#
# after:
#     processes:
#     - adjacency:
#         exchange_start:
#           threshold: 20045623
#       areas:
#       - area_id: 0.0.0.2
#         filter:
#           address: 10.1.1.0/24
#       - area_id: 0.0.0.50
#         range:
#           address: 172.20.0.0/16
#           cost: 34
#       default_information:
#         metric: 100
#         metric_type: 1
#         originate: true
#       distance:
#         intra_area: 85
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       networks:
#       - area: 0.0.0.0
#         prefix: 10.10.2.0/24
#       - area: 0.0.0.0
#         prefix: 10.10.3.0/24
#       process_id: 1
#       redistribute:
#       - routes: static
#       router_id: 170.21.0.4
#     - areas:
#       - area_id: 0.0.0.9
#         default_cost: 20
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       process_id: 2
#       vrf: vrf01
#     - max_lsa:
#         count: 12000
#       process_id: 3
#       redistribute:
#       - routes: connected
#       vrf: vrf02

# After state:
# ------------
# localhost#show running-config | section ospf
# router ospf 1
#    router-id 170.21.0.4
#    distance ospf intra-area 85
#    redistribute static
#    area 0.0.0.2 filter 10.1.1.0/24
#    area 0.0.0.50 range 172.20.0.0/16 cost 34
#    network 10.10.2.0/24 area 0.0.0.0
#    network 10.10.3.0/24 area 0.0.0.0
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
#    adjacency exchange-start threshold 20045623
#    default-information originate metric 100 metric-type 1
#
# router ospf 2 vrf vrf01
#    area 0.0.0.9 default-cost 20
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
# !
# router ospf 3 vrf vrf02
#    redistribute connected
#    max-lsa 12000

# Using replaced

# Before State:
# -------------
# localhost#show running-config | section ospf
# router ospf 1
#    router-id 170.21.0.4
#    distance ospf intra-area 85
#    redistribute static
#    area 0.0.0.2 filter 10.1.1.0/24
#    area 0.0.0.50 range 172.20.0.0/16 cost 34
#    network 10.10.2.0/24 area 0.0.0.0
#    network 10.10.3.0/24 area 0.0.0.0
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
#    adjacency exchange-start threshold 20045623
#    default-information originate metric 100 metric-type 1
# !
# router ospf 2 vrf vrf01
#    area 0.0.0.9 default-cost 20
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
# !
# router ospf 3 vrf vrf02
#    redistribute connected
#    max-lsa 12000
#
  - name: replace Ospf configs
    arista.eos.eos_ospfv2:
          config:
            - processes:
                - process_id: 2
                  vrf: "vrf01"
                  point_to_point: True
                  redistribute:
                    - routes: "isis"
                      isis_level: "level-1"
          state: replaced

# Task output:
# ------------
# before:
#     processes:
#     - adjacency:
#         exchange_start:
#           threshold: 20045623
#       areas:
#       - area_id: 0.0.0.2
#         filter:
#           address: 10.1.1.0/24
#       - area_id: 0.0.0.50
#         range:
#           address: 172.20.0.0/16
#           cost: 34
#       default_information:
#         metric: 100
#         metric_type: 1
#         originate: true
#       distance:
#         intra_area: 85
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       networks:
#       - area: 0.0.0.0
#         prefix: 10.10.2.0/24
#       - area: 0.0.0.0
#         prefix: 10.10.3.0/24
#       process_id: 1
#       redistribute:
#       - routes: static
#       router_id: 170.21.0.4
#     - areas:
#       - area_id: 0.0.0.9
#         default_cost: 20
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       process_id: 2
#       vrf: vrf01
#     - max_lsa:
#         count: 12000
#       process_id: 3
#       redistribute:
#       - routes: connected
#       vrf: vrf02
#
# commands:
# - router ospf 2 vrf vrf01
# - no area 0.0.0.9 default-cost 20
# - no max-lsa  8000 40 ignore-time 6  ignore-count 3  reset-time 20
# - point-to-point routes
# - redistribute isis level-1
#
# after:
#     processes:
#     - adjacency:
#         exchange_start:
#           threshold: 20045623
#       areas:
#       - area_id: 0.0.0.2
#         filter:
#           address: 10.1.1.0/24
#       - area_id: 0.0.0.50
#         range:
#           address: 172.20.0.0/16
#           cost: 34
#       default_information:
#         metric: 100
#         metric_type: 1
#         originate: true
#       distance:
#         intra_area: 85
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       networks:
#       - area: 0.0.0.0
#         prefix: 10.10.2.0/24
#       - area: 0.0.0.0
#         prefix: 10.10.3.0/24
#       process_id: 1
#       redistribute:
#       - routes: static
#       router_id: 170.21.0.4
#     - max_lsa:
#         count: 12000
#       process_id: 2
#       redistribute:
#       - isis_level: level-1
#         routes: isis
#       vrf: vrf01
#     - max_lsa:
#         count: 12000
#       process_id: 3
#       redistribute:
#       - routes: connected
#       vrf: vrf02

# After state:
# ------------
# localhost#show running-config | section ospf
# router ospf 1
#    router-id 170.21.0.4
#    distance ospf intra-area 85
#    redistribute static
#    area 0.0.0.2 filter 10.1.1.0/24
#    area 0.0.0.50 range 172.20.0.0/16 cost 34
#    network 10.10.2.0/24 area 0.0.0.0
#    network 10.10.3.0/24 area 0.0.0.0
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
#    adjacency exchange-start threshold 20045623
#    default-information originate metric 100 metric-type 1
# !
# router ospf 2 vrf vrf01
#    redistribute isis level-1
#    max-lsa 12000
# !
# router ospf 3 vrf vrf02
#    redistribute connected
#    max-lsa 12000

# Using overridden

# Before state:
# -------------
# localhost#show running-config | section ospf
# router ospf 1
#    router-id 170.21.0.4
#    distance ospf intra-area 85
#    redistribute static
#    area 0.0.0.2 filter 10.1.1.0/24
#    area 0.0.0.50 range 172.20.0.0/16 cost 34
#    network 10.10.2.0/24 area 0.0.0.0
#    network 10.10.3.0/24 area 0.0.0.0
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
#    adjacency exchange-start threshold 20045623
#    default-information originate metric 100 metric-type 1
# !
# router ospf 2 vrf vrf01
#    redistribute isis level-1
#    max-lsa 12000
# !
# router ospf 3 vrf vrf02
#    redistribute connected
#    max-lsa 12000

  - name: override running config with provided config
    arista.eos.eos_ospfv2:
      config:
        - processes:
            - process_id: 2
              vrf: "vrf01"
              redistribute:
                - routes: "connected"
      state: overriden

# Task output:
# ------------
# before:
#     processes:
#     - adjacency:
#         exchange_start:
#           threshold: 20045623
#       areas:
#       - area_id: 0.0.0.2
#         filter:
#           address: 10.1.1.0/24
#       - area_id: 0.0.0.50
#         range:
#           address: 172.20.0.0/16
#           cost: 34
#       default_information:
#         metric: 100
#         metric_type: 1
#         originate: true
#       distance:
#         intra_area: 85
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       networks:
#       - area: 0.0.0.0
#         prefix: 10.10.2.0/24
#       - area: 0.0.0.0
#         prefix: 10.10.3.0/24
#       process_id: 1
#       redistribute:
#       - routes: static
#       router_id: 170.21.0.4
#     - max_lsa:
#         count: 12000
#       process_id: 2
#       redistribute:
#       - isis_level: level-1
#         routes: isis
#       vrf: vrf01
#     - max_lsa:
#         count: 12000
#       process_id: 3
#       redistribute:
#       - routes: connected
#       vrf: vrf02
#
# commands:
# - no router ospf 1
# - no router ospf 3
# - router ospf 2 vrf vrf01
# - no max-lsa  12000
# - no redistribute isis level-1
# - redistribute connected
#
# after:
#     processes:
#     - max_lsa:
#         count: 12000
#       process_id: 2
#       redistribute:
#       - isis_level: level-1
#         routes: isis
#       vrf: vrf01

# After state:
# ------------
# localhost#show running-config | section ospf
# router ospf 2 vrf vrf01
#    redistribute isis level-1
#    max-lsa 12000
# !

# Using deleted

# Before state:
# -------------
# localhost#show running-config | section ospf
# router ospf 1
#    router-id 170.21.0.4
#    distance ospf intra-area 85
#    redistribute static
#    area 0.0.0.2 filter 10.1.1.0/24
#    area 0.0.0.50 range 172.20.0.0/16 cost 34
#    network 10.10.2.0/24 area 0.0.0.0
#    network 10.10.3.0/24 area 0.0.0.0
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
#    adjacency exchange-start threshold 20045623
#    default-information originate metric 100 metric-type 1
# !
# router ospf 2 vrf vrf01
#    redistribute connected
#    area 0.0.0.9 default-cost 20
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
# !
# router ospf 3 vrf vrf02
#    redistribute connected
#    max-lsa 12000
#
  - name: Delete OSPF config
    arista.eos.eos_ospfv2:
      config:
        processes:
          - process_id: 1
      state: deleted

# Task output:
# ------------
# before:
#     processes:
#     - adjacency:
#         exchange_start:
#           threshold: 20045623
#       areas:
#       - area_id: 0.0.0.2
#         filter:
#           address: 10.1.1.0/24
#       - area_id: 0.0.0.50
#         range:
#           address: 172.20.0.0/16
#           cost: 34
#       default_information:
#         metric: 100
#         metric_type: 1
#         originate: true
#       distance:
#         intra_area: 85
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       networks:
#       - area: 0.0.0.0
#         prefix: 10.10.2.0/24
#       - area: 0.0.0.0
#         prefix: 10.10.3.0/24
#       process_id: 1
#       redistribute:
#       - routes: static
#       router_id: 170.21.0.4
#     - areas:
#       - area_id: 0.0.0.9
#         default_cost: 20
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       process_id: 2
#       redistribute:
#       - routes: connected
#       vrf: vrf01
#     - max_lsa:
#         count: 12000
#       process_id: 3
#       redistribute:
#       - routes: connected
#       vrf: vrf02
#
# commands:
# - no router ospf 1
#
# after:
#     processes:
#     - areas:
#       - area_id: 0.0.0.9
#         default_cost: 20
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       process_id: 2
#       redistribute:
#       - routes: connected
#       vrf: vrf01
#     - max_lsa:
#         count: 12000
#       process_id: 3
#       redistribute:
#       - routes: connected
#       vrf: vrf02

# After state:
# ------------
# localhost#show running-config | section ospf
# router ospf 2 vrf vrf01
#    redistribute connected
#    area 0.0.0.9 default-cost 20
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
# !
# router ospf 3 vrf vrf02
#    redistribute connected
#    max-lsa 12000

# Using gathered
# localhost#show running-config | section ospf
# router ospf 2 vrf vrf01
#    redistribute connected
#    area 0.0.0.9 default-cost 20
#    max-lsa 8000 40 ignore-time 6 ignore-count 3 reset-time 20
# !
# router ospf 3 vrf vrf02
#    redistribute connected
#    max-lsa 12000

  - name: replace Ospf configs
    arista.eos.eos_ospfv2:
      state: gathered

# Task output:
# ------------
# gathered:
#     processes:
#     - areas:
#       - area_id: 0.0.0.9
#         default_cost: 20
#       max_lsa:
#         count: 8000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       process_id: 2
#       redistribute:
#       - routes: connected
#       vrf: vrf01
#     - max_lsa:
#         count: 12000
#       process_id: 3
#       redistribute:
#       - routes: connected
#       vrf: vrf02

# Using parsed
# ------------

# parsed.cfg
# router ospf 1
#    adjacency exchange-start threshold 20045623
#    area 0.0.0.2 filter 10.1.1.0/24
#    area 0.0.0.50  range 172.20.0.0/16 cost 34
#    default-information originate  metric 100 metric-type 1
#    distance ospf intra-area 85
#    max-lsa  80000 40 ignore-count 3  ignore-time 6  reset-time 20
#    network 10.10.2.0/24 area 0.0.0.0
#    network 10.10.3.0/24 area 0.0.0.0
#    redistribute static
#    router-id 170.21.0.4
# router ospf 2 vrf vrf01,
#    area 0.0.0.9 default-cost 20
#    max-lsa  80000 40 ignore-count 3  ignore-time 6  reset-time 20
# router ospf 3 vrf vrf02
#    redistribute static

  - name: Parse running config and display structured facts
    arista.eos.eos_ospfv2:
      running_config: "{{ lookup('file', './parsed.cfg') }}"
      state: parsed

# Task output:
# ------------
# parsed:
#     processes:
#     - adjacency:
#         exchange_start:
#           threshold: 20045623
#       areas:
#       - area_id: 0.0.0.2
#         filter:
#           address: 10.1.1.0/24
#       - area_id: 0.0.0.50
#         range:
#           address: 172.20.0.0/16
#           cost: 34
#       default_information:
#         metric: 100
#         metric_type: 1
#         originate: true
#       distance:
#         intra_area: 85
#       max_lsa:
#         count: 80000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       networks:
#       - area: 0.0.0.0
#         prefix: 10.10.2.0/24
#       - area: 0.0.0.0
#         prefix: 10.10.3.0/24
#       process_id: 1
#       redistribute:
#       - routes: static
#       router_id: 170.21.0.4
#     - areas:
#       - area_id: 0.0.0.9
#         default_cost: 20
#       max_lsa:
#         count: 80000
#         ignore_count: 3
#         ignore_time: 6
#         reset_time: 20
#         threshold: 40
#       process_id: 2
#       vrf: vrf01,
#     - process_id: 3
#       redistribute:
#       - routes: static
#       vrf: vrf02

# Using rendered

  - name: replace Ospf configs
    arista.eos.eos_ospfv2:
      config:
        processes:
          - process_id: 1
            adjacency:
              exchange_start:
                threshold: 20045623
            areas:
              - filter:
                  address: "10.1.1.0/24"
                area_id: "0.0.0.2"
              - area_id: "0.0.0.50"
                range:
                  address: "172.20.0.0/16"
                  cost: 34
            default_information:
              metric: 100
              metric_type: 1
              originate: true
            distance:
              intra_area: 85
            max_lsa:
              count: 8000
              ignore_count: 3
              ignore_time: 6
              reset_time: 20
              threshold: 40
            networks:
              - area: "0.0.0.0"
                prefix: 10.10.2.0/24
              - area: "0.0.0.0"
                prefix: "10.10.3.0/24"
            redistribute:
              - routes: "static"
            router_id: "170.21.0.4"
          - process_id: 2
            vrf: "vrf01"
            areas:
              - area_id: "0.0.0.9"
                default_cost: 20
            max_lsa:
              count: 8000
              ignore_count: 3
              ignore_time: 6
              reset_time: 20
              threshold: 40
            networks:
              - area: "0.0.0.0"
                prefix: 10.10.2.0/24
              - area: "0.0.0.0"
                prefix: "10.10.3.0/24"
            redistribute:
              - routes: "static"
            router_id: "170.21.0.4"
          - process_id: 2
            vrf: "vrf01"
            areas:
              - area_id: "0.0.0.9"
                default_cost: 20
            max_lsa:
              count: 8000
              ignore_count: 3
              ignore_time: 6
              reset_time: 20
              threshold: 40
          - process_id: 3
            vrf: "vrf02"
            redistribute:
              - routes: "connected"
      state: rendered

# rendered:
#   - router ospf 1
#   - adjacency exchange-start threshold 20045623
#   - area 0.0.0.2 filter 10.1.1.0/24
#   - area 0.0.0.50  range 172.20.0.0/16 cost 34
#   - default-information originate metric 100 metric-type 1
#   - distance ospf intra-area 85
#   - max-lsa  8000 40 ignore-count 3  ignore-time 6  reset-time 20
#   - network 10.10.2.0/24 area 0.0.0.0
#   - network 10.10.3.0/24 area 0.0.0.0
#   - redistribute static
#   - router-id 170.21.0.4
#   - exit
#   - router ospf 2 vrf vrf01
#   - area 0.0.0.9 default-cost 20
#   - max-lsa  8000 40 ignore-count 3  ignore-time 6  reset-time 20
#   - network 10.10.2.0/24 area 0.0.0.0
#   - network 10.10.3.0/24 area 0.0.0.0
#   - redistribute static
#   - router-id 170.21.0.4
#   - exit
#   - router ospf 2 vrf vrf01
#   - area 0.0.0.9 default-cost 20
#   - max-lsa  8000 40 ignore-count 3  ignore-time 6  reset-time 20
#   - exit
#   - router ospf 3 vrf vrf02
#   - redistribute connected
#   - exit

"""
RETURN = """
before:
  description: The configuration prior to the module execution.
  returned: when I(state) is C(merged), C(replaced), C(overridden), C(deleted) or C(purged)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
after:
  description: The resulting configuration after module execution.
  returned: when changed
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
commands:
  description: The set of commands pushed to the remote device.
  returned: when I(state) is C(merged), C(replaced), C(overridden), C(deleted) or C(purged)
  type: list
  sample:
    - router ospf 1
    - adjacency exchange-start threshold 20045623
    - area 0.0.0.2 filter 10.1.1.0/24
rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when I(state) is C(rendered)
  type: list
  sample:
    - router ospf 1
    - adjacency exchange-start threshold 20045623
    - area 0.0.0.2 filter 10.1.1.0/24
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when I(state) is C(gathered)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when I(state) is C(parsed)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.arista.eos.plugins.module_utils.network.eos.argspec.ospfv2.ospfv2 import (
    Ospfv2Args,
)
from ansible_collections.arista.eos.plugins.module_utils.network.eos.config.ospfv2.ospfv2 import (
    Ospfv2,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """

    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=Ospfv2Args.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Ospfv2(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
