/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SystemExit;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SystemExit"}, parent="Exception")
public class RubySystemExit
extends RubyException {
    IRubyObject status;

    static RubyClass define(Ruby runtime2, RubyClass exceptionClass) {
        RubyClass systemExitClass = runtime2.defineClass("SystemExit", exceptionClass, RubySystemExit::new);
        systemExitClass.defineAnnotatedMethods(RubySystemExit.class);
        return systemExitClass;
    }

    public static RubySystemExit newInstance(Ruby runtime2, int status2, String message2) {
        RubyClass klass = runtime2.getSystemExit();
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newFixnum(status2), runtime2.newString(message2)};
        return (RubySystemExit)klass.newInstance(runtime2.getCurrentContext(), args2, Block.NULL_BLOCK);
    }

    protected RubySystemExit(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
        this.status = runtime2.getNil();
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new SystemExit(message2, this);
    }

    @Override
    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        Ruby runtime2 = this.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 0, 2);
        if (argc > 0) {
            IRubyObject arg2 = args2[0];
            if (arg2 instanceof RubyFixnum) {
                this.status = arg2;
                if (argc > 1) {
                    this.message = args2[1];
                }
            } else if (arg2 instanceof RubyBoolean) {
                this.status = runtime2.newFixnum(arg2 == runtime2.getTrue() ? 0 : 1);
                if (argc > 1) {
                    this.message = args2[1];
                }
            } else {
                this.message = arg2;
                this.status = RubyFixnum.zero(runtime2);
            }
        } else {
            this.status = RubyFixnum.zero(runtime2);
        }
        super.initialize(NULL_ARRAY, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject status() {
        return this.status;
    }

    @JRubyMethod(name={"success?"})
    public IRubyObject success_p() {
        Ruby runtime2 = this.getRuntime();
        IRubyObject status2 = this.status;
        if (status2.isNil()) {
            return runtime2.getTrue();
        }
        if (status2 == runtime2.getTrue() || status2 == runtime2.getFalse()) {
            return status2;
        }
        if (status2.equals(RubyFixnum.zero(runtime2))) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }
}

