/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirVolatileAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "VOLATILE_CLASS_IDS", "", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirVolatileAnnotationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirVolatileAnnotationChecker INSTANCE = new FirVolatileAnnotationChecker();
    @NotNull
    private static final List<ClassId> VOLATILE_CLASS_IDS;

    private FirVolatileAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtSourceElement ktSourceElement = declaration.getSource();
        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtRealSourceElementKind.INSTANCE)) {
            return;
        }
        Object object = declaration.getBackingField();
        if (object == null || (object = ((FirBackingField)object).getAnnotations()) == null || (object = FirAnnotationUtilsKt.getAnnotationByClassIds((List<? extends FirAnnotation>)object, (Collection<ClassId>)VOLATILE_CLASS_IDS, context.getSession())) == null) {
            return;
        }
        Object fieldAnnotation = object;
        if (!declaration.isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirAnnotation)fieldAnnotation).getSource(), FirErrors.INSTANCE.getVOLATILE_ON_VALUE(), (DiagnosticContext)context, null, 8, null);
        }
        if (declaration.getDelegateFieldSymbol() != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirAnnotation)fieldAnnotation).getSource(), FirErrors.INSTANCE.getVOLATILE_ON_DELEGATE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    static {
        ClassId[] classIdArray = new ClassId[]{StandardClassIds.Annotations.INSTANCE.getVolatile(), StandardClassIds.Annotations.INSTANCE.getJvmVolatile()};
        VOLATILE_CLASS_IDS = CollectionsKt.listOf(classIdArray);
    }
}

