<!--
title: Serverless Framework - Orgs & Members
menuText: Serverless Orgs & Members
menuOrder: 12
description: Orgs & Members in Serverless Framework Dashboard
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/guides/orgs/)

<!-- DOCS-SITE-LINK:END -->

# Orgs & Members

## Creating an Org

An org is a unique tenant within Serverless Framework Dashboard. When you sign
up, Serverless Framework Dashboard generates a default org name which you can
change. You can create any number of orgs. Members can be added to an org, and a
member can belong to multiple orgs.

## Adding Team Members

Serverless Framework Dashboard currently supports the following basic roles
which are shared across your org.

- **Owner** - Owner of the account. Can add other contributors and access the
  Org Settings. Only one owner per account can be present.
- **Contributor** - Contributors can use all of Serverless Framework Dashboard
  but can not add other users or access the Org Settings directly.

## Changing Org Name

Org names can be changed from the Org Settings section of Serverless Framework
Dashboard. Keep in mind that org names do need to be globally unique across
Serverless, so your desired organization name may not be available.

## Using Serverless Dashboard Orgs

If you have an existing Serverless Framework Dashboard org and you log into
Serverless Framework Dashboard you will automatically start using your existing
org. Additionally if you are a member of a Serverless Framework Dashboard org
you will automatically be made a member of that org in Serverless Framework
Dashboard.
