import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DetectStackDriftInput,
  DetectStackDriftOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DetectStackDriftCommandInput extends DetectStackDriftInput {}
export interface DetectStackDriftCommandOutput
  extends DetectStackDriftOutput,
    __MetadataBearer {}
export declare class DetectStackDriftCommand extends $Command<
  DetectStackDriftCommandInput,
  DetectStackDriftCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DetectStackDriftCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DetectStackDriftCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DetectStackDriftCommandInput, DetectStackDriftCommandOutput>;
  private serialize;
  private deserialize;
}
