/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.res;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private static int LOCALE_CACHE_SIZE = 10;
    private final ResourceBundle bundle;
    private final Locale locale;
    private static final Map<String, Map<Locale, StringManager>> managers = new HashMap<String, Map<Locale, StringManager>>();

    private StringManager(String string, Locale locale) {
        Locale locale2;
        ResourceBundle resourceBundle;
        block5: {
            String string2 = string + ".LocalStrings";
            resourceBundle = null;
            try {
                if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                    locale = Locale.ROOT;
                }
                resourceBundle = ResourceBundle.getBundle(string2, locale);
            }
            catch (MissingResourceException missingResourceException) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) break block5;
                try {
                    resourceBundle = ResourceBundle.getBundle(string2, locale, classLoader);
                }
                catch (MissingResourceException missingResourceException2) {
                    // empty catch block
                }
            }
        }
        this.bundle = resourceBundle;
        this.locale = this.bundle != null ? ((locale2 = this.bundle.getLocale()).equals(Locale.ROOT) ? Locale.ENGLISH : locale2) : null;
    }

    public String getString(String string) {
        if (string == null) {
            String string2 = "key may not have a null value";
            throw new IllegalArgumentException(string2);
        }
        String string3 = null;
        try {
            if (this.bundle != null) {
                string3 = this.bundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            string3 = null;
        }
        return string3;
    }

    public String getString(String string, Object ... objectArray) {
        String string2 = this.getString(string);
        if (string2 == null) {
            string2 = string;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        messageFormat.setLocale(this.locale);
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static final StringManager getManager(Class<?> clazz) {
        return StringManager.getManager(clazz.getPackage().getName());
    }

    public static final StringManager getManager(String string) {
        return StringManager.getManager(string, Locale.getDefault());
    }

    public static final synchronized StringManager getManager(String string, Locale locale) {
        StringManager stringManager;
        LinkedHashMap<Locale, StringManager> linkedHashMap = managers.get(string);
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<Locale, StringManager>(LOCALE_CACHE_SIZE, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Locale, StringManager> entry) {
                    return this.size() > LOCALE_CACHE_SIZE - 1;
                }
            };
            managers.put(string, (Map<Locale, StringManager>)linkedHashMap);
        }
        if ((stringManager = linkedHashMap.get(locale)) == null) {
            stringManager = new StringManager(string, locale);
            linkedHashMap.put(locale, stringManager);
        }
        return stringManager;
    }

    public static StringManager getManager(String string, Enumeration<Locale> enumeration) {
        while (enumeration.hasMoreElements()) {
            Locale locale = enumeration.nextElement();
            StringManager stringManager = StringManager.getManager(string, locale);
            if (!stringManager.getLocale().equals(locale)) continue;
            return stringManager;
        }
        return StringManager.getManager(string);
    }
}

