/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.authenticator;

import java.security.Principal;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterValve;
import org.apache.catalina.ha.authenticator.ClusterSingleSignOnListener;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.ReplicatedMap;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class ClusterSingleSignOn
extends SingleSignOn
implements ClusterValve,
AbstractReplicatedMap.MapOwner {
    private static final StringManager sm = StringManager.getManager(ClusterSingleSignOn.class);
    private CatalinaCluster cluster = null;
    private long rpcTimeout = 15000L;
    private int mapSendOptions = 6;
    private boolean terminateOnStartFailure = false;
    private long accessTimeout = 5000L;

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster catalinaCluster) {
        this.cluster = catalinaCluster;
    }

    public long getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setRpcTimeout(long l) {
        this.rpcTimeout = l;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public void setMapSendOptions(int n) {
        this.mapSendOptions = n;
    }

    public boolean getTerminateOnStartFailure() {
        return this.terminateOnStartFailure;
    }

    public void setTerminateOnStartFailure(boolean bl) {
        this.terminateOnStartFailure = bl;
    }

    public long getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setAccessTimeout(long l) {
        this.accessTimeout = l;
    }

    protected boolean associate(String string, Session session) {
        boolean bl = super.associate(string, session);
        if (bl) {
            ((ReplicatedMap)this.cache).replicate((Object)string, true);
        }
        return bl;
    }

    protected boolean update(String string, Principal principal, String string2, String string3, String string4) {
        boolean bl = super.update(string, principal, string2, string3, string4);
        if (bl) {
            ((ReplicatedMap)this.cache).replicate((Object)string, true);
        }
        return bl;
    }

    protected SessionListener getSessionListener(String string) {
        return new ClusterSingleSignOnListener(string);
    }

    public void objectMadePrimary(Object object, Object object2) {
    }

    protected synchronized void startInternal() throws LifecycleException {
        try {
            ClassLoader[] classLoaderArray;
            if (this.cluster == null && (classLoaderArray = this.getContainer()) instanceof Host && classLoaderArray.getCluster() instanceof CatalinaCluster) {
                this.setCluster((CatalinaCluster)classLoaderArray.getCluster());
            }
            if (this.cluster == null) {
                throw new LifecycleException(sm.getString("clusterSingleSignOn.nocluster"));
            }
            classLoaderArray = new ClassLoader[]{this.getClass().getClassLoader()};
            ReplicatedMap replicatedMap = new ReplicatedMap((AbstractReplicatedMap.MapOwner)this, this.cluster.getChannel(), this.rpcTimeout, this.cluster.getClusterName() + "-SSO-cache", classLoaderArray, this.terminateOnStartFailure);
            replicatedMap.setChannelSendOptions(this.mapSendOptions);
            replicatedMap.setAccessTimeout(this.accessTimeout);
            this.cache = replicatedMap;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            throw new LifecycleException(sm.getString("clusterSingleSignOn.clusterLoad.fail"), throwable);
        }
        super.startInternal();
    }

    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.getCluster() != null) {
            ((ReplicatedMap)this.cache).breakdown();
        }
    }
}

