/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.util.net.openssl.OpenSSLContext;
import org.apache.tomcat.util.net.openssl.OpenSSLSessionStats;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLSessionContext
implements SSLSessionContext {
    private static final StringManager sm = StringManager.getManager(OpenSSLSessionContext.class);
    private static final Enumeration<byte[]> EMPTY = new EmptyEnumeration();
    private final OpenSSLSessionStats stats;
    private final OpenSSLContext context;
    private final long contextID;

    OpenSSLSessionContext(OpenSSLContext openSSLContext) {
        this.context = openSSLContext;
        this.contextID = openSSLContext.getSSLContextID();
        this.stats = new OpenSSLSessionStats(this.contextID);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return EMPTY;
    }

    public void setTicketKeys(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(sm.getString("sessionContext.nullTicketKeys"));
        }
        SSLContext.setSessionTicketKeys((long)this.contextID, (byte[])byArray);
    }

    public void setSessionCacheEnabled(boolean bl) {
        long l = bl ? 2L : 0L;
        SSLContext.setSessionCacheMode((long)this.contextID, (long)l);
    }

    public boolean isSessionCacheEnabled() {
        return SSLContext.getSessionCacheMode((long)this.contextID) == 2L;
    }

    public OpenSSLSessionStats stats() {
        return this.stats;
    }

    @Override
    public void setSessionTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheTimeout((long)this.contextID, (long)n);
    }

    @Override
    public int getSessionTimeout() {
        return (int)SSLContext.getSessionCacheTimeout((long)this.contextID);
    }

    @Override
    public void setSessionCacheSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheSize((long)this.contextID, (long)n);
    }

    @Override
    public int getSessionCacheSize() {
        return (int)SSLContext.getSessionCacheSize((long)this.contextID);
    }

    public boolean setSessionIdContext(byte[] byArray) {
        return SSLContext.setSessionIdContext((long)this.contextID, (byte[])byArray);
    }

    private static final class EmptyEnumeration
    implements Enumeration<byte[]> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public byte[] nextElement() {
            throw new NoSuchElementException();
        }
    }
}

