from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Quantity import *
from OCC.Core.Graphic3d import *
from OCC.Core.TCollection import *
from OCC.Core.gp import *
from OCC.Core.Image import *

Aspect_Display = NewType('Aspect_Display', None)
Aspect_Drawable = NewType('Aspect_Drawable', int)
Aspect_FBConfig = NewType('Aspect_FBConfig', GLXFBConfig)
Aspect_Handle = NewType('Aspect_Handle', int)
Aspect_RenderingContext = NewType('Aspect_RenderingContext', None)
#the following typedef cannot be wrapped as is
Aspect_TouchMap = NewType('Aspect_TouchMap', Any)
Aspect_VKey = NewType('Aspect_VKey', int)
Aspect_VKeyFlags = NewType('Aspect_VKeyFlags', int)
Aspect_VKeyMouse = NewType('Aspect_VKeyMouse', int)
#the following typedef cannot be wrapped as is
Aspect_XRActionMap = NewType('Aspect_XRActionMap', Any)
#the following typedef cannot be wrapped as is
Aspect_XRActionSetMap = NewType('Aspect_XRActionSetMap', Any)
#the following typedef cannot be wrapped as is
GLXFBConfig = NewType('GLXFBConfig', Any)
HANDLE = NewType('HANDLE', None)

class Aspect_SequenceOfColor:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Quantity_Color: ...
    def Last(self) -> Quantity_Color: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Quantity_Color) -> Quantity_Color: ...
    def Prepend(self, theItem: Quantity_Color) -> Quantity_Color: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Quantity_Color: ...
    def SetValue(self, theIndex: int, theValue: Quantity_Color) -> None: ...

class Aspect_TrackedDevicePoseArray:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Aspect_TrackedDevicePose: ...
    def __setitem__(self, index: int, value: Aspect_TrackedDevicePose) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Aspect_TrackedDevicePose]: ...
    def next(self) -> Aspect_TrackedDevicePose: ...
    __next__ = next
    def Init(self, theValue: Aspect_TrackedDevicePose) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Aspect_TrackedDevicePose: ...
    def Last(self) -> Aspect_TrackedDevicePose: ...
    def Value(self, theIndex: int) -> Aspect_TrackedDevicePose: ...
    def SetValue(self, theIndex: int, theValue: Aspect_TrackedDevicePose) -> None: ...

class Aspect_Eye(IntEnum):
    Aspect_Eye_Left: int = ...
    Aspect_Eye_Right: int = ...

Aspect_Eye_Left = Aspect_Eye.Aspect_Eye_Left
Aspect_Eye_Right = Aspect_Eye.Aspect_Eye_Right

class Aspect_VKeyBasic(IntEnum):
    Aspect_VKey_UNKNOWN: int = ...
    Aspect_VKey_A: int = ...
    Aspect_VKey_B: int = ...
    Aspect_VKey_C: int = ...
    Aspect_VKey_D: int = ...
    Aspect_VKey_E: int = ...
    Aspect_VKey_F: int = ...
    Aspect_VKey_G: int = ...
    Aspect_VKey_H: int = ...
    Aspect_VKey_I: int = ...
    Aspect_VKey_J: int = ...
    Aspect_VKey_K: int = ...
    Aspect_VKey_L: int = ...
    Aspect_VKey_M: int = ...
    Aspect_VKey_N: int = ...
    Aspect_VKey_O: int = ...
    Aspect_VKey_P: int = ...
    Aspect_VKey_Q: int = ...
    Aspect_VKey_R: int = ...
    Aspect_VKey_S: int = ...
    Aspect_VKey_T: int = ...
    Aspect_VKey_U: int = ...
    Aspect_VKey_V: int = ...
    Aspect_VKey_W: int = ...
    Aspect_VKey_X: int = ...
    Aspect_VKey_Y: int = ...
    Aspect_VKey_Z: int = ...
    Aspect_VKey_0: int = ...
    Aspect_VKey_1: int = ...
    Aspect_VKey_2: int = ...
    Aspect_VKey_3: int = ...
    Aspect_VKey_4: int = ...
    Aspect_VKey_5: int = ...
    Aspect_VKey_6: int = ...
    Aspect_VKey_7: int = ...
    Aspect_VKey_8: int = ...
    Aspect_VKey_9: int = ...
    Aspect_VKey_F1: int = ...
    Aspect_VKey_F2: int = ...
    Aspect_VKey_F3: int = ...
    Aspect_VKey_F4: int = ...
    Aspect_VKey_F5: int = ...
    Aspect_VKey_F6: int = ...
    Aspect_VKey_F7: int = ...
    Aspect_VKey_F8: int = ...
    Aspect_VKey_F9: int = ...
    Aspect_VKey_F10: int = ...
    Aspect_VKey_F11: int = ...
    Aspect_VKey_F12: int = ...
    Aspect_VKey_Up: int = ...
    Aspect_VKey_Down: int = ...
    Aspect_VKey_Left: int = ...
    Aspect_VKey_Right: int = ...
    Aspect_VKey_Plus: int = ...
    Aspect_VKey_Minus: int = ...
    Aspect_VKey_Equal: int = ...
    Aspect_VKey_PageUp: int = ...
    Aspect_VKey_PageDown: int = ...
    Aspect_VKey_Home: int = ...
    Aspect_VKey_End: int = ...
    Aspect_VKey_Escape: int = ...
    Aspect_VKey_Back: int = ...
    Aspect_VKey_Enter: int = ...
    Aspect_VKey_Backspace: int = ...
    Aspect_VKey_Space: int = ...
    Aspect_VKey_Delete: int = ...
    Aspect_VKey_Tilde: int = ...
    Aspect_VKey_Tab: int = ...
    Aspect_VKey_Comma: int = ...
    Aspect_VKey_Period: int = ...
    Aspect_VKey_Semicolon: int = ...
    Aspect_VKey_Slash: int = ...
    Aspect_VKey_BracketLeft: int = ...
    Aspect_VKey_Backslash: int = ...
    Aspect_VKey_BracketRight: int = ...
    Aspect_VKey_Apostrophe: int = ...
    Aspect_VKey_Numlock: int = ...
    Aspect_VKey_Scroll: int = ...
    Aspect_VKey_Numpad0: int = ...
    Aspect_VKey_Numpad1: int = ...
    Aspect_VKey_Numpad2: int = ...
    Aspect_VKey_Numpad3: int = ...
    Aspect_VKey_Numpad4: int = ...
    Aspect_VKey_Numpad5: int = ...
    Aspect_VKey_Numpad6: int = ...
    Aspect_VKey_Numpad7: int = ...
    Aspect_VKey_Numpad8: int = ...
    Aspect_VKey_Numpad9: int = ...
    Aspect_VKey_NumpadMultiply: int = ...
    Aspect_VKey_NumpadAdd: int = ...
    Aspect_VKey_NumpadSubtract: int = ...
    Aspect_VKey_NumpadDivide: int = ...
    Aspect_VKey_MediaNextTrack: int = ...
    Aspect_VKey_MediaPreviousTrack: int = ...
    Aspect_VKey_MediaStop: int = ...
    Aspect_VKey_MediaPlayPause: int = ...
    Aspect_VKey_VolumeMute: int = ...
    Aspect_VKey_VolumeDown: int = ...
    Aspect_VKey_VolumeUp: int = ...
    Aspect_VKey_BrowserBack: int = ...
    Aspect_VKey_BrowserForward: int = ...
    Aspect_VKey_BrowserRefresh: int = ...
    Aspect_VKey_BrowserStop: int = ...
    Aspect_VKey_BrowserSearch: int = ...
    Aspect_VKey_BrowserFavorites: int = ...
    Aspect_VKey_BrowserHome: int = ...
    Aspect_VKey_ViewTop: int = ...
    Aspect_VKey_ViewBottom: int = ...
    Aspect_VKey_ViewLeft: int = ...
    Aspect_VKey_ViewRight: int = ...
    Aspect_VKey_ViewFront: int = ...
    Aspect_VKey_ViewBack: int = ...
    Aspect_VKey_ViewAxoLeftProj: int = ...
    Aspect_VKey_ViewAxoRightProj: int = ...
    Aspect_VKey_ViewFitAll: int = ...
    Aspect_VKey_ViewRoll90CW: int = ...
    Aspect_VKey_ViewRoll90CCW: int = ...
    Aspect_VKey_ViewSwitchRotate: int = ...
    Aspect_VKey_Shift: int = ...
    Aspect_VKey_Control: int = ...
    Aspect_VKey_Alt: int = ...
    Aspect_VKey_Menu: int = ...
    Aspect_VKey_Meta: int = ...
    Aspect_VKey_NavInteract: int = ...
    Aspect_VKey_NavForward: int = ...
    Aspect_VKey_NavBackward: int = ...
    Aspect_VKey_NavSlideLeft: int = ...
    Aspect_VKey_NavSlideRight: int = ...
    Aspect_VKey_NavSlideUp: int = ...
    Aspect_VKey_NavSlideDown: int = ...
    Aspect_VKey_NavRollCCW: int = ...
    Aspect_VKey_NavRollCW: int = ...
    Aspect_VKey_NavLookLeft: int = ...
    Aspect_VKey_NavLookRight: int = ...
    Aspect_VKey_NavLookUp: int = ...
    Aspect_VKey_NavLookDown: int = ...
    Aspect_VKey_NavCrouch: int = ...
    Aspect_VKey_NavJump: int = ...
    Aspect_VKey_NavThrustForward: int = ...
    Aspect_VKey_NavThrustBackward: int = ...
    Aspect_VKey_NavThrustStop: int = ...
    Aspect_VKey_NavSpeedIncrease: int = ...
    Aspect_VKey_NavSpeedDecrease: int = ...

Aspect_VKey_UNKNOWN = Aspect_VKeyBasic.Aspect_VKey_UNKNOWN
Aspect_VKey_A = Aspect_VKeyBasic.Aspect_VKey_A
Aspect_VKey_B = Aspect_VKeyBasic.Aspect_VKey_B
Aspect_VKey_C = Aspect_VKeyBasic.Aspect_VKey_C
Aspect_VKey_D = Aspect_VKeyBasic.Aspect_VKey_D
Aspect_VKey_E = Aspect_VKeyBasic.Aspect_VKey_E
Aspect_VKey_F = Aspect_VKeyBasic.Aspect_VKey_F
Aspect_VKey_G = Aspect_VKeyBasic.Aspect_VKey_G
Aspect_VKey_H = Aspect_VKeyBasic.Aspect_VKey_H
Aspect_VKey_I = Aspect_VKeyBasic.Aspect_VKey_I
Aspect_VKey_J = Aspect_VKeyBasic.Aspect_VKey_J
Aspect_VKey_K = Aspect_VKeyBasic.Aspect_VKey_K
Aspect_VKey_L = Aspect_VKeyBasic.Aspect_VKey_L
Aspect_VKey_M = Aspect_VKeyBasic.Aspect_VKey_M
Aspect_VKey_N = Aspect_VKeyBasic.Aspect_VKey_N
Aspect_VKey_O = Aspect_VKeyBasic.Aspect_VKey_O
Aspect_VKey_P = Aspect_VKeyBasic.Aspect_VKey_P
Aspect_VKey_Q = Aspect_VKeyBasic.Aspect_VKey_Q
Aspect_VKey_R = Aspect_VKeyBasic.Aspect_VKey_R
Aspect_VKey_S = Aspect_VKeyBasic.Aspect_VKey_S
Aspect_VKey_T = Aspect_VKeyBasic.Aspect_VKey_T
Aspect_VKey_U = Aspect_VKeyBasic.Aspect_VKey_U
Aspect_VKey_V = Aspect_VKeyBasic.Aspect_VKey_V
Aspect_VKey_W = Aspect_VKeyBasic.Aspect_VKey_W
Aspect_VKey_X = Aspect_VKeyBasic.Aspect_VKey_X
Aspect_VKey_Y = Aspect_VKeyBasic.Aspect_VKey_Y
Aspect_VKey_Z = Aspect_VKeyBasic.Aspect_VKey_Z
Aspect_VKey_0 = Aspect_VKeyBasic.Aspect_VKey_0
Aspect_VKey_1 = Aspect_VKeyBasic.Aspect_VKey_1
Aspect_VKey_2 = Aspect_VKeyBasic.Aspect_VKey_2
Aspect_VKey_3 = Aspect_VKeyBasic.Aspect_VKey_3
Aspect_VKey_4 = Aspect_VKeyBasic.Aspect_VKey_4
Aspect_VKey_5 = Aspect_VKeyBasic.Aspect_VKey_5
Aspect_VKey_6 = Aspect_VKeyBasic.Aspect_VKey_6
Aspect_VKey_7 = Aspect_VKeyBasic.Aspect_VKey_7
Aspect_VKey_8 = Aspect_VKeyBasic.Aspect_VKey_8
Aspect_VKey_9 = Aspect_VKeyBasic.Aspect_VKey_9
Aspect_VKey_F1 = Aspect_VKeyBasic.Aspect_VKey_F1
Aspect_VKey_F2 = Aspect_VKeyBasic.Aspect_VKey_F2
Aspect_VKey_F3 = Aspect_VKeyBasic.Aspect_VKey_F3
Aspect_VKey_F4 = Aspect_VKeyBasic.Aspect_VKey_F4
Aspect_VKey_F5 = Aspect_VKeyBasic.Aspect_VKey_F5
Aspect_VKey_F6 = Aspect_VKeyBasic.Aspect_VKey_F6
Aspect_VKey_F7 = Aspect_VKeyBasic.Aspect_VKey_F7
Aspect_VKey_F8 = Aspect_VKeyBasic.Aspect_VKey_F8
Aspect_VKey_F9 = Aspect_VKeyBasic.Aspect_VKey_F9
Aspect_VKey_F10 = Aspect_VKeyBasic.Aspect_VKey_F10
Aspect_VKey_F11 = Aspect_VKeyBasic.Aspect_VKey_F11
Aspect_VKey_F12 = Aspect_VKeyBasic.Aspect_VKey_F12
Aspect_VKey_Up = Aspect_VKeyBasic.Aspect_VKey_Up
Aspect_VKey_Down = Aspect_VKeyBasic.Aspect_VKey_Down
Aspect_VKey_Left = Aspect_VKeyBasic.Aspect_VKey_Left
Aspect_VKey_Right = Aspect_VKeyBasic.Aspect_VKey_Right
Aspect_VKey_Plus = Aspect_VKeyBasic.Aspect_VKey_Plus
Aspect_VKey_Minus = Aspect_VKeyBasic.Aspect_VKey_Minus
Aspect_VKey_Equal = Aspect_VKeyBasic.Aspect_VKey_Equal
Aspect_VKey_PageUp = Aspect_VKeyBasic.Aspect_VKey_PageUp
Aspect_VKey_PageDown = Aspect_VKeyBasic.Aspect_VKey_PageDown
Aspect_VKey_Home = Aspect_VKeyBasic.Aspect_VKey_Home
Aspect_VKey_End = Aspect_VKeyBasic.Aspect_VKey_End
Aspect_VKey_Escape = Aspect_VKeyBasic.Aspect_VKey_Escape
Aspect_VKey_Back = Aspect_VKeyBasic.Aspect_VKey_Back
Aspect_VKey_Enter = Aspect_VKeyBasic.Aspect_VKey_Enter
Aspect_VKey_Backspace = Aspect_VKeyBasic.Aspect_VKey_Backspace
Aspect_VKey_Space = Aspect_VKeyBasic.Aspect_VKey_Space
Aspect_VKey_Delete = Aspect_VKeyBasic.Aspect_VKey_Delete
Aspect_VKey_Tilde = Aspect_VKeyBasic.Aspect_VKey_Tilde
Aspect_VKey_Tab = Aspect_VKeyBasic.Aspect_VKey_Tab
Aspect_VKey_Comma = Aspect_VKeyBasic.Aspect_VKey_Comma
Aspect_VKey_Period = Aspect_VKeyBasic.Aspect_VKey_Period
Aspect_VKey_Semicolon = Aspect_VKeyBasic.Aspect_VKey_Semicolon
Aspect_VKey_Slash = Aspect_VKeyBasic.Aspect_VKey_Slash
Aspect_VKey_BracketLeft = Aspect_VKeyBasic.Aspect_VKey_BracketLeft
Aspect_VKey_Backslash = Aspect_VKeyBasic.Aspect_VKey_Backslash
Aspect_VKey_BracketRight = Aspect_VKeyBasic.Aspect_VKey_BracketRight
Aspect_VKey_Apostrophe = Aspect_VKeyBasic.Aspect_VKey_Apostrophe
Aspect_VKey_Numlock = Aspect_VKeyBasic.Aspect_VKey_Numlock
Aspect_VKey_Scroll = Aspect_VKeyBasic.Aspect_VKey_Scroll
Aspect_VKey_Numpad0 = Aspect_VKeyBasic.Aspect_VKey_Numpad0
Aspect_VKey_Numpad1 = Aspect_VKeyBasic.Aspect_VKey_Numpad1
Aspect_VKey_Numpad2 = Aspect_VKeyBasic.Aspect_VKey_Numpad2
Aspect_VKey_Numpad3 = Aspect_VKeyBasic.Aspect_VKey_Numpad3
Aspect_VKey_Numpad4 = Aspect_VKeyBasic.Aspect_VKey_Numpad4
Aspect_VKey_Numpad5 = Aspect_VKeyBasic.Aspect_VKey_Numpad5
Aspect_VKey_Numpad6 = Aspect_VKeyBasic.Aspect_VKey_Numpad6
Aspect_VKey_Numpad7 = Aspect_VKeyBasic.Aspect_VKey_Numpad7
Aspect_VKey_Numpad8 = Aspect_VKeyBasic.Aspect_VKey_Numpad8
Aspect_VKey_Numpad9 = Aspect_VKeyBasic.Aspect_VKey_Numpad9
Aspect_VKey_NumpadMultiply = Aspect_VKeyBasic.Aspect_VKey_NumpadMultiply
Aspect_VKey_NumpadAdd = Aspect_VKeyBasic.Aspect_VKey_NumpadAdd
Aspect_VKey_NumpadSubtract = Aspect_VKeyBasic.Aspect_VKey_NumpadSubtract
Aspect_VKey_NumpadDivide = Aspect_VKeyBasic.Aspect_VKey_NumpadDivide
Aspect_VKey_MediaNextTrack = Aspect_VKeyBasic.Aspect_VKey_MediaNextTrack
Aspect_VKey_MediaPreviousTrack = Aspect_VKeyBasic.Aspect_VKey_MediaPreviousTrack
Aspect_VKey_MediaStop = Aspect_VKeyBasic.Aspect_VKey_MediaStop
Aspect_VKey_MediaPlayPause = Aspect_VKeyBasic.Aspect_VKey_MediaPlayPause
Aspect_VKey_VolumeMute = Aspect_VKeyBasic.Aspect_VKey_VolumeMute
Aspect_VKey_VolumeDown = Aspect_VKeyBasic.Aspect_VKey_VolumeDown
Aspect_VKey_VolumeUp = Aspect_VKeyBasic.Aspect_VKey_VolumeUp
Aspect_VKey_BrowserBack = Aspect_VKeyBasic.Aspect_VKey_BrowserBack
Aspect_VKey_BrowserForward = Aspect_VKeyBasic.Aspect_VKey_BrowserForward
Aspect_VKey_BrowserRefresh = Aspect_VKeyBasic.Aspect_VKey_BrowserRefresh
Aspect_VKey_BrowserStop = Aspect_VKeyBasic.Aspect_VKey_BrowserStop
Aspect_VKey_BrowserSearch = Aspect_VKeyBasic.Aspect_VKey_BrowserSearch
Aspect_VKey_BrowserFavorites = Aspect_VKeyBasic.Aspect_VKey_BrowserFavorites
Aspect_VKey_BrowserHome = Aspect_VKeyBasic.Aspect_VKey_BrowserHome
Aspect_VKey_ViewTop = Aspect_VKeyBasic.Aspect_VKey_ViewTop
Aspect_VKey_ViewBottom = Aspect_VKeyBasic.Aspect_VKey_ViewBottom
Aspect_VKey_ViewLeft = Aspect_VKeyBasic.Aspect_VKey_ViewLeft
Aspect_VKey_ViewRight = Aspect_VKeyBasic.Aspect_VKey_ViewRight
Aspect_VKey_ViewFront = Aspect_VKeyBasic.Aspect_VKey_ViewFront
Aspect_VKey_ViewBack = Aspect_VKeyBasic.Aspect_VKey_ViewBack
Aspect_VKey_ViewAxoLeftProj = Aspect_VKeyBasic.Aspect_VKey_ViewAxoLeftProj
Aspect_VKey_ViewAxoRightProj = Aspect_VKeyBasic.Aspect_VKey_ViewAxoRightProj
Aspect_VKey_ViewFitAll = Aspect_VKeyBasic.Aspect_VKey_ViewFitAll
Aspect_VKey_ViewRoll90CW = Aspect_VKeyBasic.Aspect_VKey_ViewRoll90CW
Aspect_VKey_ViewRoll90CCW = Aspect_VKeyBasic.Aspect_VKey_ViewRoll90CCW
Aspect_VKey_ViewSwitchRotate = Aspect_VKeyBasic.Aspect_VKey_ViewSwitchRotate
Aspect_VKey_Shift = Aspect_VKeyBasic.Aspect_VKey_Shift
Aspect_VKey_Control = Aspect_VKeyBasic.Aspect_VKey_Control
Aspect_VKey_Alt = Aspect_VKeyBasic.Aspect_VKey_Alt
Aspect_VKey_Menu = Aspect_VKeyBasic.Aspect_VKey_Menu
Aspect_VKey_Meta = Aspect_VKeyBasic.Aspect_VKey_Meta
Aspect_VKey_NavInteract = Aspect_VKeyBasic.Aspect_VKey_NavInteract
Aspect_VKey_NavForward = Aspect_VKeyBasic.Aspect_VKey_NavForward
Aspect_VKey_NavBackward = Aspect_VKeyBasic.Aspect_VKey_NavBackward
Aspect_VKey_NavSlideLeft = Aspect_VKeyBasic.Aspect_VKey_NavSlideLeft
Aspect_VKey_NavSlideRight = Aspect_VKeyBasic.Aspect_VKey_NavSlideRight
Aspect_VKey_NavSlideUp = Aspect_VKeyBasic.Aspect_VKey_NavSlideUp
Aspect_VKey_NavSlideDown = Aspect_VKeyBasic.Aspect_VKey_NavSlideDown
Aspect_VKey_NavRollCCW = Aspect_VKeyBasic.Aspect_VKey_NavRollCCW
Aspect_VKey_NavRollCW = Aspect_VKeyBasic.Aspect_VKey_NavRollCW
Aspect_VKey_NavLookLeft = Aspect_VKeyBasic.Aspect_VKey_NavLookLeft
Aspect_VKey_NavLookRight = Aspect_VKeyBasic.Aspect_VKey_NavLookRight
Aspect_VKey_NavLookUp = Aspect_VKeyBasic.Aspect_VKey_NavLookUp
Aspect_VKey_NavLookDown = Aspect_VKeyBasic.Aspect_VKey_NavLookDown
Aspect_VKey_NavCrouch = Aspect_VKeyBasic.Aspect_VKey_NavCrouch
Aspect_VKey_NavJump = Aspect_VKeyBasic.Aspect_VKey_NavJump
Aspect_VKey_NavThrustForward = Aspect_VKeyBasic.Aspect_VKey_NavThrustForward
Aspect_VKey_NavThrustBackward = Aspect_VKeyBasic.Aspect_VKey_NavThrustBackward
Aspect_VKey_NavThrustStop = Aspect_VKeyBasic.Aspect_VKey_NavThrustStop
Aspect_VKey_NavSpeedIncrease = Aspect_VKeyBasic.Aspect_VKey_NavSpeedIncrease
Aspect_VKey_NavSpeedDecrease = Aspect_VKeyBasic.Aspect_VKey_NavSpeedDecrease


class Aspect_TypeOfDeflection(IntEnum):
    Aspect_TOD_RELATIVE: int = ...
    Aspect_TOD_ABSOLUTE: int = ...

Aspect_TOD_RELATIVE = Aspect_TypeOfDeflection.Aspect_TOD_RELATIVE
Aspect_TOD_ABSOLUTE = Aspect_TypeOfDeflection.Aspect_TOD_ABSOLUTE

class Aspect_TypeOfLine(IntEnum):
    Aspect_TOL_EMPTY: int = ...
    Aspect_TOL_SOLID: int = ...
    Aspect_TOL_DASH: int = ...
    Aspect_TOL_DOT: int = ...
    Aspect_TOL_DOTDASH: int = ...
    Aspect_TOL_USERDEFINED: int = ...

Aspect_TOL_EMPTY = Aspect_TypeOfLine.Aspect_TOL_EMPTY
Aspect_TOL_SOLID = Aspect_TypeOfLine.Aspect_TOL_SOLID
Aspect_TOL_DASH = Aspect_TypeOfLine.Aspect_TOL_DASH
Aspect_TOL_DOT = Aspect_TypeOfLine.Aspect_TOL_DOT
Aspect_TOL_DOTDASH = Aspect_TypeOfLine.Aspect_TOL_DOTDASH
Aspect_TOL_USERDEFINED = Aspect_TypeOfLine.Aspect_TOL_USERDEFINED

class Aspect_GradientFillMethod(IntEnum):
    Aspect_GradientFillMethod_None: int = ...
    Aspect_GradientFillMethod_Horizontal: int = ...
    Aspect_GradientFillMethod_Vertical: int = ...
    Aspect_GradientFillMethod_Diagonal1: int = ...
    Aspect_GradientFillMethod_Diagonal2: int = ...
    Aspect_GradientFillMethod_Corner1: int = ...
    Aspect_GradientFillMethod_Corner2: int = ...
    Aspect_GradientFillMethod_Corner3: int = ...
    Aspect_GradientFillMethod_Corner4: int = ...
    Aspect_GradientFillMethod_Elliptical: int = ...
    Aspect_GFM_NONE: int = ...
    Aspect_GFM_HOR: int = ...
    Aspect_GFM_VER: int = ...
    Aspect_GFM_DIAG1: int = ...
    Aspect_GFM_DIAG2: int = ...
    Aspect_GFM_CORNER1: int = ...
    Aspect_GFM_CORNER2: int = ...
    Aspect_GFM_CORNER3: int = ...
    Aspect_GFM_CORNER4: int = ...

Aspect_GradientFillMethod_None = Aspect_GradientFillMethod.Aspect_GradientFillMethod_None
Aspect_GradientFillMethod_Horizontal = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Horizontal
Aspect_GradientFillMethod_Vertical = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Vertical
Aspect_GradientFillMethod_Diagonal1 = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Diagonal1
Aspect_GradientFillMethod_Diagonal2 = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Diagonal2
Aspect_GradientFillMethod_Corner1 = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Corner1
Aspect_GradientFillMethod_Corner2 = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Corner2
Aspect_GradientFillMethod_Corner3 = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Corner3
Aspect_GradientFillMethod_Corner4 = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Corner4
Aspect_GradientFillMethod_Elliptical = Aspect_GradientFillMethod.Aspect_GradientFillMethod_Elliptical
Aspect_GFM_NONE = Aspect_GradientFillMethod.Aspect_GFM_NONE
Aspect_GFM_HOR = Aspect_GradientFillMethod.Aspect_GFM_HOR
Aspect_GFM_VER = Aspect_GradientFillMethod.Aspect_GFM_VER
Aspect_GFM_DIAG1 = Aspect_GradientFillMethod.Aspect_GFM_DIAG1
Aspect_GFM_DIAG2 = Aspect_GradientFillMethod.Aspect_GFM_DIAG2
Aspect_GFM_CORNER1 = Aspect_GradientFillMethod.Aspect_GFM_CORNER1
Aspect_GFM_CORNER2 = Aspect_GradientFillMethod.Aspect_GFM_CORNER2
Aspect_GFM_CORNER3 = Aspect_GradientFillMethod.Aspect_GFM_CORNER3
Aspect_GFM_CORNER4 = Aspect_GradientFillMethod.Aspect_GFM_CORNER4

class Aspect_XRGenericAction(IntEnum):
    Aspect_XRGenericAction_IsHeadsetOn: int = ...
    Aspect_XRGenericAction_InputAppMenu: int = ...
    Aspect_XRGenericAction_InputSysMenu: int = ...
    Aspect_XRGenericAction_InputTriggerPull: int = ...
    Aspect_XRGenericAction_InputTriggerClick: int = ...
    Aspect_XRGenericAction_InputGripClick: int = ...
    Aspect_XRGenericAction_InputTrackPadPosition: int = ...
    Aspect_XRGenericAction_InputTrackPadTouch: int = ...
    Aspect_XRGenericAction_InputTrackPadClick: int = ...
    Aspect_XRGenericAction_InputThumbstickPosition: int = ...
    Aspect_XRGenericAction_InputThumbstickTouch: int = ...
    Aspect_XRGenericAction_InputThumbstickClick: int = ...
    Aspect_XRGenericAction_InputPoseBase: int = ...
    Aspect_XRGenericAction_InputPoseFront: int = ...
    Aspect_XRGenericAction_InputPoseHandGrip: int = ...
    Aspect_XRGenericAction_InputPoseFingerTip: int = ...
    Aspect_XRGenericAction_OutputHaptic: int = ...

Aspect_XRGenericAction_IsHeadsetOn = Aspect_XRGenericAction.Aspect_XRGenericAction_IsHeadsetOn
Aspect_XRGenericAction_InputAppMenu = Aspect_XRGenericAction.Aspect_XRGenericAction_InputAppMenu
Aspect_XRGenericAction_InputSysMenu = Aspect_XRGenericAction.Aspect_XRGenericAction_InputSysMenu
Aspect_XRGenericAction_InputTriggerPull = Aspect_XRGenericAction.Aspect_XRGenericAction_InputTriggerPull
Aspect_XRGenericAction_InputTriggerClick = Aspect_XRGenericAction.Aspect_XRGenericAction_InputTriggerClick
Aspect_XRGenericAction_InputGripClick = Aspect_XRGenericAction.Aspect_XRGenericAction_InputGripClick
Aspect_XRGenericAction_InputTrackPadPosition = Aspect_XRGenericAction.Aspect_XRGenericAction_InputTrackPadPosition
Aspect_XRGenericAction_InputTrackPadTouch = Aspect_XRGenericAction.Aspect_XRGenericAction_InputTrackPadTouch
Aspect_XRGenericAction_InputTrackPadClick = Aspect_XRGenericAction.Aspect_XRGenericAction_InputTrackPadClick
Aspect_XRGenericAction_InputThumbstickPosition = Aspect_XRGenericAction.Aspect_XRGenericAction_InputThumbstickPosition
Aspect_XRGenericAction_InputThumbstickTouch = Aspect_XRGenericAction.Aspect_XRGenericAction_InputThumbstickTouch
Aspect_XRGenericAction_InputThumbstickClick = Aspect_XRGenericAction.Aspect_XRGenericAction_InputThumbstickClick
Aspect_XRGenericAction_InputPoseBase = Aspect_XRGenericAction.Aspect_XRGenericAction_InputPoseBase
Aspect_XRGenericAction_InputPoseFront = Aspect_XRGenericAction.Aspect_XRGenericAction_InputPoseFront
Aspect_XRGenericAction_InputPoseHandGrip = Aspect_XRGenericAction.Aspect_XRGenericAction_InputPoseHandGrip
Aspect_XRGenericAction_InputPoseFingerTip = Aspect_XRGenericAction.Aspect_XRGenericAction_InputPoseFingerTip
Aspect_XRGenericAction_OutputHaptic = Aspect_XRGenericAction.Aspect_XRGenericAction_OutputHaptic


class Aspect_TypeOfHighlightMethod(IntEnum):
    Aspect_TOHM_COLOR: int = ...
    Aspect_TOHM_BOUNDBOX: int = ...

Aspect_TOHM_COLOR = Aspect_TypeOfHighlightMethod.Aspect_TOHM_COLOR
Aspect_TOHM_BOUNDBOX = Aspect_TypeOfHighlightMethod.Aspect_TOHM_BOUNDBOX

class Aspect_TypeOfResize(IntEnum):
    Aspect_TOR_UNKNOWN: int = ...
    Aspect_TOR_NO_BORDER: int = ...
    Aspect_TOR_TOP_BORDER: int = ...
    Aspect_TOR_RIGHT_BORDER: int = ...
    Aspect_TOR_BOTTOM_BORDER: int = ...
    Aspect_TOR_LEFT_BORDER: int = ...
    Aspect_TOR_TOP_AND_RIGHT_BORDER: int = ...
    Aspect_TOR_RIGHT_AND_BOTTOM_BORDER: int = ...
    Aspect_TOR_BOTTOM_AND_LEFT_BORDER: int = ...
    Aspect_TOR_LEFT_AND_TOP_BORDER: int = ...

Aspect_TOR_UNKNOWN = Aspect_TypeOfResize.Aspect_TOR_UNKNOWN
Aspect_TOR_NO_BORDER = Aspect_TypeOfResize.Aspect_TOR_NO_BORDER
Aspect_TOR_TOP_BORDER = Aspect_TypeOfResize.Aspect_TOR_TOP_BORDER
Aspect_TOR_RIGHT_BORDER = Aspect_TypeOfResize.Aspect_TOR_RIGHT_BORDER
Aspect_TOR_BOTTOM_BORDER = Aspect_TypeOfResize.Aspect_TOR_BOTTOM_BORDER
Aspect_TOR_LEFT_BORDER = Aspect_TypeOfResize.Aspect_TOR_LEFT_BORDER
Aspect_TOR_TOP_AND_RIGHT_BORDER = Aspect_TypeOfResize.Aspect_TOR_TOP_AND_RIGHT_BORDER
Aspect_TOR_RIGHT_AND_BOTTOM_BORDER = Aspect_TypeOfResize.Aspect_TOR_RIGHT_AND_BOTTOM_BORDER
Aspect_TOR_BOTTOM_AND_LEFT_BORDER = Aspect_TypeOfResize.Aspect_TOR_BOTTOM_AND_LEFT_BORDER
Aspect_TOR_LEFT_AND_TOP_BORDER = Aspect_TypeOfResize.Aspect_TOR_LEFT_AND_TOP_BORDER

class Aspect_GridType(IntEnum):
    Aspect_GT_Rectangular: int = ...
    Aspect_GT_Circular: int = ...

Aspect_GT_Rectangular = Aspect_GridType.Aspect_GT_Rectangular
Aspect_GT_Circular = Aspect_GridType.Aspect_GT_Circular

class Aspect_TypeOfColorScaleData(IntEnum):
    Aspect_TOCSD_AUTO: int = ...
    Aspect_TOCSD_USER: int = ...

Aspect_TOCSD_AUTO = Aspect_TypeOfColorScaleData.Aspect_TOCSD_AUTO
Aspect_TOCSD_USER = Aspect_TypeOfColorScaleData.Aspect_TOCSD_USER

class Aspect_TypeOfStyleText(IntEnum):
    Aspect_TOST_NORMAL: int = ...
    Aspect_TOST_ANNOTATION: int = ...

Aspect_TOST_NORMAL = Aspect_TypeOfStyleText.Aspect_TOST_NORMAL
Aspect_TOST_ANNOTATION = Aspect_TypeOfStyleText.Aspect_TOST_ANNOTATION

class Aspect_TypeOfMarker(IntEnum):
    Aspect_TOM_EMPTY: int = ...
    Aspect_TOM_POINT: int = ...
    Aspect_TOM_PLUS: int = ...
    Aspect_TOM_STAR: int = ...
    Aspect_TOM_X: int = ...
    Aspect_TOM_O: int = ...
    Aspect_TOM_O_POINT: int = ...
    Aspect_TOM_O_PLUS: int = ...
    Aspect_TOM_O_STAR: int = ...
    Aspect_TOM_O_X: int = ...
    Aspect_TOM_RING1: int = ...
    Aspect_TOM_RING2: int = ...
    Aspect_TOM_RING3: int = ...
    Aspect_TOM_BALL: int = ...
    Aspect_TOM_USERDEFINED: int = ...

Aspect_TOM_EMPTY = Aspect_TypeOfMarker.Aspect_TOM_EMPTY
Aspect_TOM_POINT = Aspect_TypeOfMarker.Aspect_TOM_POINT
Aspect_TOM_PLUS = Aspect_TypeOfMarker.Aspect_TOM_PLUS
Aspect_TOM_STAR = Aspect_TypeOfMarker.Aspect_TOM_STAR
Aspect_TOM_X = Aspect_TypeOfMarker.Aspect_TOM_X
Aspect_TOM_O = Aspect_TypeOfMarker.Aspect_TOM_O
Aspect_TOM_O_POINT = Aspect_TypeOfMarker.Aspect_TOM_O_POINT
Aspect_TOM_O_PLUS = Aspect_TypeOfMarker.Aspect_TOM_O_PLUS
Aspect_TOM_O_STAR = Aspect_TypeOfMarker.Aspect_TOM_O_STAR
Aspect_TOM_O_X = Aspect_TypeOfMarker.Aspect_TOM_O_X
Aspect_TOM_RING1 = Aspect_TypeOfMarker.Aspect_TOM_RING1
Aspect_TOM_RING2 = Aspect_TypeOfMarker.Aspect_TOM_RING2
Aspect_TOM_RING3 = Aspect_TypeOfMarker.Aspect_TOM_RING3
Aspect_TOM_BALL = Aspect_TypeOfMarker.Aspect_TOM_BALL
Aspect_TOM_USERDEFINED = Aspect_TypeOfMarker.Aspect_TOM_USERDEFINED

class Aspect_TypeOfColorScaleOrientation(IntEnum):
    Aspect_TOCSO_NONE: int = ...
    Aspect_TOCSO_LEFT: int = ...
    Aspect_TOCSO_RIGHT: int = ...
    Aspect_TOCSO_CENTER: int = ...

Aspect_TOCSO_NONE = Aspect_TypeOfColorScaleOrientation.Aspect_TOCSO_NONE
Aspect_TOCSO_LEFT = Aspect_TypeOfColorScaleOrientation.Aspect_TOCSO_LEFT
Aspect_TOCSO_RIGHT = Aspect_TypeOfColorScaleOrientation.Aspect_TOCSO_RIGHT
Aspect_TOCSO_CENTER = Aspect_TypeOfColorScaleOrientation.Aspect_TOCSO_CENTER

class Aspect_TypeOfFacingModel(IntEnum):
    Aspect_TOFM_BOTH_SIDE: int = ...
    Aspect_TOFM_BACK_SIDE: int = ...
    Aspect_TOFM_FRONT_SIDE: int = ...

Aspect_TOFM_BOTH_SIDE = Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE
Aspect_TOFM_BACK_SIDE = Aspect_TypeOfFacingModel.Aspect_TOFM_BACK_SIDE
Aspect_TOFM_FRONT_SIDE = Aspect_TypeOfFacingModel.Aspect_TOFM_FRONT_SIDE

class Aspect_FillMethod(IntEnum):
    Aspect_FM_NONE: int = ...
    Aspect_FM_CENTERED: int = ...
    Aspect_FM_TILED: int = ...
    Aspect_FM_STRETCH: int = ...

Aspect_FM_NONE = Aspect_FillMethod.Aspect_FM_NONE
Aspect_FM_CENTERED = Aspect_FillMethod.Aspect_FM_CENTERED
Aspect_FM_TILED = Aspect_FillMethod.Aspect_FM_TILED
Aspect_FM_STRETCH = Aspect_FillMethod.Aspect_FM_STRETCH

class Aspect_ColorSpace(IntEnum):
    Aspect_ColorSpace_sRGB: int = ...
    Aspect_ColorSpace_Linear: int = ...

Aspect_ColorSpace_sRGB = Aspect_ColorSpace.Aspect_ColorSpace_sRGB
Aspect_ColorSpace_Linear = Aspect_ColorSpace.Aspect_ColorSpace_Linear

class Aspect_HatchStyle(IntEnum):
    Aspect_HS_SOLID: int = ...
    Aspect_HS_HORIZONTAL: int = ...
    Aspect_HS_HORIZONTAL_WIDE: int = ...
    Aspect_HS_VERTICAL: int = ...
    Aspect_HS_VERTICAL_WIDE: int = ...
    Aspect_HS_DIAGONAL_45: int = ...
    Aspect_HS_DIAGONAL_45_WIDE: int = ...
    Aspect_HS_DIAGONAL_135: int = ...
    Aspect_HS_DIAGONAL_135_WIDE: int = ...
    Aspect_HS_GRID: int = ...
    Aspect_HS_GRID_WIDE: int = ...
    Aspect_HS_GRID_DIAGONAL: int = ...
    Aspect_HS_GRID_DIAGONAL_WIDE: int = ...
    Aspect_HS_NB: int = ...

Aspect_HS_SOLID = Aspect_HatchStyle.Aspect_HS_SOLID
Aspect_HS_HORIZONTAL = Aspect_HatchStyle.Aspect_HS_HORIZONTAL
Aspect_HS_HORIZONTAL_WIDE = Aspect_HatchStyle.Aspect_HS_HORIZONTAL_WIDE
Aspect_HS_VERTICAL = Aspect_HatchStyle.Aspect_HS_VERTICAL
Aspect_HS_VERTICAL_WIDE = Aspect_HatchStyle.Aspect_HS_VERTICAL_WIDE
Aspect_HS_DIAGONAL_45 = Aspect_HatchStyle.Aspect_HS_DIAGONAL_45
Aspect_HS_DIAGONAL_45_WIDE = Aspect_HatchStyle.Aspect_HS_DIAGONAL_45_WIDE
Aspect_HS_DIAGONAL_135 = Aspect_HatchStyle.Aspect_HS_DIAGONAL_135
Aspect_HS_DIAGONAL_135_WIDE = Aspect_HatchStyle.Aspect_HS_DIAGONAL_135_WIDE
Aspect_HS_GRID = Aspect_HatchStyle.Aspect_HS_GRID
Aspect_HS_GRID_WIDE = Aspect_HatchStyle.Aspect_HS_GRID_WIDE
Aspect_HS_GRID_DIAGONAL = Aspect_HatchStyle.Aspect_HS_GRID_DIAGONAL
Aspect_HS_GRID_DIAGONAL_WIDE = Aspect_HatchStyle.Aspect_HS_GRID_DIAGONAL_WIDE
Aspect_HS_NB = Aspect_HatchStyle.Aspect_HS_NB

class Aspect_XRActionType(IntEnum):
    Aspect_XRActionType_InputDigital: int = ...
    Aspect_XRActionType_InputAnalog: int = ...
    Aspect_XRActionType_InputPose: int = ...
    Aspect_XRActionType_InputSkeletal: int = ...
    Aspect_XRActionType_OutputHaptic: int = ...

Aspect_XRActionType_InputDigital = Aspect_XRActionType.Aspect_XRActionType_InputDigital
Aspect_XRActionType_InputAnalog = Aspect_XRActionType.Aspect_XRActionType_InputAnalog
Aspect_XRActionType_InputPose = Aspect_XRActionType.Aspect_XRActionType_InputPose
Aspect_XRActionType_InputSkeletal = Aspect_XRActionType.Aspect_XRActionType_InputSkeletal
Aspect_XRActionType_OutputHaptic = Aspect_XRActionType.Aspect_XRActionType_OutputHaptic

class Aspect_PolygonOffsetMode(IntEnum):
    Aspect_POM_Off: int = ...
    Aspect_POM_Fill: int = ...
    Aspect_POM_Line: int = ...
    Aspect_POM_Point: int = ...
    Aspect_POM_All: int = ...
    Aspect_POM_None: int = ...
    Aspect_POM_Mask: int = ...

Aspect_POM_Off = Aspect_PolygonOffsetMode.Aspect_POM_Off
Aspect_POM_Fill = Aspect_PolygonOffsetMode.Aspect_POM_Fill
Aspect_POM_Line = Aspect_PolygonOffsetMode.Aspect_POM_Line
Aspect_POM_Point = Aspect_PolygonOffsetMode.Aspect_POM_Point
Aspect_POM_All = Aspect_PolygonOffsetMode.Aspect_POM_All
Aspect_POM_None = Aspect_PolygonOffsetMode.Aspect_POM_None
Aspect_POM_Mask = Aspect_PolygonOffsetMode.Aspect_POM_Mask

class Aspect_XRTrackedDeviceRole(IntEnum):
    Aspect_XRTrackedDeviceRole_Head: int = ...
    Aspect_XRTrackedDeviceRole_LeftHand: int = ...
    Aspect_XRTrackedDeviceRole_RightHand: int = ...
    Aspect_XRTrackedDeviceRole_Other: int = ...

Aspect_XRTrackedDeviceRole_Head = Aspect_XRTrackedDeviceRole.Aspect_XRTrackedDeviceRole_Head
Aspect_XRTrackedDeviceRole_LeftHand = Aspect_XRTrackedDeviceRole.Aspect_XRTrackedDeviceRole_LeftHand
Aspect_XRTrackedDeviceRole_RightHand = Aspect_XRTrackedDeviceRole.Aspect_XRTrackedDeviceRole_RightHand
Aspect_XRTrackedDeviceRole_Other = Aspect_XRTrackedDeviceRole.Aspect_XRTrackedDeviceRole_Other


class Aspect_TypeOfColorScalePosition(IntEnum):
    Aspect_TOCSP_NONE: int = ...
    Aspect_TOCSP_LEFT: int = ...
    Aspect_TOCSP_RIGHT: int = ...
    Aspect_TOCSP_CENTER: int = ...

Aspect_TOCSP_NONE = Aspect_TypeOfColorScalePosition.Aspect_TOCSP_NONE
Aspect_TOCSP_LEFT = Aspect_TypeOfColorScalePosition.Aspect_TOCSP_LEFT
Aspect_TOCSP_RIGHT = Aspect_TypeOfColorScalePosition.Aspect_TOCSP_RIGHT
Aspect_TOCSP_CENTER = Aspect_TypeOfColorScalePosition.Aspect_TOCSP_CENTER

class Aspect_GraphicsLibrary(IntEnum):
    Aspect_GraphicsLibrary_OpenGL: int = ...
    Aspect_GraphicsLibrary_OpenGLES: int = ...

Aspect_GraphicsLibrary_OpenGL = Aspect_GraphicsLibrary.Aspect_GraphicsLibrary_OpenGL
Aspect_GraphicsLibrary_OpenGLES = Aspect_GraphicsLibrary.Aspect_GraphicsLibrary_OpenGLES



class Aspect_XAtom(IntEnum):
    Aspect_XA_DELETE_WINDOW: int = ...

Aspect_XA_DELETE_WINDOW = Aspect_XAtom.Aspect_XA_DELETE_WINDOW

class Aspect_TypeOfTriedronPosition(IntEnum):
    Aspect_TOTP_CENTER: int = ...
    Aspect_TOTP_TOP: int = ...
    Aspect_TOTP_BOTTOM: int = ...
    Aspect_TOTP_LEFT: int = ...
    Aspect_TOTP_RIGHT: int = ...
    Aspect_TOTP_LEFT_LOWER: int = ...
    Aspect_TOTP_LEFT_UPPER: int = ...
    Aspect_TOTP_RIGHT_LOWER: int = ...
    Aspect_TOTP_RIGHT_UPPER: int = ...

Aspect_TOTP_CENTER = Aspect_TypeOfTriedronPosition.Aspect_TOTP_CENTER
Aspect_TOTP_TOP = Aspect_TypeOfTriedronPosition.Aspect_TOTP_TOP
Aspect_TOTP_BOTTOM = Aspect_TypeOfTriedronPosition.Aspect_TOTP_BOTTOM
Aspect_TOTP_LEFT = Aspect_TypeOfTriedronPosition.Aspect_TOTP_LEFT
Aspect_TOTP_RIGHT = Aspect_TypeOfTriedronPosition.Aspect_TOTP_RIGHT
Aspect_TOTP_LEFT_LOWER = Aspect_TypeOfTriedronPosition.Aspect_TOTP_LEFT_LOWER
Aspect_TOTP_LEFT_UPPER = Aspect_TypeOfTriedronPosition.Aspect_TOTP_LEFT_UPPER
Aspect_TOTP_RIGHT_LOWER = Aspect_TypeOfTriedronPosition.Aspect_TOTP_RIGHT_LOWER
Aspect_TOTP_RIGHT_UPPER = Aspect_TypeOfTriedronPosition.Aspect_TOTP_RIGHT_UPPER

class Aspect_GridDrawMode(IntEnum):
    Aspect_GDM_Lines: int = ...
    Aspect_GDM_Points: int = ...
    Aspect_GDM_None: int = ...

Aspect_GDM_Lines = Aspect_GridDrawMode.Aspect_GDM_Lines
Aspect_GDM_Points = Aspect_GridDrawMode.Aspect_GDM_Points
Aspect_GDM_None = Aspect_GridDrawMode.Aspect_GDM_None

class Aspect_WidthOfLine(IntEnum):
    Aspect_WOL_THIN: int = ...
    Aspect_WOL_MEDIUM: int = ...
    Aspect_WOL_THICK: int = ...
    Aspect_WOL_VERYTHICK: int = ...
    Aspect_WOL_USERDEFINED: int = ...

Aspect_WOL_THIN = Aspect_WidthOfLine.Aspect_WOL_THIN
Aspect_WOL_MEDIUM = Aspect_WidthOfLine.Aspect_WOL_MEDIUM
Aspect_WOL_THICK = Aspect_WidthOfLine.Aspect_WOL_THICK
Aspect_WOL_VERYTHICK = Aspect_WidthOfLine.Aspect_WOL_VERYTHICK
Aspect_WOL_USERDEFINED = Aspect_WidthOfLine.Aspect_WOL_USERDEFINED

class Aspect_TypeOfDisplayText(IntEnum):
    Aspect_TODT_NORMAL: int = ...
    Aspect_TODT_SUBTITLE: int = ...
    Aspect_TODT_DEKALE: int = ...
    Aspect_TODT_BLEND: int = ...
    Aspect_TODT_DIMENSION: int = ...
    Aspect_TODT_SHADOW: int = ...

Aspect_TODT_NORMAL = Aspect_TypeOfDisplayText.Aspect_TODT_NORMAL
Aspect_TODT_SUBTITLE = Aspect_TypeOfDisplayText.Aspect_TODT_SUBTITLE
Aspect_TODT_DEKALE = Aspect_TypeOfDisplayText.Aspect_TODT_DEKALE
Aspect_TODT_BLEND = Aspect_TypeOfDisplayText.Aspect_TODT_BLEND
Aspect_TODT_DIMENSION = Aspect_TypeOfDisplayText.Aspect_TODT_DIMENSION
Aspect_TODT_SHADOW = Aspect_TypeOfDisplayText.Aspect_TODT_SHADOW

class Aspect_InteriorStyle(IntEnum):
    Aspect_IS_EMPTY: int = ...
    Aspect_IS_SOLID: int = ...
    Aspect_IS_HATCH: int = ...
    Aspect_IS_HIDDENLINE: int = ...
    Aspect_IS_POINT: int = ...
    Aspect_IS_HOLLOW: int = ...

Aspect_IS_EMPTY = Aspect_InteriorStyle.Aspect_IS_EMPTY
Aspect_IS_SOLID = Aspect_InteriorStyle.Aspect_IS_SOLID
Aspect_IS_HATCH = Aspect_InteriorStyle.Aspect_IS_HATCH
Aspect_IS_HIDDENLINE = Aspect_InteriorStyle.Aspect_IS_HIDDENLINE
Aspect_IS_POINT = Aspect_InteriorStyle.Aspect_IS_POINT
Aspect_IS_HOLLOW = Aspect_InteriorStyle.Aspect_IS_HOLLOW

class Aspect_Background:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, AColor: Quantity_Color) -> None: ...
    def Color(self) -> Quantity_Color: ...
    def SetColor(self, AColor: Quantity_Color) -> None: ...

class Aspect_DisplayConnection(Standard_Transient):
    def GetDefaultFBConfig(self) -> Aspect_FBConfig: ...
    def GetDefaultVisualInfo(self) -> Aspect_XVisualInfo: ...
    def GetDisplayAspect(self) -> Aspect_XDisplay: ...

class Aspect_GenId:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLow: int, theUpper: int) -> None: ...
    def Available(self) -> int: ...
    @overload
    def Free(self) -> None: ...
    @overload
    def Free(self, theId: int) -> None: ...
    def HasFree(self) -> bool: ...
    def Lower(self) -> int: ...
    @overload
    def Next(self) -> int: ...
    @overload
    def Next(self) -> Tuple[bool, int]: ...
    def Upper(self) -> int: ...

class Aspect_Grid(Standard_Transient):
    def Activate(self) -> None: ...
    def Colors(self, aColor: Quantity_Color, aTenthColor: Quantity_Color) -> None: ...
    def Compute(self, X: float, Y: float) -> Tuple[float, float]: ...
    def Deactivate(self) -> None: ...
    def Display(self) -> None: ...
    def DrawMode(self) -> Aspect_GridDrawMode: ...
    def Erase(self) -> None: ...
    def Hit(self, X: float, Y: float) -> Tuple[float, float]: ...
    def Init(self) -> None: ...
    def IsActive(self) -> bool: ...
    def IsDisplayed(self) -> bool: ...
    def Rotate(self, anAngle: float) -> None: ...
    def RotationAngle(self) -> float: ...
    def SetColors(self, aColor: Quantity_Color, aTenthColor: Quantity_Color) -> None: ...
    def SetDrawMode(self, aDrawMode: Aspect_GridDrawMode) -> None: ...
    def SetRotationAngle(self, anAngle: float) -> None: ...
    def SetXOrigin(self, anOrigin: float) -> None: ...
    def SetYOrigin(self, anOrigin: float) -> None: ...
    def Translate(self, aDx: float, aDy: float) -> None: ...
    def XOrigin(self) -> float: ...
    def YOrigin(self) -> float: ...

class Aspect_ScrollDelta:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theValue: float, theFlags: Optional[Aspect_VKeyFlags] = Aspect_VKeyFlags_NONE) -> None: ...
    def HasPoint(self) -> bool: ...
    def ResetPoint(self) -> None: ...

class Aspect_Touch:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theX: float, theY: float, theIsPreciseDevice: bool) -> None: ...
    def Delta(self) -> False: ...

class Aspect_TrackedDevicePose:
    def __init__(self) -> None: ...

class Aspect_Window(Standard_Transient):
    def Background(self) -> Aspect_Background: ...
    def BackgroundFillMethod(self) -> Aspect_FillMethod: ...
    def ConvertPointFromBacking(self, thePnt: Graphic3d_Vec2d) -> Graphic3d_Vec2d: ...
    def ConvertPointToBacking(self, thePnt: Graphic3d_Vec2d) -> Graphic3d_Vec2d: ...
    def DevicePixelRatio(self) -> float: ...
    def DisplayConnection(self) -> Aspect_DisplayConnection: ...
    def DoMapping(self) -> bool: ...
    def DoResize(self) -> Aspect_TypeOfResize: ...
    def GradientBackground(self) -> Aspect_GradientBackground: ...
    def InvalidateContent(self, theDisp: Aspect_DisplayConnection) -> None: ...
    def IsMapped(self) -> bool: ...
    def IsVirtual(self) -> bool: ...
    def Map(self) -> None: ...
    def NativeFBConfig(self) -> Aspect_FBConfig: ...
    def Position(self) -> Tuple[int, int, int, int]: ...
    def Ratio(self) -> float: ...
    @overload
    def SetBackground(self, ABack: Aspect_Background) -> None: ...
    @overload
    def SetBackground(self, color: Quantity_Color) -> None: ...
    @overload
    def SetBackground(self, ABackground: Aspect_GradientBackground) -> None: ...
    @overload
    def SetBackground(self, theFirstColor: Quantity_Color, theSecondColor: Quantity_Color, theFillMethod: Aspect_GradientFillMethod) -> None: ...
    def SetTitle(self, theTitle: TCollection_AsciiString) -> None: ...
    def SetVirtual(self, theVirtual: bool) -> None: ...
    def Size(self) -> Tuple[int, int]: ...
    def Unmap(self) -> None: ...

class Aspect_WindowInputListener:
    def AddTouchPoint(self, theId: int, thePnt: Graphic3d_Vec2d, theClearBefore: Optional[bool] = false) -> None: ...
    def Change3dMouseIsNoRotate(self) -> bool: ...
    def Change3dMouseToReverse(self) -> bool: ...
    def ChangeKeys(self) -> Aspect_VKeySet: ...
    def EventTime(self) -> False: ...
    def Get3dMouseIsNoRotate(self) -> bool: ...
    def Get3dMouseRotationScale(self) -> float: ...
    def Get3dMouseToReverse(self) -> bool: ...
    def Get3dMouseTranslationScale(self) -> float: ...
    def HasTouchPoints(self) -> bool: ...
    def Keys(self) -> Aspect_VKeySet: ...
    def LastMouseFlags(self) -> Aspect_VKeyFlags: ...
    def LastMousePosition(self) -> Graphic3d_Vec2i: ...
    def PressMouseButton(self, thePoint: Graphic3d_Vec2i, theButton: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsEmulated: bool) -> bool: ...
    def PressedMouseButtons(self) -> Aspect_VKeyMouse: ...
    def ProcessClose(self) -> None: ...
    def ProcessConfigure(self, theIsResized: bool) -> None: ...
    def ProcessExpose(self) -> None: ...
    def ProcessFocus(self, theIsActivated: bool) -> None: ...
    def ProcessInput(self) -> None: ...
    def ReleaseMouseButton(self, thePoint: Graphic3d_Vec2i, theButton: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsEmulated: bool) -> bool: ...
    def RemoveTouchPoint(self, theId: int, theClearSelectPnts: Optional[bool] = false) -> bool: ...
    def Set3dMousePreciseInput(self, theIsQuadric: bool) -> None: ...
    def Set3dMouseRotationScale(self, theScale: float) -> None: ...
    def Set3dMouseTranslationScale(self, theScale: float) -> None: ...
    def To3dMousePreciseInput(self) -> bool: ...
    def TouchPoints(self) -> Aspect_TouchMap: ...
    def UpdateMouseButtons(self, thePoint: Graphic3d_Vec2i, theButtons: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsEmulated: bool) -> bool: ...
    def UpdateMousePosition(self, thePoint: Graphic3d_Vec2i, theButtons: Aspect_VKeyMouse, theModifiers: Aspect_VKeyFlags, theIsEmulated: bool) -> bool: ...
    def UpdateMouseScroll(self, theDelta: Aspect_ScrollDelta) -> bool: ...
    def UpdateTouchPoint(self, theId: int, thePnt: Graphic3d_Vec2d) -> None: ...

class Aspect_XRAction(Standard_Transient):
    def __init__(self, theId: TCollection_AsciiString, theType: Aspect_XRActionType) -> None: ...
    def Id(self) -> TCollection_AsciiString: ...
    def IsValid(self) -> bool: ...
    def RawHandle(self) -> False: ...
    def Type(self) -> Aspect_XRActionType: ...

class Aspect_XRActionSet(Standard_Transient):
    def __init__(self, theId: TCollection_AsciiString) -> None: ...
    def Actions(self) -> Aspect_XRActionMap: ...
    def AddAction(self, theAction: Aspect_XRAction) -> None: ...
    def Id(self) -> TCollection_AsciiString: ...
    def RawHandle(self) -> False: ...

class Aspect_XRAnalogActionData:
    def __init__(self) -> None: ...
    def IsChanged(self) -> bool: ...

class Aspect_XRDigitalActionData:
    def __init__(self) -> None: ...

class Aspect_XRHapticActionData:
    def __init__(self) -> None: ...
    def IsValid(self) -> bool: ...

class Aspect_XRPoseActionData:
    def __init__(self) -> None: ...

class Aspect_XRSession(Standard_Transient):
    def AbortHapticVibrationAction(self, theAction: Aspect_XRAction) -> None: ...
    def Aspect(self) -> float: ...
    def Close(self) -> None: ...
    def DisplayFrequency(self) -> float: ...
    def EyeToHeadTransform(self, theEye: Aspect_Eye) -> False: ...
    def FieldOfView(self) -> float: ...
    def GenericAction(self, theDevice: Aspect_XRTrackedDeviceRole, theAction: Aspect_XRGenericAction) -> Aspect_XRAction: ...
    def GetAnalogActionData(self, theAction: Aspect_XRAction) -> Aspect_XRAnalogActionData: ...
    def GetDigitalActionData(self, theAction: Aspect_XRAction) -> Aspect_XRDigitalActionData: ...
    def GetPoseActionDataForNextFrame(self, theAction: Aspect_XRAction) -> Aspect_XRPoseActionData: ...
    def HasProjectionFrustums(self) -> bool: ...
    def HasTrackedPose(self, theDevice: int) -> bool: ...
    def HeadPose(self) -> gp_Trsf: ...
    def HeadToEyeTransform(self, theEye: Aspect_Eye) -> False: ...
    def IOD(self) -> float: ...
    def IsOpen(self) -> bool: ...
    def LeftHandPose(self) -> gp_Trsf: ...
    @overload
    def LoadRenderModel(self, theDevice: int, theTexture: Image_Texture) -> Graphic3d_ArrayOfTriangles: ...
    @overload
    def LoadRenderModel(self, theDevice: int, theToApplyUnitFactor: bool, theTexture: Image_Texture) -> Graphic3d_ArrayOfTriangles: ...
    def NamedTrackedDevice(self, theDevice: Aspect_XRTrackedDeviceRole) -> int: ...
    def Open(self) -> bool: ...
    def ProcessEvents(self) -> None: ...
    def ProjectionFrustum(self, theEye: Aspect_Eye) -> False: ...
    def RecommendedViewport(self) -> False: ...
    def RightHandPose(self) -> gp_Trsf: ...
    def SetUnitFactor(self, theFactor: float) -> None: ...
    def SubmitEye(self, theTexture: None, theGraphicsLib: Aspect_GraphicsLibrary, theColorSpace: Aspect_ColorSpace, theEye: Aspect_Eye) -> bool: ...
    def TrackedPoses(self) -> Aspect_TrackedDevicePoseArray: ...
    def TrackingOrigin(self) -> False: ...
    def TriggerHapticVibrationAction(self, theAction: Aspect_XRAction, theParams: Aspect_XRHapticActionData) -> None: ...
    def UnitFactor(self) -> float: ...
    def WaitPoses(self) -> bool: ...

class Aspect_GradientBackground(Aspect_Background):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theColor1: Quantity_Color, theColor2: Quantity_Color, theMethod: Optional[Aspect_GradientFillMethod] = Aspect_GradientFillMethod_Horizontal) -> None: ...
    def BgGradientFillMethod(self) -> Aspect_GradientFillMethod: ...
    def Colors(self, theColor1: Quantity_Color, theColor2: Quantity_Color) -> None: ...
    def SetColors(self, theColor1: Quantity_Color, theColor2: Quantity_Color, theMethod: Optional[Aspect_GradientFillMethod] = Aspect_GradientFillMethod_Horizontal) -> None: ...

class Aspect_OpenVRSession(Aspect_XRSession):
    def __init__(self) -> None: ...
    def Close(self) -> None: ...
    def EyeToHeadTransform(self, theEye: Aspect_Eye) -> False: ...
    def GetAnalogActionData(self, theAction: Aspect_XRAction) -> Aspect_XRAnalogActionData: ...
    def GetDigitalActionData(self, theAction: Aspect_XRAction) -> Aspect_XRDigitalActionData: ...
    def GetPoseActionDataForNextFrame(self, theAction: Aspect_XRAction) -> Aspect_XRPoseActionData: ...
    def HasProjectionFrustums(self) -> bool: ...
    @staticmethod
    def IsHmdPresent() -> bool: ...
    def IsOpen(self) -> bool: ...
    def NamedTrackedDevice(self, theDevice: Aspect_XRTrackedDeviceRole) -> int: ...
    def Open(self) -> bool: ...
    def ProcessEvents(self) -> None: ...
    def RecommendedViewport(self) -> False: ...
    def SubmitEye(self, theTexture: None, theGraphicsLib: Aspect_GraphicsLibrary, theColorSpace: Aspect_ColorSpace, theEye: Aspect_Eye) -> bool: ...
    def WaitPoses(self) -> bool: ...

#classnotwrapped
class Aspect_CircularGrid: ...

#classnotwrapped
class Aspect_NeutralWindow: ...

#classnotwrapped
class Aspect_RectangularGrid: ...

#classnotwrapped
class Aspect_FrustumLRBT: ...

# harray1 classes
# harray2 classes
# hsequence classes

Aspect_OpenVRSession_IsHmdPresent = Aspect_OpenVRSession.IsHmdPresent
