/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.c.STR;
import org.jmol.dssx.DSSP;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public final class BioModel
extends Model {
    private Viewer vwr;
    int bioPolymerCount = 0;
    public BioPolymer[] bioPolymers;
    boolean isMutated;
    String defaultStructure;

    BioModel(ModelSet modelSet, int modelIndex, int trajectoryBaseIndex, String jmolData, Properties properties, Map<String, Object> auxiliaryInfo) {
        this.vwr = modelSet.vwr;
        this.set(modelSet, modelIndex, trajectoryBaseIndex, jmolData, properties, auxiliaryInfo);
        this.isBioModel = true;
        this.vwr.getJBR().getBioModelSet(modelSet);
        this.clearBioPolymers();
        modelSet.am[modelIndex] = this;
        this.pdbID = (String)auxiliaryInfo.get("name");
    }

    int addBioPolymer(BioPolymer polymer) {
        if (this.bioPolymers.length == 0) {
            this.clearBioPolymers();
        }
        if (this.bioPolymerCount == this.bioPolymers.length) {
            this.bioPolymers = (BioPolymer[])AU.doubleLength(this.bioPolymers);
        }
        polymer.bioPolymerIndexInModel = this.bioPolymerCount;
        this.bioPolymers[this.bioPolymerCount++] = polymer;
        return polymer.monomerCount;
    }

    void addSecondaryStructure(STR type, String structureID, int serialID, int strandCount, int startChainID, int startSeqcode, int endChainID, int endSeqcode, int istart, int iend, BS bsAssigned) {
        int i = this.bioPolymerCount;
        while (--i >= 0) {
            if (!(this.bioPolymers[i] instanceof AlphaPolymer)) continue;
            ((AlphaPolymer)this.bioPolymers[i]).addStructure(type, structureID, serialID, strandCount, startChainID, startSeqcode, endChainID, endSeqcode, istart, iend, bsAssigned);
        }
    }

    void addStructureByBS(int count, int dsspType, STR type, BS bs) {
        int i = this.bioPolymerCount;
        while (--i >= 0) {
            BioPolymer b = this.bioPolymers[i];
            if (!(b instanceof AlphaPolymer)) continue;
            ++count;
            count = ((AlphaPolymer)this.bioPolymers[i]).setStructureBS(count, dsspType, type, bs, true);
        }
    }

    private String calculateDssx(Lst<Bond> vHBonds, boolean doReport, boolean dsspIgnoreHydrogen, boolean setStructure, int version) {
        boolean haveProt = false;
        boolean haveNucl = false;
        for (int i = 0; !(i >= this.bioPolymerCount || haveProt && haveNucl); ++i) {
            if (this.bioPolymers[i].isNucleic()) {
                haveNucl = true;
                continue;
            }
            if (!(this.bioPolymers[i] instanceof AminoPolymer)) continue;
            haveProt = true;
        }
        String s = "";
        if (haveProt) {
            s = s + ((DSSP)Interface.getOption("dssx.DSSP", this.vwr, "ms")).calculateDssp(this.bioPolymers, this.bioPolymerCount, vHBonds, doReport, dsspIgnoreHydrogen, setStructure, version);
        }
        if (haveNucl && this.auxiliaryInfo.containsKey("dssr") && vHBonds != null) {
            s = s + this.vwr.getAnnotationParser(true).getHBonds(this.ms, this.modelIndex, vHBonds, doReport);
        }
        return s;
    }

    String calculateStructures(boolean asDSSP, boolean doReport, boolean dsspIgnoreHydrogen, boolean setStructure, boolean includeAlpha, int version) {
        int i;
        if (this.bioPolymerCount == 0 || !setStructure && !asDSSP) {
            return "";
        }
        this.structureTainted = true;
        this.ms.proteinStructureTainted = true;
        if (setStructure) {
            i = this.bioPolymerCount;
            while (--i >= 0) {
                if (asDSSP && this.bioPolymers[i].monomers[0].getNitrogenAtom() == null) continue;
                this.bioPolymers[i].clearStructures();
            }
        }
        if (!asDSSP || includeAlpha) {
            i = this.bioPolymerCount;
            while (--i >= 0) {
                if (!(this.bioPolymers[i] instanceof AlphaPolymer)) continue;
                ((AlphaPolymer)this.bioPolymers[i]).calculateStructures(includeAlpha);
            }
        }
        return asDSSP ? this.calculateDssx(null, doReport, dsspIgnoreHydrogen, setStructure, version) : "";
    }

    void clearBioPolymers() {
        this.bioPolymers = new BioPolymer[8];
        this.bioPolymerCount = 0;
    }

    @Override
    public void fixIndices(int modelIndex, int nAtomsDeleted, BS bsDeleted) {
        this.fixIndicesM(modelIndex, nAtomsDeleted, bsDeleted);
        this.recalculateLeadMidpointsAndWingVectors();
    }

    @Override
    public boolean freeze() {
        this.freezeM();
        this.bioPolymers = (BioPolymer[])AU.arrayCopyObject(this.bioPolymers, this.bioPolymerCount);
        return true;
    }

    public Lst<BS> getBioBranches(Lst<BS> biobranches) {
        for (int j = 0; j < this.bioPolymerCount; ++j) {
            BS bsBranch = new BS();
            this.bioPolymers[j].getRange(bsBranch, this.isMutated);
            int iAtom = bsBranch.nextSetBit(0);
            if (iAtom < 0) continue;
            if (biobranches == null) {
                biobranches = new Lst();
            }
            biobranches.addLast(bsBranch);
        }
        return biobranches;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    Object getCachedAnnotationMap(String key, Object ann) {
        Hashtable cache;
        Hashtable hashtable = cache = this.dssrCache == null && ann != null ? (this.dssrCache = new Hashtable()) : this.dssrCache;
        if (cache == null) {
            return null;
        }
        Object annotv = cache.get(key);
        if (annotv == null && ann != null) {
            annotv = ann instanceof SV || ann instanceof Hashtable ? ann : this.vwr.parseJSONMap((String)((Object)ann));
            cache.put(key, annotv);
        }
        return annotv instanceof SV || annotv instanceof Hashtable ? annotv : null;
    }

    public void getConformation(int conformationIndex0, boolean doSet, BS bsAtoms, BS bsRet) {
        Atom atom;
        int i;
        char thisAltLoc;
        boolean isConfig0;
        boolean bl = isConfig0 = conformationIndex0 == 0;
        if (this.altLocCount == 0) {
            if (isConfig0) {
                bsRet.or(bsAtoms);
            }
            return;
        }
        boolean isFirst = conformationIndex0 <= 0;
        Atom[] atoms = this.ms.at;
        boolean isSpace = conformationIndex0 == -32;
        char c = thisAltLoc = isFirst && !isSpace ? (char)(-conformationIndex0) : (char)'\u0000';
        if (isFirst) {
            int lastChain = Integer.MIN_VALUE;
            char lastIns = '\u0000';
            int lastRes = Integer.MIN_VALUE;
            Hashtable<String, int[]> map = new Hashtable<String, int[]>();
            i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                int i0;
                String name;
                int[] locs;
                atom = atoms[i];
                int chain = atom.getChainID();
                int res = atom.getResno();
                char ins = atom.getInsertionCode();
                if (res != lastRes || ins != lastIns || chain != lastChain) {
                    lastChain = chain;
                    lastRes = res;
                    lastIns = ins;
                    map.clear();
                }
                if ((locs = (int[])map.get(name = atom.getAtomName())) == null) {
                    locs = new int[1];
                    map.put(name, locs);
                }
                if ((i0 = locs[0] - 1) < 0) {
                    if (i0 == -2) {
                        bsAtoms.clear(i);
                    } else if (isSpace) {
                        if (atom.altloc != '\u0000') {
                            bsAtoms.clear(i);
                        }
                    } else {
                        locs[0] = i + 1;
                    }
                } else {
                    if (isConfig0) {
                        bsAtoms.clear(i);
                        locs[0] = -1;
                    } else if (atom.altloc == thisAltLoc) {
                        locs[0] = -1;
                    } else {
                        i0 = i;
                    }
                    bsAtoms.clear(i0);
                }
                i = bsAtoms.nextSetBit(i + 1);
            }
        } else {
            Group g = null;
            char ch = '\u0000';
            int conformationIndex = --conformationIndex0;
            BS bsFound = new BS();
            i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                atom = atoms[i];
                char altloc = atom.altloc;
                if (altloc != '\u0000') {
                    if (atom.group != g) {
                        g = atom.group;
                        ch = '\u0000';
                        conformationIndex = conformationIndex0;
                        bsFound.clearAll();
                    }
                    if (conformationIndex >= 0 && altloc != ch && !bsFound.get(altloc)) {
                        ch = altloc;
                        --conformationIndex;
                        bsFound.set(altloc);
                    }
                    if (conformationIndex >= 0 || altloc != ch) {
                        bsAtoms.clear(i);
                    }
                }
                i = bsAtoms.nextSetBit(i + 1);
            }
        }
        if (bsAtoms.nextSetBit(0) >= 0) {
            bsRet.or(bsAtoms);
            if (doSet) {
                int j = this.bioPolymerCount;
                while (--j >= 0) {
                    this.bioPolymers[j].setConformation(bsAtoms);
                }
            }
        }
    }

    public void getDefaultLargePDBRendering(SB sb, int maxAtoms) {
        BS bs = new BS();
        if (this.getBondCount() == 0) {
            bs = this.bsAtoms;
        }
        if (bs != this.bsAtoms) {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                this.bioPolymers[i].getRange(bs, this.isMutated);
            }
        }
        if (bs.nextSetBit(0) < 0) {
            return;
        }
        BS bs2 = new BS();
        if (bs == this.bsAtoms) {
            bs2 = bs;
        } else {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                if (this.bioPolymers[i].getType() != 0) continue;
                this.bioPolymers[i].getRange(bs2, this.isMutated);
            }
        }
        if (bs2.nextSetBit(0) >= 0) {
            sb.append("select ").append(Escape.eBS(bs2)).append(";backbone only;");
        }
        if (this.act <= maxAtoms) {
            return;
        }
        sb.append("select ").append(Escape.eBS(bs)).append(" & connected; wireframe only;");
        if (bs != this.bsAtoms) {
            bs2.clearAll();
            bs2.or(this.bsAtoms);
            bs2.andNot(bs);
            if (bs2.nextSetBit(0) >= 0) {
                sb.append("select " + Escape.eBS(bs2) + " & !connected;stars 0.5;spacefill off;");
            }
        }
    }

    public String getFullPDBHeader() {
        if (this.modelIndex < 0) {
            return "";
        }
        String info = (String)this.auxiliaryInfo.get("fileHeader");
        if (info != null) {
            return info;
        }
        return this.ms.bioModelset.getBioExt().getFullPDBHeader(this.auxiliaryInfo);
    }

    public void getPdbData(String type, char ctype, boolean isDraw, BS bsSelected, OC out, LabelToken[] tokens, SB pdbCONECT, BS bsWritten) {
        this.ms.bioModelset.getBioExt().getPdbDataM(this, this.vwr, type, ctype, isDraw, bsSelected, out, tokens, pdbCONECT, bsWritten);
    }

    void getRasmolHydrogenBonds(BS bsA, BS bsB, Lst<Bond> vHBonds, boolean nucleicOnly, int nMax, boolean dsspIgnoreHydrogens, BS bsHBonds, int version) {
        int i;
        boolean asDSSX;
        boolean doAdd;
        boolean bl = doAdd = vHBonds == null;
        if (doAdd) {
            vHBonds = new Lst();
        }
        if (nMax < 0) {
            nMax = Integer.MAX_VALUE;
        }
        boolean bl2 = asDSSX = bsB == null;
        if (asDSSX && this.bioPolymerCount > 0) {
            this.calculateDssx(vHBonds, false, dsspIgnoreHydrogens, false, version);
        } else {
            i = this.bioPolymerCount;
            block4: while (--i >= 0) {
                BioPolymer bp = this.bioPolymers[i];
                if (bp.monomerCount == 0) continue;
                int type = bp.getType();
                boolean isRNA = false;
                switch (type) {
                    case 1: {
                        if (nucleicOnly) continue block4;
                        bp.calcRasmolHydrogenBonds(null, bsA, bsB, vHBonds, nMax, null, true, false);
                        break;
                    }
                    case 2: {
                        isRNA = bp.monomers[0].isRna();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                int j = this.bioPolymerCount;
                while (--j >= 0) {
                    BioPolymer bp1 = this.bioPolymers[j];
                    if (bp1 == null || !isRNA && i == j || type != bp1.getType()) continue;
                    bp1.calcRasmolHydrogenBonds(bp, bsA, bsB, vHBonds, nMax, null, true, false);
                }
            }
        }
        if (vHBonds.size() == 0 || !doAdd) {
            return;
        }
        this.hasRasmolHBonds = true;
        for (i = 0; i < vHBonds.size(); ++i) {
            HBond bond = (HBond)vHBonds.get(i);
            Atom atom1 = bond.atom1;
            Atom atom2 = bond.atom2;
            if (atom1.isBonded(atom2)) continue;
            int index = this.ms.addHBond(atom1, atom2, bond.order, bond.getEnergy());
            if (bsHBonds == null) continue;
            bsHBonds.set(index);
        }
    }

    public String getUnitID(Atom atom, int flags) {
        boolean isAll;
        SB sb = new SB();
        Group m = atom.group;
        boolean noTrim = (flags & 0x10) != 16;
        char ch = (flags & 8) == 8 ? m.getInsertionCode() : (char)'\u0000';
        boolean bl = isAll = ch != '\u0000';
        if ((flags & 1) == 1 && this.pdbID != null) {
            sb.append(this.pdbID);
        }
        sb.append("|").appendO(this.ms.getInfo(this.modelIndex, "modelNumber")).append("|").append(this.vwr.getChainIDStr(m.chain.chainID)).append("|").append(m.getGroup3()).append("|").appendI(m.getResno());
        if ((flags & 4) == 4) {
            sb.append("|").append(atom.getAtomName());
            if (atom.altloc != '\u0000') {
                sb.append("|").appendC(atom.altloc);
            } else if (noTrim || isAll) {
                sb.append("|");
            }
        } else if (noTrim || isAll) {
            sb.append("||");
        }
        if (isAll) {
            sb.append("|").appendC(ch);
        } else if (noTrim) {
            sb.append("|");
        }
        if (noTrim) {
            sb.append("|");
        }
        return sb.toString();
    }

    void recalculateLeadMidpointsAndWingVectors() {
        for (int ip = 0; ip < this.bioPolymerCount; ++ip) {
            this.bioPolymers[ip].recalculateLeadMidpointsAndWingVectors();
        }
    }

    public void resetRasmolBonds(BS bs, int dsspVersion) {
        BS bsDelete = new BS();
        this.hasRasmolHBonds = false;
        Model[] am = this.ms.am;
        Bond[] bo = this.ms.bo;
        int i = this.ms.bondCount;
        while (--i >= 0) {
            Bond bond = bo[i];
            if ((bond.order & 0x7000) == 0 || am[bond.atom1.mi].trajectoryBaseIndex != this.modelIndex) continue;
            bsDelete.set(i);
        }
        if (bsDelete.nextSetBit(0) >= 0) {
            this.ms.deleteBonds(bsDelete, false);
        }
        this.getRasmolHydrogenBonds(bs, bs, null, false, Integer.MAX_VALUE, false, null, dsspVersion);
    }

    public void getAtomicDSSRData(float[] dssrData, String dataType) {
        if (this.auxiliaryInfo.containsKey("dssr")) {
            this.vwr.getAnnotationParser(true).getAtomicDSSRData(this.ms, this.modelIndex, dssrData, dataType);
        }
    }
}

