/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.X509TrustManagerImpl;

final class AbstractTrustManagerWrapper
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;

    AbstractTrustManagerWrapper(X509TrustManager tm) {
        this.tm = tm;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, engine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkAdditionalTrust(chain, authType, engine, false);
    }

    private void checkAdditionalTrust(X509Certificate[] chain, String authType, Socket socket, boolean isClient) throws CertificateException {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String identityAlg = sslSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (identityAlg != null && identityAlg.length() != 0) {
                String hostname = session.getPeerHost();
                X509TrustManagerImpl.checkIdentity(hostname, chain[0], identityAlg);
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(session.getProtocol());
            SSLAlgorithmConstraints constraints = null;
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    String[] peerSupportedSignAlgs = extSession.getLocalSupportedSignatureAlgorithms();
                    constraints = new SSLAlgorithmConstraints(sslSocket, peerSupportedSignAlgs, true);
                } else {
                    constraints = new SSLAlgorithmConstraints(sslSocket, true);
                }
            } else {
                constraints = new SSLAlgorithmConstraints(sslSocket, true);
            }
            this.checkAlgorithmConstraints(chain, constraints, isClient);
        }
    }

    private void checkAdditionalTrust(X509Certificate[] chain, String authType, SSLEngine engine, boolean isClient) throws CertificateException {
        if (engine != null) {
            SSLSession session = engine.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String identityAlg = engine.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (identityAlg != null && identityAlg.length() != 0) {
                String hostname = session.getPeerHost();
                X509TrustManagerImpl.checkIdentity(hostname, chain[0], identityAlg);
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(session.getProtocol());
            SSLAlgorithmConstraints constraints = null;
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    String[] peerSupportedSignAlgs = extSession.getLocalSupportedSignatureAlgorithms();
                    constraints = new SSLAlgorithmConstraints(engine, peerSupportedSignAlgs, true);
                } else {
                    constraints = new SSLAlgorithmConstraints(engine, true);
                }
            } else {
                constraints = new SSLAlgorithmConstraints(engine, true);
            }
            this.checkAlgorithmConstraints(chain, constraints, isClient);
        }
    }

    private void checkAlgorithmConstraints(X509Certificate[] chain, AlgorithmConstraints constraints, boolean isClient) throws CertificateException {
        try {
            int checkedLength = chain.length - 1;
            HashSet trustedCerts = new HashSet();
            X509Certificate[] certs = this.tm.getAcceptedIssuers();
            if (certs != null && certs.length > 0) {
                Collections.addAll(trustedCerts, certs);
            }
            if (trustedCerts.contains(chain[checkedLength])) {
                --checkedLength;
            }
            if (checkedLength >= 0) {
                AlgorithmChecker checker = new AlgorithmChecker(constraints, null, isClient ? "tls client" : "tls server");
                checker.init(false);
                for (int i = checkedLength; i >= 0; --i) {
                    X509Certificate cert = chain[i];
                    checker.check(cert, Collections.emptySet());
                }
            }
        }
        catch (CertPathValidatorException cpve) {
            throw new CertificateException("Certificates do not conform to algorithm constraints", cpve);
        }
    }
}

