/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.PackageReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class ImportDeclaration
extends AstNode {
    public static final TokenRole IMPORT_KEYWORD_RULE = new TokenRole("import", 1);
    public static final ImportDeclaration NULL = new NullImportDeclaration();

    public ImportDeclaration() {
    }

    public ImportDeclaration(String packageOrTypeName) {
        this.setImport(packageOrTypeName);
    }

    public ImportDeclaration(PackageReference pkg) {
        this.setImport(VerifyArgument.notNull(pkg, "pkg").getFullName() + ".*");
        this.putUserData(Keys.PACKAGE_REFERENCE, pkg);
    }

    public ImportDeclaration(TypeReference type) {
        this.setImport(VerifyArgument.notNull(type, "pkg").getFullName() + ".*");
        this.putUserData(Keys.TYPE_REFERENCE, type);
    }

    public ImportDeclaration(AstType type) {
        TypeReference typeReference = VerifyArgument.notNull(type, "type").toTypeReference();
        if (typeReference != null) {
            this.setImport(typeReference.getFullName());
            this.putUserData(Keys.TYPE_REFERENCE, typeReference);
        } else {
            this.setImport(type.toString());
        }
    }

    public final String getImport() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setImport(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final Identifier getImportIdentifier() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setImportIdentifier(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final JavaTokenNode getImportToken() {
        return this.getChildByRole(IMPORT_KEYWORD_RULE);
    }

    public final JavaTokenNode getSemicolonToken() {
        return this.getChildByRole(Roles.SEMICOLON);
    }

    public Role<? extends ImportDeclaration> getRole() {
        return super.getRole();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitImportDeclaration(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof ImportDeclaration && this.getImportIdentifier().matches(((ImportDeclaration)other).getImportIdentifier(), match);
    }

    private static final class NullImportDeclaration
    extends ImportDeclaration {
        private NullImportDeclaration() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

