"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateDescribeAccountLimits = void 0;
const CloudFormationClient_1 = require("../CloudFormationClient");
const DescribeAccountLimitsCommand_1 = require("../commands/DescribeAccountLimitsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new DescribeAccountLimitsCommand_1.DescribeAccountLimitsCommand(input), ...args);
};
async function* paginateDescribeAccountLimits(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        if (config.client instanceof CloudFormationClient_1.CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateDescribeAccountLimits = paginateDescribeAccountLimits;
