/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrCallableMethod;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMappingKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.TypeMappingUtil;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyClass;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyFunctionBase;
import org.jetbrains.kotlin.ir.declarations.lazy.IrMaybeDeserializedClass;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.descriptors.IrBasedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.BuiltinSpecialProperties;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.SpecialGenericSignatures;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.TypeMappingModeExtensionsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001]B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0017J\u0018\u0010)\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\nJ\u000e\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0017J\u0010\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00172\b\b\u0002\u00100\u001a\u00020\nJ\u001a\u00101\u001a\u0004\u0018\u00010+2\u0006\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\nH\u0002J$\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\b\b\u0002\u00109\u001a\u00020\nJ,\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020;2\b\u00107\u001a\u0004\u0018\u0001082\b\b\u0002\u00109\u001a\u00020\nH\u0002J,\u0010<\u001a\u00020=2\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020\n2\b\b\u0002\u00109\u001a\u00020\nH\u0002J\u000e\u0010?\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0017J\u000e\u0010@\u001a\u00020=2\u0006\u0010\u0014\u001a\u00020\u0017J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\u0017J\u000e\u0010F\u001a\u00020G2\u0006\u0010!\u001a\u00020\u0017J\u000e\u0010H\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0017J2\u0010I\u001a\u00020J2\u0006\u00107\u001a\u0002082\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020;2\u0006\u0010\u0014\u001a\u00020\u00172\b\b\u0002\u00109\u001a\u00020\nH\u0002J*\u0010N\u001a\u00020J2\u0006\u00107\u001a\u0002082\u0006\u0010M\u001a\u00020;2\u0006\u00106\u001a\u00020\u000e2\b\b\u0002\u00109\u001a\u00020\nH\u0002J\f\u0010O\u001a\u00020\u001b*\u00020\u0017H\u0002J\u000e\u0010P\u001a\u0004\u0018\u00010\u001b*\u00020\u000bH\u0002J\u000e\u0010Q\u001a\u0004\u0018\u00010\u001b*\u00020\u000bH\u0002J\u000e\u0010R\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002J\u0013\u0010S\u001a\u0004\u0018\u00010\n*\u00020TH\u0002\u00a2\u0006\u0002\u0010UJ\f\u0010V\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010W\u001a\u00020\n*\u00020;H\u0002J\f\u0010X\u001a\u00020\n*\u00020\u000bH\u0002J\u0013\u0010Y\u001a\u0004\u0018\u00010\n*\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010ZJ\f\u0010[\u001a\u00020\\*\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\fR\u0018\u0010\r\u001a\u00020\n*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006^"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;)V", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "isBuiltIn", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isMethodWithDeclarationSiteWildcards", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "originalForDefaultAdapter", "getOriginalForDefaultAdapter", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "findSuperDeclaration", "function", "isSuperCall", "forceBoxedReturnType", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "forceBoxedReturnTypeOnDefaultImplFun", "forceFoxedReturnTypeOnOverride", "getJvmMethodNameIfSpecial", "", "irFunction", "getJvmModuleNameForDeserialized", "Lorg/jetbrains/kotlin/ir/declarations/lazy/IrLazyFunctionBase;", "getMethodKindTag", "", "irFun", "getModuleName", "hasVoidReturnType", "isBoxMethodForInlineClass", "mangleMemberNameIfRequired", "name", "mapAsmMethod", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "mapCalleeToAsmMethod", "mapFakeOverrideSignatureSkipGeneric", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "mapFieldSignature", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "mapFunctionName", "skipSpecial", "mapOverriddenSpecialBuiltinIfNeeded", "callee", "superCall", "mapReturnType", "Lorg/jetbrains/org/objectweb/asm/Type;", "declaration", "sw", "Lorg/jetbrains/kotlin/codegen/signature/JvmSignatureWriter;", "materialized", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "mapSignature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodGenericSignature;", "skipGenericSignature", "mapSignatureSkipGeneric", "mapSignatureWithGeneric", "mapToCallableMethod", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrCallableMethod;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "caller", "mapToMethodHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "shouldBoxSingleValueParameterForSpecialCaseOfRemove", "writeParameter", "", "kind", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodParameterKind;", "type", "writeParameterType", "computeJvmSignature", "getBuiltinSpecialPropertyGetterName", "getDifferentNameForJvmBuiltinFunction", "getInternalFunctionForManglingIfNeeded", "getSuppressWildcardsAnnotationValue", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "(Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;)Ljava/lang/Boolean;", "isInvisibleInMultifilePart", "isJavaLangRecord", "isPublishedApi", "suppressWildcardsMode", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Ljava/lang/Boolean;", "toIrBasedDescriptorWithOriginalOverrides", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "IrBasedSimpleFunctionDescriptorWithOriginalOverrides", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nMethodSignatureMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodSignatureMapper.kt\norg/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SignatureBuildingComponents.kt\norg/jetbrains/kotlin/load/kotlin/SignatureBuildingComponentsKt\n*L\n1#1,550:1\n1747#2,3:551\n1747#2,3:555\n1747#2,3:558\n1747#2,3:561\n766#2:564\n857#2,2:565\n1603#2,9:567\n1855#2:576\n1856#2:578\n1612#2:579\n1603#2,9:580\n1855#2:589\n1856#2:591\n1612#2:592\n1#3:554\n1#3:577\n1#3:590\n13#4:593\n*S KotlinDebug\n*F\n+ 1 MethodSignatureMapper.kt\norg/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper\n*L\n82#1:551,3\n205#1:555,3\n332#1:558,3\n372#1:561,3\n470#1:564\n470#1:565,2\n471#1:567,9\n471#1:576\n471#1:578\n471#1:579\n483#1:580,9\n483#1:589\n483#1:591\n483#1:592\n471#1:577\n483#1:590\n490#1:593\n*E\n"})
public final class MethodSignatureMapper {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final IrTypeSystemContext typeSystem;

    public MethodSignatureMapper(@NotNull JvmBackendContext context, @NotNull IrTypeMapper typeMapper2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(typeMapper2, "typeMapper");
        this.context = context;
        this.typeMapper = typeMapper2;
        this.typeSystem = this.typeMapper.getTypeSystem();
    }

    @NotNull
    public final Method mapAsmMethod(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Method method = this.mapSignatureSkipGeneric(function2).getAsmMethod();
        Intrinsics.checkNotNullExpressionValue(method, "mapSignatureSkipGeneric(function).asmMethod");
        return method;
    }

    @Nullable
    public final String mapFieldSignature(@NotNull IrField field2) {
        Intrinsics.checkNotNullParameter(field2, "field");
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
        Object object = field2.getCorrespondingPropertySymbol();
        boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isVar() : false;
        if (bl) {
            MethodSignatureMapper.writeParameterType$default(this, sw, field2.getType(), field2, false, 8, null);
        } else {
            MethodSignatureMapper.mapReturnType$default(this, field2, field2.getType(), sw, false, 8, null);
        }
        return sw.makeJavaGenericSignature();
    }

    @NotNull
    public final String mapFunctionName(@NotNull IrFunction function2, boolean skipSpecial) {
        block14: {
            IrClass propertyParent;
            String propertyName;
            block16: {
                block15: {
                    boolean bl;
                    block13: {
                        IrProperty property;
                        Intrinsics.checkNotNullParameter(function2, "function");
                        if (!(function2 instanceof IrSimpleFunction)) {
                            String string2 = function2.getName().asString();
                            Intrinsics.checkNotNullExpressionValue(string2, "function.name.asString()");
                            return string2;
                        }
                        if (!skipSpecial) {
                            String platformName;
                            if (!Intrinsics.areEqual(function2.getOrigin(), IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && (platformName = JvmIrUtilsKt.getJvmNameFromAnnotation(function2)) != null) {
                                return platformName;
                            }
                            String nameForSpecialFunction = this.getJvmMethodNameIfSpecial((IrSimpleFunction)function2);
                            if (nameForSpecialFunction != null) {
                                return nameForSpecialFunction;
                            }
                        }
                        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)function2).getCorrespondingPropertySymbol();
                        IrProperty irProperty2 = property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                        if (property == null) break block14;
                        String string3 = property.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string3, "property.name.asString()");
                        propertyName = string3;
                        propertyParent = IrUtilsKt.getParentAsClass(property);
                        if (IrUtilsKt.isAnnotationClass(propertyParent)) break block15;
                        Iterable $this$any$iv = propertyParent.getSuperTypes();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                IrType it = (IrType)element$iv;
                                boolean bl2 = false;
                                if (!this.isJavaLangRecord(it)) continue;
                                bl = true;
                                break block13;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block16;
                }
                return propertyName;
            }
            if ((IrUtilsKt.isEnumClass(propertyParent) || IrUtilsKt.isEnumEntry(propertyParent)) && (Intrinsics.areEqual(propertyName, "name") || Intrinsics.areEqual(propertyName, "ordinal"))) {
                return propertyName;
            }
            if (function2.getName().isSpecial()) {
                String accessorName = AdditionalIrUtilsKt.isGetter(function2) ? JvmAbi.getterName(propertyName) : JvmAbi.setterName(propertyName);
                return this.mangleMemberNameIfRequired(accessorName, (IrSimpleFunction)function2);
            }
        }
        String string4 = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string4, "function.name.asString()");
        return this.mangleMemberNameIfRequired(string4, (IrSimpleFunction)function2);
    }

    public static /* synthetic */ String mapFunctionName$default(MethodSignatureMapper methodSignatureMapper, IrFunction irFunction2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return methodSignatureMapper.mapFunctionName(irFunction2, bl);
    }

    private final boolean isJavaLangRecord(IrType $this$isJavaLangRecord) {
        IrClass irClass2 = IrTypesKt.getClass($this$isJavaLangRecord);
        Intrinsics.checkNotNull(irClass2);
        return AdditionalIrUtilsKt.hasEqualFqName(irClass2, JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME());
    }

    private final String mangleMemberNameIfRequired(String name2, IrSimpleFunction function2) {
        String string2;
        String string3 = JvmCodegenUtil.sanitizeNameIfNeeded(name2, this.context.getState().getLanguageVersionSettings());
        Intrinsics.checkNotNullExpressionValue(string3, "sanitizeNameIfNeeded(nam\u2026.languageVersionSettings)");
        String newName2 = string3;
        if (IrUtilsKt.isTopLevel(function2)) {
            string2 = this.isInvisibleInMultifilePart(function2) ? IrUtilsKt.getParentAsClass(function2).getName().asString() : null;
        } else {
            IrSimpleFunction irSimpleFunction = this.getInternalFunctionForManglingIfNeeded(function2);
            if (irSimpleFunction != null) {
                IrSimpleFunction it = irSimpleFunction;
                boolean bl = false;
                string2 = NameUtils.sanitizeAsJavaIdentifier(this.getModuleName(it));
            } else {
                string2 = null;
            }
        }
        if (string2 == null) {
            return newName2;
        }
        String suffix = string2;
        if (Intrinsics.areEqual(function2.getOrigin(), IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE)) {
            boolean bl = StringsKt.endsWith$default(newName2, "$default", false, 2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string4 = "Default adapter should end with $default: " + RenderIrElementKt.render(function2);
                throw new AssertionError((Object)string4);
            }
            return StringsKt.substringBeforeLast$default(newName2, "$default", null, 2, null) + '$' + suffix + "$default";
        }
        return newName2 + '$' + suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvisibleInMultifilePart(IrSimpleFunction $this$isInvisibleInMultifilePart) {
        if (Intrinsics.areEqual($this$isInvisibleInMultifilePart.getName().asString(), "<clinit>")) return false;
        IrDeclarationParent irDeclarationParent = $this$isInvisibleInMultifilePart.getParent();
        IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (!CollectionsKt.contains((Iterable)this.context.getMultifileFacadeForPart().keySet(), irClass2 != null ? irClass2.getAttributeOwnerId() : null)) return false;
        if (DescriptorVisibilities.isPrivate(JvmIrUtilsKt.suspendFunctionOriginal($this$isInvisibleInMultifilePart).getVisibility())) return true;
        IrSimpleFunction irSimpleFunction = this.getOriginalForDefaultAdapter($this$isInvisibleInMultifilePart);
        if (irSimpleFunction == null) return false;
        if (!this.isInvisibleInMultifilePart(irSimpleFunction)) return false;
        return true;
    }

    private final IrSimpleFunction getInternalFunctionForManglingIfNeeded(IrSimpleFunction $this$getInternalFunctionForManglingIfNeeded) {
        IrSimpleFunction irSimpleFunction;
        if (!(!Intrinsics.areEqual($this$getInternalFunctionForManglingIfNeeded.getVisibility(), DescriptorVisibilities.INTERNAL) || Intrinsics.areEqual($this$getInternalFunctionForManglingIfNeeded.getOrigin(), JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_CONSTRUCTOR.INSTANCE) || Intrinsics.areEqual($this$getInternalFunctionForManglingIfNeeded.getOrigin(), JvmLoweredDeclarationOrigin.STATIC_MULTI_FIELD_VALUE_CLASS_CONSTRUCTOR.INSTANCE) || Intrinsics.areEqual($this$getInternalFunctionForManglingIfNeeded.getOrigin(), JvmLoweredDeclarationOrigin.SYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS.INSTANCE) || Intrinsics.areEqual($this$getInternalFunctionForManglingIfNeeded.getOrigin(), IrDeclarationOrigin.PROPERTY_DELEGATE.INSTANCE) || this.isPublishedApi($this$getInternalFunctionForManglingIfNeeded))) {
            IrFunction irFunction2;
            IrFunction it = irFunction2 = IrUtilsKt.getOriginalFunction($this$getInternalFunctionForManglingIfNeeded);
            boolean bl = false;
            IrFunction irFunction3 = !Intrinsics.areEqual(it, $this$getInternalFunctionForManglingIfNeeded) ? irFunction2 : null;
            IrSimpleFunction irSimpleFunction2 = irFunction3 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction3 : null;
            return irSimpleFunction2 != null && (irFunction3 = this.getInternalFunctionForManglingIfNeeded(irSimpleFunction2)) != null ? irFunction3 : $this$getInternalFunctionForManglingIfNeeded;
        }
        IrSimpleFunction irSimpleFunction3 = this.getOriginalForDefaultAdapter($this$getInternalFunctionForManglingIfNeeded);
        if (irSimpleFunction3 != null && (irSimpleFunction = this.getInternalFunctionForManglingIfNeeded(irSimpleFunction3)) != null) {
            IrSimpleFunction it = irSimpleFunction;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final IrSimpleFunction getOriginalForDefaultAdapter(IrSimpleFunction $this$originalForDefaultAdapter) {
        IrSimpleFunction irSimpleFunction;
        if (Intrinsics.areEqual($this$originalForDefaultAdapter.getOrigin(), IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE)) {
            IrAttributeContainer irAttributeContainer = $this$originalForDefaultAdapter.getAttributeOwnerId();
            Intrinsics.checkNotNull(irAttributeContainer, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
            IrFunction irFunction2 = ((IrFunction)((Object)irAttributeContainer)).getSymbol().getOwner();
            Intrinsics.checkNotNull(irFunction2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            irSimpleFunction = (IrSimpleFunction)irFunction2;
        } else {
            irSimpleFunction = null;
        }
        return irSimpleFunction;
    }

    private final String getModuleName(IrSimpleFunction function2) {
        String string2 = function2 instanceof IrLazyFunctionBase ? this.getJvmModuleNameForDeserialized((IrLazyFunctionBase)((Object)function2)) : null;
        if (string2 == null) {
            string2 = this.context.getState().getModuleName();
        }
        return string2;
    }

    private final boolean isPublishedApi(IrSimpleFunction $this$isPublishedApi) {
        return AdditionalIrUtilsKt.hasAnnotation(JvmIrUtilsKt.getPropertyIfAccessor($this$isPublishedApi).getAnnotations(), StandardNames.FqNames.publishedApi);
    }

    @NotNull
    public final Type mapReturnType(@NotNull IrDeclaration declaration, @Nullable JvmSignatureWriter sw, boolean materialized) {
        Type type2;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!(declaration instanceof IrFunction)) {
            if (!(declaration instanceof IrField)) {
                boolean bl = false;
                String string2 = "Unsupported declaration: " + declaration;
                throw new IllegalArgumentException(string2.toString());
            }
            return this.mapReturnType(declaration, ((IrField)declaration).getType(), sw, materialized);
        }
        if (this.hasVoidReturnType((IrFunction)declaration)) {
            JvmSignatureWriter jvmSignatureWriter = sw;
            if (jvmSignatureWriter != null) {
                jvmSignatureWriter.writeAsmType(Type.VOID_TYPE);
            }
            Type type3 = Type.VOID_TYPE;
            Intrinsics.checkNotNullExpressionValue(type3, "{\n                sw?.wr\u2026e.VOID_TYPE\n            }");
            type2 = type3;
        } else {
            type2 = this.forceBoxedReturnType((IrFunction)declaration) ? this.typeMapper.mapType(((IrFunction)declaration).getReturnType(), TypeMappingMode.RETURN_TYPE_BOXED, sw, materialized) : this.mapReturnType(declaration, ((IrFunction)declaration).getReturnType(), sw, materialized);
        }
        return type2;
    }

    public static /* synthetic */ Type mapReturnType$default(MethodSignatureMapper methodSignatureMapper, IrDeclaration irDeclaration2, JvmSignatureWriter jvmSignatureWriter, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            jvmSignatureWriter = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return methodSignatureMapper.mapReturnType(irDeclaration2, jvmSignatureWriter, bl);
    }

    private final Type mapReturnType(IrDeclaration declaration, IrType returnType2, JvmSignatureWriter sw, boolean materialized) {
        IrDeclarationParent it = declaration.getParent();
        boolean bl = false;
        boolean isAnnotationMethod = it instanceof IrClass && IrUtilsKt.isAnnotationClass((IrClass)it);
        if (sw == null || sw.skipGenericSignature()) {
            return this.typeMapper.mapType(returnType2, TypeMappingMode.Companion.getModeForReturnTypeNoGeneric(isAnnotationMethod), sw, materialized);
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(this.typeSystem, this.suppressWildcardsMode(declaration), returnType2, isAnnotationMethod, false);
        if (typeMappingModeFromAnnotation != null) {
            return this.typeMapper.mapType(returnType2, typeMappingModeFromAnnotation, sw, materialized);
        }
        TypeMappingMode mappingMode = TypeMappingModeExtensionsKt.getOptimalModeForReturnType(this.typeSystem, returnType2, isAnnotationMethod);
        return this.typeMapper.mapType(returnType2, mappingMode, sw, materialized);
    }

    static /* synthetic */ Type mapReturnType$default(MethodSignatureMapper methodSignatureMapper, IrDeclaration irDeclaration2, IrType irType, JvmSignatureWriter jvmSignatureWriter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return methodSignatureMapper.mapReturnType(irDeclaration2, irType, jvmSignatureWriter, bl);
    }

    private final boolean hasVoidReturnType(IrFunction function2) {
        return function2 instanceof IrConstructor || IrTypePredicatesKt.isUnit(function2.getReturnType()) && !AdditionalIrUtilsKt.isGetter(function2);
    }

    private final boolean forceBoxedReturnType(IrFunction function2) {
        return this.isBoxMethodForInlineClass(function2) || this.forceFoxedReturnTypeOnOverride(function2) || this.forceBoxedReturnTypeOnDefaultImplFun(function2) || IrUtilsKt.isFromJava(function2) && JvmIrTypeUtilsKt.isInlineClassType(function2.getReturnType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean forceFoxedReturnTypeOnOverride(IrFunction function2) {
        boolean bl;
        if (!(function2 instanceof IrSimpleFunction)) return false;
        if (!IrTypePredicatesKt.isPrimitiveType$default(function2.getReturnType(), false, 1, null)) return false;
        Iterable $this$any$iv = IrUtilsKt.allOverridden$default((IrOverridableDeclaration)((Object)function2), false, 1, null);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl2 = false;
            if (!IrTypePredicatesKt.isPrimitiveType$default(it.getReturnType(), false, 1, null)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean forceBoxedReturnTypeOnDefaultImplFun(IrFunction function2) {
        if (!(function2 instanceof IrSimpleFunction)) {
            return false;
        }
        IrSimpleFunction irSimpleFunction = this.context.getCachedDeclarations().getOriginalFunctionForDefaultImpl((IrSimpleFunction)function2);
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction originalFun = irSimpleFunction;
        return this.forceFoxedReturnTypeOnOverride(originalFun);
    }

    private final boolean isBoxMethodForInlineClass(IrFunction function2) {
        IrDeclarationParent it = function2.getParent();
        boolean bl = false;
        return it instanceof IrClass && IrDeclarationsKt.isSingleFieldValueClass((IrClass)it) && Intrinsics.areEqual(function2.getOrigin(), JvmLoweredDeclarationOrigin.SYNTHETIC_INLINE_CLASS_MEMBER.INSTANCE) && Intrinsics.areEqual(function2.getName().asString(), "box-impl");
    }

    @NotNull
    public final JvmMethodSignature mapFakeOverrideSignatureSkipGeneric(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return MethodSignatureMapper.mapSignature$default(this, function2, true, false, false, 4, null);
    }

    @NotNull
    public final JvmMethodSignature mapSignatureSkipGeneric(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return MethodSignatureMapper.mapSignature$default(this, function2, true, false, false, 12, null);
    }

    @NotNull
    public final JvmMethodGenericSignature mapSignatureWithGeneric(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return MethodSignatureMapper.mapSignature$default(this, function2, false, false, false, 12, null);
    }

    private final JvmMethodGenericSignature mapSignature(IrFunction function2, boolean skipGenericSignature, boolean skipSpecial, boolean materialized) {
        block8: {
            block9: {
                if (!(function2 instanceof IrLazyFunctionBase) || IrFakeOverrideUtilsKt.isFakeOverride(function2) && !IrUtilsKt.isFromJava(IrUtilsKt.getParentAsClass(function2)) || ((IrLazyFunctionBase)((Object)function2)).getInitialSignatureFunction() == null) break block8;
                IrSimpleFunction irSimpleFunction = function2 instanceof IrSimpleFunction ? (IrSimpleFunction)function2 : null;
                if ((irSimpleFunction != null ? this.getDifferentNameForJvmBuiltinFunction(irSimpleFunction) : null) == null) break block9;
                IrDeclarationParent irDeclarationParent = function2.getParent();
                IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (!Intrinsics.areEqual(irClass2 != null ? irClass2.getOrigin() : null, IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE)) break block8;
            }
            IrFunction irFunction2 = ((IrLazyFunctionBase)((Object)function2)).getInitialSignatureFunction();
            Intrinsics.checkNotNull(irFunction2);
            return MethodSignatureMapper.mapSignature$default(this, irFunction2, skipGenericSignature, false, false, 12, null);
        }
        JvmSignatureWriter sw = skipGenericSignature ? new JvmSignatureWriter() : (JvmSignatureWriter)new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        this.typeMapper.writeFormalTypeParameters(function2.getTypeParameters(), sw);
        sw.writeParametersStart();
        List<IrValueParameter> contextReceivers = function2.getValueParameters().subList(0, function2.getContextReceiverParametersCount());
        for (IrValueParameter contextReceiver2 : contextReceivers) {
            MethodSignatureMapper.writeParameter$default(this, sw, JvmMethodParameterKind.CONTEXT_RECEIVER, contextReceiver2.getType(), function2, false, 16, null);
        }
        IrValueParameter receiverParameter = function2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            MethodSignatureMapper.writeParameter$default(this, sw, JvmMethodParameterKind.RECEIVER, receiverParameter.getType(), function2, false, 16, null);
        }
        List<IrValueParameter> regularValueParameters = function2.getValueParameters().subList(function2.getContextReceiverParametersCount(), function2.getValueParameters().size());
        for (IrValueParameter parameter2 : regularValueParameters) {
            IrDeclarationOrigin irDeclarationOrigin = parameter2.getOrigin();
            JvmMethodParameterKind kind = Intrinsics.areEqual(irDeclarationOrigin, JvmLoweredDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE) ? JvmMethodParameterKind.OUTER : (Intrinsics.areEqual(irDeclarationOrigin, JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE) ? JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL : JvmMethodParameterKind.VALUE);
            IrType type2 = this.shouldBoxSingleValueParameterForSpecialCaseOfRemove(function2) ? IrTypesKt.makeNullable(parameter2.getType()) : parameter2.getType();
            this.writeParameter(sw, kind, type2, function2, materialized);
        }
        sw.writeReturnType();
        this.mapReturnType(function2, sw, materialized);
        sw.writeReturnTypeEnd();
        JvmMethodGenericSignature jvmMethodGenericSignature = sw.makeJvmMethodSignature(this.mapFunctionName(function2, skipSpecial));
        Intrinsics.checkNotNullExpressionValue(jvmMethodGenericSignature, "sw.makeJvmMethodSignatur\u2026e(function, skipSpecial))");
        JvmMethodGenericSignature signature2 = jvmMethodGenericSignature;
        BuiltinMethodsWithSpecialGenericSignature $this$mapSignature_u24lambda_u249 = BuiltinMethodsWithSpecialGenericSignature.INSTANCE;
        boolean bl = false;
        SpecialGenericSignatures.SpecialSignatureInfo specialSignatureInfo = BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(this.toIrBasedDescriptorWithOriginalOverrides(function2));
        if (specialSignatureInfo != null && !this.context.getFunctionsWithSpecialBridges().contains(function2)) {
            String newGenericSignature = CodegenUtilKt.replaceValueParametersIn(specialSignatureInfo, signature2.getGenericsSignature());
            return new JvmMethodGenericSignature(signature2.getAsmMethod(), signature2.getValueParameters(), newGenericSignature);
        }
        if (Intrinsics.areEqual(function2.getOrigin(), JvmLoweredDeclarationOrigin.ABSTRACT_BRIDGE_STUB.INSTANCE)) {
            return new JvmMethodGenericSignature(signature2.getAsmMethod(), signature2.getValueParameters(), null);
        }
        return signature2;
    }

    static /* synthetic */ JvmMethodGenericSignature mapSignature$default(MethodSignatureMapper methodSignatureMapper, IrFunction irFunction2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return methodSignatureMapper.mapSignature(irFunction2, bl, bl2, bl3);
    }

    private final FunctionDescriptor toIrBasedDescriptorWithOriginalOverrides(IrFunction $this$toIrBasedDescriptorWithOriginalOverrides) {
        FunctionDescriptor functionDescriptor;
        IrFunction irFunction2 = $this$toIrBasedDescriptorWithOriginalOverrides;
        if (irFunction2 instanceof IrConstructor) {
            functionDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrConstructor)$this$toIrBasedDescriptorWithOriginalOverrides);
        } else if (irFunction2 instanceof IrSimpleFunction) {
            functionDescriptor = IrDeclarationsKt.isPropertyAccessor($this$toIrBasedDescriptorWithOriginalOverrides) ? IrBasedDescriptorsKt.toIrBasedDescriptor((IrSimpleFunction)$this$toIrBasedDescriptorWithOriginalOverrides) : (IrBasedSimpleFunctionDescriptor)new IrBasedSimpleFunctionDescriptorWithOriginalOverrides((IrSimpleFunction)$this$toIrBasedDescriptorWithOriginalOverrides, this.context);
        } else {
            throw new AssertionError((Object)("Unexpected function kind: " + $this$toIrBasedDescriptorWithOriginalOverrides));
        }
        return functionDescriptor;
    }

    public final boolean shouldBoxSingleValueParameterForSpecialCaseOfRemove(@NotNull IrFunction irFunction2) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            if (!(irFunction2 instanceof IrSimpleFunction)) {
                return false;
            }
            if (!Intrinsics.areEqual(irFunction2.getName().asString(), "remove")) {
                String string2 = irFunction2.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "irFunction.name.asString()");
                if (!StringsKt.startsWith$default(string2, "remove-", false, 2, null)) {
                    return false;
                }
            }
            if (IrUtilsKt.isFromJava(irFunction2)) {
                return false;
            }
            if (irFunction2.getValueParameters().size() != 1) {
                return false;
            }
            IrType valueParameterType = irFunction2.getValueParameters().get(0).getType();
            if (!IrTypePredicatesKt.isInt(InlineClassAbiKt.unboxInlineClass(valueParameterType))) {
                return false;
            }
            Iterable $this$any$iv = IrUtilsKt.allOverridden((IrOverridableDeclaration)((Object)irFunction2), false);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getKotlinFqName(it.getParent()), StandardNames.FqNames.mutableCollection)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void writeParameter(JvmSignatureWriter sw, JvmMethodParameterKind kind, IrType type2, IrFunction function2, boolean materialized) {
        sw.writeParameterType(kind);
        this.writeParameterType(sw, type2, function2, materialized);
        sw.writeParameterTypeEnd();
    }

    static /* synthetic */ void writeParameter$default(MethodSignatureMapper methodSignatureMapper, JvmSignatureWriter jvmSignatureWriter, JvmMethodParameterKind jvmMethodParameterKind, IrType irType, IrFunction irFunction2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        methodSignatureMapper.writeParameter(jvmSignatureWriter, jvmMethodParameterKind, irType, irFunction2, bl);
    }

    private final void writeParameterType(JvmSignatureWriter sw, IrType type2, IrDeclaration declaration, boolean materialized) {
        if (sw.skipGenericSignature()) {
            if (JvmIrTypeUtilsKt.isInlineClassType(type2) && IrUtilsKt.isFromJava(declaration)) {
                this.typeMapper.mapType(type2, TypeMappingMode.GENERIC_ARGUMENT, sw, materialized);
            } else {
                this.typeMapper.mapType(type2, TypeMappingMode.DEFAULT, sw, materialized);
            }
            return;
        }
        IrTypeSystemContext $this$writeParameterType_u24lambda_u2411 = this.typeSystem;
        boolean bl = false;
        TypeMappingMode typeMappingMode = TypeMappingUtil.extractTypeMappingModeFromAnnotation($this$writeParameterType_u24lambda_u2411, this.suppressWildcardsMode(declaration), type2, false, false);
        if (typeMappingMode == null) {
            typeMappingMode = this.isMethodWithDeclarationSiteWildcards(declaration) && !JvmIrUtilsKt.isStaticInlineClassReplacement(declaration) && $this$writeParameterType_u24lambda_u2411.argumentsCount(type2) != 0 ? TypeMappingMode.GENERIC_ARGUMENT : TypeMappingModeExtensionsKt.getOptimalModeForValueParameter(this.typeSystem, type2);
        }
        TypeMappingMode mode = typeMappingMode;
        this.typeMapper.mapType(type2, mode, sw, materialized);
    }

    static /* synthetic */ void writeParameterType$default(MethodSignatureMapper methodSignatureMapper, JvmSignatureWriter jvmSignatureWriter, IrType irType, IrDeclaration irDeclaration2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        methodSignatureMapper.writeParameterType(jvmSignatureWriter, irType, irDeclaration2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMethodWithDeclarationSiteWildcards(IrDeclaration $this$isMethodWithDeclarationSiteWildcards) {
        IrSimpleFunction it;
        if (!($this$isMethodWithDeclarationSiteWildcards instanceof IrSimpleFunction)) return false;
        Iterable $this$any$iv = IrUtilsKt.allOverridden$default((IrOverridableDeclaration)$this$isMethodWithDeclarationSiteWildcards, false, 1, null);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (IrSimpleFunction)element$iv;
            boolean bl = false;
        } while (!TypeMappingUtil.isMethodWithDeclarationSiteWildcardsFqName(IrUtilsKt.getFqNameWhenAvailable(it)));
        return true;
    }

    private final Boolean suppressWildcardsMode(IrDeclaration $this$suppressWildcardsMode) {
        return (Boolean)SequencesKt.firstOrNull(SequencesKt.mapNotNull(LocalDeclarationsLoweringKt.getParentsWithSelf($this$suppressWildcardsMode), (Function1)new Function1<IrDeclarationParent, Boolean>(this){
            final /* synthetic */ MethodSignatureMapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Boolean invoke(@NotNull IrDeclarationParent declaration) {
                IrProperty irProperty2;
                IrPropertySymbol irPropertySymbol;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrDeclarationParent irDeclarationParent = declaration;
                return irDeclarationParent instanceof IrField ? ((irPropertySymbol = ((IrField)declaration).getCorrespondingPropertySymbol()) != null && (irProperty2 = (IrProperty)irPropertySymbol.getOwner()) != null ? MethodSignatureMapper.access$getSuppressWildcardsAnnotationValue(this.this$0, irProperty2) : null) : (irDeclarationParent instanceof IrAnnotationContainer ? MethodSignatureMapper.access$getSuppressWildcardsAnnotationValue(this.this$0, (IrAnnotationContainer)((Object)declaration)) : null);
            }
        }));
    }

    private final Boolean getSuppressWildcardsAnnotationValue(IrAnnotationContainer $this$getSuppressWildcardsAnnotationValue) {
        Boolean bl;
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getSuppressWildcardsAnnotationValue, TypeMappingUtil.getJVM_SUPPRESS_WILDCARDS_ANNOTATION_FQ_NAME());
        if (irConstructorCall != null) {
            IrConstructorCall $this$getSuppressWildcardsAnnotationValue_u24lambda_u2413 = irConstructorCall;
            boolean bl2 = false;
            if ($this$getSuppressWildcardsAnnotationValue_u24lambda_u2413.getValueArgumentsCount() > 0) {
                IrExpression irExpression = $this$getSuppressWildcardsAnnotationValue_u24lambda_u2413.getValueArgument(0);
                IrConst irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
                Object t = irConst != null ? irConst.getValue() : null;
                Boolean bl3 = t instanceof Boolean ? (Boolean)t : null;
                bl = bl3 != null ? bl3 : true;
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return bl;
    }

    @NotNull
    public final IrCallableMethod mapToCallableMethod(@NotNull IrCall expression2, @Nullable IrFunction caller) {
        JvmMethodSignature jvmMethodSignature;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        Object object = expression2.getSuperQualifierSymbol();
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            Object object2 = expression2.getDispatchReceiver();
            if (object2 != null && (object2 = ((IrExpression)object2).getType()) != null && (object2 = IrTypesKt.getClassOrNull((IrType)object2)) != null && (object2 = (IrClass)object2.getOwner()) != null) {
                Object it = object2;
                boolean bl = false;
                object = JvmIrUtilsKt.isJvmInterface((IrClass)it) && IrUtilsKt.isMethodOfAny(callee) ? (IrClass)this.context.getIrBuiltIns().getAnyClass().getOwner() : it;
            } else {
                object = IrUtilsKt.getParentAsClass(callee);
            }
        }
        Object calleeParent = object;
        Type owner = IrTypeMappingKt.mapOwner(this.typeMapper, (IrClass)calleeParent);
        boolean isInterface = JvmIrUtilsKt.isJvmInterface((IrClass)calleeParent);
        boolean isSuperCall = expression2.getSuperQualifierSymbol() != null;
        int invokeOpcode = callee.getDispatchReceiverParameter() == null ? 184 : (isSuperCall ? 183 : (isInterface && !DescriptorVisibilities.isPrivate(callee.getVisibility()) ? 185 : (DescriptorVisibilities.isPrivate(callee.getVisibility()) ? 183 : 182)));
        IrSimpleFunction declaration = this.findSuperDeclaration(callee, isSuperCall);
        if (caller != null && JvmIrUtilsKt.isBridge(caller)) {
            jvmMethodSignature = this.mapSignatureSkipGeneric(declaration);
        } else {
            jvmMethodSignature = this.mapOverriddenSpecialBuiltinIfNeeded(declaration, isSuperCall);
            if (jvmMethodSignature == null) {
                jvmMethodSignature = this.mapSignatureSkipGeneric(declaration);
            }
        }
        JvmMethodSignature signature2 = jvmMethodSignature;
        return new IrCallableMethod(owner, invokeOpcode, signature2, isInterface, declaration.getReturnType());
    }

    private final JvmMethodSignature mapOverriddenSpecialBuiltinIfNeeded(IrFunction callee, boolean superCall) {
        IrSimpleFunction overriddenSpecialBuiltinFunction;
        if (JvmIrUtilsKt.isStaticValueClassReplacement(callee)) {
            return null;
        }
        IrBasedSimpleFunctionDescriptor irBasedSimpleFunctionDescriptor = (IrBasedSimpleFunctionDescriptor)SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor((CallableMemberDescriptor)IrBasedDescriptorsKt.toIrBasedDescriptor(callee));
        IrSimpleFunction irSimpleFunction = overriddenSpecialBuiltinFunction = irBasedSimpleFunctionDescriptor != null ? (IrSimpleFunction)irBasedSimpleFunctionDescriptor.getOwner() : null;
        if (overriddenSpecialBuiltinFunction != null && !superCall) {
            return this.mapSignatureSkipGeneric(overriddenSpecialBuiltinFunction);
        }
        return null;
    }

    @NotNull
    public final Method mapCalleeToAsmMethod(@NotNull IrSimpleFunction function2, boolean isSuperCall) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return this.mapAsmMethod(this.findSuperDeclaration(function2, isSuperCall));
    }

    public static /* synthetic */ Method mapCalleeToAsmMethod$default(MethodSignatureMapper methodSignatureMapper, IrSimpleFunction irSimpleFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return methodSignatureMapper.mapCalleeToAsmMethod(irSimpleFunction, bl);
    }

    private final IrSimpleFunction findSuperDeclaration(IrSimpleFunction function2, boolean isSuperCall) {
        return JvmIrUtilsKt.findSuperDeclaration(function2, isSuperCall, this.context.getState().getJvmDefaultMode());
    }

    private final String getJvmMethodNameIfSpecial(IrSimpleFunction irFunction2) {
        if (Intrinsics.areEqual(irFunction2.getOrigin(), JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_REPLACEMENT.INSTANCE) || Intrinsics.areEqual(irFunction2.getOrigin(), JvmLoweredDeclarationOrigin.STATIC_MULTI_FIELD_VALUE_CLASS_REPLACEMENT.INSTANCE)) {
            return null;
        }
        String string2 = this.getBuiltinSpecialPropertyGetterName(irFunction2);
        if (string2 == null) {
            string2 = this.getDifferentNameForJvmBuiltinFunction(irFunction2);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBuiltIn(IrSimpleFunction $this$isBuiltIn) {
        if (Intrinsics.areEqual(IrUtilsKt.getPackageFragment($this$isBuiltIn).getFqName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return true;
        IrDeclarationParent irDeclarationParent = $this$isBuiltIn.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        IrClass irClass2 = (IrClass)irDeclarationParent;
        Object object = irClass2;
        if (irClass2 == null) return false;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object);
        object = fqName2;
        if (fqName2 == null) return false;
        FqNameUnsafe fqNameUnsafe = ((FqName)object).toUnsafe();
        object = fqNameUnsafe;
        if (fqNameUnsafe == null) return false;
        Object object2 = object;
        JavaToKotlinClassMap javaToKotlinClassMap = JavaToKotlinClassMap.INSTANCE;
        Object p0 = object2;
        boolean bl = false;
        ClassId classId = javaToKotlinClassMap.mapKotlinToJava((FqNameUnsafe)p0);
        if (classId == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final String getDifferentNameForJvmBuiltinFunction(IrSimpleFunction $this$getDifferentNameForJvmBuiltinFunction) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (!SpecialGenericSignatures.Companion.getORIGINAL_SHORT_NAMES().contains($this$getDifferentNameForJvmBuiltinFunction.getName())) {
            return null;
        }
        if (!this.isBuiltIn($this$getDifferentNameForJvmBuiltinFunction)) {
            return null;
        }
        Iterable $this$filter$iv = IrUtilsKt.allOverridden((IrOverridableDeclaration)$this$getDifferentNameForJvmBuiltinFunction, true);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (!this.isBuiltIn(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            String signature2 = this.computeJvmSignature(it);
            Name name2 = SpecialGenericSignatures.Companion.getSIGNATURE_TO_JVM_REPRESENTATION_NAME().get(signature2);
            if ((name2 != null ? name2.asString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (String)CollectionsKt.firstOrNull((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final String getBuiltinSpecialPropertyGetterName(IrSimpleFunction $this$getBuiltinSpecialPropertyGetterName) {
        void $this$mapNotNullTo$iv$iv;
        Object object = $this$getBuiltinSpecialPropertyGetterName.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null || (object = object.getName()) == null) {
            return null;
        }
        Object propertyName = object;
        if (!BuiltinSpecialProperties.INSTANCE.getSPECIAL_SHORT_NAMES().contains(propertyName)) {
            return null;
        }
        if (!this.isBuiltIn($this$getBuiltinSpecialPropertyGetterName)) {
            return null;
        }
        Iterable $this$mapNotNull$iv = IrUtilsKt.allOverridden((IrOverridableDeclaration)$this$getBuiltinSpecialPropertyGetterName, true);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            IrPropertySymbol irPropertySymbol = it.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(irPropertySymbol);
            IrProperty property = (IrProperty)irPropertySymbol.getOwner();
            Name name2 = BuiltinSpecialProperties.INSTANCE.getPROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP().get(IrUtilsKt.getFqNameWhenAvailable(property));
            if ((name2 != null ? name2.asString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (String)CollectionsKt.firstOrNull((List)destination$iv$iv);
    }

    private final String computeJvmSignature(IrFunction $this$computeJvmSignature) {
        boolean $i$f$signatures = false;
        SignatureBuildingComponents $this$computeJvmSignature_u24lambda_u2418 = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        String classPart = IrTypeMapper.mapType$default(this.typeMapper, IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass($this$computeJvmSignature)), null, null, false, 14, null).getInternalName();
        String string2 = MethodSignatureMapper.mapSignature$default(this, $this$computeJvmSignature, false, true, false, 8, null).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "mapSignature(this@comput\u2026pecial = true).toString()");
        String signature2 = string2;
        Intrinsics.checkNotNullExpressionValue(classPart, "classPart");
        return $this$computeJvmSignature_u24lambda_u2418.signature(classPart, signature2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getJvmModuleNameForDeserialized(IrLazyFunctionBase function2) {
        void var2_3;
        IrDeclarationParent irDeclarationParent = function2.getParent();
        while (var2_3 != null) {
            void var3_5 = var2_3;
            if (var3_5 instanceof IrLazyClass) {
                ProtoBuf.Class clazz = ((IrLazyClass)var2_3).getClassProto();
                if (clazz == null) {
                    return null;
                }
                ProtoBuf.Class classProto = clazz;
                NameResolver nameResolver2 = ((IrLazyClass)var2_3).getNameResolver();
                if (nameResolver2 == null) {
                    return null;
                }
                NameResolver nameResolver3 = nameResolver2;
                GeneratedMessageLite.ExtendableMessage extendableMessage = classProto;
                GeneratedMessageLite.GeneratedExtension<ProtoBuf.Class, Integer> generatedExtension = JvmProtoBuf.classModuleName;
                Intrinsics.checkNotNullExpressionValue(generatedExtension, "classModuleName");
                Integer n = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
                if (n == null) return "main";
                int p0 = ((Number)n).intValue();
                boolean bl = false;
                String string2 = nameResolver3.getString(p0);
                if (string2 == null) return "main";
                String string3 = string2;
                return string3;
            }
            if (var3_5 instanceof IrMaybeDeserializedClass) {
                return ((IrMaybeDeserializedClass)var2_3).getModuleName();
            }
            if (var3_5 instanceof IrExternalPackageFragment) {
                DeserializedContainerSource deserializedContainerSource = ((IrExternalPackageFragment)var2_3).getContainerSource();
                if (deserializedContainerSource == null) {
                    return null;
                }
                DeserializedContainerSource source = deserializedContainerSource;
                if (!(source instanceof JvmPackagePartSource)) return null;
                JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)source;
                if (jvmPackagePartSource == null) return null;
                String string4 = jvmPackagePartSource.getModuleName();
                return string4;
            }
            void var5_6 = var2_3;
            if (!(var5_6 instanceof IrDeclaration)) return null;
            IrDeclaration irDeclaration2 = (IrDeclaration)var5_6;
            IrElement irElement = irDeclaration2;
            if (irDeclaration2 == null) return null;
            if ((irElement = irElement.getParent()) == null) {
                return null;
            }
            IrElement irElement2 = irElement;
        }
        return null;
    }

    @NotNull
    public final Handle mapToMethodHandle(@NotNull IrFunction irFun) {
        IrFunction irFunction2;
        Intrinsics.checkNotNullParameter(irFun, "irFun");
        IrFunction irFunction3 = irFun;
        if (irFunction3 instanceof IrConstructor) {
            irFunction2 = irFun;
        } else if (irFunction3 instanceof IrSimpleFunction) {
            irFunction2 = JvmIrUtilsKt.findSuperDeclaration((IrSimpleFunction)irFun, false, this.context.getState().getJvmDefaultMode());
        } else {
            throw new AssertionError((Object)("Simple function or constructor expected: " + RenderIrElementKt.render(irFun)));
        }
        IrFunction irNonFakeFun = irFunction2;
        IrDeclarationParent irDeclarationParent = irNonFakeFun.getParent();
        IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass2 == null) {
            throw new AssertionError((Object)("Unexpected parent: " + RenderIrElementKt.render(irNonFakeFun.getParent())));
        }
        IrClass irParentClass = irClass2;
        Type owner = IrTypeMappingKt.mapOwner(this.typeMapper, irParentClass);
        Method asmMethod2 = this.mapAsmMethod(irNonFakeFun);
        int handleTag = this.getMethodKindTag(irNonFakeFun);
        return new Handle(handleTag, owner.getInternalName(), asmMethod2.getName(), asmMethod2.getDescriptor(), JvmIrUtilsKt.isJvmInterface(irParentClass));
    }

    private final int getMethodKindTag(IrFunction irFun) {
        return irFun instanceof IrConstructor ? 8 : (irFun.getDispatchReceiverParameter() == null ? 6 : (JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(irFun)) ? 9 : 5));
    }

    public static final /* synthetic */ Boolean access$getSuppressWildcardsAnnotationValue(MethodSignatureMapper $this, IrAnnotationContainer $receiver) {
        return $this.getSuppressWildcardsAnnotationValue($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper$IrBasedSimpleFunctionDescriptorWithOriginalOverrides;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedSimpleFunctionDescriptor;", "owner", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getOverriddenDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "backend.jvm"})
    @SourceDebugExtension(value={"SMAP\nMethodSignatureMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodSignatureMapper.kt\norg/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper$IrBasedSimpleFunctionDescriptorWithOriginalOverrides\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,550:1\n1549#2:551\n1620#2,3:552\n*S KotlinDebug\n*F\n+ 1 MethodSignatureMapper.kt\norg/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper$IrBasedSimpleFunctionDescriptorWithOriginalOverrides\n*L\n318#1:551\n318#1:552,3\n*E\n"})
    private static final class IrBasedSimpleFunctionDescriptorWithOriginalOverrides
    extends IrBasedSimpleFunctionDescriptor {
        @NotNull
        private final JvmBackendContext context;

        public IrBasedSimpleFunctionDescriptorWithOriginalOverrides(@NotNull IrSimpleFunction owner, @NotNull JvmBackendContext context) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(context, "context");
            super(owner);
            this.context = context;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<FunctionDescriptor> getOverriddenDescriptors() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.context.getOverridesWithoutStubs((IrSimpleFunction)this.getOwner());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IrBasedSimpleFunctionDescriptorWithOriginalOverrides((IrSimpleFunction)it.getOwner(), this.context));
            }
            return (List)destination$iv$iv;
        }
    }
}

