/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirGeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.caches.FirLazyValue;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.GeneratedDeclarationValidationKt;
import org.jetbrains.kotlin.fir.extensions.DeclarationGenerationContext;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassDeclaredMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirGeneratedMemberDeclarationsStorage;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003'()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0012\u001a\u0004\u0018\u00010\n2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J%\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\tH\u0002JP\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0!2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\t2'\u0010#\u001a#\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0%0$\u00a2\u0006\u0002\b&H\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cachesFactory", "Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;", "callableStorageByClass", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$CallableStorage;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$StorageContext;", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Member;", "Lorg/jetbrains/kotlin/fir/extensions/MemberGenerationContext;", "classifierStorageByClass", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$ClassifierStorage;", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Nested;", "Lorg/jetbrains/kotlin/fir/extensions/NestedClassGenerationContext;", "getCallableStorage", "classSymbol", "regularDeclaredScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirClassDeclaredMemberScope;", "scopeForGeneratedClass", "", "getCallableStorage$providers", "getClassifierStorage", "regularNestedClassifierScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "getClassifierStorage$providers", "getExtensionsForClass", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "groupExtensionsByName", "", "Lorg/jetbrains/kotlin/name/Name;", "nameExtractor", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "CallableStorage", "ClassifierStorage", "StorageContext", "providers"})
@SourceDebugExtension(value={"SMAP\nFirGeneratedScopes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirGeneratedScopes.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,280:1\n263#1,2:281\n263#1,2:307\n269#2,24:283\n269#2,24:309\n269#2,24:333\n*S KotlinDebug\n*F\n+ 1 FirGeneratedScopes.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage\n*L\n145#1:281,2\n155#1:307,2\n145#1:283,24\n155#1:309,24\n264#1:333,24\n*E\n"})
public final class FirGeneratedMemberDeclarationsStorage
implements FirSessionComponent {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirCachesFactory cachesFactory;
    @NotNull
    private final FirCache<FirClassSymbol<?>, CallableStorage, StorageContext<DeclarationGenerationContext.Member>> callableStorageByClass;
    @NotNull
    private final FirCache<FirClassSymbol<?>, ClassifierStorage, StorageContext<DeclarationGenerationContext.Nested>> classifierStorageByClass;

    public FirGeneratedMemberDeclarationsStorage(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.cachesFactory = FirCachesFactoryKt.getFirCachesFactory(this.session);
        this.callableStorageByClass = this.cachesFactory.createCache(new Function2<FirClassSymbol<?>, StorageContext<DeclarationGenerationContext.Member>, CallableStorage>(this){
            final /* synthetic */ FirGeneratedMemberDeclarationsStorage this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final CallableStorage invoke(@NotNull FirClassSymbol<?> firClassSymbol, @NotNull StorageContext<DeclarationGenerationContext.Member> storageContext) {
                Intrinsics.checkNotNullParameter(firClassSymbol, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(storageContext, "<name for destructuring parameter 1>");
                DeclarationGenerationContext.Member context = storageContext.component1();
                Map<Name, List<FirDeclarationGenerationExtension>> extensionsMap = storageContext.component2();
                return new CallableStorage(FirGeneratedMemberDeclarationsStorage.access$getCachesFactory$p(this.this$0), context, extensionsMap);
            }
        });
        this.classifierStorageByClass = this.cachesFactory.createCache(new Function2<FirClassSymbol<?>, StorageContext<DeclarationGenerationContext.Nested>, ClassifierStorage>(this){
            final /* synthetic */ FirGeneratedMemberDeclarationsStorage this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final ClassifierStorage invoke(@NotNull FirClassSymbol<?> classSymbol, @NotNull StorageContext<DeclarationGenerationContext.Nested> storageContext) {
                Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
                Intrinsics.checkNotNullParameter(storageContext, "<name for destructuring parameter 1>");
                DeclarationGenerationContext.Nested context = storageContext.component1();
                Map<Name, List<FirDeclarationGenerationExtension>> extensionsMap = storageContext.component2();
                return new ClassifierStorage(FirGeneratedMemberDeclarationsStorage.access$getCachesFactory$p(this.this$0), classSymbol, context, extensionsMap);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CallableStorage getCallableStorage$providers(@NotNull FirClassSymbol<?> classSymbol, @Nullable FirClassDeclaredMemberScope regularDeclaredScope, boolean scopeForGeneratedClass) {
        List<FirDeclarationGenerationExtension> extensions$iv;
        Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
        DeclarationGenerationContext.Member generationContext = new DeclarationGenerationContext.Member(classSymbol, regularDeclaredScope);
        FirGeneratedMemberDeclarationsStorage this_$iv = this;
        boolean $i$f$groupExtensionsByName = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv = extensions$iv = this_$iv.getExtensionsForClass(classSymbol);
        boolean $i$f$flatGroupBy = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv$iv = $this$flatGroupBy$iv$iv;
        boolean $i$f$flatGroupBy2 = false;
        Map result$iv$iv$iv = new LinkedHashMap();
        Iterator<FirDeclarationGenerationExtension> iterator2 = $this$flatGroupBy$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            FirDeclarationGenerationExtension element$iv$iv$iv;
            FirDeclarationGenerationExtension it$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirClassSymbol<?> firClassSymbol = classSymbol;
            FirDeclarationGenerationExtension $this$getCallableStorage_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            Collection keys$iv$iv$iv = $this$getCallableStorage_u24lambda_u240.getCallableNamesForClass((FirClassSymbol<?>)it, generationContext);
            FirDeclarationGenerationExtension it$iv$iv = element$iv$iv$iv;
            boolean bl3 = false;
            FirDeclarationGenerationExtension value$iv$iv$iv = it$iv$iv;
            Iterator iterator3 = keys$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object key$iv$iv$iv;
                Object it$iv$iv2 = key$iv$iv$iv = iterator3.next();
                boolean bl4 = false;
                Object transformedKey$iv$iv$iv = it$iv$iv2;
                List list$iv$iv$iv = (List)result$iv$iv$iv.get(transformedKey$iv$iv$iv);
                if (list$iv$iv$iv == null) {
                    list$iv$iv$iv = new ArrayList();
                    result$iv$iv$iv.put(transformedKey$iv$iv$iv, list$iv$iv$iv);
                }
                ((Collection)list$iv$iv$iv).add(value$iv$iv$iv);
            }
        }
        Map extensionsByCallableName = result$iv$iv$iv;
        if (extensionsByCallableName.isEmpty() && !scopeForGeneratedClass) {
            return null;
        }
        return this.callableStorageByClass.getValue(classSymbol, new StorageContext<DeclarationGenerationContext.Member>(generationContext, extensionsByCallableName));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassifierStorage getClassifierStorage$providers(@NotNull FirClassSymbol<?> classSymbol, @Nullable FirNestedClassifierScope regularNestedClassifierScope) {
        List<FirDeclarationGenerationExtension> extensions$iv;
        Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
        DeclarationGenerationContext.Nested generationContext = new DeclarationGenerationContext.Nested(classSymbol, regularNestedClassifierScope);
        FirGeneratedMemberDeclarationsStorage this_$iv = this;
        boolean $i$f$groupExtensionsByName = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv = extensions$iv = this_$iv.getExtensionsForClass(classSymbol);
        boolean $i$f$flatGroupBy = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv$iv = $this$flatGroupBy$iv$iv;
        boolean $i$f$flatGroupBy2 = false;
        Map result$iv$iv$iv = new LinkedHashMap();
        Iterator<FirDeclarationGenerationExtension> iterator2 = $this$flatGroupBy$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            FirDeclarationGenerationExtension element$iv$iv$iv;
            FirDeclarationGenerationExtension it$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirClassSymbol<?> firClassSymbol = classSymbol;
            FirDeclarationGenerationExtension $this$getClassifierStorage_u24lambda_u241 = it$iv;
            boolean bl2 = false;
            Collection keys$iv$iv$iv = $this$getClassifierStorage_u24lambda_u241.getNestedClassifiersNames((FirClassSymbol<?>)it, generationContext);
            FirDeclarationGenerationExtension it$iv$iv = element$iv$iv$iv;
            boolean bl3 = false;
            FirDeclarationGenerationExtension value$iv$iv$iv = it$iv$iv;
            Iterator iterator3 = keys$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object key$iv$iv$iv;
                Object it$iv$iv2 = key$iv$iv$iv = iterator3.next();
                boolean bl4 = false;
                Object transformedKey$iv$iv$iv = it$iv$iv2;
                List list$iv$iv$iv = (List)result$iv$iv$iv.get(transformedKey$iv$iv$iv);
                if (list$iv$iv$iv == null) {
                    list$iv$iv$iv = new ArrayList();
                    result$iv$iv$iv.put(transformedKey$iv$iv$iv, list$iv$iv$iv);
                }
                ((Collection)list$iv$iv$iv).add(value$iv$iv$iv);
            }
        }
        Map extensionsByClassifierName = result$iv$iv$iv;
        if (extensionsByClassifierName.isEmpty()) {
            return null;
        }
        return this.classifierStorageByClass.getValue(classSymbol, new StorageContext<DeclarationGenerationContext.Nested>(generationContext, extensionsByClassifierName));
    }

    private final List<FirDeclarationGenerationExtension> getExtensionsForClass(FirClassSymbol<?> classSymbol) {
        List<FirDeclarationGenerationExtension> list2;
        if (!(this.session == classSymbol.getModuleData().getSession())) {
            boolean bl = false;
            String string2 = "Class " + classSymbol + " is declared in " + classSymbol.getModuleData().getSession() + ", but generated storage for it taken from " + this.session;
            throw new IllegalArgumentException(string2.toString());
        }
        if (classSymbol.getOrigin().getGenerated()) {
            FirDeclarationGenerationExtension firDeclarationGenerationExtension = FirGeneratedDeclarationsUtilsKt.getOwnerGenerator((FirClassLikeDeclaration)classSymbol.getFir());
            Intrinsics.checkNotNull(firDeclarationGenerationExtension);
            list2 = CollectionsKt.listOf(firDeclarationGenerationExtension);
        } else {
            list2 = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.session));
        }
        return list2;
    }

    public static final /* synthetic */ FirCachesFactory access$getCachesFactory$p(FirGeneratedMemberDeclarationsStorage $this) {
        return $this.cachesFactory;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\nH\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\n2\u0006\u0010%\u001a\u00020\tH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020!0\n2\u0006\u0010%\u001a\u00020\tH\u0002R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\n0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001a\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010 \u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001f\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$CallableStorage;", "", "cachesFactory", "Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;", "generationContext", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Member;", "Lorg/jetbrains/kotlin/fir/extensions/MemberGenerationContext;", "extensionsByCallableName", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "(Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Member;Ljava/util/Map;)V", "allCallableNames", "", "getAllCallableNames", "()Ljava/util/Set;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getClassSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "constructorCache", "Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getConstructorCache", "()Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "functionCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "", "getFunctionCache", "()Lorg/jetbrains/kotlin/fir/caches/FirCache;", "propertyCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPropertyCache", "generateConstructors", "generateMemberFunctions", "name", "generateMemberProperties", "providers"})
    @SourceDebugExtension(value={"SMAP\nFirGeneratedScopes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirGeneratedScopes.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$CallableStorage\n+ 2 FirCachesFactory.kt\norg/jetbrains/kotlin/fir/caches/FirCachesFactoryKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n69#2,3:281\n69#2,3:284\n1360#3:287\n1446#3,5:288\n2634#3:293\n1360#3:295\n1446#3,5:296\n2634#3:301\n1360#3:303\n1446#3,5:304\n2634#3:309\n1#4:294\n1#4:302\n1#4:310\n*S KotlinDebug\n*F\n+ 1 FirGeneratedScopes.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$CallableStorage\n*L\n181#1:281,3\n184#1:284,3\n198#1:287\n198#1:288,5\n199#1:293\n205#1:295\n205#1:296,5\n206#1:301\n211#1:303\n211#1:304,5\n212#1:309\n199#1:294\n206#1:302\n212#1:310\n*E\n"})
    public static final class CallableStorage {
        @NotNull
        private final DeclarationGenerationContext.Member generationContext;
        @NotNull
        private final Map<Name, List<FirDeclarationGenerationExtension>> extensionsByCallableName;
        @NotNull
        private final FirCache functionCache;
        @NotNull
        private final FirCache propertyCache;
        @NotNull
        private final FirLazyValue<List<FirConstructorSymbol>> constructorCache;

        public CallableStorage(@NotNull FirCachesFactory cachesFactory, @NotNull DeclarationGenerationContext.Member generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByCallableName) {
            Intrinsics.checkNotNullParameter(cachesFactory, "cachesFactory");
            Intrinsics.checkNotNullParameter(generationContext, "generationContext");
            Intrinsics.checkNotNullParameter(extensionsByCallableName, "extensionsByCallableName");
            this.generationContext = generationContext;
            this.extensionsByCallableName = extensionsByCallableName;
            FirCachesFactory $this$createCache$iv = cachesFactory;
            boolean $i$f$createCache = false;
            this.functionCache = $this$createCache$iv.createCache(new Function2(this){
                final /* synthetic */ CallableStorage this$0;
                {
                    this.this$0 = callableStorage;
                    super(2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Name name2 = (Name)key;
                    boolean bl = false;
                    return CallableStorage.access$generateMemberFunctions(this.this$0, name2);
                }
            });
            $this$createCache$iv = cachesFactory;
            $i$f$createCache = false;
            this.propertyCache = $this$createCache$iv.createCache(new Function2(this){
                final /* synthetic */ CallableStorage this$0;
                {
                    this.this$0 = callableStorage;
                    super(2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Name name2 = (Name)key;
                    boolean bl = false;
                    return CallableStorage.access$generateMemberProperties(this.this$0, name2);
                }
            });
            this.constructorCache = cachesFactory.createLazyValue((Function0)new Function0<List<? extends FirConstructorSymbol>>(this){
                final /* synthetic */ CallableStorage this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<FirConstructorSymbol> invoke() {
                    return CallableStorage.access$generateConstructors(this.this$0);
                }
            });
        }

        @NotNull
        public final FirCache getFunctionCache() {
            return this.functionCache;
        }

        @NotNull
        public final FirCache getPropertyCache() {
            return this.propertyCache;
        }

        @NotNull
        public final FirLazyValue<List<FirConstructorSymbol>> getConstructorCache() {
            return this.constructorCache;
        }

        @NotNull
        public final Set<Name> getAllCallableNames() {
            return this.extensionsByCallableName.keySet();
        }

        private final FirClassSymbol<?> getClassSymbol() {
            return this.generationContext.getOwner();
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirNamedFunctionSymbol> generateMemberFunctions(Name name2) {
            Object it;
            void $this$flatMapTo$iv$iv;
            if (Intrinsics.areEqual(name2, SpecialNames.INIT)) {
                return CollectionsKt.emptyList();
            }
            List<FirDeclarationGenerationExtension> list2 = this.extensionsByCallableName.get(name2);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((FirDeclarationGenerationExtension)it).generateFunctions(new CallableId(this.getClassSymbol().getClassId(), name2), this.generationContext);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                it = (FirNamedFunctionSymbol)element$iv;
                boolean bl2 = false;
                GeneratedDeclarationValidationKt.validate((FirElement)((FirBasedSymbol)it).getFir());
            }
            return (List)iterable;
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirPropertySymbol> generateMemberProperties(Name name2) {
            Object it;
            void $this$flatMapTo$iv$iv;
            if (Intrinsics.areEqual(name2, SpecialNames.INIT)) {
                return CollectionsKt.emptyList();
            }
            List<FirDeclarationGenerationExtension> list2 = this.extensionsByCallableName.get(name2);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((FirDeclarationGenerationExtension)it).generateProperties(new CallableId(this.getClassSymbol().getClassId(), name2), this.generationContext);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                it = (FirPropertySymbol)element$iv;
                boolean bl2 = false;
                GeneratedDeclarationValidationKt.validate((FirElement)((FirBasedSymbol)it).getFir());
            }
            return (List)iterable;
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirConstructorSymbol> generateConstructors() {
            Object it;
            void $this$flatMapTo$iv$iv;
            List<FirDeclarationGenerationExtension> list2 = this.extensionsByCallableName.get(SpecialNames.INIT);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((FirDeclarationGenerationExtension)it).generateConstructors(this.generationContext);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                it = (FirConstructorSymbol)element$iv;
                boolean bl2 = false;
                GeneratedDeclarationValidationKt.validate((FirElement)((FirBasedSymbol)it).getFir());
            }
            return (List)iterable;
        }

        public static final /* synthetic */ List access$generateMemberFunctions(CallableStorage $this, Name name2) {
            return $this.generateMemberFunctions(name2);
        }

        public static final /* synthetic */ List access$generateMemberProperties(CallableStorage $this, Name name2) {
            return $this.generateMemberProperties(name2);
        }

        public static final /* synthetic */ List access$generateConstructors(CallableStorage $this) {
            return $this.generateConstructors();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u000bH\u0002R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$ClassifierStorage;", "", "cachesFactory", "Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "generationContext", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Nested;", "Lorg/jetbrains/kotlin/fir/extensions/NestedClassGenerationContext;", "extensionsByClassifierName", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "(Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Nested;Ljava/util/Map;)V", "allClassifierNames", "", "getAllClassifierNames", "()Ljava/util/Set;", "classifiersCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "", "getClassifiersCache", "()Lorg/jetbrains/kotlin/fir/caches/FirCache;", "generateNestedClassifier", "name", "providers"})
    @SourceDebugExtension(value={"SMAP\nFirGeneratedScopes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirGeneratedScopes.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$ClassifierStorage\n+ 2 FirCachesFactory.kt\norg/jetbrains/kotlin/fir/caches/FirCachesFactoryKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n69#2,3:281\n1603#3,9:284\n1855#3:293\n1856#3:295\n1612#3:296\n1#4:294\n1#4:297\n*S KotlinDebug\n*F\n+ 1 FirGeneratedScopes.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$ClassifierStorage\n*L\n223#1:281,3\n238#1:284,9\n238#1:293\n238#1:295\n238#1:296\n238#1:294\n*E\n"})
    public static final class ClassifierStorage {
        @NotNull
        private final FirClassSymbol<?> classSymbol;
        @NotNull
        private final DeclarationGenerationContext.Nested generationContext;
        @NotNull
        private final Map<Name, List<FirDeclarationGenerationExtension>> extensionsByClassifierName;
        @NotNull
        private final FirCache classifiersCache;

        public ClassifierStorage(@NotNull FirCachesFactory cachesFactory, @NotNull FirClassSymbol<?> classSymbol, @NotNull DeclarationGenerationContext.Nested generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByClassifierName) {
            Intrinsics.checkNotNullParameter(cachesFactory, "cachesFactory");
            Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
            Intrinsics.checkNotNullParameter(generationContext, "generationContext");
            Intrinsics.checkNotNullParameter(extensionsByClassifierName, "extensionsByClassifierName");
            this.classSymbol = classSymbol;
            this.generationContext = generationContext;
            this.extensionsByClassifierName = extensionsByClassifierName;
            FirCachesFactory $this$createCache$iv = cachesFactory;
            boolean $i$f$createCache = false;
            this.classifiersCache = $this$createCache$iv.createCache(new Function2(this){
                final /* synthetic */ ClassifierStorage this$0;
                {
                    this.this$0 = classifierStorage;
                    super(2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Name name2 = (Name)key;
                    boolean bl = false;
                    return ClassifierStorage.access$generateNestedClassifier(this.this$0, name2);
                }
            });
        }

        @NotNull
        public final FirCache getClassifiersCache() {
            return this.classifiersCache;
        }

        @NotNull
        public final Set<Name> getAllClassifierNames() {
            return this.extensionsByClassifierName.keySet();
        }

        /*
         * WARNING - void declaration
         */
        private final FirRegularClassSymbol generateNestedClassifier(Name name2) {
            void $this$mapNotNullTo$iv$iv;
            FirRegularClassSymbol companion;
            if (this.classSymbol instanceof FirRegularClassSymbol && (companion = ((FirRegularClassSymbol)this.classSymbol).getCompanionObjectSymbol()) != null && companion.getOrigin().getGenerated() && Intrinsics.areEqual(companion.getClassId().getShortClassName(), name2)) {
                return companion;
            }
            List<FirDeclarationGenerationExtension> list2 = this.extensionsByClassifierName.get(name2);
            if (list2 == null) {
                return null;
            }
            List<FirDeclarationGenerationExtension> extensions = list2;
            Iterable $this$mapNotNull$iv = extensions;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirClassLikeSymbol<?> firClassLikeSymbol;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirDeclarationGenerationExtension extension = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl2 = false;
                if (extension.generateNestedClassLikeDeclaration(this.classSymbol, name2, this.generationContext) != null) {
                    FirClassLikeSymbol<?> firClassLikeSymbol2;
                    FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol2;
                    boolean bl3 = false;
                    FirGeneratedDeclarationsUtilsKt.setOwnerGenerator((FirClassLikeDeclaration)symbol2.getFir(), extension);
                    firClassLikeSymbol = firClassLikeSymbol2;
                } else {
                    firClassLikeSymbol = null;
                }
                if (firClassLikeSymbol == null) continue;
                FirClassLikeSymbol<?> it$iv$iv = firClassLikeSymbol;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List generatedClasses = (List)destination$iv$iv;
            switch (generatedClasses.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException(StringsKt.trimIndent("\n                     Multiple plugins generated nested class with same name " + name2 + " for class " + this.classSymbol.getClassId() + ":\n                    " + CollectionsKt.joinToString$default(generatedClasses, "\n", null, null, 0, null, generateNestedClassifier.generatedClass.1.INSTANCE, 30, null) + "\n                ").toString());
                }
            }
            FirClassLikeSymbol generatedClass2 = (FirClassLikeSymbol)CollectionsKt.first(generatedClasses);
            if (!(generatedClass2 instanceof FirRegularClassSymbol)) {
                boolean bl = false;
                String string2 = "Only regular class are allowed as nested classes";
                throw new IllegalArgumentException(string2.toString());
            }
            return (FirRegularClassSymbol)generatedClass2;
        }

        public static final /* synthetic */ FirRegularClassSymbol access$generateNestedClassifier(ClassifierStorage $this, Name name2) {
            return $this.generateNestedClassifier(name2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005H\u00c6\u0003J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$StorageContext;", "C", "", "generationContext", "extensionsByName", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "(Ljava/lang/Object;Ljava/util/Map;)V", "getExtensionsByName", "()Ljava/util/Map;", "getGenerationContext", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/util/Map;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$StorageContext;", "equals", "", "other", "hashCode", "", "toString", "", "providers"})
    private static final class StorageContext<C> {
        private final C generationContext;
        @NotNull
        private final Map<Name, List<FirDeclarationGenerationExtension>> extensionsByName;

        public StorageContext(C generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByName) {
            Intrinsics.checkNotNullParameter(extensionsByName, "extensionsByName");
            this.generationContext = generationContext;
            this.extensionsByName = extensionsByName;
        }

        public final C getGenerationContext() {
            return this.generationContext;
        }

        @NotNull
        public final Map<Name, List<FirDeclarationGenerationExtension>> getExtensionsByName() {
            return this.extensionsByName;
        }

        public final C component1() {
            return this.generationContext;
        }

        @NotNull
        public final Map<Name, List<FirDeclarationGenerationExtension>> component2() {
            return this.extensionsByName;
        }

        @NotNull
        public final StorageContext<C> copy(C generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByName) {
            Intrinsics.checkNotNullParameter(extensionsByName, "extensionsByName");
            return new StorageContext<C>(generationContext, extensionsByName);
        }

        public static /* synthetic */ StorageContext copy$default(StorageContext storageContext, Object object, Map map, int n, Object object2) {
            if ((n & 1) != 0) {
                object = storageContext.generationContext;
            }
            if ((n & 2) != 0) {
                map = storageContext.extensionsByName;
            }
            return storageContext.copy(object, map);
        }

        @NotNull
        public String toString() {
            return "StorageContext(generationContext=" + this.generationContext + ", extensionsByName=" + this.extensionsByName + ')';
        }

        public int hashCode() {
            int result2 = this.generationContext == null ? 0 : this.generationContext.hashCode();
            result2 = result2 * 31 + ((Object)this.extensionsByName).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StorageContext)) {
                return false;
            }
            StorageContext storageContext = (StorageContext)other;
            if (!Intrinsics.areEqual(this.generationContext, storageContext.generationContext)) {
                return false;
            }
            return Intrinsics.areEqual(this.extensionsByName, storageContext.extensionsByName);
        }
    }
}

