/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context.active;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.CollectionUtils;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.util.concurrent.ConcurrentMapLong;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.active.AsynchronousSearchActiveContext;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchStateMachine;
import org.opensearch.search.asynchronous.settings.LegacyOpendistroAsynchronousSearchSettings;

public class AsynchronousSearchActiveStore {
    private static Logger logger = LogManager.getLogger(AsynchronousSearchActiveStore.class);
    private volatile int nodeConcurrentRunningSearches;
    public static final int NODE_CONCURRENT_RUNNING_SEARCHES = 20;
    public static final Setting<Integer> NODE_CONCURRENT_RUNNING_SEARCHES_SETTING = Setting.intSetting((String)"plugins.asynchronous_search.node_concurrent_running_searches", LegacyOpendistroAsynchronousSearchSettings.NODE_CONCURRENT_RUNNING_SEARCHES_SETTING, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final ConcurrentMapLong<AsynchronousSearchActiveContext> activeContexts = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();

    public AsynchronousSearchActiveStore(ClusterService clusterService) {
        Settings settings = clusterService.getSettings();
        this.nodeConcurrentRunningSearches = (Integer)NODE_CONCURRENT_RUNNING_SEARCHES_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(NODE_CONCURRENT_RUNNING_SEARCHES_SETTING, this::setNodeConcurrentRunningSearches);
    }

    private void setNodeConcurrentRunningSearches(int nodeConcurrentRunningSearches) {
        this.nodeConcurrentRunningSearches = nodeConcurrentRunningSearches;
    }

    public synchronized void putContext(AsynchronousSearchContextId asynchronousSearchContextId, AsynchronousSearchActiveContext asynchronousSearchContext, Consumer<AsynchronousSearchContextId> contextRejectionEventConsumer) {
        if (this.activeContexts.size() >= this.nodeConcurrentRunningSearches) {
            contextRejectionEventConsumer.accept(asynchronousSearchContextId);
            throw new OpenSearchRejectedExecutionException("Trying to create too many concurrent searches. Must be less than or equal to: [" + this.nodeConcurrentRunningSearches + "]. This limit can be set by changing the [" + NODE_CONCURRENT_RUNNING_SEARCHES_SETTING.getKey() + "] settings.");
        }
        this.activeContexts.put(asynchronousSearchContextId.getId(), (Object)asynchronousSearchContext);
    }

    public Optional<AsynchronousSearchActiveContext> getContext(AsynchronousSearchContextId contextId) {
        AsynchronousSearchActiveContext context = (AsynchronousSearchActiveContext)this.activeContexts.get(contextId.getId());
        if (context == null) {
            return Optional.empty();
        }
        if (context.getContextId().getContextId().equals(contextId.getContextId())) {
            return Optional.of(context);
        }
        return Optional.empty();
    }

    public Map<Long, AsynchronousSearchActiveContext> getAllContexts() {
        return CollectionUtils.copyMap(this.activeContexts);
    }

    public boolean freeContext(AsynchronousSearchContextId asynchronousSearchContextId) {
        assert (AsynchronousSearchActiveStore.calledFromAsynchronousSearchStateMachine()) : "Method should only ever be invoked by the state machine";
        AsynchronousSearchActiveContext asynchronousSearchContext = (AsynchronousSearchActiveContext)this.activeContexts.get(asynchronousSearchContextId.getId());
        if (asynchronousSearchContext != null) {
            logger.debug("Removing asynchronous search [{}] from active store", (Object)asynchronousSearchContext.getAsynchronousSearchId());
            asynchronousSearchContext.close();
            this.activeContexts.remove(asynchronousSearchContextId.getId());
            return true;
        }
        return false;
    }

    private static boolean calledFromAsynchronousSearchStateMachine() {
        return Stream.of(Thread.currentThread().getStackTrace()).skip(1L).limit(10L).anyMatch(f -> {
            try {
                boolean isTestMethodInvocation = f.getClassName().contains("AsynchronousSearchActiveStoreTests");
                boolean isStateMachineTriggerMethodInvocation = AsynchronousSearchStateMachine.class.isAssignableFrom(Class.forName(f.getClassName())) && f.getMethodName().equals("trigger");
                return isTestMethodInvocation || isStateMachineTriggerMethodInvocation;
            }
            catch (Exception ignored) {
                return false;
            }
        });
    }
}

