/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.spi.indexstatemanagement.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002()B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B!\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u000bH\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "Lorg/opensearch/common/io/stream/Writeable;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "count", "", "backoff", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry$Backoff;", "delay", "Lorg/opensearch/common/unit/TimeValue;", "(JLorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry$Backoff;Lorg/opensearch/common/unit/TimeValue;)V", "getBackoff", "()Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry$Backoff;", "getCount", "()J", "getDelay", "()Lorg/opensearch/common/unit/TimeValue;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Backoff", "Companion", "opensearch-index-management-spi"})
@SourceDebugExtension(value={"SMAP\nActionRetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionRetry.kt\norg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class ActionRetry
implements ToXContentFragment,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long count;
    @NotNull
    private final Backoff backoff;
    @NotNull
    private final TimeValue delay;
    @NotNull
    public static final String RETRY_FIELD = "retry";
    @NotNull
    public static final String COUNT_FIELD = "count";
    @NotNull
    public static final String BACKOFF_FIELD = "backoff";
    @NotNull
    public static final String DELAY_FIELD = "delay";

    public ActionRetry(long count, @NotNull Backoff backoff, @NotNull TimeValue delay) {
        Intrinsics.checkNotNullParameter((Object)((Object)backoff), (String)BACKOFF_FIELD);
        Intrinsics.checkNotNullParameter((Object)delay, (String)DELAY_FIELD);
        this.count = count;
        this.backoff = backoff;
        this.delay = delay;
        if (!(this.count >= 0L)) {
            boolean bl = false;
            String string = "Count for ActionRetry must be a non-negative number";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ActionRetry(long l, Backoff backoff, TimeValue timeValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            backoff = Backoff.EXPONENTIAL;
        }
        if ((n & 4) != 0) {
            TimeValue timeValue2 = TimeValue.timeValueMinutes((long)1L);
            Intrinsics.checkNotNullExpressionValue((Object)timeValue2, (String)"timeValueMinutes(1)");
            timeValue = timeValue2;
        }
        this(l, backoff, timeValue);
    }

    public final long getCount() {
        return this.count;
    }

    @NotNull
    public final Backoff getBackoff() {
        return this.backoff;
    }

    @NotNull
    public final TimeValue getDelay() {
        return this.delay;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject(RETRY_FIELD).field(COUNT_FIELD, this.count).field(BACKOFF_FIELD, (Object)this.backoff).field(DELAY_FIELD, this.delay.getStringRep()).endObject();
        return builder;
    }

    public ActionRetry(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        long l = sin.readLong();
        Enum enum_ = sin.readEnum(Backoff.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"sin.readEnum(Backoff::class.java)");
        Backoff backoff = (Backoff)enum_;
        TimeValue timeValue = sin.readTimeValue();
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"sin.readTimeValue()");
        this(l, backoff, timeValue);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeLong(this.count);
        out.writeEnum((Enum)this.backoff);
        out.writeTimeValue(this.delay);
    }

    public final long component1() {
        return this.count;
    }

    @NotNull
    public final Backoff component2() {
        return this.backoff;
    }

    @NotNull
    public final TimeValue component3() {
        return this.delay;
    }

    @NotNull
    public final ActionRetry copy(long count, @NotNull Backoff backoff, @NotNull TimeValue delay) {
        Intrinsics.checkNotNullParameter((Object)((Object)backoff), (String)BACKOFF_FIELD);
        Intrinsics.checkNotNullParameter((Object)delay, (String)DELAY_FIELD);
        return new ActionRetry(count, backoff, delay);
    }

    public static /* synthetic */ ActionRetry copy$default(ActionRetry actionRetry, long l, Backoff backoff, TimeValue timeValue, int n, Object object) {
        if ((n & 1) != 0) {
            l = actionRetry.count;
        }
        if ((n & 2) != 0) {
            backoff = actionRetry.backoff;
        }
        if ((n & 4) != 0) {
            timeValue = actionRetry.delay;
        }
        return actionRetry.copy(l, backoff, timeValue);
    }

    @NotNull
    public String toString() {
        return "ActionRetry(count=" + this.count + ", backoff=" + this.backoff + ", delay=" + this.delay + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.count);
        result = result * 31 + this.backoff.hashCode();
        result = result * 31 + this.delay.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActionRetry)) {
            return false;
        }
        ActionRetry actionRetry = (ActionRetry)other;
        if (this.count != actionRetry.count) {
            return false;
        }
        if (this.backoff != actionRetry.backoff) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.delay, (Object)actionRetry.delay);
    }

    @JvmStatic
    @NotNull
    public static final ActionRetry parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BG\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ(\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\b\u0010\u001c\u001a\u00020\u0003H\u0016RA\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014j\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006 "}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry$Backoff;", "", "type", "", "getNextRetryTime", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "consumedRetries", "Lorg/opensearch/common/unit/TimeValue;", "timeValue", "", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getGetNextRetryTime", "()Lkotlin/jvm/functions/Function2;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getType", "()Ljava/lang/String;", "shouldBackoff", "Lkotlin/Pair;", "", "actionMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionMetaData;", "actionRetry", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;", "toString", "EXPONENTIAL", "CONSTANT", "LINEAR", "opensearch-index-management-spi"})
    public static final class Backoff
    extends Enum<Backoff> {
        @NotNull
        private final String type;
        @NotNull
        private final Function2<Integer, TimeValue, Long> getNextRetryTime;
        private final Logger logger;
        public static final /* enum */ Backoff EXPONENTIAL = new Backoff("exponential", (Function2<? super Integer, ? super TimeValue, Long>)((Function2)1.INSTANCE));
        public static final /* enum */ Backoff CONSTANT = new Backoff("constant", (Function2<? super Integer, ? super TimeValue, Long>)((Function2)2.INSTANCE));
        public static final /* enum */ Backoff LINEAR = new Backoff("linear", (Function2<? super Integer, ? super TimeValue, Long>)((Function2)3.INSTANCE));
        private static final /* synthetic */ Backoff[] $VALUES;

        private Backoff(String type, Function2<? super Integer, ? super TimeValue, Long> getNextRetryTime) {
            this.type = type;
            this.getNextRetryTime = getNextRetryTime;
            this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Function2<Integer, TimeValue, Long> getGetNextRetryTime() {
            return this.getNextRetryTime;
        }

        @NotNull
        public String toString() {
            return this.type;
        }

        @NotNull
        public final Pair<Boolean, Long> shouldBackoff(@Nullable ActionMetaData actionMetaData, @Nullable ActionRetry actionRetry) {
            if (actionMetaData == null || actionRetry == null) {
                this.logger.debug("There is no actionMetaData and ActionRetry we don't need to backoff");
                return new Pair((Object)false, null);
            }
            if (actionMetaData.getConsumedRetries() > 0 && actionMetaData.getLastRetryTime() != null) {
                long remainingTime = ((Number)this.getNextRetryTime.invoke((Object)actionMetaData.getConsumedRetries(), (Object)actionRetry.getDelay())).longValue() - (Instant.now().toEpochMilli() - actionMetaData.getLastRetryTime());
                return new Pair((Object)(remainingTime > 0L ? 1 : 0), (Object)remainingTime);
            }
            return new Pair((Object)false, null);
        }

        public static Backoff[] values() {
            return (Backoff[])$VALUES.clone();
        }

        public static Backoff valueOf(String value) {
            return Enum.valueOf(Backoff.class, value);
        }

        static {
            $VALUES = backoffArray = new Backoff[]{Backoff.EXPONENTIAL, Backoff.CONSTANT, Backoff.LINEAR};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry$Companion;", "", "()V", "BACKOFF_FIELD", "", "COUNT_FIELD", "DELAY_FIELD", "RETRY_FIELD", "parse", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management-spi"})
    @SourceDebugExtension(value={"SMAP\nActionRetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionRetry.kt\norg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final ActionRetry parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Long count = null;
            Backoff backoff = Backoff.EXPONENTIAL;
            TimeValue timeValue = TimeValue.timeValueMinutes((long)1L);
            Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"timeValueMinutes(1)");
            TimeValue delay = timeValue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                block9: {
                    block8: {
                        String string;
                        String fieldName = xcp.currentName();
                        xcp.nextToken();
                        String string2 = fieldName;
                        if (string2 == null) continue;
                        switch (string2.hashCode()) {
                            case 95467907: {
                                if (string2.equals(ActionRetry.DELAY_FIELD)) break block8;
                                break block9;
                            }
                            case -347198680: {
                                if (string2.equals(ActionRetry.BACKOFF_FIELD)) break;
                                break block9;
                            }
                            case 94851343: {
                                if (string2.equals(ActionRetry.COUNT_FIELD)) {
                                    count = xcp.longValue();
                                }
                                break block9;
                            }
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        Locale locale = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                        String string3 = string.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
                        backoff = Backoff.valueOf(string3);
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)TimeValue.parseTimeValue((String)xcp.text(), (String)ActionRetry.DELAY_FIELD), (String)"parseTimeValue(xcp.text(), DELAY_FIELD)");
                }
            }
            Long l = count;
            if (l == null) {
                boolean bl = false;
                String string = "ActionRetry count is null";
                throw new IllegalArgumentException(string.toString());
            }
            TimeValue timeValue2 = delay;
            Backoff backoff2 = backoff;
            long l2 = ((Number)l).longValue();
            return new ActionRetry(l2, backoff2, timeValue2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

