/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.filter.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.opensearch.indexmanagement.controlcenter.notification.filter.OperationResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskId;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ*\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J0\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u001e\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ReindexRespParser;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ResponseParser;", "Lorg/opensearch/index/reindex/BulkByScrollResponse;", "task", "Lorg/opensearch/tasks/Task;", "request", "Lorg/opensearch/index/reindex/ReindexRequest;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/tasks/Task;Lorg/opensearch/index/reindex/ReindexRequest;Lorg/opensearch/cluster/service/ClusterService;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getRequest", "()Lorg/opensearch/index/reindex/ReindexRequest;", "sourceIndex", "", "getTask", "()Lorg/opensearch/tasks/Task;", "buildNotificationMessage", "response", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isTimeout", "", "buildNotificationTitle", "operationResult", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/OperationResult;", "parseAndSendNotification", "", "ex", "callback", "Ljava/util/function/Consumer;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ActionRespParseResult;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nReindexRespParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReindexRespParser.kt\norg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ReindexRespParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n1549#3:127\n1620#3,3:128\n1549#3:131\n1620#3,3:132\n1549#3:135\n1620#3,3:136\n*S KotlinDebug\n*F\n+ 1 ReindexRespParser.kt\norg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ReindexRespParser\n*L\n88#1:127\n88#1:128,3\n91#1:131\n91#1:132,3\n103#1:135\n103#1:136,3\n*E\n"})
public final class ReindexRespParser
implements ResponseParser<BulkByScrollResponse> {
    @NotNull
    private final Task task;
    @NotNull
    private final ReindexRequest request;
    @NotNull
    private final ClusterService clusterService;
    @Nullable
    private final String sourceIndex;

    public ReindexRespParser(@NotNull Task task, @NotNull ReindexRequest request, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.task = task;
        this.request = request;
        this.clusterService = clusterService;
        this.sourceIndex = this.getIndexName((ActionRequest)this.request, this.clusterService);
    }

    @NotNull
    public final Task getTask() {
        return this.task;
    }

    @NotNull
    public final ReindexRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @Override
    public void parseAndSendNotification(@Nullable BulkByScrollResponse response2, @Nullable Exception ex, @NotNull Consumer<ActionRespParseResult> callback) {
        boolean hasFailures;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, null, ex, false, 4, null), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response2 == null) {
            boolean $i$a$-requireNotNull-ReindexRespParser$parseAndSendNotification$22 = false;
            String $i$a$-requireNotNull-ReindexRespParser$parseAndSendNotification$22 = "Reindex response must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ReindexRespParser$parseAndSendNotification$22.toString());
        }
        Object object = response2.getBulkFailures();
        boolean bl = !(object == null || object.isEmpty()) || !((object = (Collection)response2.getSearchFailures()) == null || object.isEmpty()) ? true : (hasFailures = false);
        if (hasFailures) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, (ActionResponse)response2, null, false, 6, null), this.buildNotificationTitle(OperationResult.FAILED)));
        } else {
            object = response2.getReasonCancelled();
            if (!(object == null || object.length() == 0)) {
                callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, (ActionResponse)response2, null, false, 6, null), this.buildNotificationTitle(OperationResult.CANCELLED)));
            } else {
                callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, (ActionResponse)response2, null, false, 6, null), this.buildNotificationTitle(OperationResult.COMPLETE)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String buildNotificationMessage(@Nullable BulkByScrollResponse response2, @Nullable Exception exception, boolean isTimeout) {
        Object object;
        ScrollableHitSource.SearchFailure it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        List list;
        IndexRequest indexRequest = this.request.getDestination();
        Intrinsics.checkNotNullExpressionValue((Object)indexRequest, (String)"request.destination");
        StringBuilder result2 = new StringBuilder("The reindex operation from " + this.sourceIndex + " to " + this.getIndexName((ActionRequest)indexRequest, this.clusterService) + " ");
        if (exception != null) {
            result2.append("has failed. " + exception.getMessage());
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            return string;
        }
        if (response2 == null) {
            boolean $i$a$-requireNotNull-ReindexRespParser$buildNotificationMessage$22 = false;
            String $i$a$-requireNotNull-ReindexRespParser$buildNotificationMessage$22 = "Reindex response must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ReindexRespParser$buildNotificationMessage$22.toString());
        }
        String reason = response2.getReasonCancelled();
        List failures = new ArrayList();
        Iterable iterable = response2.getBulkFailures();
        if (!(iterable == null || iterable.isEmpty())) {
            List list2 = response2.getBulkFailures();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"response.bulkFailures");
            iterable = list2;
            list = failures;
            $i$f$map = false;
            Collection collection2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BulkItemResponse.Failure failure = (BulkItemResponse.Failure)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCause());
            }
            list.addAll((List)destination$iv$iv);
        }
        if (!(($this$map$iv = (Collection)response2.getSearchFailures()) == null || $this$map$iv.isEmpty())) {
            List list3 = response2.getSearchFailures();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"response.searchFailures");
            $this$map$iv = list3;
            list = failures;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ScrollableHitSource.SearchFailure)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getReason());
            }
            list.addAll((List)destination$iv$iv);
        }
        boolean failed = !((Collection)failures).isEmpty();
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), this.task.getId());
        StringBuilder $this$buildNotificationMessage_u24lambda_u245 = result2;
        boolean bl = false;
        StringBuilder stringBuilder = $this$buildNotificationMessage_u24lambda_u245;
        Object $i$f$mapTo2 = reason;
        if (!($i$f$mapTo2 == null || StringsKt.isBlank((CharSequence)$i$f$mapTo2))) {
            object = "has been cancelled by user's request";
        } else if (failed) {
            Collection<String> collection3;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            $i$f$mapTo2 = failures;
            int n = failures.size();
            StringBuilder stringBuilder2 = stringBuilder;
            boolean $i$f$map2 = false;
            void bl2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                Throwable throwable = (Throwable)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl3 = false;
                collection3.add(it2.getMessage());
            }
            collection3 = (List)destination$iv$iv2;
            stringBuilder = stringBuilder2;
            object = "has failed. \n\n " + n + " error(s) found, including: \n" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)CollectionsKt.distinct((Iterable)collection3), (int)2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "\nTo see full errors, use `GET /_tasks/" + taskId + "`";
        } else {
            object = "has been completed.";
        }
        stringBuilder.append((String)object);
        $this$buildNotificationMessage_u24lambda_u245.append("\n\n");
        $this$buildNotificationMessage_u24lambda_u245.append("*Summary (number of documents)* \n");
        $this$buildNotificationMessage_u24lambda_u245.append("Total: " + response2.getTotal() + ", Created: " + response2.getCreated() + ", Updated: " + response2.getUpdated() + ", Deleted: " + response2.getDeleted() + ", Conflicts: " + response2.getVersionConflicts());
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @Override
    @NotNull
    public String buildNotificationTitle(@NotNull OperationResult operationResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationResult), (String)"operationResult");
        return "Reindex operation on " + this.sourceIndex + " has " + this.getOperationResultTitleDesc(operationResult);
    }

    @Override
    @Nullable
    public String getIndexName(@NotNull ActionRequest req, @NotNull ClusterService clusterService) {
        return ResponseParser.DefaultImpls.getIndexName(this, req, clusterService);
    }

    @Override
    @NotNull
    public String getOperationResultTitleDesc(@NotNull OperationResult result2) {
        return ResponseParser.DefaultImpls.getOperationResultTitleDesc(this, result2);
    }
}

