/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetrics;
import org.opensearch.indexmanagement.rollup.model.metric.Metric;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B9\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u00c6\u0003JG\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\nH\u00d6\u0001J\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\b\u0010)\u001a\u00020\u0007H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u00064"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/ISMRollup;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/common/io/stream/Writeable;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "description", "", "targetIndex", "pageSize", "", "dimensions", "", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "metrics", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetrics;", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/List;Ljava/util/List;)V", "getDescription", "()Ljava/lang/String;", "getDimensions", "()Ljava/util/List;", "getMetrics", "getPageSize", "()I", "getTargetIndex", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toRollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "sourceIndex", "user", "Lorg/opensearch/commons/authuser/User;", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nISMRollup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISMRollup.kt\norg/opensearch/indexmanagement/rollup/model/ISMRollup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1#2:202\n766#3:203\n857#3,2:204\n1855#3,2:206\n1855#3:208\n1855#3,2:209\n1856#3:211\n*S KotlinDebug\n*F\n+ 1 ISMRollup.kt\norg/opensearch/indexmanagement/rollup/model/ISMRollup\n*L\n45#1:203\n45#1:204,2\n114#1:206,2\n118#1:208\n120#1:209,2\n118#1:211\n*E\n"})
public final class ISMRollup
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    @NotNull
    private final String targetIndex;
    private final int pageSize;
    @NotNull
    private final List<Dimension> dimensions;
    @NotNull
    private final List<RollupMetrics> metrics;

    /*
     * WARNING - void declaration
     */
    public ISMRollup(@NotNull String description, @NotNull String targetIndex, int pageSize, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.description = description;
        this.targetIndex = targetIndex;
        this.pageSize = pageSize;
        this.dimensions = dimensions;
        this.metrics = metrics;
        int n = this.pageSize;
        if (!(1 <= n ? n < 10001 : false)) {
            boolean $i$a$-require-ISMRollup$42 = false;
            String $i$a$-require-ISMRollup$42 = "Page size must be between 1 and 10000";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$42.toString());
        }
        if (!(((CharSequence)this.description).length() > 0)) {
            boolean $i$a$-require-ISMRollup$72 = false;
            String $i$a$-require-ISMRollup$72 = "Description cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$72.toString());
        }
        if (!(((CharSequence)this.targetIndex).length() > 0)) {
            boolean $i$a$-require-ISMRollup$82 = false;
            String $i$a$-require-ISMRollup$82 = "Target Index cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$82.toString());
        }
        Iterable $this$filter$iv = this.dimensions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dimension it = (Dimension)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == Dimension.Type.DATE_HISTOGRAM)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!(((List)destination$iv$iv).size() == 1)) {
            boolean $i$a$-require-ISMRollup$92 = false;
            String $i$a$-require-ISMRollup$92 = "Must specify precisely one date histogram dimension";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$92.toString());
        }
        if (!(((Dimension)CollectionsKt.first(this.dimensions)).getType() == Dimension.Type.DATE_HISTOGRAM)) {
            boolean bl = false;
            String string = "The first dimension must be a date histogram";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().field("description", this.description).field("target_index", this.targetIndex).field("page_size", this.pageSize).field("dimensions", (Iterable)this.dimensions).field("metrics", (Iterable)this.metrics);
        builder.endObject();
        return builder;
    }

    @NotNull
    public final Rollup toRollup(@NotNull String sourceIndex, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        String id2 = sourceIndex + this;
        Instant currentTime = Instant.now();
        String string = DigestUtils.sha1Hex((String)id2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sha1Hex(id)");
        Schedule schedule = (Schedule)new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES);
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        return new Rollup(string, -2L, 0L, true, 1L, schedule, currentTime, currentTime, this.description, sourceIndex, this.targetIndex, null, null, this.pageSize, null, false, this.dimensions, this.metrics, user, 4096, null);
    }

    public static /* synthetic */ Rollup toRollup$default(ISMRollup iSMRollup, String string, User user, int n, Object object) {
        if ((n & 2) != 0) {
            user = null;
        }
        return iSMRollup.toRollup(string, user);
    }

    /*
     * WARNING - void declaration
     */
    public ISMRollup(@NotNull StreamInput sin) throws IOException {
        void it;
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        StreamInput streamInput = sin;
        int n = sin.readInt();
        String string3 = string2;
        String string4 = string;
        ISMRollup iSMRollup = this;
        boolean bl = false;
        List dimensionsList = new ArrayList();
        int size = it.readVInt();
        for (int i = 0; i < size; ++i) {
            Dimension dimension;
            boolean bl2 = false;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list = dimensionsList;
            Dimension.Type type2 = type;
            if (type2 == null) {
                List list2 = list;
                boolean bl3 = false;
                List list3 = list2;
                String string5 = "Dimension type cannot be null";
                throw new IllegalArgumentException(string5.toString());
            }
            switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    dimension = new DateHistogram(sin);
                    break;
                }
                case 2: {
                    dimension = new Terms(sin);
                    break;
                }
                case 3: {
                    dimension = new Histogram(sin);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            list.add(dimension);
        }
        List list = CollectionsKt.toList((Iterable)dimensionsList);
        List list4 = sin.readList(RollupMetrics::new);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"sin.readList(::RollupMetrics)");
        iSMRollup(string4, string3, n, list, list4);
    }

    @NotNull
    public String toString() {
        Object it;
        StringBuffer sb = new StringBuffer();
        sb.append(this.targetIndex);
        sb.append(this.pageSize);
        Iterable $this$forEach$iv = this.dimensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Dimension)element$iv;
            boolean bl = false;
            sb.append((Object)((Dimension)it).getType());
            sb.append(((Dimension)it).getSourceField());
        }
        $this$forEach$iv = this.metrics;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (RollupMetrics)element$iv;
            boolean bl = false;
            sb.append(((RollupMetrics)it).getSourceField());
            Iterable $this$forEach$iv2 = ((RollupMetrics)it).getMetrics();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Metric metric = (Metric)element$iv2;
                boolean bl2 = false;
                sb.append((Object)metric.getType());
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.description);
        out.writeString(this.targetIndex);
        out.writeInt(this.pageSize);
        out.writeVInt(this.dimensions.size());
        for (Dimension dimension : this.dimensions) {
            out.writeEnum((Enum)dimension.getType());
            Dimension dimension2 = dimension;
            if (dimension2 instanceof DateHistogram) {
                dimension.writeTo(out);
                continue;
            }
            if (dimension2 instanceof Terms) {
                dimension.writeTo(out);
                continue;
            }
            if (!(dimension2 instanceof Histogram)) continue;
            dimension.writeTo(out);
        }
        out.writeCollection((Collection)this.metrics);
    }

    @NotNull
    public final String component1() {
        return this.description;
    }

    @NotNull
    public final String component2() {
        return this.targetIndex;
    }

    public final int component3() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> component4() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> component5() {
        return this.metrics;
    }

    @NotNull
    public final ISMRollup copy(@NotNull String description, @NotNull String targetIndex, int pageSize, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        return new ISMRollup(description, targetIndex, pageSize, dimensions, metrics);
    }

    public static /* synthetic */ ISMRollup copy$default(ISMRollup iSMRollup, String string, String string2, int n, List list, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = iSMRollup.description;
        }
        if ((n2 & 2) != 0) {
            string2 = iSMRollup.targetIndex;
        }
        if ((n2 & 4) != 0) {
            n = iSMRollup.pageSize;
        }
        if ((n2 & 8) != 0) {
            list = iSMRollup.dimensions;
        }
        if ((n2 & 0x10) != 0) {
            list2 = iSMRollup.metrics;
        }
        return iSMRollup.copy(string, string2, n, list, list2);
    }

    public int hashCode() {
        int result2 = this.description.hashCode();
        result2 = result2 * 31 + this.targetIndex.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.pageSize);
        result2 = result2 * 31 + ((Object)this.dimensions).hashCode();
        result2 = result2 * 31 + ((Object)this.metrics).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ISMRollup)) {
            return false;
        }
        ISMRollup iSMRollup = (ISMRollup)other;
        if (!Intrinsics.areEqual((Object)this.description, (Object)iSMRollup.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndex, (Object)iSMRollup.targetIndex)) {
            return false;
        }
        if (this.pageSize != iSMRollup.pageSize) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dimensions, iSMRollup.dimensions)) {
            return false;
        }
        return Intrinsics.areEqual(this.metrics, iSMRollup.metrics);
    }

    @JvmStatic
    @NotNull
    public static final ISMRollup parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/ISMRollup$Companion;", "", "()V", "parse", "Lorg/opensearch/indexmanagement/rollup/model/ISMRollup;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ISMRollup parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String description = "";
            String targetIndex = "";
            int pageSize = 0;
            List dimensions = new ArrayList();
            List metrics = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block14: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block22: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block22;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -207303516: {
                            if (string.equals("target_index")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals("description")) {
                                n = 2;
                            }
                            break;
                        }
                        case 955826371: {
                            if (string.equals("metrics")) {
                                n = 3;
                            }
                            break;
                        }
                        case 883849137: {
                            if (string.equals("page_size")) {
                                n = 4;
                            }
                            break;
                        }
                        case 414334925: {
                            if (string.equals("dimensions")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                            continue block14;
                        }
                        case 1: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                            continue block14;
                        }
                        case 4: {
                            pageSize = xcp.intValue();
                            continue block14;
                        }
                        case 5: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                dimensions.add(Dimension.Companion.parse(xcp));
                            }
                            continue block14;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                metrics.add(RollupMetrics.Companion.parse(xcp));
                            }
                            continue block14;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field, [" + fieldName + "] not supported in ISM Rollup.");
            }
            return new ISMRollup(description, targetIndex, pageSize, dimensions, metrics);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Dimension.Type.values().length];
            try {
                nArray[Dimension.Type.DATE_HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.TERMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.HISTOGRAM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

