/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.util;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.util.OpenForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/indexmanagement/util/IndexUtils;", "", "()V", "Companion", "opensearch-index-management"})
public final class IndexUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String _META = "_meta";
    @NotNull
    public static final String PROPERTIES = "properties";
    @NotNull
    public static final String FIELDS = "fields";
    @NotNull
    public static final String SCHEMA_VERSION = "schema_version";
    public static final long DEFAULT_SCHEMA_VERSION = 1L;
    @NotNull
    public static final String ODFE_MAGIC_NULL = "#ODFE-MAGIC-NULL-MAGIC-ODFE#";
    public static final int LUCENE_MAX_CLAUSES = 1024;
    private static final int BYTE_ARRAY_SIZE = 16;
    private static final long DOCUMENT_ID_SEED = 72390L;
    private static final Logger logger = LogManager.getLogger(IndexUtils.class);
    private static long indexManagementConfigSchemaVersion = Companion.getSchemaVersion(IndexManagementIndices.Companion.getIndexManagementMappings());
    private static long indexStateManagementHistorySchemaVersion = Companion.getSchemaVersion(IndexManagementIndices.Companion.getIndexStateManagementHistoryMappings());

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0007J$\u0010'\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J$\u0010(\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J>\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0007J(\u0010+\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010,2\u0006\u0010-\u001a\u00020\t2\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030,J!\u0010/\u001a\u00020\t2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\tJ\u001a\u00104\u001a\u0004\u0018\u00010\t2\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!J\u000e\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\tJ\u0018\u00108\u001a\u0002092\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!J\u0018\u0010:\u001a\u0002092\b\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!J\u0018\u0010;\u001a\u0002092\b\u0010<\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!J\u0018\u0010=\u001a\u0002092\b\u0010*\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0002R\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0019\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006@"}, d2={"Lorg/opensearch/indexmanagement/util/IndexUtils$Companion;", "", "()V", "BYTE_ARRAY_SIZE", "", "DEFAULT_SCHEMA_VERSION", "", "DOCUMENT_ID_SEED", "FIELDS", "", "LUCENE_MAX_CLAUSES", "ODFE_MAGIC_NULL", "PROPERTIES", "SCHEMA_VERSION", "_META", "get_META$annotations", "<set-?>", "indexManagementConfigSchemaVersion", "getIndexManagementConfigSchemaVersion", "()J", "indexStateManagementHistorySchemaVersion", "getIndexStateManagementHistorySchemaVersion", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "checkAndUpdateAliasMapping", "", "alias", "schemaVersion", "mapping", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "client", "Lorg/opensearch/client/IndicesAdminClient;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "checkAndUpdateConfigIndexMapping", "checkAndUpdateHistoryIndexMapping", "checkAndUpdateIndexMapping", "index", "getFieldFromMappings", "", "fieldName", "mappings", "getNewestIndexByCreationDate", "concreteIndices", "", "([Ljava/lang/String;Lorg/opensearch/cluster/ClusterState;)Ljava/lang/String;", "getSchemaVersion", "getWriteIndex", "indexName", "hashToFixedSize", "id", "isAlias", "", "isConcreteIndex", "isDataStream", "name", "shouldUpdateIndex", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "newVersion", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexUtils.kt\norg/opensearch/indexmanagement/util/IndexUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1855#2,2:240\n*S KotlinDebug\n*F\n+ 1 IndexUtils.kt\norg/opensearch/indexmanagement/util/IndexUtils$Companion\n*L\n182#1:240,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void get_META$annotations() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public final long getIndexManagementConfigSchemaVersion() {
            return indexManagementConfigSchemaVersion;
        }

        public final long getIndexStateManagementHistorySchemaVersion() {
            return indexStateManagementHistorySchemaVersion;
        }

        public final long getSchemaVersion(@NotNull String mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
            while (!xcp.isClosed()) {
                XContentParser.Token token = xcp.currentToken();
                if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                    if (!Intrinsics.areEqual((Object)xcp.currentName(), (Object)IndexUtils._META)) {
                        xcp.nextToken();
                        xcp.skipChildren();
                    } else {
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (Intrinsics.areEqual((Object)xcp.currentName(), (Object)IndexUtils.SCHEMA_VERSION)) {
                                long version = xcp.longValue();
                                if (!(version > -1L)) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                return version;
                            }
                            xcp.nextToken();
                        }
                    }
                }
                xcp.nextToken();
            }
            return 1L;
        }

        public final boolean shouldUpdateIndex(@Nullable IndexMetadata index2, long newVersion) {
            Map indexMapping;
            long oldVersion = 1L;
            IndexMetadata indexMetadata2 = index2;
            Map map = indexMetadata2 != null && (indexMetadata2 = indexMetadata2.mapping()) != null ? indexMetadata2.sourceAsMap() : (indexMapping = null);
            if (indexMapping != null && indexMapping.containsKey(IndexUtils._META) && indexMapping.get(IndexUtils._META) instanceof HashMap) {
                Object v = indexMapping.get(IndexUtils._META);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
                HashMap metaData = (HashMap)v;
                if (((Map)metaData).containsKey(IndexUtils.SCHEMA_VERSION)) {
                    Object v2 = ((Map)metaData).get(IndexUtils.SCHEMA_VERSION);
                    Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Int");
                    oldVersion = ((Integer)v2).intValue();
                }
            }
            return newVersion > oldVersion;
        }

        public final void checkAndUpdateConfigIndexMapping(@NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            this.checkAndUpdateIndexMapping(".opendistro-ism-config", this.getIndexManagementConfigSchemaVersion(), IndexManagementIndices.Companion.getIndexManagementMappings(), clusterState, client, actionListener);
        }

        public final void checkAndUpdateHistoryIndexMapping(@NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            this.checkAndUpdateAliasMapping(".opendistro-ism-managed-index-history-write", this.getIndexStateManagementHistorySchemaVersion(), IndexManagementIndices.Companion.getIndexStateManagementHistoryMappings(), clusterState, client, actionListener);
        }

        @OpenForTesting
        public final void checkAndUpdateIndexMapping(@NotNull String index2, long schemaVersion, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            if (clusterState.getMetadata().getIndices().containsKey(index2)) {
                if (this.shouldUpdateIndex((IndexMetadata)clusterState.getMetadata().getIndices().get(index2), schemaVersion)) {
                    String[] stringArray = new String[]{index2};
                    PutMappingRequest putMappingRequest = new PutMappingRequest(stringArray).source(mapping, XContentType.JSON);
                    Intrinsics.checkNotNullExpressionValue((Object)putMappingRequest, (String)"PutMappingRequest(index)\u2026pping, XContentType.JSON)");
                    PutMappingRequest putMappingRequest2 = putMappingRequest;
                    client.putMapping(putMappingRequest2, actionListener);
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                }
            } else {
                this.getLogger().error("IndexMetaData does not exist for " + index2);
                actionListener.onResponse((Object)new AcknowledgedResponse(false));
            }
        }

        @OpenForTesting
        public final void checkAndUpdateAliasMapping(@NotNull String alias, long schemaVersion, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            IndexAbstraction result2 = (IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(alias);
            if (result2 == null || result2.getType() != IndexAbstraction.Type.ALIAS) {
                this.getLogger().error("There are no indices for alias " + alias);
                actionListener.onResponse((Object)new AcknowledgedResponse(false));
            } else {
                IndexMetadata writeIndex = result2.getWriteIndex();
                if (writeIndex == null) {
                    this.getLogger().error("Concrete write index does not exist for alias " + alias);
                    actionListener.onResponse((Object)new AcknowledgedResponse(false));
                } else if (this.shouldUpdateIndex(writeIndex, schemaVersion)) {
                    String[] stringArray = new String[]{writeIndex.getIndex().getName()};
                    PutMappingRequest putMappingRequest = new PutMappingRequest(stringArray).source(mapping, XContentType.JSON);
                    Intrinsics.checkNotNullExpressionValue((Object)putMappingRequest, (String)"PutMappingRequest(writeI\u2026pping, XContentType.JSON)");
                    PutMappingRequest putMappingRequest2 = putMappingRequest;
                    client.putMapping(putMappingRequest2, actionListener);
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }
        }

        @Nullable
        public final Map<?, ?> getFieldFromMappings(@NotNull String fieldName, @NotNull Map<?, ?> mappings) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
            Map currMap = null;
            currMap = mappings;
            String[] stringArray = new String[]{"."};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)fieldName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map map;
                String field = (String)element$iv;
                boolean bl = false;
                Map map2 = (Map)currMap.get(IndexUtils.PROPERTIES);
                if (map2 == null) {
                    map2 = map = (Map)currMap.get(IndexUtils.FIELDS);
                }
                if (map2 == null || (map = map.get(field)) == null) {
                    return null;
                }
                Map nextMap = map;
                Intrinsics.checkNotNull((Object)nextMap, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                currMap = nextMap;
            }
            return currMap;
        }

        @NotNull
        public final String hashToFixedSize(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            String string = id2;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] docByteArray = byArray;
            MurmurHash3.Hash128 hash = MurmurHash3.hash128((byte[])docByteArray, (int)0, (int)docByteArray.length, (long)72390L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
            byte[] byteArray = ByteBuffer.allocate(16).putLong(hash.h1).putLong(hash.h2).array();
            String string2 = Base64.getUrlEncoder().withoutPadding().encodeToString(byteArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrlEncoder().withoutP\u2026encodeToString(byteArray)");
            return string2;
        }

        public final boolean isDataStream(@Nullable String name, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            return clusterState.getMetadata().dataStreams().containsKey(name);
        }

        public final boolean isAlias(@Nullable String indexName, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            return clusterState.getMetadata().hasAlias(indexName);
        }

        @Nullable
        public final String getWriteIndex(@Nullable String indexName, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            if (this.isAlias(indexName, clusterState) || this.isDataStream(indexName, clusterState)) {
                Object v = clusterState.getMetadata().getIndicesLookup().get(indexName);
                Intrinsics.checkNotNull(v);
                IndexMetadata writeIndexMetadata = ((IndexAbstraction)v).getWriteIndex();
                if (writeIndexMetadata != null) {
                    return writeIndexMetadata.getIndex().getName();
                }
            }
            return null;
        }

        @NotNull
        public final String getNewestIndexByCreationDate(@NotNull String[] concreteIndices, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)concreteIndices, (String)"concreteIndices");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            SortedMap lookup = clusterState.getMetadata().getIndicesLookup();
            long maxCreationDate = Long.MIN_VALUE;
            String newestIndex = concreteIndices[0];
            for (String indexName : concreteIndices) {
                IndexAbstraction index2 = (IndexAbstraction)lookup.get(indexName);
                IndexMetadata indexMetadata2 = clusterState.getMetadata().index(indexName);
                if (index2 == null || index2.getType() != IndexAbstraction.Type.CONCRETE_INDEX || indexMetadata2.getCreationDate() <= maxCreationDate) continue;
                maxCreationDate = indexMetadata2.getCreationDate();
                newestIndex = indexName;
            }
            return newestIndex;
        }

        public final boolean isConcreteIndex(@Nullable String indexName, @NotNull ClusterState clusterState) {
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            Object v = clusterState.getMetadata().getIndicesLookup().get(indexName);
            Intrinsics.checkNotNull(v);
            return ((IndexAbstraction)v).getType() == IndexAbstraction.Type.CONCRETE_INDEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

