/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.perl.inline.java.InlineJavaArray;
import org.perl.inline.java.InlineJavaCastException;
import org.perl.inline.java.InlineJavaClass;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaHandle;
import org.perl.inline.java.InlineJavaInvocationTargetException;
import org.perl.inline.java.InlineJavaPerlException;
import org.perl.inline.java.InlineJavaPerlNatives;
import org.perl.inline.java.InlineJavaPerlObject;
import org.perl.inline.java.InlineJavaServer;
import org.perl.inline.java.InlineJavaThrown;
import org.perl.inline.java.InlineJavaUtils;

class InlineJavaProtocol {
    private InlineJavaServer ijs;
    private InlineJavaClass ijc;
    private InlineJavaArray ija;
    private String cmd;
    private String response = null;
    private final String encoding = "UTF-8";
    private static Map<String, Member> member_cache = Collections.synchronizedMap(new HashMap());
    private static final String report_version = "V2";

    InlineJavaProtocol(InlineJavaServer _ijs, String _cmd) {
        this.ijs = _ijs;
        this.ijc = new InlineJavaClass(this.ijs, this);
        this.ija = new InlineJavaArray(this.ijc);
        this.cmd = _cmd;
    }

    void Do() throws InlineJavaException {
        StringTokenizer st = new StringTokenizer(this.cmd, " ");
        String c = st.nextToken();
        if (c.equals("call_method")) {
            this.CallJavaMethod(st);
        } else if (c.equals("set_member")) {
            this.SetJavaMember(st);
        } else if (c.equals("get_member")) {
            this.GetJavaMember(st);
        } else if (c.equals("add_classpath")) {
            this.AddClassPath(st);
        } else if (c.equals("server_type")) {
            this.ServerType(st);
        } else if (c.equals("report")) {
            this.Report(st);
        } else if (c.equals("isa")) {
            this.IsA(st);
        } else if (c.equals("create_object")) {
            this.CreateJavaObject(st);
        } else if (c.equals("delete_object")) {
            this.DeleteJavaObject(st);
        } else if (c.equals("obj_cnt")) {
            this.ObjectCount(st);
        } else if (c.equals("cast")) {
            this.Cast(st);
        } else if (c.equals("read")) {
            this.Read(st);
        } else if (c.equals("make_buffered")) {
            this.MakeBuffered(st);
        } else if (c.equals("readline")) {
            this.ReadLine(st);
        } else if (c.equals("write")) {
            this.Write(st);
        } else if (c.equals("close")) {
            this.Close(st);
        } else if (c.equals("die")) {
            InlineJavaUtils.debug(1, "received a request to die...");
            this.ijs.Shutdown();
        } else {
            throw new InlineJavaException("Unknown command " + c);
        }
    }

    void Report(StringTokenizer st) throws InlineJavaException {
        StringBuffer pw = new StringBuffer("V2\n");
        StringTokenizer st2 = new StringTokenizer(st.nextToken(), ":");
        st2.nextToken();
        StringTokenizer st3 = new StringTokenizer(this.Decode(st2.nextToken()), " ");
        ArrayList<String> class_list = new ArrayList<String>();
        while (st3.hasMoreTokens()) {
            String c = st3.nextToken();
            class_list.add(class_list.size(), c);
        }
        for (int i = 0; i < class_list.size(); ++i) {
            String stat;
            Class<Object> decl;
            String sign;
            AccessibleObject x;
            int j;
            String name = (String)class_list.get(i);
            Class c = InlineJavaClass.ValidateClass(name);
            InlineJavaUtils.debug(3, "reporting for " + c);
            Class parent = c.getSuperclass();
            String pname = parent == null ? "null" : parent.getName();
            pw.append("class " + c.getName() + " " + pname + "\n");
            Constructor<?>[] constructors = c.getConstructors();
            Method[] methods = c.getMethods();
            Field[] fields = c.getFields();
            boolean pub = InlineJavaClass.ClassIsPublic(c);
            if (pub && c.getDeclaredConstructors().length == 0) {
                String noarg_sign = InlineJavaUtils.CreateSignature(new Class[0]);
                pw.append("constructor " + noarg_sign + "\n");
            }
            boolean pn = InlineJavaPerlNatives.class.isAssignableFrom(c);
            for (j = 0; j < constructors.length; ++j) {
                x = constructors[j];
                if (pn && Modifier.isNative(((Constructor)x).getModifiers())) continue;
                Class[] params = ((Constructor)x).getParameterTypes();
                sign = InlineJavaUtils.CreateSignature(params);
                decl = ((Constructor)x).getDeclaringClass();
                pw.append("constructor " + sign + "\n");
            }
            for (j = 0; j < methods.length; ++j) {
                x = methods[j];
                if (pn && Modifier.isNative(((Method)x).getModifiers())) continue;
                stat = Modifier.isStatic(((Method)x).getModifiers()) ? " static " : " instance ";
                sign = InlineJavaUtils.CreateSignature(((Method)x).getParameterTypes());
                decl = ((Method)x).getDeclaringClass();
                pw.append("method" + stat + decl.getName() + " " + ((Method)x).getName() + sign + "\n");
            }
            for (j = 0; j < fields.length; ++j) {
                x = fields[InlineJavaUtils.ReverseMembers() ? fields.length - 1 - j : j];
                stat = Modifier.isStatic(((Field)x).getModifiers()) ? " static " : " instance ";
                Class<?> decl2 = ((Field)x).getDeclaringClass();
                Class<?> type = ((Field)x).getType();
                pw.append("field" + stat + decl2.getName() + " " + ((Field)x).getName() + " " + type.getName() + "\n");
            }
        }
        this.SetResponse(pw.toString());
    }

    void AddClassPath(StringTokenizer st) throws InlineJavaException {
        while (st.hasMoreTokens()) {
            String path = this.Decode(st.nextToken());
            InlineJavaServer.GetInstance().GetUserClassLoader().AddClassPath(path);
        }
        this.SetResponse(null);
    }

    void ServerType(StringTokenizer st) throws InlineJavaException {
        this.SetResponse(this.ijs.GetType());
    }

    void IsA(StringTokenizer st) throws InlineJavaException {
        String class_name = st.nextToken();
        Class c = InlineJavaClass.ValidateClass(class_name);
        String is_it_a = st.nextToken();
        Class d = InlineJavaClass.ValidateClass(is_it_a);
        this.SetResponse(InlineJavaClass.DoesExtend(c, d));
    }

    void ObjectCount(StringTokenizer st) throws InlineJavaException {
        this.SetResponse(this.ijs.ObjectCount());
    }

    void CreateJavaObject(StringTokenizer st) throws InlineJavaException {
        String class_name = st.nextToken();
        Class c = InlineJavaClass.ValidateClass(class_name);
        if (!InlineJavaClass.ClassIsArray(c)) {
            ArrayList<Object> f = this.ValidateMethod(true, c, class_name, st);
            Object[] p = (Object[])f.get(1);
            Class[] clist = (Class[])f.get(2);
            try {
                Object o = this.CreateObject(c, p, clist);
                this.SetResponse(o);
            }
            catch (InlineJavaInvocationTargetException ite) {
                Throwable t = ite.GetThrowable();
                if (t instanceof InlineJavaException) {
                    InlineJavaException ije = (InlineJavaException)t;
                    throw ije;
                }
                this.SetResponse(new InlineJavaThrown(t));
            }
        } else {
            StringBuffer sb = new StringBuffer(class_name);
            while (sb.toString().startsWith("[")) {
                sb.replace(0, 1, "");
            }
            if (sb.toString().startsWith("L")) {
                sb.replace(0, 1, "");
                sb.replace(sb.length() - 1, sb.length(), "");
            }
            Class ec = InlineJavaClass.ValidateClass(sb.toString());
            InlineJavaUtils.debug(4, "array elements: " + ec.getName());
            Object o = this.ija.CreateArray(ec, st);
            this.SetResponse(o);
        }
    }

    void CallJavaMethod(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        String class_name = st.nextToken();
        Object o = null;
        if (id > 0) {
            o = this.ijs.GetObject(id);
        }
        Class c = InlineJavaClass.ValidateClass(class_name);
        String method = st.nextToken();
        if (InlineJavaClass.ClassIsArray(c) && method.equals("getLength")) {
            int length = Array.getLength(o);
            this.SetResponse(length);
        } else {
            ArrayList<Object> f = this.ValidateMethod(false, c, method, st);
            Method m = (Method)f.get(0);
            String name = m.getName();
            Object[] p = (Object[])f.get(1);
            try {
                Object ret = InlineJavaServer.GetInstance().GetUserClassLoader().invoke(m, o, p);
                this.SetResponse(ret, this.AutoCast(ret, m.getReturnType()));
            }
            catch (IllegalAccessException e) {
                throw new InlineJavaException("You are not allowed to invoke method " + name + " in class " + class_name + ": " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new InlineJavaException("Arguments for method " + name + " in class " + class_name + " are incompatible: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                String type = t.getClass().getName();
                String msg = t.getMessage();
                InlineJavaUtils.debug(1, "method " + name + " in class " + class_name + " threw exception " + type + ": " + msg);
                if (t instanceof InlineJavaException) {
                    InlineJavaException ije = (InlineJavaException)t;
                    throw ije;
                }
                Throwable retval = t;
                if (t instanceof InlineJavaPerlException) {
                    InlineJavaPerlException ijpe = (InlineJavaPerlException)t;
                    Object eo = ijpe.GetObject();
                    if (eo instanceof Throwable) {
                        retval = (Throwable)eo;
                    }
                    InlineJavaUtils.debug(2, "InlineJavaPerlException " + retval.toString());
                }
                this.SetResponse(new InlineJavaThrown(retval));
            }
        }
    }

    Class AutoCast(Object o, Class want) {
        boolean _public;
        if (o == null) {
            return null;
        }
        Class<?> got = o.getClass();
        if (got.equals(want)) {
            return null;
        }
        boolean bl = _public = (got.getModifiers() & 1) != 0;
        if (_public || got.getPackage() == null) {
            return null;
        }
        InlineJavaUtils.debug(3, "AutoCast: " + got.getName() + " -> " + want.getName());
        return want;
    }

    void Cast(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        String class_name = st.nextToken();
        Object o = this.ijs.GetObject(id);
        Class c = InlineJavaClass.ValidateClass(class_name);
        this.SetResponse(o, c);
    }

    void Read(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        int len = Integer.parseInt(st.nextToken());
        Object o = this.ijs.GetObject(id);
        Object ret = null;
        try {
            ret = InlineJavaHandle.read(o, len);
        }
        catch (IOException e) {
            ret = new InlineJavaThrown(e);
        }
        this.SetResponse(ret);
    }

    void MakeBuffered(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        Object o = this.ijs.GetObject(id);
        Object ret = null;
        try {
            ret = InlineJavaHandle.makeBuffered(o);
            if (ret != o) {
                int buf_id = this.ijs.PutObject(ret);
                ret = buf_id;
            } else {
                ret = id;
            }
        }
        catch (IOException e) {
            ret = new InlineJavaThrown(e);
        }
        this.SetResponse(ret);
    }

    void ReadLine(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        Object o = this.ijs.GetObject(id);
        Object ret = null;
        try {
            ret = InlineJavaHandle.readLine(o);
        }
        catch (IOException e) {
            ret = new InlineJavaThrown(e);
        }
        this.SetResponse(ret);
    }

    void Write(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        Object arg = this.ijc.CastArgument(Object.class, st.nextToken());
        Object o = this.ijs.GetObject(id);
        Object ret = null;
        try {
            int len = InlineJavaHandle.write(o, arg.toString());
            ret = len;
        }
        catch (IOException e) {
            ret = new InlineJavaThrown(e);
        }
        this.SetResponse(ret);
    }

    void Close(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        Object o = this.ijs.GetObject(id);
        InlineJavaThrown ret = null;
        try {
            InlineJavaHandle.close(o);
        }
        catch (IOException e) {
            ret = new InlineJavaThrown(e);
        }
        this.SetResponse(ret);
    }

    void SetJavaMember(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        String class_name = st.nextToken();
        Object o = null;
        if (id > 0) {
            o = this.ijs.GetObject(id);
        }
        Class c = InlineJavaClass.ValidateClass(class_name);
        String member = st.nextToken();
        if (InlineJavaClass.ClassIsArray(c)) {
            int idx = Integer.parseInt(member);
            Class type = InlineJavaClass.ValidateClass(st.nextToken());
            String arg = st.nextToken();
            String msg = "For array of type " + c.getName() + ", element " + member + ": ";
            try {
                Object elem = this.ijc.CastArgument(type, arg);
                InlineJavaServer.GetInstance().GetUserClassLoader().array_set(o, idx, elem);
                this.SetResponse(null);
            }
            catch (InlineJavaCastException e) {
                throw new InlineJavaCastException(msg + e.getMessage());
            }
            catch (InlineJavaException e) {
                throw new InlineJavaException(msg + e.getMessage());
            }
        }
        ArrayList<Object> fl = this.ValidateMember(c, member, st);
        Field f = (Field)fl.get(0);
        String name = f.getName();
        Object p = fl.get(1);
        try {
            InlineJavaServer.GetInstance().GetUserClassLoader().set(f, o, p);
            this.SetResponse(null);
        }
        catch (IllegalAccessException e) {
            throw new InlineJavaException("You are not allowed to set member " + name + " in class " + class_name + ": " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InlineJavaException("Argument for member " + name + " in class " + class_name + " is incompatible: " + e.getMessage());
        }
    }

    void GetJavaMember(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        String class_name = st.nextToken();
        Object o = null;
        if (id > 0) {
            o = this.ijs.GetObject(id);
        }
        Class c = InlineJavaClass.ValidateClass(class_name);
        String member = st.nextToken();
        if (InlineJavaClass.ClassIsArray(c)) {
            int idx = Integer.parseInt(member);
            Object ret = InlineJavaServer.GetInstance().GetUserClassLoader().array_get(o, idx);
            Class eclass = InlineJavaClass.ValidateClass(InlineJavaClass.CleanClassName(class_name.substring(1)));
            this.SetResponse(ret, this.AutoCast(ret, eclass));
        } else {
            ArrayList<Object> fl = this.ValidateMember(c, member, st);
            Field f = (Field)fl.get(0);
            String name = f.getName();
            try {
                Object ret = InlineJavaServer.GetInstance().GetUserClassLoader().get(f, o);
                this.SetResponse(ret, this.AutoCast(ret, f.getType()));
            }
            catch (IllegalAccessException e) {
                throw new InlineJavaException("You are not allowed to set member " + name + " in class " + class_name + ": " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new InlineJavaException("Argument for member " + name + " in class " + class_name + " is incompatible: " + e.getMessage());
            }
        }
    }

    void DeleteJavaObject(StringTokenizer st) throws InlineJavaException {
        int id = Integer.parseInt(st.nextToken());
        Object o = this.ijs.DeleteObject(id);
        this.SetResponse(null);
    }

    Object CreateObject(Class p, Object[] args, Class[] proto) throws InlineJavaException {
        p = InlineJavaClass.FindWrapper(p);
        String name = p.getName();
        Object ret = null;
        try {
            ret = InlineJavaServer.GetInstance().GetUserClassLoader().create(p, args, proto);
        }
        catch (NoSuchMethodException e) {
            throw new InlineJavaException("Constructor for class " + name + " with signature " + InlineJavaUtils.CreateSignature(proto) + " not found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InlineJavaException("You are not allowed to instantiate object of class " + name + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InlineJavaException("You are not allowed to instantiate object of class " + name + " using the constructor with signature " + InlineJavaUtils.CreateSignature(proto) + ": " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InlineJavaException("Arguments to constructor for class " + name + " with signature " + InlineJavaUtils.CreateSignature(proto) + " are incompatible: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String type = t.getClass().getName();
            String msg = t.getMessage();
            throw new InlineJavaInvocationTargetException("Constructor for class " + name + " with signature " + InlineJavaUtils.CreateSignature(proto) + " threw exception " + type + ": " + msg, t);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArrayList<Object> ValidateMethod(boolean constructor, Class c, String name, StringTokenizer st) throws InlineJavaException {
        ArrayList<Object> ret = new ArrayList<Object>();
        String signature = st.nextToken();
        ArrayList<String> args = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            args.add(args.size(), st.nextToken());
        }
        String key = c.getName() + "." + name + signature;
        ArrayList<Member> ml = new ArrayList<Member>();
        Class[] params = null;
        Member cached = member_cache.get(key);
        if (cached != null) {
            InlineJavaUtils.debug(3, "method was cached");
            ml.add(ml.size(), cached);
        } else {
            Member[] ma = constructor ? (Member[])c.getConstructors() : (Member[])c.getMethods();
            for (int i = 0; i < ma.length; ++i) {
                Member m = ma[i];
                if (!m.getName().equals(name)) continue;
                InlineJavaUtils.debug(3, "found a " + name + (constructor ? " constructor" : " method"));
                params = constructor ? ((Constructor)m).getParameterTypes() : ((Method)m).getParameterTypes();
                String sign = InlineJavaUtils.CreateSignature(params, ",");
                InlineJavaUtils.debug(3, sign + " = " + signature + "?");
                if (!signature.equals(sign)) continue;
                InlineJavaUtils.debug(3, "has matching signature " + sign);
                ml.add(ml.size(), m);
                member_cache.put(key, m);
                break;
            }
        }
        if (ml.size() == 0) {
            if (!constructor || !signature.equals("()")) throw new InlineJavaException((constructor ? "Constructor " : "Method ") + name + " for class " + c.getName() + " with signature " + signature + " not found");
            ret.add(0, null);
            ret.add(1, new Object[0]);
            ret.add(2, new Class[0]);
            return ret;
        }
        if (ml.size() != 1) return ret;
        Member m = (Member)ml.get(0);
        params = constructor ? ((Constructor)m).getParameterTypes() : ((Method)m).getParameterTypes();
        String msg = "In method " + name + " of class " + c.getName() + ": ";
        try {
            ret.add(0, m);
            ret.add(1, this.ijc.CastArguments(params, args));
            ret.add(2, params);
            return ret;
        }
        catch (InlineJavaCastException e) {
            throw new InlineJavaCastException(msg + e.getMessage());
        }
        catch (InlineJavaException e) {
            throw new InlineJavaException(msg + e.getMessage());
        }
    }

    ArrayList<Object> ValidateMember(Class c, String name, StringTokenizer st) throws InlineJavaException {
        ArrayList<Object> ret = new ArrayList<Object>();
        String type = st.nextToken();
        String arg = st.nextToken();
        String key = type + " " + c.getName() + "." + name;
        ArrayList<Member> fl = new ArrayList<Member>();
        Class<?> param = null;
        Member cached = member_cache.get(key);
        if (cached != null) {
            InlineJavaUtils.debug(3, "member was cached");
            fl.add(fl.size(), cached);
        } else {
            Field[] fa = c.getFields();
            for (int i = 0; i < fa.length; ++i) {
                Field f = fa[InlineJavaUtils.ReverseMembers() ? fa.length - 1 - i : i];
                if (!f.getName().equals(name)) continue;
                InlineJavaUtils.debug(3, "found a " + name + " member");
                param = f.getType();
                String t = param.getName();
                if (!type.equals(t)) continue;
                InlineJavaUtils.debug(3, "has matching type " + t);
                fl.add(fl.size(), f);
            }
        }
        if (fl.size() == 0) {
            throw new InlineJavaException("Member " + name + " of type " + type + " for class " + c.getName() + " not found");
        }
        Field f = (Field)fl.get(fl.size() - 1);
        member_cache.put(key, f);
        param = f.getType();
        String msg = "For member " + name + " of class " + c.getName() + ": ";
        try {
            ret.add(0, f);
            ret.add(1, this.ijc.CastArgument(param, arg));
            ret.add(2, param);
        }
        catch (InlineJavaCastException e) {
            throw new InlineJavaCastException(msg + e.getMessage());
        }
        catch (InlineJavaException e) {
            throw new InlineJavaException(msg + e.getMessage());
        }
        return ret;
    }

    void SetResponse(Object o) throws InlineJavaException {
        this.SetResponse(o, null);
    }

    void SetResponse(Object o, Class p) throws InlineJavaException {
        this.response = "ok " + this.SerializeObject(o, p);
    }

    String SerializeObject(Object o, Class p) throws InlineJavaException {
        Class<?> c;
        block17: {
            block16: {
                Class<?> clazz = c = o == null ? null : o.getClass();
                if (c != null && p != null) {
                    if (InlineJavaClass.DoesExtend(c, p) < 0) {
                        throw new InlineJavaException("Can't cast a " + c.getName() + " to a " + p.getName());
                    }
                    c = p;
                }
                if (o == null) {
                    return "undef:";
                }
                if (InlineJavaClass.ClassIsNumeric(c)) break block16;
                if (InlineJavaClass.ClassIsChar(c)) break block16;
                if (!InlineJavaClass.ClassIsString(c)) break block17;
            }
            if (this.ijs.GetNativeDoubles()) {
                if (InlineJavaClass.ClassIsDouble(c)) {
                    Double d = (Double)o;
                    long l = Double.doubleToLongBits(d);
                    char[] ca = new char[8];
                    for (int i = 0; i < 8; ++i) {
                        ca[i] = (char)(l >> 8 * i & 0xFFL);
                    }
                    return "double:" + this.Encode(new String(ca));
                }
            }
            return "scalar:" + this.Encode(o.toString());
        }
        if (InlineJavaClass.ClassIsBool(c)) {
            String b = o.toString();
            return "scalar:" + this.Encode(b.equals("true") ? "1" : "0");
        }
        if (!(o instanceof InlineJavaPerlObject)) {
            boolean thrown = false;
            String type = "object";
            if (o instanceof InlineJavaThrown) {
                thrown = true;
                o = ((InlineJavaThrown)o).GetThrowable();
                c = o.getClass();
            } else if (InlineJavaClass.ClassIsArray(c)) {
                type = "array";
            } else if (InlineJavaClass.ClassIsHandle(c)) {
                type = "handle";
            }
            int id = this.ijs.PutObject(o);
            return "java_" + type + ":" + (thrown ? "1" : "0") + ":" + String.valueOf(id) + ":" + c.getName();
        }
        return "perl_object:" + ((InlineJavaPerlObject)o).GetId() + ":" + ((InlineJavaPerlObject)o).GetPkg();
    }

    byte[] DecodeToByteArray(String s) {
        return InlineJavaUtils.DecodeBase64(s.toCharArray());
    }

    String Decode(String s) throws InlineJavaException {
        try {
            if ("UTF-8" != null) {
                return new String(this.DecodeToByteArray(s), "UTF-8");
            }
            return new String(this.DecodeToByteArray(s));
        }
        catch (UnsupportedEncodingException e) {
            throw new InlineJavaException("Unsupported encoding: " + e.getMessage());
        }
    }

    String EncodeFromByteArray(byte[] bytes) {
        return new String(InlineJavaUtils.EncodeBase64(bytes));
    }

    String Encode(String s) throws InlineJavaException {
        try {
            if ("UTF-8" != null) {
                return this.EncodeFromByteArray(s.getBytes("UTF-8"));
            }
            return this.EncodeFromByteArray(s.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            throw new InlineJavaException("Unsupported encoding: " + e.getMessage());
        }
    }

    String GetResponse() {
        return this.response;
    }
}

