/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.AggUtil;
import org.apache.solr.search.facet.DocValuesAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UnInvertedFieldAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class VarianceAgg
extends SimpleAggValueSource {
    public VarianceAgg(ValueSource vs) {
        super("variance", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.getType().getNumberType() == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for " + sf.getType().getTypeName());
            }
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                if (sf.hasDocValues()) {
                    if (sf.getType().isPointField()) {
                        return new VarianceSortedNumericAcc(fcontext, sf, numSlots);
                    }
                    return new VarianceSortedSetAcc(fcontext, sf, numSlots);
                }
                if (sf.getType().isPointField()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for PointField w/o docValues");
                }
                return new VarianceUnInvertedFieldAcc(fcontext, sf, numSlots);
            }
            vs = sf.getType().getValueSource(sf, null);
        }
        return new SlotAcc.VarianceSlotAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    class VarianceSortedNumericAcc
    extends DocValuesAcc.SDVSortedNumericAcc {
        public VarianceSortedNumericAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots);
        }

        @Override
        protected double computeVal(int slot) {
            return AggUtil.uncorrectedVariance(this.result[slot], this.sum[slot], this.counts[slot]);
        }
    }

    class VarianceSortedSetAcc
    extends DocValuesAcc.SDVSortedSetAcc {
        public VarianceSortedSetAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots);
        }

        @Override
        protected double computeVal(int slot) {
            return AggUtil.uncorrectedVariance(this.result[slot], this.sum[slot], this.counts[slot]);
        }
    }

    class VarianceUnInvertedFieldAcc
    extends UnInvertedFieldAcc.SDVUnInvertedFieldAcc {
        public VarianceUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots);
        }

        @Override
        protected double computeVal(int slot) {
            return AggUtil.uncorrectedVariance(this.result[slot], this.sum[slot], this.counts[slot]);
        }
    }

    private static class Merger
    extends FacetModule.FacetDoubleMerger {
        long count;
        double sumSq;
        double sum;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext1) {
            List numberList = (List)facetResult;
            this.count += ((Number)numberList.get(0)).longValue();
            this.sumSq += ((Number)numberList.get(1)).doubleValue();
            this.sum += ((Number)numberList.get(2)).doubleValue();
        }

        @Override
        public Object getMergedResult() {
            return this.getDouble();
        }

        @Override
        protected double getDouble() {
            return AggUtil.uncorrectedVariance(this.sumSq, this.sum, this.count);
        }
    }
}

