/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetBucket;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetRequestSorted;

abstract class FacetRequestSortedMerger<FacetRequestT extends FacetRequestSorted>
extends FacetModule.FacetBucketMerger<FacetRequestT> {
    LinkedHashMap<Object, FacetBucket> buckets = new LinkedHashMap();
    List<FacetBucket> sortedBuckets;
    BitSet shardHasMoreBuckets;
    FacetMerger.Context mcontext;

    public FacetRequestSortedMerger(FacetRequestT freq) {
        super(freq);
    }

    @Override
    public void merge(Object facetResult, FacetMerger.Context mcontext) {
        this.mcontext = mcontext;
        SimpleOrderedMap res = (SimpleOrderedMap)facetResult;
        Boolean more = (Boolean)res.get("more");
        if (more != null && more.booleanValue()) {
            if (this.shardHasMoreBuckets == null) {
                this.shardHasMoreBuckets = new BitSet(mcontext.numShards);
            }
            this.shardHasMoreBuckets.set(mcontext.shardNum);
        }
    }

    public void mergeBucketList(List<SimpleOrderedMap> bucketList, FacetMerger.Context mcontext) {
        for (SimpleOrderedMap bucketRes : bucketList) {
            Comparable bucketVal = (Comparable)bucketRes.get("val");
            FacetBucket bucket = this.buckets.get(bucketVal);
            if (bucket == null) {
                bucket = this.newBucket(bucketVal, mcontext);
                this.buckets.put(bucketVal, bucket);
            }
            bucket.mergeBucket(bucketRes, mcontext);
        }
    }

    public void sortBuckets(FacetRequest.FacetSort sort) {
        this.sortedBuckets = new ArrayList<FacetBucket>(this.buckets.values());
        Comparator comparator = null;
        FacetRequest.SortDirection direction = sort.sortDirection;
        int sortMul = direction.getMultiplier();
        if ("count".equals(sort.sortVariable)) {
            comparator = (o1, o2) -> {
                int v = -Long.compare(o1.count, o2.count) * sortMul;
                return v == 0 ? o1.bucketValue.compareTo(o2.bucketValue) : v;
            };
            Collections.sort(this.sortedBuckets, comparator);
        } else if ("index".equals(sort.sortVariable)) {
            comparator = (o1, o2) -> -o1.bucketValue.compareTo(o2.bucketValue) * sortMul;
            Collections.sort(this.sortedBuckets, comparator);
        } else {
            String key = sort.sortVariable;
            ArrayList<SortVal> lst = new ArrayList<SortVal>(this.buckets.size());
            ArrayList<FacetBucket> nulls = new ArrayList<FacetBucket>(this.buckets.size() >> 1);
            for (int i = 0; i < this.sortedBuckets.size(); ++i) {
                FacetBucket bucket = this.sortedBuckets.get(i);
                FacetMerger merger = bucket.getExistingMerger(key);
                if (merger == null) {
                    nulls.add(bucket);
                }
                if (merger == null) continue;
                SortVal sv = new SortVal();
                sv.bucket = bucket;
                sv.merger = (FacetModule.FacetSortableMerger)merger;
                sv.direction = direction;
                lst.add(sv);
            }
            Collections.sort(lst);
            Collections.sort(nulls, (o1, o2) -> o1.bucketValue.compareTo(o2.bucketValue));
            ArrayList<FacetBucket> out = new ArrayList<FacetBucket>(this.buckets.size());
            for (SortVal sv : lst) {
                out.add(sv.bucket);
            }
            out.addAll(nulls);
            this.sortedBuckets = out;
        }
        assert (null != this.sortedBuckets);
    }

    boolean isBucketComplete(FacetBucket bucket, FacetMerger.Context mcontext) {
        if (mcontext.numShards <= 1 || this.shardHasMoreBuckets == null) {
            return true;
        }
        for (int shard = 0; shard < mcontext.numShards; ++shard) {
            if (mcontext.getShardFlag(bucket.bucketNumber, shard) || this.shardHasMoreBuckets == null || !this.shardHasMoreBuckets.get(shard)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getRefinement(FacetMerger.Context mcontext) {
        Collection<FacetBucket> bucketList;
        boolean returnedAllBuckets;
        Map<String, Object> refinement = null;
        Collection<String> tags = mcontext.getSubsWithRefinement(this.freq);
        if (tags.isEmpty() && !((FacetRequestSorted)this.freq).doRefine()) {
            return null;
        }
        FacetRequest.FacetSort initial_sort = null == ((FacetRequestSorted)this.freq).prelim_sort ? ((FacetRequestSorted)this.freq).sort : ((FacetRequestSorted)this.freq).prelim_sort;
        Collection<String> tagsWithPartial = mcontext.getSubsWithPartial(this.freq);
        boolean thisMissing = mcontext.bucketWasMissing();
        boolean shardHasMore = this.shardHasMoreBuckets != null && this.shardHasMoreBuckets.get(mcontext.shardNum);
        boolean isCommandPartial = ((FacetRequestSorted)this.freq).returnsPartial() || ((FacetRequestSorted)this.freq).processEmpty;
        boolean bl = returnedAllBuckets = !(shardHasMore |= thisMissing) && !((FacetRequestSorted)this.freq).processEmpty;
        if (returnedAllBuckets && tags.isEmpty() && tagsWithPartial.isEmpty()) {
            return null;
        }
        long numBucketsToCheck = Integer.MAX_VALUE;
        if (((FacetRequestSorted)this.freq).limit >= 0L) {
            numBucketsToCheck = ((FacetRequestSorted)this.freq).offset + ((FacetRequestSorted)this.freq).limit;
            if (-1 == ((FacetRequestSorted)this.freq).overrefine) {
                if (((FacetRequestSorted)this.freq).mincount > 1L || !"index".equals(initial_sort.sortVariable) && (!"count".equals(initial_sort.sortVariable) || FacetRequest.SortDirection.desc != initial_sort.sortDirection)) {
                    numBucketsToCheck = 0 <= ((FacetRequestSorted)this.freq).overrequest ? (numBucketsToCheck += (long)((FacetRequestSorted)this.freq).overrequest) : (long)((double)numBucketsToCheck * 1.1 + 4.0);
                }
            } else {
                numBucketsToCheck += (long)((FacetRequestSorted)this.freq).overrefine;
            }
        }
        numBucketsToCheck = Math.min((long)this.buckets.size(), numBucketsToCheck);
        if ((long)this.buckets.size() < numBucketsToCheck) {
            bucketList = this.buckets.values();
        } else {
            if (this.sortedBuckets == null) {
                this.sortBuckets(initial_sort);
            }
            bucketList = this.sortedBuckets;
        }
        ArrayList<Comparable> leafBuckets = null;
        ArrayList<List<Object>> partialBuckets = null;
        ArrayList<List<Object>> skipBuckets = null;
        for (FacetBucket bucket : bucketList) {
            Map<String, Object> bucketRefinement;
            boolean saw;
            if (numBucketsToCheck-- <= 0L) break;
            assert (!thisMissing || thisMissing && !mcontext.getShardFlag(bucket.bucketNumber));
            boolean bl2 = saw = !thisMissing && mcontext.getShardFlag(bucket.bucketNumber);
            if (!saw && !returnedAllBuckets) {
                bucketRefinement = null;
                if (!tagsWithPartial.isEmpty()) {
                    boolean prev = mcontext.setBucketWasMissing(true);
                    bucketRefinement = bucket.getRefinement(mcontext, tagsWithPartial);
                    mcontext.setBucketWasMissing(prev);
                    if (bucketRefinement != null) {
                        if (partialBuckets == null) {
                            partialBuckets = new ArrayList<List<Object>>();
                        }
                        partialBuckets.add(Arrays.asList(bucket.bucketValue, bucketRefinement));
                    }
                }
                if (bucketRefinement != null) continue;
                if (leafBuckets == null) {
                    leafBuckets = new ArrayList<Comparable>();
                }
                leafBuckets.add(bucket.bucketValue);
                continue;
            }
            if (tags.isEmpty() || (bucketRefinement = bucket.getRefinement(mcontext, tagsWithPartial)) == null) continue;
            if (skipBuckets == null) {
                skipBuckets = new ArrayList<List<Object>>();
            }
            skipBuckets.add(Arrays.asList(bucket.bucketValue, bucketRefinement));
        }
        if (leafBuckets != null || partialBuckets != null || skipBuckets != null) {
            refinement = new HashMap<String, Object>(3);
            if (leafBuckets != null) {
                refinement.put("_l", leafBuckets);
            }
            if (partialBuckets != null) {
                refinement.put("_p", partialBuckets);
            }
            if (skipBuckets != null) {
                refinement.put("_s", skipBuckets);
            }
        }
        refinement = this.getRefinementSpecial(mcontext, refinement, tagsWithPartial);
        return refinement;
    }

    Map<String, Object> getRefinementSpecial(FacetMerger.Context mcontext, Map<String, Object> refinement, Collection<String> tagsWithPartial) {
        return refinement;
    }

    private static class SortVal
    implements Comparable<SortVal> {
        FacetBucket bucket;
        FacetModule.FacetSortableMerger merger;
        FacetRequest.SortDirection direction;

        private SortVal() {
        }

        @Override
        public int compareTo(SortVal o) {
            int c = -this.merger.compareTo(o.merger, this.direction) * this.direction.getMultiplier();
            return c == 0 ? this.bucket.bucketValue.compareTo(o.bucket.bucketValue) : c;
        }
    }
}

