/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.Acceptor;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProcessorBase;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.LimitLatch;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.apache.tomcat.util.threads.VirtualThreadExecutor;

public abstract class AbstractEndpoint<S, U> {
    protected static final StringManager sm = StringManager.getManager(AbstractEndpoint.class);
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected volatile boolean internalExecutor = true;
    private volatile LimitLatch connectionLimitLatch = null;
    protected final SocketProperties socketProperties = new SocketProperties();
    protected Acceptor<U> acceptor;
    protected SynchronizedStack<SocketProcessorBase<S>> processorCache;
    private ObjectName oname = null;
    protected Map<U, SocketWrapperBase<S>> connections = new ConcurrentHashMap<U, SocketWrapperBase<S>>();
    private String defaultSSLHostConfigName = "_default_";
    protected ConcurrentMap<String, SSLHostConfig> sslHostConfigs = new ConcurrentHashMap<String, SSLHostConfig>();
    private boolean useSendfile = true;
    private long executorTerminationTimeoutMillis = 5000L;
    protected int acceptorThreadPriority = 5;
    private int maxConnections = 8192;
    private Executor executor = null;
    private boolean useVirtualThreads = false;
    private ScheduledExecutorService utilityExecutor = null;
    private int port = -1;
    private int portOffset = 0;
    private InetAddress address;
    private int acceptCount = 100;
    private boolean bindOnInit = true;
    private volatile BindState bindState = BindState.UNBOUND;
    private Integer keepAliveTimeout = null;
    private boolean SSLEnabled = false;
    private int minSpareThreads = 10;
    private int maxThreads = 200;
    protected int threadPriority = 5;
    private int maxKeepAliveRequests = 100;
    private String name = "TP";
    private String domain;
    private boolean daemon = true;
    private boolean useAsyncIO = true;
    protected final List<String> negotiableProtocols = new ArrayList<String>();
    private Handler<S> handler = null;
    protected HashMap<String, Object> attributes = new HashMap();

    public static long toTimeout(long l) {
        return l > 0L ? l : Long.MAX_VALUE;
    }

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public Set<SocketWrapperBase<S>> getConnections() {
        return new HashSet<SocketWrapperBase<S>>(this.connections.values());
    }

    public String getDefaultSSLHostConfigName() {
        return this.defaultSSLHostConfigName;
    }

    public void setDefaultSSLHostConfigName(String string) {
        this.defaultSSLHostConfigName = string.toLowerCase(Locale.ENGLISH);
    }

    public void addSslHostConfig(SSLHostConfig sSLHostConfig) throws IllegalArgumentException {
        this.addSslHostConfig(sSLHostConfig, false);
    }

    public void addSslHostConfig(SSLHostConfig sSLHostConfig, boolean bl) throws IllegalArgumentException {
        String string = sSLHostConfig.getHostName();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(sm.getString("endpoint.noSslHostName"));
        }
        if (this.bindState != BindState.UNBOUND && this.bindState != BindState.SOCKET_CLOSED_ON_STOP && this.isSSLEnabled()) {
            try {
                this.createSSLContext(sSLHostConfig);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        if (bl) {
            SSLHostConfig sSLHostConfig2 = this.sslHostConfigs.put(string, sSLHostConfig);
            if (sSLHostConfig2 != null) {
                this.unregisterJmx(sSLHostConfig);
            }
            this.registerJmx(sSLHostConfig);
        } else {
            SSLHostConfig sSLHostConfig3 = this.sslHostConfigs.putIfAbsent(string, sSLHostConfig);
            if (sSLHostConfig3 != null) {
                this.releaseSSLContext(sSLHostConfig);
                throw new IllegalArgumentException(sm.getString("endpoint.duplicateSslHostName", new Object[]{string}));
            }
            this.registerJmx(sSLHostConfig);
        }
    }

    public SSLHostConfig removeSslHostConfig(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals(this.getDefaultSSLHostConfigName())) {
            throw new IllegalArgumentException(sm.getString("endpoint.removeDefaultSslHostConfig", new Object[]{string}));
        }
        SSLHostConfig sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.remove(string2);
        this.unregisterJmx(sSLHostConfig);
        return sSLHostConfig;
    }

    public void reloadSslHostConfig(String string) {
        SSLHostConfig sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get(string.toLowerCase(Locale.ENGLISH));
        if (sSLHostConfig == null) {
            throw new IllegalArgumentException(sm.getString("endpoint.unknownSslHostName", new Object[]{string}));
        }
        this.addSslHostConfig(sSLHostConfig, true);
    }

    public void reloadSslHostConfigs() {
        for (String string : this.sslHostConfigs.keySet()) {
            this.reloadSslHostConfig(string);
        }
    }

    public SSLHostConfig[] findSslHostConfigs() {
        return this.sslHostConfigs.values().toArray(new SSLHostConfig[0]);
    }

    protected abstract void createSSLContext(SSLHostConfig var1) throws Exception;

    protected void logCertificate(SSLHostConfigCertificate sSLHostConfigCertificate) {
        String string;
        String string2;
        SSLHostConfig sSLHostConfig = sSLHostConfigCertificate.getSSLHostConfig();
        if (sSLHostConfigCertificate.getStoreType() == SSLHostConfigCertificate.StoreType.PEM) {
            string2 = sm.getString("endpoint.tls.info.cert.pem", new Object[]{sSLHostConfigCertificate.getCertificateKeyFile(), sSLHostConfigCertificate.getCertificateFile(), sSLHostConfigCertificate.getCertificateChainFile()});
        } else {
            string = sSLHostConfigCertificate.getCertificateKeyAlias();
            if (string == null) {
                string = "tomcat";
            }
            string2 = sm.getString("endpoint.tls.info.cert.keystore", new Object[]{sSLHostConfigCertificate.getCertificateKeystoreFile(), string});
        }
        string = sSLHostConfig.getTruststoreFile();
        if (string == null) {
            string = sSLHostConfig.getCaCertificateFile();
        }
        if (string == null) {
            string = sSLHostConfig.getCaCertificatePath();
        }
        this.getLogCertificate().info((Object)sm.getString("endpoint.tls.info", new Object[]{this.getName(), sSLHostConfig.getHostName(), sSLHostConfigCertificate.getType(), string2, string}));
        if (this.getLogCertificate().isDebugEnabled()) {
            X509Certificate[] x509CertificateArray;
            String string3 = sSLHostConfigCertificate.getCertificateKeyAlias();
            if (string3 == null) {
                string3 = "tomcat";
            }
            if ((x509CertificateArray = sSLHostConfigCertificate.getSslContext().getCertificateChain(string3)) != null && x509CertificateArray.length > 0) {
                this.getLogCertificate().debug((Object)this.generateCertificateDebug(x509CertificateArray[0]));
            } else {
                this.getLogCertificate().debug((Object)sm.getString("endpoint.tls.cert.noCerts"));
            }
        }
    }

    protected String generateCertificateDebug(X509Certificate x509Certificate) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n[");
        try {
            byte[] byArray = x509Certificate.getEncoded();
            stringBuilder.append("\nSHA-256 fingerprint: ");
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            stringBuilder.append(HexUtils.toHexString((byte[])messageDigest.digest()));
            stringBuilder.append("\nSHA-1 fingerprint: ");
            MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1");
            messageDigest2.update(byArray);
            stringBuilder.append(HexUtils.toHexString((byte[])messageDigest2.digest()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.getLogCertificate().warn((Object)sm.getString("endpoint.tls.cert.encodingError"), (Throwable)certificateEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        stringBuilder.append("\n");
        stringBuilder.append(x509Certificate);
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    protected void destroySsl() throws Exception {
        if (this.isSSLEnabled()) {
            for (SSLHostConfig sSLHostConfig : this.sslHostConfigs.values()) {
                this.releaseSSLContext(sSLHostConfig);
            }
        }
    }

    protected void releaseSSLContext(SSLHostConfig sSLHostConfig) {
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates()) {
            SSLContext sSLContext;
            if (sSLHostConfigCertificate.getSslContext() == null || (sSLContext = sSLHostConfigCertificate.getSslContext()) == null) continue;
            sSLContext.destroy();
        }
    }

    protected SSLHostConfig getSSLHostConfig(String string) {
        SSLHostConfig sSLHostConfig = null;
        if (string != null) {
            sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get(string);
            if (sSLHostConfig != null) {
                return sSLHostConfig;
            }
            int n = string.indexOf(46);
            if (n > -1) {
                sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get("*" + string.substring(n));
            }
        }
        if (sSLHostConfig == null) {
            sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get(this.getDefaultSSLHostConfigName());
        }
        if (sSLHostConfig == null) {
            throw new IllegalStateException();
        }
        return sSLHostConfig;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseSendfile(boolean bl) {
        this.useSendfile = bl;
    }

    public long getExecutorTerminationTimeoutMillis() {
        return this.executorTerminationTimeoutMillis;
    }

    public void setExecutorTerminationTimeoutMillis(long l) {
        this.executorTerminationTimeoutMillis = l;
    }

    public void setAcceptorThreadPriority(int n) {
        this.acceptorThreadPriority = n;
    }

    public int getAcceptorThreadPriority() {
        return this.acceptorThreadPriority;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            if (n == -1) {
                this.releaseConnectionLatch();
            } else {
                limitLatch.setLimit((long)n);
            }
        } else if (n > 0) {
            this.initializeConnectionLatch();
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getConnectionCount() {
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            return limitLatch.getCount();
        }
        return -1L;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.internalExecutor = executor == null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setUseVirtualThreads(boolean bl) {
        this.useVirtualThreads = bl;
    }

    public boolean getUseVirtualThreads() {
        return this.useVirtualThreads;
    }

    public void setUtilityExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.utilityExecutor = scheduledExecutorService;
    }

    public ScheduledExecutorService getUtilityExecutor() {
        if (this.utilityExecutor == null) {
            this.getLog().warn((Object)sm.getString("endpoint.warn.noUtilityExecutor"));
            this.utilityExecutor = new ScheduledThreadPoolExecutor(1);
        }
        return this.utilityExecutor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(sm.getString("endpoint.portOffset.invalid", new Object[]{n}));
        }
        this.portOffset = n;
    }

    public int getPortWithOffset() {
        int n = this.getPort();
        if (n > 0) {
            return n + this.getPortOffset();
        }
        return n;
    }

    public final int getLocalPort() {
        try {
            InetSocketAddress inetSocketAddress = this.getLocalAddress();
            if (inetSocketAddress == null) {
                return -1;
            }
            return inetSocketAddress.getPort();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    protected abstract InetSocketAddress getLocalAddress() throws IOException;

    public void setAcceptCount(int n) {
        if (n > 0) {
            this.acceptCount = n;
        }
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public boolean getBindOnInit() {
        return this.bindOnInit;
    }

    public void setBindOnInit(boolean bl) {
        this.bindOnInit = bl;
    }

    protected BindState getBindState() {
        return this.bindState;
    }

    public int getKeepAliveTimeout() {
        if (this.keepAliveTimeout == null) {
            return this.getConnectionTimeout();
        }
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean bl) {
        this.socketProperties.setTcpNoDelay(bl);
    }

    public int getConnectionLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setConnectionLinger(int n) {
        this.socketProperties.setSoLingerTime(n);
        this.socketProperties.setSoLingerOn(n >= 0);
    }

    public int getConnectionTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.socketProperties.setSoTimeout(n);
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean bl) {
        this.SSLEnabled = bl;
    }

    public void setMinSpareThreads(int n) {
        this.minSpareThreads = n;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)executor).setCorePoolSize(n);
        }
    }

    public int getMinSpareThreads() {
        return Math.min(this.getMinSpareThreadsInternal(), this.getMaxThreads());
    }

    private int getMinSpareThreadsInternal() {
        if (this.internalExecutor) {
            return this.minSpareThreads;
        }
        return -1;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)executor).setMaximumPoolSize(n);
        }
    }

    public int getMaxThreads() {
        if (this.internalExecutor) {
            return this.maxThreads;
        }
        return -1;
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    public int getThreadPriority() {
        if (this.internalExecutor) {
            return this.threadPriority;
        }
        return -1;
    }

    public int getMaxKeepAliveRequests() {
        if (this.bindState.isBound()) {
            return this.maxKeepAliveRequests;
        }
        return 1;
    }

    public void setMaxKeepAliveRequests(int n) {
        this.maxKeepAliveRequests = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setUseAsyncIO(boolean bl) {
        this.useAsyncIO = bl;
    }

    public boolean getUseAsyncIO() {
        return this.useAsyncIO;
    }

    @Deprecated
    protected boolean getDeferAccept() {
        return false;
    }

    public String getId() {
        return null;
    }

    public void addNegotiatedProtocol(String string) {
        this.negotiableProtocols.add(string);
    }

    public boolean hasNegotiableProtocols() {
        return this.negotiableProtocols.size() > 0;
    }

    public void setHandler(Handler<S> handler) {
        this.handler = handler;
    }

    public Handler<S> getHandler() {
        return this.handler;
    }

    public void setAttribute(String string, Object object) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("endpoint.setAttribute", new Object[]{string, object}));
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        Object object = this.attributes.get(string);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("endpoint.getAttribute", new Object[]{string, object}));
        }
        return object;
    }

    public boolean setProperty(String string, String string2) {
        this.setAttribute(string, string2);
        try {
            if (string.startsWith("socket.")) {
                return IntrospectionUtils.setProperty((Object)this.socketProperties, (String)string.substring("socket.".length()), (String)string2);
            }
            return IntrospectionUtils.setProperty((Object)this, (String)string, (String)string2, (boolean)false);
        }
        catch (Exception exception) {
            this.getLog().error((Object)sm.getString("endpoint.setAttributeError", new Object[]{string, string2}), (Throwable)exception);
            return false;
        }
    }

    public String getProperty(String string) {
        Object object;
        String string2 = (String)this.getAttribute(string);
        if (string2 == null && string.startsWith("socket.") && (object = IntrospectionUtils.getProperty((Object)this.socketProperties, (String)string.substring("socket.".length()))) != null) {
            string2 = object.toString();
        }
        return string2;
    }

    public int getCurrentThreadCount() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getPoolSize();
            }
            if (executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                return ((java.util.concurrent.ThreadPoolExecutor)executor).getPoolSize();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getPoolSize();
            }
            return -1;
        }
        return -2;
    }

    public int getCurrentThreadsBusy() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getActiveCount();
            }
            if (executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                return ((java.util.concurrent.ThreadPoolExecutor)executor).getActiveCount();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getActiveCount();
            }
            return -1;
        }
        return -2;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void createExecutor() {
        this.internalExecutor = true;
        if (this.getUseVirtualThreads()) {
            this.executor = new VirtualThreadExecutor(this.getName() + "-virt-");
        } else {
            TaskQueue taskQueue = new TaskQueue();
            TaskThreadFactory taskThreadFactory = new TaskThreadFactory(this.getName() + "-exec-", this.daemon, this.getThreadPriority());
            this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue)taskQueue, (ThreadFactory)taskThreadFactory);
            taskQueue.setParent((ThreadPoolExecutor)this.executor);
        }
    }

    public void shutdownExecutor() {
        Executor executor = this.executor;
        if (executor != null && this.internalExecutor) {
            this.executor = null;
            if (executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                threadPoolExecutor.shutdownNow();
                long l = this.getExecutorTerminationTimeoutMillis();
                if (l > 0L) {
                    try {
                        threadPoolExecutor.awaitTermination(l, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (threadPoolExecutor.isTerminating()) {
                        this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}));
                    }
                }
                TaskQueue taskQueue = (TaskQueue)threadPoolExecutor.getQueue();
                taskQueue.setParent(null);
            }
        }
    }

    protected void unlockAccept() {
        block18: {
            if (this.acceptor == null || this.acceptor.getState() != Acceptor.AcceptorState.RUNNING) {
                return;
            }
            InetSocketAddress inetSocketAddress = null;
            InetSocketAddress inetSocketAddress2 = null;
            try {
                inetSocketAddress2 = this.getLocalAddress();
            }
            catch (IOException iOException) {
                this.getLog().debug((Object)sm.getString("endpoint.debug.unlock.localFail", new Object[]{this.getName()}), (Throwable)iOException);
            }
            if (inetSocketAddress2 == null) {
                this.getLog().warn((Object)sm.getString("endpoint.debug.unlock.localNone", new Object[]{this.getName()}));
                return;
            }
            try {
                inetSocketAddress = AbstractEndpoint.getUnlockAddress(inetSocketAddress2);
                try (Socket socket = new Socket();){
                    int n = 2000;
                    int n2 = 2000;
                    if (this.getSocketProperties().getSoTimeout() > n) {
                        n = this.getSocketProperties().getSoTimeout();
                    }
                    if (this.getSocketProperties().getUnlockTimeout() > n2) {
                        n2 = this.getSocketProperties().getUnlockTimeout();
                    }
                    socket.setSoTimeout(n);
                    socket.setSoLinger(true, 0);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("About to unlock socket for:" + inetSocketAddress));
                    }
                    socket.connect(inetSocketAddress, n2);
                    if (this.getDeferAccept()) {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), "ISO-8859-1");
                        outputStreamWriter.write("OPTIONS * HTTP/1.0\r\nUser-Agent: Tomcat wakeup connection\r\n\r\n");
                        outputStreamWriter.flush();
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("Socket unlock completed for:" + inetSocketAddress));
                    }
                }
                long l = System.nanoTime();
                while (l + 1000000000L > System.nanoTime() && this.acceptor.getState() == Acceptor.AcceptorState.RUNNING) {
                    if (l + 1000000L >= System.nanoTime()) continue;
                    Thread.sleep(1L);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (!this.getLog().isDebugEnabled()) break block18;
                this.getLog().debug((Object)sm.getString("endpoint.debug.unlock.fail", new Object[]{String.valueOf(this.getPortWithOffset())}), throwable);
            }
        }
    }

    private static InetSocketAddress getUnlockAddress(InetSocketAddress inetSocketAddress) throws SocketException {
        if (inetSocketAddress.getAddress().isAnyLocalAddress()) {
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = null;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress3 = enumeration2.nextElement();
                    if (!inetSocketAddress.getAddress().getClass().isAssignableFrom(inetAddress3.getClass())) continue;
                    if (inetAddress3.isLoopbackAddress()) {
                        if (inetAddress != null) continue;
                        inetAddress = inetAddress3;
                        continue;
                    }
                    if (inetAddress3.isLinkLocalAddress()) {
                        if (inetAddress2 != null) continue;
                        inetAddress2 = inetAddress3;
                        continue;
                    }
                    return new InetSocketAddress(inetAddress3, inetSocketAddress.getPort());
                }
            }
            if (inetAddress != null) {
                return new InetSocketAddress(inetAddress, inetSocketAddress.getPort());
            }
            if (inetAddress2 != null) {
                return new InetSocketAddress(inetAddress2, inetSocketAddress.getPort());
            }
            return new InetSocketAddress("localhost", inetSocketAddress.getPort());
        }
        return inetSocketAddress;
    }

    public boolean processSocket(SocketWrapperBase<S> socketWrapperBase, SocketEvent socketEvent, boolean bl) {
        try {
            if (socketWrapperBase == null) {
                return false;
            }
            SocketProcessorBase<S> socketProcessorBase = null;
            if (this.processorCache != null) {
                socketProcessorBase = (SocketProcessorBase<S>)this.processorCache.pop();
            }
            if (socketProcessorBase == null) {
                socketProcessorBase = this.createSocketProcessor(socketWrapperBase, socketEvent);
            } else {
                socketProcessorBase.reset(socketWrapperBase, socketEvent);
            }
            Executor executor = this.getExecutor();
            if (bl && executor != null) {
                executor.execute(socketProcessorBase);
            } else {
                socketProcessorBase.run();
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.getLog().warn((Object)sm.getString("endpoint.executor.fail", new Object[]{socketWrapperBase}), (Throwable)rejectedExecutionException);
            return false;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.getLog().error((Object)sm.getString("endpoint.process.fail"), throwable);
            return false;
        }
        return true;
    }

    protected abstract SocketProcessorBase<S> createSocketProcessor(SocketWrapperBase<S> var1, SocketEvent var2);

    public abstract void bind() throws Exception;

    public abstract void unbind() throws Exception;

    public abstract void startInternal() throws Exception;

    public abstract void stopInternal() throws Exception;

    private void bindWithCleanup() throws Exception {
        try {
            this.bind();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.unbind();
            throw throwable;
        }
    }

    public final void init() throws Exception {
        if (this.bindOnInit) {
            this.bindWithCleanup();
            this.bindState = BindState.BOUND_ON_INIT;
        }
        if (this.domain != null) {
            this.oname = new ObjectName(this.domain + ":type=ThreadPool,name=\"" + this.getName() + "\"");
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            ObjectName objectName = new ObjectName(this.domain + ":type=SocketProperties,name=\"" + this.getName() + "\"");
            this.socketProperties.setObjectName(objectName);
            Registry.getRegistry(null, null).registerComponent((Object)this.socketProperties, objectName, null);
            for (SSLHostConfig sSLHostConfig : this.findSslHostConfigs()) {
                this.registerJmx(sSLHostConfig);
            }
        }
    }

    private void registerJmx(SSLHostConfig sSLHostConfig) {
        if (this.domain == null) {
            return;
        }
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.domain + ":type=SSLHostConfig,ThreadPool=\"" + this.getName() + "\",name=" + ObjectName.quote(sSLHostConfig.getHostName()));
            sSLHostConfig.setObjectName(objectName);
            try {
                Registry.getRegistry(null, null).registerComponent((Object)sSLHostConfig, objectName, null);
            }
            catch (Exception exception) {
                this.getLog().warn((Object)sm.getString("endpoint.jmxRegistrationFailed", new Object[]{objectName}), (Throwable)exception);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this.getLog().warn((Object)sm.getString("endpoint.invalidJmxNameSslHost", new Object[]{sSLHostConfig.getHostName()}), (Throwable)malformedObjectNameException);
        }
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates()) {
            ObjectName objectName2 = null;
            try {
                objectName2 = new ObjectName(this.domain + ":type=SSLHostConfigCertificate,ThreadPool=\"" + this.getName() + "\",Host=" + ObjectName.quote(sSLHostConfig.getHostName()) + ",name=" + sSLHostConfigCertificate.getType());
                sSLHostConfigCertificate.setObjectName(objectName2);
                try {
                    Registry.getRegistry(null, null).registerComponent((Object)sSLHostConfigCertificate, objectName2, null);
                }
                catch (Exception exception) {
                    this.getLog().warn((Object)sm.getString("endpoint.jmxRegistrationFailed", new Object[]{objectName2}), (Throwable)exception);
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                this.getLog().warn((Object)sm.getString("endpoint.invalidJmxNameSslHostCert", new Object[]{sSLHostConfig.getHostName(), sSLHostConfigCertificate.getType()}), (Throwable)malformedObjectNameException);
            }
        }
    }

    private void unregisterJmx(SSLHostConfig sSLHostConfig) {
        Registry registry = Registry.getRegistry(null, null);
        registry.unregisterComponent(sSLHostConfig.getObjectName());
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates()) {
            registry.unregisterComponent(sSLHostConfigCertificate.getObjectName());
        }
    }

    public final void start() throws Exception {
        if (this.bindState == BindState.UNBOUND) {
            this.bindWithCleanup();
            this.bindState = BindState.BOUND_ON_START;
        }
        this.startInternal();
    }

    protected void startAcceptorThread() {
        this.acceptor = new Acceptor(this);
        String string = this.getName() + "-Acceptor";
        this.acceptor.setThreadName(string);
        Thread thread = new Thread(this.acceptor, string);
        thread.setPriority(this.getAcceptorThreadPriority());
        thread.setDaemon(this.getDaemon());
        thread.start();
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.releaseConnectionLatch();
            this.unlockAccept();
            this.getHandler().pause();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public final void stop() throws Exception {
        this.stopInternal();
        if (this.bindState == BindState.BOUND_ON_START || this.bindState == BindState.SOCKET_CLOSED_ON_STOP) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public final void destroy() throws Exception {
        if (this.bindState == BindState.BOUND_ON_INIT) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
        Registry registry = Registry.getRegistry(null, null);
        registry.unregisterComponent(this.oname);
        registry.unregisterComponent(this.socketProperties.getObjectName());
        for (SSLHostConfig sSLHostConfig : this.findSslHostConfigs()) {
            this.unregisterJmx(sSLHostConfig);
        }
    }

    protected abstract Log getLog();

    protected Log getLogCertificate() {
        return this.getLog();
    }

    protected LimitLatch initializeConnectionLatch() {
        if (this.maxConnections == -1) {
            return null;
        }
        if (this.connectionLimitLatch == null) {
            this.connectionLimitLatch = new LimitLatch((long)this.getMaxConnections());
        }
        return this.connectionLimitLatch;
    }

    private void releaseConnectionLatch() {
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            limitLatch.releaseAll();
        }
        this.connectionLimitLatch = null;
    }

    protected void countUpOrAwaitConnection() throws InterruptedException {
        if (this.maxConnections == -1) {
            return;
        }
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            limitLatch.countUpOrAwait();
        }
    }

    protected long countDownConnection() {
        if (this.maxConnections == -1) {
            return -1L;
        }
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            long l = limitLatch.countDown();
            if (l < 0L) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.incorrectConnectionCount"));
            }
            return l;
        }
        return -1L;
    }

    public final void closeServerSocketGraceful() {
        if (this.bindState == BindState.BOUND_ON_START) {
            this.acceptor.stop(-1);
            this.releaseConnectionLatch();
            this.unlockAccept();
            this.getHandler().pause();
            this.bindState = BindState.SOCKET_CLOSED_ON_STOP;
            try {
                this.doCloseServerSocket();
            }
            catch (IOException iOException) {
                this.getLog().warn((Object)sm.getString("endpoint.serverSocket.closeFailed", new Object[]{this.getName()}), (Throwable)iOException);
            }
        }
    }

    public final long awaitConnectionsClose(long l) {
        while (l > 0L && !this.connections.isEmpty()) {
            try {
                Thread.sleep(50L);
                l -= 50L;
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                l = 0L;
            }
        }
        return l;
    }

    protected abstract void doCloseServerSocket() throws IOException;

    protected abstract U serverSocketAccept() throws Exception;

    protected abstract boolean setSocketOptions(U var1);

    protected void closeSocket(U u) {
        SocketWrapperBase<S> socketWrapperBase = this.connections.get(u);
        if (socketWrapperBase != null) {
            socketWrapperBase.close();
        }
    }

    protected abstract void destroySocket(U var1);

    protected static enum BindState {
        UNBOUND(false, false),
        BOUND_ON_INIT(true, true),
        BOUND_ON_START(true, true),
        SOCKET_CLOSED_ON_STOP(false, true);

        private final boolean bound;
        private final boolean wasBound;

        private BindState(boolean bl, boolean bl2) {
            this.bound = bl;
            this.wasBound = bl2;
        }

        public boolean isBound() {
            return this.bound;
        }

        public boolean wasBound() {
            return this.wasBound;
        }
    }

    public static interface Handler<S> {
        public SocketState process(SocketWrapperBase<S> var1, SocketEvent var2);

        public Object getGlobal();

        public void release(SocketWrapperBase<S> var1);

        public void pause();

        public void recycle();

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG,
            ASYNC_END,
            SENDFILE,
            UPGRADING,
            UPGRADED,
            ASYNC_IO,
            SUSPENDED;

        }
    }
}

