/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.catalina.CredentialHandler;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.catalina.realm.MessageDigestCredentialHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;

public class JAASMemoryLoginModule
extends MemoryRealm
implements LoginModule {
    private static final Log log = LogFactory.getLog(JAASMemoryLoginModule.class);
    protected CallbackHandler callbackHandler = null;
    protected boolean committed = false;
    protected Map<String, ?> options = null;
    protected String pathname = "conf/tomcat-users.xml";
    protected Principal principal = null;
    protected Map<String, ?> sharedState = null;
    protected Subject subject = null;

    public JAASMemoryLoginModule() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MEMORY LOGIN MODULE");
        }
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Abort");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("commit " + this.principal));
        }
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
            if (this.principal instanceof GenericPrincipal) {
                String[] stringArray;
                for (String string : stringArray = ((GenericPrincipal)this.principal).getRoles()) {
                    this.subject.getPrincipals().add(new GenericPrincipal(string));
                }
            }
        }
        this.committed = true;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Init");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        Object obj = map2.get("pathname");
        if (obj instanceof String) {
            this.pathname = (String)obj;
        }
        CredentialHandler credentialHandler = null;
        obj = map2.get("credentialHandlerClassName");
        if (obj instanceof String) {
            try {
                Class<?> clazz = Class.forName((String)obj);
                credentialHandler = (CredentialHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new IllegalArgumentException(reflectiveOperationException);
            }
        }
        if (credentialHandler == null) {
            credentialHandler = new MessageDigestCredentialHandler();
        }
        for (Map.Entry entry : map2.entrySet()) {
            if ("pathname".equals(entry.getKey()) || "credentialHandlerClassName".equals(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
            IntrospectionUtils.setProperty((Object)credentialHandler, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        this.setCredentialHandler(credentialHandler);
        this.load();
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(sm.getString("jaasMemoryLoginModule.noCallbackHandler"));
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new TextInputCallback("nonce"), new TextInputCallback("nc"), new TextInputCallback("cnonce"), new TextInputCallback("qop"), new TextInputCallback("realmName"), new TextInputCallback("digestA2"), new TextInputCallback("algorithm"), new TextInputCallback("authMethod")};
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        try {
            this.callbackHandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[0]).getName();
            string2 = new String(((PasswordCallback)callbackArray[1]).getPassword());
            string3 = ((TextInputCallback)callbackArray[2]).getText();
            string4 = ((TextInputCallback)callbackArray[3]).getText();
            string5 = ((TextInputCallback)callbackArray[4]).getText();
            string6 = ((TextInputCallback)callbackArray[5]).getText();
            string7 = ((TextInputCallback)callbackArray[6]).getText();
            string8 = ((TextInputCallback)callbackArray[7]).getText();
            string9 = ((TextInputCallback)callbackArray[8]).getText();
            string10 = ((TextInputCallback)callbackArray[9]).getText();
        }
        catch (IOException | UnsupportedCallbackException exception) {
            throw new LoginException(sm.getString("jaasMemoryLoginModule.callbackHandlerError", new Object[]{exception.toString()}));
        }
        if (string10 == null) {
            this.principal = super.authenticate(string, string2);
        } else if (string10.equals("DIGEST")) {
            this.principal = super.authenticate(string, string2, string3, string4, string5, string6, string7, string8, string9);
        } else if (string10.equals("CLIENT_CERT")) {
            this.principal = super.getPrincipal(string);
        } else {
            throw new LoginException(sm.getString("jaasMemoryLoginModule.unknownAuthenticationMethod"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("login " + string + " " + this.principal));
        }
        if (this.principal != null) {
            return true;
        }
        throw new FailedLoginException(sm.getString("jaasMemoryLoginModule.invalidCredentials"));
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.committed = false;
        this.principal = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        String string;
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            string = this.getCatalinaBase();
            if (string == null) {
                log.error((Object)sm.getString("jaasMemoryLoginModule.noCatalinaBase", new Object[]{this.pathname}));
                return;
            }
            file = new File(string, this.pathname);
        }
        if (!file.canRead()) {
            log.error((Object)sm.getString("jaasMemoryLoginModule.noConfig", new Object[]{file.getAbsolutePath()}));
            return;
        }
        string = new Digester();
        string.setValidating(false);
        string.addRuleSet((RuleSet)new MemoryRuleSet());
        try {
            string.push((Object)this);
            string.parse(file);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("jaasMemoryLoginModule.parseError", new Object[]{file.getAbsolutePath()}), (Throwable)exception);
        }
        finally {
            string.reset();
        }
    }

    private String getCatalinaBase() {
        if (this.callbackHandler == null) {
            return null;
        }
        Callback[] callbackArray = new Callback[]{new TextInputCallback("catalinaBase")};
        String string = null;
        try {
            this.callbackHandler.handle(callbackArray);
            string = ((TextInputCallback)callbackArray[0]).getText();
        }
        catch (IOException | UnsupportedCallbackException exception) {
            return null;
        }
        return string;
    }
}

