import * as exposes from './exposes';
import { OnEventType, OnEventData, Zh, KeyValue, Tz, Logger, Fz, Expose, OnEvent } from './types';
export declare function onEvent(options?: {
    queryOnDeviceAnnounce?: boolean;
    timeStart?: '1970' | '2000';
}): OnEvent;
export declare function onEventMeasurementPoll(type: OnEventType, data: OnEventData, device: Zh.Device, options: KeyValue, electricalMeasurement?: boolean, metering?: boolean): Promise<void>;
export declare function onEventSetTime(type: OnEventType, data: KeyValue, device: Zh.Device): Promise<void>;
export declare function onEventSetLocalTime(type: OnEventType, data: KeyValue, device: Zh.Device): Promise<void>;
export declare function sendDataPointBool(entity: Zh.Group | Zh.Endpoint, dp: number, value: boolean, cmd?: string, seq?: number): Promise<number>;
export declare function sendDataPointEnum(entity: Zh.Group | Zh.Endpoint, dp: number, value: number, cmd?: string, seq?: number): Promise<number>;
declare const tuyaExposes: {
    lightType: () => exposes.Enum;
    lightBrightnessWithMinMax: () => exposes.Light;
    lightBrightness: () => exposes.Light;
    countdown: () => exposes.Numeric;
    switch: () => exposes.Switch;
    selfTest: () => exposes.Binary;
    selfTestResult: () => exposes.Enum;
    faultAlarm: () => exposes.Binary;
    silence: () => exposes.Binary;
    frostProtection: (extraNote?: string) => exposes.Binary;
    errorStatus: () => exposes.Numeric;
    scheduleAllDays: (access: number, format: string) => exposes.Text[];
    temperatureUnit: () => exposes.Enum;
    temperatureCalibration: () => exposes.Numeric;
    humidityCalibration: () => exposes.Numeric;
    gasValue: () => exposes.Numeric;
    energyWithPhase: (phase: string) => exposes.Numeric;
    energyProducedWithPhase: (phase: string) => exposes.Numeric;
    energyFlowWithPhase: (phase: string) => exposes.Enum;
    voltageWithPhase: (phase: string) => exposes.Numeric;
    powerWithPhase: (phase: string) => exposes.Numeric;
    currentWithPhase: (phase: string) => exposes.Numeric;
    powerFactorWithPhase: (phase: string) => exposes.Numeric;
    switchType: () => exposes.Enum;
    backlightModeLowMediumHigh: () => exposes.Enum;
    backlightModeOffNormalInverted: () => exposes.Enum;
    backlightModeOffOn: () => exposes.Binary;
    indicatorMode: () => exposes.Enum;
    indicatorModeNoneRelayPos: () => exposes.Enum;
    powerOutageMemory: () => exposes.Enum;
    batteryState: () => exposes.Enum;
    doNotDisturb: () => exposes.Binary;
    colorPowerOnBehavior: () => exposes.Enum;
    switchMode: () => exposes.Enum;
    lightMode: () => exposes.Enum;
};
export { tuyaExposes as exposes };
export declare const skip: {
    stateOnAndBrightnessPresent: (meta: Tz.Meta) => boolean;
};
export declare const configureMagicPacket: (device: Zh.Device, coordinatorEndpoint: Zh.Endpoint, logger: Logger) => Promise<void>;
export declare const fingerprint: (modelID: string, manufacturerNames: string[]) => {
    modelID: string;
    manufacturerName: string;
}[];
export declare const whitelabel: (vendor: string, model: string, description: string, manufacturerNames: string[]) => {
    vendor: string;
    model: string;
    description: string;
    fingerprint: {
        manufacturerName: string;
    }[];
};
declare class Base {
    value: number;
    constructor(value: number);
    valueOf(): number;
}
export declare class Enum extends Base {
    constructor(value: number);
}
declare const enumConstructor: (value: number) => Enum;
export { enumConstructor as enum };
export declare class Bitmap extends Base {
    constructor(value: number);
}
export declare const valueConverterBasic: {
    lookup: (map: {
        [s: string]: string | number | boolean | Enum;
    }) => {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    scale: (min1: number, max1: number, min2: number, max2: number) => {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    raw: () => {
        to: (v: string | number | boolean) => string | number | boolean;
        from: (v: string | number | boolean) => string | number | boolean;
    };
    divideBy: (value: number) => {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    trueFalse: (valueTrue: number | Enum) => {
        from: (v: number) => boolean;
    };
};
export declare const valueConverter: {
    trueFalse0: {
        from: (v: number) => boolean;
    };
    trueFalse1: {
        from: (v: number) => boolean;
    };
    trueFalseInvert: {
        to: (v: boolean) => boolean;
        from: (v: boolean) => boolean;
    };
    trueFalseEnum0: {
        from: (v: number) => boolean;
    };
    trueFalseEnum1: {
        from: (v: number) => boolean;
    };
    onOff: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    powerOnBehavior: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    powerOnBehaviorEnum: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    switchType: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    backlightMode: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    lightType: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    countdown: {
        to: (v: string | number | boolean) => string | number | boolean;
        from: (v: string | number | boolean) => string | number | boolean;
    };
    scale0_254to0_1000: {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    scale0_1to0_1000: {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    divideBy100: {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    temperatureUnit: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    temperatureUnitEnum: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    batteryState: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    divideBy10: {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    divideBy1000: {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    switchMode: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    lightMode: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    raw: {
        to: (v: string | number | boolean) => string | number | boolean;
        from: (v: string | number | boolean) => string | number | boolean;
    };
    localTemperatureCalibration: {
        from: (value: number) => number;
        to: (value: number) => number;
    };
    setLimit: {
        to: (v: number) => number;
        from: (v: number) => number;
    };
    coverPosition: {
        to: (v: number, meta: Tz.Meta) => Promise<number>;
        from: (v: number, meta: Fz.Meta, options: KeyValue) => number;
    };
    plus1: {
        from: (v: number) => number;
        to: (v: number) => number;
    };
    static: (value: string | number) => {
        from: (v: string | number) => string | number;
    };
    phaseVariant1: {
        from: (v: string) => {
            voltage: number;
            current: number;
        };
    };
    phaseVariant2: {
        from: (v: string) => {
            voltage: number;
            current: number;
            power: number;
        };
    };
    phaseVariant2WithPhase: (phase: string) => {
        from: (v: string) => {
            [x: string]: number;
        };
    };
    phaseVariant3: {
        from: (v: string) => {
            voltage: number;
            current: number;
            power: number;
        };
    };
    threshold: {
        from: (v: string) => {
            threshold_1_protection: unknown;
            threshold_1: unknown;
            threshold_1_value: number;
            threshold_2_protection: unknown;
            threshold_2: unknown;
            threshold_2_value: number;
        };
    };
    selfTestResult: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    lockUnlock: {
        to: (v: string) => string | number | boolean | Enum;
        from: (v: number) => string;
    };
    localTempCalibration1: {
        from: (v: number) => number;
        to: (v: number) => number;
    };
    localTempCalibration2: {
        from: (v: number) => number;
        to: (v: number) => number;
    };
    thermostatHolidayStartStop: {
        from: (v: string) => string;
        to: (v: string) => string;
    };
    thermostatScheduleDaySingleDP: {
        from: (v: number[]) => string;
        to: (v: KeyValue, meta: Tz.Meta) => unknown[];
    };
    thermostatScheduleDayMultiDP: {
        from: (v: string) => string;
        to: (v: string) => number[];
    };
    thermostatScheduleDayMultiDPWithDayNumber: (dayNum: number) => {
        from: (v: string) => string;
        to: (v: string) => number[];
    };
    TV02SystemMode: {
        to: (v: number, meta: Tz.Meta) => Promise<void>;
        from: (v: boolean) => {
            system_mode: string;
            heating_stop: string;
        };
    };
    TV02FrostProtection: {
        to: (v: unknown, meta: Tz.Meta) => Promise<void>;
        from: (v: unknown) => {
            frost_protection: string;
        };
    };
    inverse: {
        to: (v: boolean) => boolean;
        from: (v: boolean) => boolean;
    };
    onOffNotStrict: {
        from: (v: string) => "ON" | "OFF";
        to: (v: string) => boolean;
    };
    errorOrBatteryLow: {
        from: (v: number) => {
            battery_low: boolean;
            error?: undefined;
        } | {
            error: number;
            battery_low?: undefined;
        };
    };
};
declare const tuyaTz: {
    power_on_behavior_1: Tz.Converter;
    power_on_behavior_2: Tz.Converter;
    switch_type: Tz.Converter;
    backlight_indicator_mode_1: Tz.Converter;
    backlight_indicator_mode_2: Tz.Converter;
    child_lock: Tz.Converter;
    min_brightness: Tz.Converter;
    color_power_on_behavior: Tz.Converter;
    datapoints: Tz.Converter;
    do_not_disturb: Tz.Converter;
};
export { tuyaTz as tz };
declare const tuyaFz: {
    gateway_connection_status: Fz.Converter;
    power_on_behavior_1: Fz.Converter;
    power_on_behavior_2: Fz.Converter;
    power_outage_memory: Fz.Converter;
    switch_type: Fz.Converter;
    backlight_mode_low_medium_high: Fz.Converter;
    backlight_mode_off_normal_inverted: Fz.Converter;
    backlight_mode_off_on: Fz.Converter;
    indicator_mode: Fz.Converter;
    child_lock: Fz.Converter;
    min_brightness: Fz.Converter;
    datapoints: Fz.Converter;
};
export { tuyaFz as fz };
declare const tuyaExtend: {
    switch: (options?: {
        endpoints?: string[];
        powerOutageMemory?: boolean;
        powerOnBehavior2?: boolean;
        switchType?: boolean;
        backlightModeLowMediumHigh?: boolean;
        indicatorMode?: boolean;
        backlightModeOffNormalInverted?: boolean;
        backlightModeOffOn?: boolean;
        electricalMeasurements?: boolean;
        electricalMeasurementsFzConverter?: Fz.Converter;
        childLock?: boolean;
        fromZigbee?: Fz.Converter[];
        toZigbee?: Tz.Converter[];
        exposes?: Expose[];
    }) => {
        exposes: Expose[];
        fromZigbee: Fz.Converter[];
        toZigbee: Tz.Converter[];
    };
    light_onoff_brightness_colortemp_color: (options?: {}) => {
        meta: {
            applyRedFix: boolean;
            supportsEnhancedHue: boolean;
        };
        fromZigbee: Fz.Converter[];
        toZigbee: Tz.Converter[];
        exposes: Expose[];
        configure?: import("./types").Configure;
    };
    light_onoff_brightness_colortemp: (options?: {}) => import("./types").Extend;
    light_onoff_brightness_color: (options?: {}) => {
        meta: {
            applyRedFix: boolean;
            supportsEnhancedHue: boolean;
        };
        fromZigbee: Fz.Converter[];
        toZigbee: Tz.Converter[];
        exposes: Expose[];
        configure?: import("./types").Configure;
    };
    light_onoff_brightness: (options?: {
        endpoints?: string[];
        disablePowerOnBehavior?: boolean;
        minBrightness?: boolean;
        toZigbee?: Tz.Converter[];
        exposes?: Expose[];
        noConfigure?: boolean;
        disableMoveStep?: boolean;
        disableTransition?: boolean;
    }) => import("./types").Extend;
};
export { tuyaExtend as extend };
//# sourceMappingURL=tuya.d.ts.map