##############################################################################
##
#W  cat1data.g                  GAP4 package `XMod'              Chris Wensley
#W                                                                 & Murat Alp
##
##  This file contains data on cat1-groups and crossed modules up to size 70 
##
#Y  Copyright (C) 2001-2020, Chris Wensley et al,  
#Y  School of Computer Science, Bangor University, U.K. 

##############################################################################
##
##  Cat1-structures for iso-classes of gps of size <= CAT1_LIST_MAX_SIZE
##

Info( InfoXMod, 1, "Loading cat1-group data into CAT1_LIST" );

CAT1_LIST := [
[1,1,"1",[[]],[]],
[2,1,"C2",[[1,1]],[]],
[3,1,"C3",[[1,1]],[]],
[4,1,"C4",[[1,1]],[]],
[4,2,"C2 x C2",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1]], [[1,1],[1,1]], [[1,1],[]] ] ]
],
[5,1,"C5",[[1,1]],[]],
[6,1,"S3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[6,2,"C6",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[7,1,"C7",[[1,1]],[]],
[8,1,"C8",[[1,1]],[]],
[8,2,"C4 x C2",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[2,1]], [[],[2,1]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[3,1]] ],
  [ [[2,1]], [[2,1],[2,1]], [[],[2,1]] ] ]
],
[8,3,"D8",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[1,1]], [[1,1],[1,1]] ] ]
],
[8,4,"Q8",[[1,1],[2,1]],[]],
[8,5,"C2 x C2 x C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[1,1]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[1,1],[1,1]] ] ]
],
[9,1,"C9",[[1,1]],[]],
[9,2,"C3 x C3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[1,1]] ] ]
],
[10,1,"D10",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[10,2,"C10",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[11,1,"C11",[[1,1]],[]],
[12,1,"C3 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[12,2,"C12",[[1,1,2,1]],
[ [ [[1,1]], [[1,1]] ],
  [ [[2,1]], [[2,1]] ] ]
],
[12,3,"A4",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[12,4,"D12",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[12,5,"C6 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,3,1]], [[1,1],[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1]], [[1,1],[1,1]], [[],[1,1]] ] ]
],
[13,1,"C13",[[1,1]],[]],
[14,1,"D14",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[14,2,"C14",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[15,1,"C15",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[16,1,"C16",[[1,1]],[]],
[16,2,"C4 x C4",[[1,1],[2,1]],
[ [ [[2,1]], [[],[2,1]] ] ],
[ [ [[2,1]], [[],[2,1]], [[4,1],[2,1]] ],
  [ [[2,1]], [[],[2,1]], [[2,1],[2,1]] ] ]
],
[16,3,"(C4 x C2) : C2",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[2,1]], [[],[2,1]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[4,1]] ] ]
],
[16,4,"C4 : C4",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[4,1]] ] ]
],
[16,5,"C8 x C2",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[2,1]], [[],[2,1]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[4,1]] ],
  [ [[2,1]], [[],[2,1]], [[2,1],[2,1]] ] ]
],
[16,6,"C8 : C2",[[1,1],[2,1]],
[ [ [[2,1]], [[],[2,1]] ] ]
],
[16,7,"D16",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[1,1]] ] ]
],
[16,8,"QD16",[[1,1],[2,1]],
[ [ [[2,1]], [[2,1],[2,1]] ] ]
],
[16,9,"Q16",[[1,1],[2,1]],[]],
[16,10,"C4 x C2 x C2",[[1,1],[2,1],[3,1]],
[ [ [[2,1],[1,1]], [[1,1],[2,1],[]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1]] ],
  [ [[1,1]], [[1,1],[],[]] ],
  [ [[2,1]], [[],[2,1],[]] ] ],
[ [ [[2,1],[1,1]], [[1,1],[2,1],[4,1]], [[1,1],[2,1],[]] ],
  [ [[2,1],[1,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[2,1]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1]], [[2,1],[2,1],[3,1]] ],
  [ [[1,1]], [[1,1],[],[4,1]], [[1,1],[],[]] ],
  [ [[2,1]], [[],[2,1],[]], [[],[2,1],[2,1]] ],
  [ [[2,1]], [[],[2,1],[]], [[2,1],[2,1],[]] ] ]
],
[16,11,"C2 x D8",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[1,1],[3,1]] ],
  [ [[1,1]], [[1,1],[],[]] ],
  [ [[1,1]], [[1,1],[1,1],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[3,1]], [[1,1],[],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[1,1],[3,1]], [[1,1],[1,1,3,1],[3,1]] ] ]
],
[16,12,"C2 x Q8",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[4,1]], [[1,1],[2,1],[]] ] ]
],
[16,13,"(C4 x C2) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1]], [[1,1],[],[]] ] ]
],
[16,14,"C2 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]] ],
  [ [[1,1]], [[1,1],[],[],[]] ] ],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]], [[1,1],[2,1],[3,1],[1,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]], [[1,1],[2,1],[1,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]], [[1,1],[2,1],[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[],[],[]], [[1,1],[1,1],[],[]] ] ]
],
[17,1,"C17",[[1,1]],[]],
[18,1,"D18",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[18,2,"C18",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[18,3,"C3 x S3",[[3,1],[1,1,2,1]],
[ [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[18,4,"(C3 x C3) : C2",[[1,1],[2,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[],[3,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[3,1]], [[1,1],[],[3,1]], [[1,1],[3,2],[]] ] ]
],
[18,5,"C6 x C3",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[3,1]], [[3,1],[]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,2,1]], [[],[1,1,2,1]], [[2,1],[1,1,2,1]] ],
  [ [[3,1]], [[3,1],[]], [[3,1],[3,1]] ] ]
],
[19,1,"C19",[[1,1]],[]],
[20,1,"C5 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[20,2,"C20",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[20,3,"C5 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[20,4,"D20",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[20,5,"C10 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[1,1],[1,1]] ] ]
],
[21,1,"C7 : C3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[21,2,"C21",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[22,1,"D22",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[22,2,"C22",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[23,1,"C23",[[1,1]],[]],
[24,1,"C3 : C8",[[1,1],[4,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[24,2,"C24",[[1,1,2,1]],
[ [ [[1,1]], [[1,1]] ],
  [ [[2,1]], [[2,1]] ] ]
],
[24,3,"SL(2,3)",[[1,1],[2,1]],[]],
[24,4,"C3 : Q8",[[1,1],[2,1,4,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[24,5,"C4 x S3",[[1,1],[2,1,4,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[4,1],[1,1,3,1]], [[1,1,3,1],[4,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]] ] ]
],
[24,6,"D24",[[1,1],[2,1,4,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[4,1],[1,1,2,1]], [[1,1,2,1],[4,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1],[]] ] ]
],
[24,7,"C2 x (C3 : C4)",[[1,1],[2,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1],[4,1]], [[1,1],[4,1]], [[1,1],[3,1,4,1]] ],
  [ [[1,1]], [[1,1],[]], [[1,1],[3,1]] ] ]
],
[24,8,"(C6 x C2) : C2",[[1,1],[2,1,4,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[24,9,"C12 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[2,1],[1,1]], [[2,1],[1,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[4,1],[1,1,3,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]], [[2,1],[2,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[4,1],[1,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[24,10,"C3 x D8",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[1,1]], [[1,1],[1,1]] ] ]
],
[24,11,"C3 x Q8",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ] ]
],
[24,12,"S4",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ] ]
],
[24,13,"C2 x A4",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[2,1]], [[],[2,1]] ] ]
],
[24,14,"C2 x C2 x S3",[[1,1],[3,1],[2,1,4,1]],
[ [ [[1,1],[3,1,4,1]], [[1,1],[3,1],[4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[4,1]], [[1,1],[],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[3,1,4,1]], [[1,1],[3,1],[3,1,4,1]], [[1,1],[3,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[]], [[1,1],[3,1],[3,1]] ] ]
],
[24,15,"C6 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],
[ [ [[3,1],[1,1,4,1]], [[],[3,1],[1,1,4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[2,1],[3,1],[1,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]] ],
  [ [[1,1],[3,1]], [[],[3,1],[1,1]] ],
  [ [[4,1]], [[],[],[4,1]] ],
  [ [[2,1]], [[2,1],[],[]] ] ],
[ [ [[3,1],[1,1,4,1]], [[],[3,1],[1,1,4,1]], [[3,1],[3,1],[1,1,4,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]], [[],[1,1],[1,1,4,1]] ],
  [ [[1,1],[3,1]], [[],[3,1],[1,1]], [[3,1],[3,1],[1,1]] ],
  [ [[2,1]], [[2,1],[],[]], [[2,1],[2,1],[]] ] ]
],
[25,1,"C25",[[1,1]],[]],
[25,2,"C5 x C5",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[1,1]] ] ]
],
[26,1,"D26",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[26,2,"C26",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[27,1,"C27",[[1,1]],[]],
[27,2,"C9 x C3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[2,1]], [[],[2,1]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[3,1]] ],
  [ [[2,1]], [[],[2,1]], [[2,1],[2,1]] ] ]
],
[27,3,"(C3 x C3) : C3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[27,4,"C9 : C3",[[1,1],[2,1]],
[ [ [[2,1]], [[],[2,1]] ] ]
],
[27,5,"C3 x C3 x C3",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[1,1]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[1,1],[]] ] ]
],
[28,1,"C7 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[28,2,"C28",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[28,3,"D28",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[28,4,"C14 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[1,1],[1,1]] ] ]
],
[29,1,"C29",[[1,1]],[]],
[30,1,"C5 x S3",[[3,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[30,2,"C3 x D10",[[3,1],[1,1,2,1]],
[ [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[30,3,"D30",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[30,4,"C30",[[1,1,2,1,3,1]],
[ [ [[2,1,3,1]], [[2,1,3,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1]] ],
  [ [[3,1]], [[3,1]] ],
  [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[31,1,"C31",[[1,1]],[]],
[32,1,"C32",[[1,1]],[]],
[32,2,"(C4 x C2) : C4",[[1,1],[2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ] ],
[ [ [[1,1,2,1]], [[1,1,2,1],[]], [[1,1,2,1,3,1,4,1,5,1],[3,1,4,1,5,1]] ] ]
],
[32,3,"C8 x C4",[[1,1],[2,1]],
[ [ [[1,1,3,1,4,1]], [[1,1,4,1],[]] ],
  [ [[2,1,3,1]], [[],[2,1,3,1]] ] ],
[ [ [[1,1,3,1,4,1]], [[1,1,4,1],[]], [[1,1,4,1],[5,1]] ],
  [ [[1,1,3,1,4,1]], [[1,1,4,1],[]], [[1,1,4,1,5,1],[3,1]] ],
  [ [[2,1,3,1]], [[],[2,1,3,1]], [[4,1,5,1],[2,1,3,1]] ],
  [ [[2,1,3,1]], [[],[2,1,3,1]], [[2,1,3,1,4,1,5,1],[2,1,3,1,4,1,5,1]] ] ]
],
[32,4,"C8 : C4",[[1,1],[2,1]],
[ [ [[2,1,3,1]], [[],[2,1,3,1]] ] ],
[ [ [[2,1,3,1]], [[],[2,1,3,1]], [[4,1,5,1],[2,1,3,1]] ] ]
],
[32,5,"(C8 x C2) : C2",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[2,1]], [[],[2,1]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[5,1]] ] ]
],
[32,6,"((C4 x C2) : C2) : C2",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[1,1]], [[1,1],[4,1]] ] ]
],
[32,7,"(C8 : C2) : C2",[[1,1],[2,1]],[]],
[32,8,"C2 . ((C4 x C2) : C2) = (C2 x C2) . (C4 x C2)",[[1,1],[2,1]],[]],
[32,9,"(C8 x C2) : C2",[[1,1],[2,1]],
[ [ [[2,1]], [[2,1],[2,1]] ] ]
],
[32,10,"Q8 : C4",[[1,1],[2,1]],[]],
[32,11,"(C4 x C4) : C2",[[1,1],[2,1]],
[ [ [[2,1]], [[2,1],[2,1]] ] ]
],
[32,12,"C4 : C8",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1]], [[1,1],[5,1]], [[1,1],[]] ] ]
],
[32,13,"C8 : C4",[[1,1],[2,1]],
[ [ [[1,1,2,1]], [[1,1,2,1],[]] ] ],
[ [ [[1,1,2,1]], [[1,1,2,1],[]], [[1,1,2,1,4,1,5,1],[4,1,5,1]] ] ]
],
[32,14,"C8 : C4",[[1,1],[2,1]],
[ [ [[1,1,2,1]], [[1,1,2,1],[]] ] ],
[ [ [[1,1,2,1,4,1]], [[1,1,2,1,4,1],[4,1]], [[1,1,2,1],[]] ] ]
],
[32,15,"C4 . D8 = C4 . (C4 x C2)",[[1,1],[2,1]],[]],
[32,16,"C16 x C2",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ],
  [ [[2,1]], [[],[2,1]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[5,1]] ],
  [ [[2,1]], [[],[2,1]], [[2,1],[2,1]] ] ]
],
[32,17,"C16 : C2",[[1,1],[2,1]],
[ [ [[2,1]], [[],[2,1]] ] ]
],
[32,18,"D32",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[1,1]] ] ]
],
[32,19,"QD32",[[1,1],[2,1]],
[ [ [[2,1]], [[2,1],[2,1]] ] ]
],
[32,20,"Q32",[[1,1],[2,1]],[]],
[32,21,"C4 x C4 x C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]] ],
  [ [[1,1]], [[1,1],[],[]] ],
  [ [[3,1]], [[],[],[3,1]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]], [[1,1],[4,1],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]], [[1,1],[3,1],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]], [[1,1],[1,1],[3,1]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[4,1],[]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[],[4,1]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[1,1],[]] ],
  [ [[3,1]], [[],[],[3,1]], [[3,1],[],[3,1]] ] ]
],
[32,22,"C2 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]] ],
  [ [[3,1],[1,1,2,1]], [[1,1,2,1],[],[3,1]] ],
  [ [[2,1],[3,1,4,1]], [[],[2,1],[3,1,4,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1],[],[]] ],
  [ [[2,1]], [[],[2,1],[]] ] ],
[ [ [[1,1],[2,1,3,1,5,1]], [[1,1],[2,1,3,1,5,1],[5,1]],
    [[1,1],[2,1,3,1,4,1,5,1],[4,1,5,1]] ],
  [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]],
    [[1,1],[2,1,3,1,4,1,5,1],[4,1,5,1]] ],
  [ [[3,1],[1,1,2,1,3,1]], [[1,1,2,1,3,1],[3,1],[3,1]],
    [[1,1,2,1,3,1,4,1,5,1],[3,1,4,1,5,1],[3,1]] ],
  [ [[3,1],[1,1,2,1]], [[1,1,2,1],[],[3,1]],
    [[1,1,2,1,3,1,4,1,5,1],[3,1,4,1,5,1],[3,1]] ],
  [ [[2,1],[3,1,4,1]], [[3,1,4,1],[2,1],[3,1,4,1]], [[],[2,1],[3,1,4,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1],[],[]], [[1,1,2,1,4,1,5,1],[4,1,5,1],[]] ],
  [ [[1,1,2,1]], [[1,1,2,1],[],[]], [[1,1,2,1],[],[4,1,5,1]] ] ]
],
[32,23,"C2 x (C4 : C4)",[[1,1],[2,1],[3,1]],
[ [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1],[]] ],
  [ [[1,1],[3,1,4,1]], [[1,1],[],[3,1,4,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[2,1],[1,1,3,1,4,1]], [[1,1,3,1,4,1],[2,1],[4,1]], [[1,1,3,1],[2,1],[]] ],
  [ [[2,1],[1,1,3,1,5,1]], [[1,1,3,1,5,1],[2,1],[5,1]], [[1,1,3,1],[2,1],[]] ],
  [ [[2,1],[1,1,3,1,5,1]], [[1,1,3,1,5,1],[2,1],[5,1]],
    [[1,1,3,1,4,1],[2,1],[4,1]] ],
  [ [[1,1],[3,1,4,1]], [[1,1],[],[3,1,4,1]], [[1,1],[5,1],[3,1,4,1]] ],
  [ [[1,1],[3,1,4,1]], [[1,1],[3,1,4,1],[3,1,4,1]], [[1,1],[5,1],[3,1,4,1]] ],
  [ [[1,1]], [[1,1],[5,1],[]], [[1,1],[],[]] ],
  [ [[1,1]], [[1,1],[],[5,1]], [[1,1],[],[]] ] ]
],
[32,24,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1]], [[1,1],[],[]] ],
  [ [[2,1]], [[],[2,1],[]] ] ],
[ [ [[1,1]], [[1,1],[],[]], [[1,1],[5,1],[]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[],[5,1]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[5,1],[5,1]] ] ]
],
[32,25,"C4 x D8",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[3,1]], [[1,1],[],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[1,1,3,1],[3,1]] ],
  [ [[2,1,5,1],[1,1,3,1,5,1]], [[1,1,3,1,5,1],[2,1,5,1],[]] ],
  [ [[2,1]], [[],[2,1],[]] ],
  [ [[2,1]], [[2,1],[2,1],[]] ] ],
[ [ [[2,1,5,1],[1,1,3,1,5,1]], [[1,1,3,1,5,1],[2,1,5,1],[]],
    [[1,1,3,1,4,1,5,1],[2,1,5,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]], [[1,1],[5,1],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[1,1,3,1],[3,1]],
    [[1,1],[1,1,3,1,5,1],[3,1]] ] ]
],
[32,26,"C4 x Q8",[[1,1],[2,1],[3,1]],
[ [ [[2,1],[1,1,3,1,5,1]], [[1,1,3,1,5,1],[2,1],[4,1]] ] ],
[ [ [[2,1],[1,1,3,1,4,1,5,1]], [[1,1,3,1,4,1,5,1],[2,1],[]],
    [[1,1,3,1,5,1],[2,1],[4,1]] ] ]
],
[32,27,"(C2 x C2 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1,3,1,4,1]], [[1,1],[],[2,1,3,1,4,1]] ],
  [ [[2,1],[3,1]], [[3,1],[2,1],[3,1]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[2,1,3,1,5,1]], [[1,1],[2,1,3,1,5,1],[]],
    [[1,1],[2,1,3,1,4,1],[4,1,5,1]] ],
  [ [[1,1],[2,1,3,1,5,1]], [[1,1],[2,1,3,1,5,1],[]],
    [[1,1],[],[2,1,3,1,4,1]] ] ]
],
[32,28,"(C4 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],
[ [ [[3,1],[1,1,2,1]], [[1,1,2,1],[],[3,1]] ],
  [ [[1,1],[2,1,5,1]], [[1,1],[2,1,5,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[3,1],[1,1,2,1,5,1]], [[1,1,2,1,5,1],[5,1],[3,1]],
    [[1,1,2,1],[],[3,1]] ],
  [ [[1,1],[2,1,5,1]], [[1,1],[2,1,5,1],[4,1]],
    [[1,1],[2,1,5,1],[]] ] ]
],
[32,29,"(C2 x Q8) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1,5,1]], [[1,1],[2,1,5,1],[]] ] ],
[ [ [[1,1],[2,1,5,1]], [[1,1],[2,1,5,1],[]], [[1,1],[2,1,5,1],[4,1]] ] ]
],
[32,30,"(C4 x C2 x C2) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1]], [[1,1],[],[]] ] ]
],
[32,31,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1]], [[1,1],[],[]] ] ]
],
[32,32,"(C2 x C2) . (C2 x C2 x C2)",[[1,1],[2,1],[3,1]],[]],
[32,33,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1]], [[1,1],[],[]] ] ]
],
[32,34,"(C4 x C4) : C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1,3,1],[2,1,5,1]], [[1,1,3,1],[2,1,5,1],[]] ],
  [ [[1,1,2,1,3,1]], [[1,1,2,1,3,1],[],[]] ] ],
[ [ [[1,1,3,1],[2,1,5,1]], [[1,1,3,1],[2,1,5,1],[]],
    [[1,1,3,1,4,1],[2,1,5,1],[4,1]] ],
  [ [[1,1,3,1],[2,1,5,1]], [[1,1,3,1],[2,1,5,1],[]],
    [[1,1,2,1,3,1,5,1],[2,1,4,1,5,1],[2,1,4,1,5,1]] ] ]
],
[32,35,"C4 : Q8",[[1,1],[2,1],[3,1]],
[ [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1],[]] ] ],
[ [ [[2,1],[1,1,3,1,4,1]], [[1,1,3,1,4,1],[2,1],[4,1]],
    [[1,1,3,1],[2,1],[]] ],
  [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1],[]],
    [[1,1,2,1,3,1,4,1],[2,1],[2,1]] ] ]
],
[32,36,"C8 x C2 x C2",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1]] ],
  [ [[2,1]], [[],[2,1],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[5,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[2,1]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[5,1],[]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1]], [[2,1],[2,1],[3,1]] ],
  [ [[2,1]], [[],[2,1],[]], [[],[2,1],[2,1]] ],
  [ [[2,1]], [[],[2,1],[]], [[2,1],[2,1],[]] ] ]
],
[32,37,"C2 x (C8 : C2)",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1]] ],
  [ [[2,1]], [[],[2,1],[]] ] ],
[ [ [[1,1],[2,1,3,1,5,1]], [[1,1],[2,1,3,1,5,1],[5,1]],
    [[1,1],[2,1,3,1],[]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1]], [[3,1],[2,1],[3,1]] ] ]
],
[32,38,"(C8 x C2) : C2",[[1,1],[2,1],[3,1]],
[ [ [[2,1]], [[],[2,1],[]] ] ]
],
[32,39,"C2 x D16",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ],
  [ [[2,1],[3,1,5,1]], [[2,1],[2,1],[3,1,5,1]] ],
  [ [[2,1]], [[2,1],[2,1],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[5,1]], [[1,1],[2,1],[]] ],
  [ [[2,1],[3,1,5,1]], [[2,1,3,1,5,1],[2,1],[3,1,5,1]],
    [[2,1],[2,1],[3,1,5,1]] ] ]
],
[32,40,"C2 x QD16",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]] ],
  [ [[2,1],[3,1,5,1]], [[2,1],[2,1],[3,1,5,1]] ],
  [ [[2,1,3,1]], [[2,1,3,1],[2,1,3,1],[]] ] ],
[ [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]], [[1,1],[2,1,3,1,5,1],[5,1]] ],
  [ [[2,1],[3,1,5,1]], [[2,1,3,1,5,1],[2,1],[3,1,5,1]],
      [[2,1],[2,1],[3,1,5,1]] ] ]
],
[32,41,"C2 x Q16",[[1,1],[2,1],[3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[5,1]] ] ]
],
[32,42,"(C8 x C2) : C2",[[1,1],[2,1],[3,1]],
[ [ [[2,1]], [[2,1],[2,1],[]], [[2,1],[2,1],[]] ] ]
],
[32,43,"(C2 x D8) : C2",[[1,1],[2,1],[3,1]],
[ [ [[2,1],[3,1]], [[2,1],[2,1],[3,1]] ] ]
],
[32,44,"(C2 x Q8) : C2",[[1,1],[2,1],[3,1]],[]],
[32,45,"C4 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]] ],
  [ [[2,1],[3,1],[4,1]], [[],[2,1],[3,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1],[]] ],
  [ [[1,1]], [[1,1],[],[],[]] ],
  [ [[2,1]], [[],[2,1],[],[]] ] ],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]], [[1,1],[2,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]], [[1,1],[2,1],[3,1],[3,1]] ],
  [ [[2,1],[3,1],[4,1]], [[],[2,1],[3,1],[4,1]], [[2,1],[2,1],[3,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]], [[1,1],[2,1],[5,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]], [[1,1],[2,1],[2,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]], [[1,1],[2,1],[2,1],[5,1]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1],[]], [[],[2,1],[3,1],[3,1]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1],[]], [[2,1],[2,1],[3,1],[]] ],
  [ [[2,1],[3,1]], [[],[2,1],[3,1],[]], [[2,1],[2,1],[3,1],[3,1]] ],
  [ [[1,1]], [[1,1],[],[],[]], [[1,1],[5,1],[],[]] ],
  [ [[2,1]], [[],[2,1],[],[]], [[],[2,1],[2,1],[]] ],
  [ [[2,1]], [[],[2,1],[],[]], [[2,1],[2,1],[],[]] ] ]
],
[32,46,"C2 x C2 x D8",[[1,1],[2,1],[3,1],[4,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]] ],
  [ [[1,1],[3,1],[4,1]], [[1,1],[],[3,1],[4,1]] ],
  [ [[1,1],[3,1],[4,1]], [[1,1],[1,1],[3,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1],[]] ],
  [ [[1,1],[3,1]], [[1,1],[1,1],[3,1],[]] ],
  [ [[1,1]], [[1,1],[],[],[]] ],
  [ [[1,1]], [[1,1],[1,1],[],[]] ] ],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]], [[1,1],[2,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]], [[1,1],[2,1],[3,1],[3,1]] ],
  [ [[1,1],[3,1],[4,1]], [[1,1],[],[3,1],[4,1]], [[1,1],[3,1],[3,1],[4,1]] ],
  [ [[1,1],[3,1],[4,1]], [[1,1],[1,1],[3,1],[4,1]], 
      [[1,1],[1,1,4,1],[3,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]], [[1,1],[2,1],[5,1],[]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1],[]], [[1,1],[],[3,1],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1],[]], [[1,1],[3,1],[3,1],[]] ],
  [ [[1,1],[3,1]], [[1,1],[1,1],[3,1],[]], [[1,1],[1,1],[3,1],[3,1]] ],
  [ [[1,1],[3,1]], [[1,1],[1,1],[3,1],[]], [[1,1],[1,1,3,1],[3,1],[]] ] ]
],
[32,47,"C2 x C2 x Q8",[[1,1],[2,1],[3,1],[4,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]] ] ],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]], [[1,1],[2,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[]], [[1,1],[2,1],[3,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[]], [[1,1],[2,1],[5,1],[]] ] ]
],
[32,48,"C2 x ((C4 x C2) : C2)",[[1,1],[2,1],[3,1],[4,1]],
[ [ [[2,1],[1,1,4,1],[3,1,4,1]], [[1,1,4,1],[2,1],[3,1,4,1],[]] ],
  [ [[1,1],[4,1,5,1]], [[1,1],[],[],[4,1,5,1]] ],
  [ [[1,1,2,1,3,1]], [[],[1,1,2,1,3,1],[],[]] ] ],
[ [ [[2,1],[1,1,4,1],[3,1,4,1]], [[1,1,4,1],[2,1],[3,1,4,1],[]],
    [[1,1,4,1,5,1],[2,1],[3,1,4,1,5,1],[5,1]] ], 
  [ [[1,1],[4,1,5,1]], [[1,1],[],[],[4,1,5,1]],
    [[1,1],[],[4,1,5,1],[4,1,5,1]] ],
  [ [[1,1],[4,1,5,1]], [[1,1],[4,1,5,1],[],[4,1,5,1]],
    [[1,1],[],[4,1,5,1],[4,1,5,1]] ],
  [ [[1,1],[4,1,5,1]], [[1,1],[],[],[4,1,5,1]],
    [[1,1],[4,1,5,1],[],[4,1,5,1]] ] ]
],
[32,49,"(C2 x D8) : C2",[[1,1],[2,1],[3,1],[4,1]],
[ [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1],[],[]] ],
  [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1],[],[1,1,3,1]] ] ],
[ [ [[2,1],[1,1,3,1]], [[],[2,1],[1,1,3,1],[]],
    [[1,1,3,1],[2,1],[],[2,1]] ],
  [ [[2,1],[1,1,3,1]], [[2,1],[2,1],[1,1,2,1,3,1,5,1],[1,1,3,1]],
    [[1,1,2,1,3,1,5,1],[2,1],[2,1],[1,1,2,1,3,1,5,1]] ] ]
],
[32,50,"(C2 x Q8) : C2",[[1,1],[2,1],[3,1],[4,1]],[]],
[32,51,"C2 x C2 x C2 x C2 x C2",[[1,1],[2,1],[3,1],[4,1],[5,1]],
[ [ [[1,1],[2,1],[3,1],[4,1]], [[1,1],[2,1],[3,1],[4,1],[]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[],[]] ],
  [ [[1,1]], [[1,1],[],[],[],[]] ] ],
[ [ [[1,1],[2,1],[3,1],[4,1]], [[1,1],[2,1],[3,1],[4,1],[]],
    [[1,1],[2,1],[3,1],[4,1],[1,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[],[]],
    [[1,1],[2,1],[3,1],[1,1],[]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[2,1],[3,1],[],[]],
    [[1,1],[2,1],[3,1],[1,1],[2,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[],[]], [[1,1],[2,1],[1,1],[],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[],[],[]], [[1,1],[2,1],[1,1],[2,1],[]] ],
  [ [[1,1]], [[1,1],[],[],[],[]], [[1,1],[1,1],[],[],[]] ] ]
],
[33,1,"C33",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[34,1,"D34",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[34,2,"C34",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[35,1,"C35",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[36,1,"C9 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[36,2,"C36",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[36,3,"(C2 x C2) : C9",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[36,4,"D36",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[36,5,"C18 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[36,6,"C3 x (C3 : C4)",[[4,1],[1,1,2,1]],
[ [ [[1,1],[4,1]], [[4,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[36,7,"(C3 x C3) : C4",[[1,1],[3,1],[3,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[],[4,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[4,1]], [[1,1],[],[4,1]], [[1,1],[4,2],[]] ] ]
],
[36,8,"C12 x C3",[[3,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[3,1]], [[3,1],[]] ] ],
[ [ [[1,1,2,1]], [[],[1,1,2,1]], [[2,1],[1,1,2,1]] ],
  [ [[3,1]], [[3,1],[]], [[3,1],[3,1]] ] ]
],
[36,9,"(C3 x C3) : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[36,10,"S3 x S3",[[1,1,3,1],[2,1,4,1]],
[ [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ] ],
[ [ [[1,1,2,1],[3,1,4,1]], [[3,1,4,1],[1,1,2,1]], [[1,1,2,1],[3,1,4,1]] ] ]
],
[36,11,"C3 x A4",[[1,1],[2,1,3,1]],
[ [ [[3,1],[1,1,2,1]], [[1,1,2,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1,2,2]], [[1,1,2,2],[]] ] ]
],
[36,12,"C6 x S3",[[1,1,3,1],[2,1,4,1]],
[ [ [[4,1],[1,1,2,1,3,1]], [[1,1,2,1,3,1],[4,1]] ],
  [ [[1,1],[2,1,4,1]], [[1,1],[2,1,4,1]] ],
  [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]] ],
  [ [[4,1],[1,1,2,1]], [[1,1,2,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[36,13,"C2 x ((C3 x C3) : C2)",[[1,1],[3,2],[2,1,3,1,4,1]],
[ [ [[1,1],[3,1],[3,1,4,1]], [[1,1],[3,2],[3,1,4,1]] ],
  [ [[1,1],[2,1,4,1]], [[1,1],[],[2,1,4,1]] ],
  [ [[1,1],[3,1,4,1]], [[1,1],[],[3,1,4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[],[2,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[2,1,4,1]], [[1,1],[4,2],[2,1,4,2]], [[1,1],[],[2,1,4,1]] ],
  [ [[1,1],[3,1,4,1]], [[1,1],[3,2,4,2],[3,1,4,1]], [[1,1],[],[3,1,4,1]] ] ]
],
[36,14,"C6 x C6",[[1,1,3,1],[2,1,4,1]],
[ [ [[1,1,3,1],[4,1]], [[1,1,3,1],[4,1]] ],
  [ [[1,1,3,1],[2,1]], [[1,1,3,1],[2,1]] ],
  [ [[3,1],[4,1]], [[3,1],[4,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[3,1]], [[3,1],[]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1,3,1],[4,1]], [[1,1,3,1],[4,1]], [[1,1,3,1],[1,1,4,1]] ],
  [ [[1,1,3,1],[2,1]], [[1,1,3,1],[2,1]], [[1,1,3,1],[2,1,3,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]], [[1,1,3,1],[1,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]], [[1,1,3,1],[3,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]], [[1,1,3,1],[1,1,3,1]] ],
  [ [[3,1]], [[3,1],[]], [[3,1],[3,1]] ],
  [ [[1,1]], [[1,1],[]], [[1,1],[1,1]] ] ]
],
[37,1,"C37",[[1,1]],[]],
[38,1,"D38",[[1,1],[2,1]],[
[[[1,1]],
  [[1,1],[]],
  [[1,1],[]]]]],
[38,2,"C38",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[39,1,"C13 : C3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[39,2,"C39",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[40,1,"C5 : C8",[[1,1],[4,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[40,2,"C40",[[1,1,2,1]],
[ [ [[1,1]], [[1,1]] ],
  [ [[2,1]], [[2,1]] ] ]
],
[40,3,"C5 : C8",[[1,1],[4,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[40,4,"C5 : Q8",[[1,1],[2,1,4,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[40,5,"C4 x D10",[[1,1],[2,1,4,1]],
[ [ [[4,1],[1,1,3,1]], [[1,1,3,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]] ] ]
],
[40,6,"D40",[[1,1],[2,1,4,1]],
[ [ [[4,1],[1,1,2,1]], [[1,1,2,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1],[]] ] ]
],
[40,7,"C2 x (C5 : C4)",[[1,1],[2,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1],[4,1]], [[1,1],[4,1]], [[1,1],[3,1,4,1]] ],
  [ [[1,1]], [[1,1],[3,1]], [[1,1],[]] ] ]
],
[40,8,"(C10 x C2) : C2",[[1,1],[2,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[40,9,"C20 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[4,1],[1,1,3,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]], [[2,1],[2,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[4,1],[1,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[40,10,"C5 x D8",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[1,1]], [[1,1],[1,1]] ] ]
],
[40,11,"C5 x Q8",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ] ]
],
[40,12,"C2 x (C5 : C4)",[[1,1],[2,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[40,13,"C2 x C2 x D10",[[1,1],[3,1],[2,1,4,1]],
[ [ [[1,1],[3,1,4,1]], [[1,1],[3,1],[4,1]] ],
  [ [[1,1],[4,1]], [[1,1],[],[4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[3,1,4,1]], [[1,1],[3,1],[4,1]], [[1,1],[3,1],[3,1,4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[3,1]], [[1,1],[3,1],[]] ] ]
],
[40,14,"C10 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],
[ [ [[2,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[2,1],[3,1],[1,1]] ],
  [ [[4,1]], [[],[],[4,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[]] ],
  [ [[2,1]], [[2,1],[],[]] ] ],
[ [ [[2,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]], [[2,1],[2,1],[1,1,4,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]], [[1,1],[],[1,1,4,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[]], [[2,1],[3,1],[3,1]] ],
  [ [[2,1]], [[2,1],[],[]], [[2,1],[2,1],[]] ] ]
],
[41,1,"C41",[[1,1]],[]],
[42,1,"(C7 : C3) : C2",[[3,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ] ] 
],
[42,2,"C2 x (C7 : C3)",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[2,1]], [[],[2,1]] ] ]
],
[42,3,"C7 x S3",[[3,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[42,4,"C3 x D14",[[3,1],[1,1,2,1]],
[ [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[42,5,"D42",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[42,6,"C42",[[1,1,2,1,3,1]],
[ [ [[2,1,3,1]], [[2,1,3,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1]] ],
  [ [[3,1]], [[3,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1]] ],
  [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[43,1,"C43",[[1,1]],[]],
[44,1,"C11 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[44,2,"C44",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[44,3,"D44",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[44,4,"C22 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[1,1],[1,1]] ] ]
],
[45,1,"C45",[[1,1,2,1]],
[ [ [[1,1]], [[1,1]] ],
  [ [[2,1]], [[2,1]] ] ]
],
[45,2,"C15 x C3",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[46,1,"D46",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[46,2,"C46",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[47,1,"C47",[[1,1]],[]],
[48,1,"C3 : C16",[[1,1],[5,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[48,2,"C48",[[1,1,2,1]],
[ [ [[1,1]], [[1,1]] ],
  [ [[2,1]], [[2,1]] ] ]
],
[48,3,"(C4 x C4) : C3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[48,4,"C8 x S3",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[5,1],[1,1,4,1]], [[1,1,4,1],[5,1]] ],
  [ [[1,1,4,1]], [[1,1,4,1],[]] ] ]
],
[48,5,"C24 : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[48,6,"C24 : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[48,7,"D48",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[48,8,"C3 : Q16",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[48,9,"C2 x (C3 : C8)",[[1,1],[2,1,5,1]],
[ [ [[1,1],[5,1]], [[1,1],[5,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1],[5,1]], [[1,1],[4,1,5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[4,1]], [[1,1],[]] ] ]
],
[48,10,"(C3 : C8) : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[48,11,"C4 x (C3 : C4)",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[5,1],[1,1,4,1]], [[1,1,4,1],[5,1]] ],
  [ [[1,1,4,1]], [[1,1,4,1],[]] ] ],
[ [ [[5,1],[1,1,4,1]], [[1,1,4,1],[5,1]], [[1,1,4,1],[3,1,5,1]] ],
  [ [[1,1,4,1]], [[1,1,4,1],[3,1]], [[1,1,4,1],[]] ] ]
],
[48,12,"(C3 : C4) : C4",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[48,13,"C12 : C4",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1],[5,1]], [[1,1],[5,1]], [[1,1],[3,1,5,1]] ],
  [ [[1,1]], [[1,1],[3,1]], [[1,1],[]] ] ]
],
[48,14,"(C12 x C2) : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[48,15,"(C3 x D8) : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[48,16,"(C3 : C8) : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[48,17,"(C3 x Q8) : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[48,18,"C3 : Q16",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[48,19,"(C2 x (C3 : C4)) : C2",[[1,1],[2,1,5,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1],[5,1]], [[1,1],[3,1,5,1]], [[1,1],[5,1]] ],
  [ [[1,1]], [[1,1],[3,1]], [[1,1],[]] ] ]
],
[48,20,"C12 x C4",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[2,1]], [[2,1],[]] ],
  [ [[3,1]], [[],[3,1]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[4,1],[1,1,3,1]] ],
  [ [[1,1,3,1]], [[],[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[5,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[48,21,"C3 x ((C4 x C2) : C2)",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[2,1,3,1,5,1]], [[2,1,5,1],[3,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[5,1],[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[5,1],[1,1]] ] ]
],
[48,22,"C3 x (C4 : C4)",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,3,1]], [[5,1],[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[5,1],[1,1]] ] ]
],
[48,23,"C24 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[5,1],[1,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[5,1],[1,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]], [[2,1],[2,1,3,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[48,24,"C3 x (C8 : C2)",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]] ],
  [ [[2,1]], [[2,1],[]] ] ]
],
[48,25,"C3 x D16",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[2,1,3,1]], [[2,1],[2,1,3,1]] ],
  [ [[1,1]], [[1,1],[1,1]] ] ]
],
[48,26,"C3 x QD16",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[2,1,3,1]], [[2,1],[2,1,3,1]] ],
  [ [[2,1]], [[2,1],[2,1]] ] ]
],
[48,27,"C3 x Q16",[[2,1],[1,1,3,1]],
[ [ [[1,1],[2,1]], [[2,1],[1,1]] ] ]
],
[48,28,"C2 . S4 = SL(2,3) . C2",[[2,1],[1,1,3,1]],[]],
[48,29,"GL(2,3)",[[2,1],[1,1,3,1]],[]],
[48,30,"A4 : C4",[[3,1],[1,1,4,1]],
[ [ [[1,1],[3,1]], [[3,1],[1,1]] ] ]
],
[48,31,"C4 x A4",[[4,1],[1,1,2,1]],
[ [ [[2,1],[4,1]], [[4,1],[2,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[2,1]], [[],[2,1]] ] ]
],
[48,32,"C2 x SL(2,3)",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ] ],
[ [ [[2,1],[3,1]], [[3,1],[2,1]], [[3,1],[2,1,5,1]] ] ]
],
[48,33,"SL(2,3) : C2",[[3,1],[1,1,2,1]],[]],
[48,34,"C2 x (C3 : Q8)",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[]] ] ],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]], [[1,1],[3,1],[4,1,5,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[4,1]], [[1,1],[3,1],[]] ] ]
],
[48,35,"C2 x C4 x S3",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1,4,1],[2,1,5,1]], [[1,1,4,1],[],[2,1,5,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[]] ],
  [ [[5,1],[1,1,2,1]], [[1,1,2,1],[],[5,1]] ],
  [ [[1,1],[2,1]], [[1,1],[],[2,1]] ],
  [ [[1,1,4,1]], [[1,1,4,1],[],[]] ] ],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[4,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1,4,1],[2,1,5,1]], [[1,1,4,1],[2,1],[2,1,5,1]], 
      [[1,1,4,1],[],[2,1,5,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[4,1]], [[1,1],[3,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]], [[1,1],[],[2,1]] ] ]
],
[48,36,"C2 x D24",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[2,1,4,1,5,1]], [[1,1],[],[2,1,4,1,5,1]] ],
  [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]] ],
  [ [[5,1],[1,1,3,1]], [[1,1,3,1],[],[5,1]] ],
  [ [[1,1],[2,1]], [[1,1],[],[2,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[],[]] ] ],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]], [[1,1],[3,1],[4,1,5,1]] ],
  [ [[1,1],[2,1,4,1,5,1]], [[1,1],[],[2,1,4,1,5,1]],
      [[1,1],[2,1,4,1],[2,1,4,1,5,1]] ],
  [ [[1,1],[2,1,3,1,4,1]], [[1,1],[2,1,3,1,4,1],[4,1]], [[1,1],[2,1,3,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]], [[1,1],[],[2,1]] ] ]
],
[48,37,"(C12 x C2) : C2",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[],[5,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ]
],
[48,38,"D8 x S3",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[2,1,5,1]], [[1,1],[],[2,1,5,1]] ],
  [ [[1,1],[2,1,5,1]], [[1,1],[2,1],[2,1,5,1]] ],
  [ [[1,1],[2,1]], [[1,1],[],[2,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]] ] ]
],
[48,39,"(C2 x (C3 : C4)) : C2",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ] ]
],
[48,40,"Q8 x S3",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ] ]
],
[48,41,"(C4 x S3) : C2",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ] ]
],
[48,42,"C2 x C2 x (C3 : C4)",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[5,1]], [[1,1],[],[5,1]] ],
  [ [[3,1],[1,1,2,1]], [[1,1,2,1],[3,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[4,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[3,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1],[5,1]], [[1,1],[],[5,1]], [[1,1],[4,1],[4,1,5,1]] ],
  [ [[3,1],[1,1,2,1,3,1]], [[1,1,2,1,3,1],[3,1],[3,1]],
      [[1,1,2,1,3,1,4,1],[3,1],[3,1,4,1]] ],
  [ [[3,1],[1,1,2,1]], [[1,1,2,1],[3,1],[]],
      [[1,1,2,1,3,1,4,1],[3,1],[3,1,4,1]] ],
  [ [[1,1]], [[1,1],[],[]], [[1,1],[4,1],[4,1]] ] ]
],
[48,43,"C2 x ((C6 x C2) : C2)",[[1,1],[3,1],[2,1,5,1]],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[2,1,5,1]], [[1,1],[],[2,1,5,1]] ],
  [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]] ],
  [ [[5,1],[1,1,2,1]], [[1,1,2,1],[],[5,1]] ],
  [ [[1,1],[2,1]], [[1,1],[],[2,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1],[],[]] ] ],
[ [ [[1,1],[3,1,5,1]], [[1,1],[3,1],[5,1]], [[1,1],[3,1],[4,1,5,1]] ],
  [ [[1,1],[2,1,5,1]], [[1,1],[2,1],[2,1,5,1]], [[1,1],[],[2,1,5,1]] ],
  [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1],[]], [[1,1],[2,1,3,1,4,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]], [[1,1],[],[2,1]] ] ]
],
[48,44,"C12 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],
[ [ [[1,1,4,1],[2,1]], [[2,1],[],[1,1,4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[2,1],[3,1],[1,1]] ],
  [ [[2,1,4,1],[3,1]], [[2,1],[3,1],[4,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]] ],
  [ [[1,1],[2,1]], [[2,1],[],[1,1]] ],
  [ [[2,1,4,1]], [[2,1],[],[4,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[]] ],
  [ [[1,1]], [[],[],[1,1]] ],
  [ [[4,1]], [[],[],[4,1]] ],
  [ [[2,1]], [[2,1],[],[]] ] ],
[ [ [[1,1,4,1],[2,1]], [[2,1],[],[1,1,4,1]], [[2,1],[5,1],[1,1,4,1]] ],
  [ [[1,1,4,1],[2,1]], [[2,1],[],[1,1,4,1]], [[2,1],[2,1],[1,1,4,1]] ],
  [ [[2,1,4,1],[3,1]], [[2,1],[3,1],[4,1]], [[2,1],[3,1],[2,1,4,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]], [[5,1],[],[1,1,4,1]] ],
  [ [[1,1],[2,1]], [[2,1],[],[1,1]], [[2,1],[5,1],[1,1]] ],
  [ [[1,1],[2,1]], [[2,1],[],[1,1]], [[2,1],[2,1],[1,1]] ],
  [ [[2,1,4,1]], [[2,1],[],[4,1]], [[2,1],[2,1],[4,1]] ],
  [ [[2,1,4,1]], [[2,1],[],[4,1]], [[2,1],[],[2,1,4,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[]], [[2,1],[3,1],[3,1]] ],
  [ [[1,1]], [[],[],[1,1]], [[5,1],[],[1,1]] ],
  [ [[2,1]], [[2,1],[],[]], [[2,1],[2,1],[]] ],
  [ [[2,1]], [[2,1],[],[]], [[2,1],[],[2,1]] ] ]
],
[48,45,"C6 x D8",[[2,1],[3,1],[1,1,4,1]],
[ [ [[2,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[2,1],[3,1],[1,1]] ],
  [ [[3,1],[1,1,4,1]], [[],[3,1],[1,1,4,1]] ],
  [ [[3,1],[1,1,4,1]], [[1,1],[3,1],[1,1,4,1]] ],
  [ [[1,1],[2,1]], [[2,1],[],[1,1]] ],
  [ [[1,1,3,1,4,1]], [[],[],[1,1,3,1,4,1]] ],
  [ [[1,1,3,1,4,1]], [[1,1,3,1],[],[1,1,3,1,4,1]] ],
  [ [[2,1],[3,1,5,1]], [[2,1],[3,1,5,1],[]] ],
  [ [[2,1],[3,1,5,1]], [[2,1],[3,1,5,1],[2,1]] ],
  [ [[1,1]], [[],[],[1,1]] ],
  [ [[1,1]], [[1,1],[],[1,1]] ] ],
[ [ [[2,1],[1,1,4,1]], [[2,1],[5,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]] ],
  [ [[3,1],[1,1,4,1]], [[],[3,1],[1,1,4,1]], [[3,1],[3,1],[1,1,4,1]] ],
  [ [[3,1],[1,1,4,1]], [[1,1],[3,1],[1,1,4,1]], [[1,1,3,1],[3,1],[1,1,4,1]] ],
  [ [[1,1],[2,1]], [[2,1],[5,1],[1,1]], [[2,1],[],[1,1]] ],
  [ [[2,1],[3,1,5,1]], [[2,1],[3,1,5,1],[3,1,5,1]], [[2,1],[3,1,5,1],[]] ],
  [ [[2,1],[3,1,5,1]], [[2,1],[3,1,5,1],[2,1]], 
      [[2,1],[3,1,5,1],[2,1,3,1,5,1]] ] ]
],
[48,46,"C6 x Q8",[[2,1],[3,1],[1,1,4,1]],
[ [ [[2,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[2,1],[3,1],[1,1]] ],
  [ [[1,1],[2,1]], [[2,1],[],[1,1]] ] ],
[ [ [[2,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]], [[2,1],[5,1],[1,1,4,1]] ],
  [ [[1,1],[2,1]], [[2,1],[5,1],[1,1]], [[2,1],[],[1,1]] ] ]
],
[48,47,"C3 x ((C4 x C2) : C2)",[[2,1],[3,1],[1,1,4,1]],
[ [ [[1,1],[2,1],[3,1]], [[2,1],[3,1],[1,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]] ],
  [ [[1,1]], [[],[],[1,1]] ] ]
],
[48,48,"C2 x S4",[[1,1,4,1],[2,1,3,1]],
[ [ [[3,1],[1,1,4,1]], [[1,1,4,1],[3,1]] ],
  [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1]] ],
  [ [[3,1],[1,1,2,1]], [[1,1,2,1],[3,1]] ] ]
],
[48,49,"C2 x C2 x A4",[[1,1,3,1],[2,1,4,1]],
[ [ [[4,1],[1,1,2,1,3,1]], [[1,1,2,1,3,1],[4,1]] ],
  [ [[3,1],[4,1]], [[3,1],[4,1]] ],
  [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1]] ],
  [ [[1,1,2,1,3,1]], [[1,1,2,1,3,1],[]] ],
  [ [[3,1]], [[3,1],[]] ] ],
[ [ [[4,1],[1,1,2,1,3,1]], [[3,1],[1,1,2,1,4,1]], [[1,1,2,1,3,1],[4,1]] ],
  [ [[1,1,2,1,3,1]], [[3,1],[1,1,2,1]], [[1,1,2,1,3,1],[]] ] ]
],
[48,50,"(C2 x C2 x C2 x C2) : C3",[[1,1],[2,1],[2,1,4,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[]], [[1,1],[2,1],[2,1]] ] ]
],
[48,51,"C2 x C2 x C2 x S3",[[1,1],[3,1],[4,1],[2,1,5,1]],
[ [ [[1,1,3,1],[2,1,5,1],[3,1,4,1]], [[1,1,3,1],[],[3,1,4,1],[2,1,5,1]] ],
  [ [[1,1],[2,1],[3,1],[4,1]], [[1,1],[3,1],[4,1],[2,1]] ],
  [ [[1,1,3,1],[2,1,3,1,5,1]], [[1,1,3,1],[],[],[2,1,3,1,5,1]] ],
  [ [[1,1],[3,1],[4,1]], [[1,1],[3,1],[4,1],[]] ],
  [ [[5,1],[1,1,3,1]], [[1,1,3,1],[],[],[5,1]] ],
  [ [[1,1,3,1],[2,1,3,1]], [[1,1,3,1],[],[],[2,1,3,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[],[],[]] ] ],
[ [ [[1,1,4,1],[2,1,5,1],[3,1,4,1]], [[1,1,4,1],[3,1,4,1],[],[2,1,5,1]],
      [[1,1,3,1],[],[3,1,4,1],[2,1,5,1]] ],
  [ [[1,1,2,1],[2,1,3,1,5,1]], [[1,1,2,1],[2,1,3,1],[],[5,1]],
      [[1,1,3,1],[],[],[2,1,3,1,5,1]] ],
  [ [[1,1],[3,1],[4,1]], [[1,1],[3,1],[4,1],[]], [[1,1],[3,1],[4,1],[4,1]] ],
  [ [[1,1,2,1],[2,1,3,1]], [[1,1,2,1],[2,1,3,1],[],[]],
      [[1,1,3,1],[],[],[2,1,3,1]] ] ]
],
[48,52,"C6 x C2 x C2 x C2",[[2,1],[3,1],[4,1],[1,1,5,1]],
[ [ [[2,1],[3,1],[1,1,5,1]], [[2,1],[3,1],[],[1,1,5,1]] ],
  [ [[1,1],[2,1],[3,1],[4,1]], [[2,1],[3,1],[4,1],[1,1]] ],
  [ [[2,1],[1,1,5,1]], [[2,1],[],[],[1,1,5,1]] ],
  [ [[2,1],[3,1],[4,1]], [[2,1],[3,1],[4,1],[]] ],
  [ [[1,1,5,1]], [[],[],[],[1,1,5,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[],[]] ],
  [ [[5,1]], [[],[],[],[5,1]] ],
  [ [[2,1]], [[2,1],[],[],[]] ] ],
[ [ [[2,1],[3,1],[1,1,5,1]], [[2,1],[3,1],[],[1,1,5,1]], 
      [[2,1],[3,1],[3,1],[1,1,5,1]] ],
  [ [[2,1],[1,1,5,1]], [[2,1],[],[],[1,1,5,1]], [[2,1],[2,1],[],[1,1,5,1]] ],
  [ [[2,1],[1,1,5,1]], [[2,1],[],[],[1,1,5,1]], [[2,1],[2,1],[1,1],[1,1,5,1]] ],
  [ [[2,1],[3,1],[4,1]], [[2,1],[3,1],[4,1],[]], [[2,1],[3,1],[4,1],[4,1]] ],
  [ [[1,1,5,1]], [[],[],[],[1,1,5,1]], [[1,1],[],[],[1,1,5,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[],[]], [[2,1],[3,1],[2,1],[]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[],[]], [[2,1],[3,1],[2,1],[3,1]] ],
  [ [[2,1]], [[2,1],[],[],[]], [[2,1],[2,1],[],[]] ] ]
],
[49,1,"C49",[[1,1]],[]],
[49,2,"C7 x C7",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1]], [[1,1],[]], [[1,1],[1,1]] ] ]
],
[50,1,"D50",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[50,2,"C50",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[50,3,"C5 x D10",[[3,1],[1,1,2,1]],
[ [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[50,4,"(C5 x C5) : C2",[[1,1],[2,1],[2,1,3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]], [[1,1],[2,1],[2,3]] ] ]
],
[50,5,"C10 x C5",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[3,1]], [[3,1],[]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,2,1]], [[],[1,1,2,1]], [[2,1],[1,1,2,1]] ],
  [ [[3,1]], [[3,1],[]], [[3,1],[3,1]] ] ]
],
[51,1,"C51",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[52,1,"C13 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[52,2,"C52",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[52,3,"C13 : C4",[[1,1],[3,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[52,4,"D52",[[1,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[52,5,"C26 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[53,1,"C53",[[1,1]],[]],
[54,1,"D54",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[54,2,"C54",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[54,3,"C3 x D18",[[3,1],[1,1,2,1]],
[ [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[54,4,"C9 x S3",[[4,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1],[4,1]], [[4,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[54,5,"((C3 x C3) : C3) : C2",[[3,1],[1,1,2,1]],
[ [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ] ]
],
[54,6,"(C9 : C3) : C2",[[3,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ] ]
],
[54,7,"(C9 x C3) : C2",[[1,1],[2,1],[2,1,3,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[2,1]], [[1,1],[2,1],[2,1]], [[1,1],[2,1],[2,1,4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[],[3,1]], [[1,1],[3,2],[]] ] ]
],
[54,8,"((C3 x C3) : C3) : C2",[[1,1],[2,1],[2,1,3,1]],
[ [ [[1,1],[3,1]], [[1,1],[],[3,1]] ] ]
],
[54,9,"C18 x C3",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[2,1]], [[],[2,1]] ],
  [ [[1,1,3,1]], [[3,1],[1,1]] ],
  [ [[3,1]], [[3,1],[]] ],
  [ [[1,1]], [[],[1,1]] ] ],
[ [ [[1,1,2,1]], [[],[1,1,2,1]], [[4,1],[1,1,2,1]] ],
  [ [[2,1]], [[],[2,1]], [[4,1],[2,1]] ],
  [ [[1,1,3,1]], [[3,1],[1,1]], [[3,1],[1,1,3,1]] ],
  [ [[3,1]], [[3,1],[]], [[3,1],[3,1]] ] ]
],
[54,10,"C2 x ((C3 x C3) : C3)",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1,3,1]], [[3,1],[1,1]] ],
  [ [[3,1]], [[3,1],[]] ] ]
],
[54,11,"C2 x (C9 : C3)",[[3,1],[1,1,2,1]],
[ [ [[2,1],[3,1]], [[3,1],[2,1]] ],
  [ [[1,1,3,1]], [[3,1],[1,1]] ],
  [ [[3,1]], [[3,1],[]] ] ]
],
[54,12,"C3 x C3 x S3",[[1,1,2,1],[3,1,4,1]],
[ [ [[3,1],[1,1,2,1]], [[1,1,2,1],[3,1]] ],
  [ [[4,1],[1,1,3,1]], [[1,1],[3,1,4,1]] ],
  [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1,3,1]], [[1,1],[3,1]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[4,1],[1,1,3,1]], [[1,1],[3,1,4,1]], [[1,1,3,2],[3,1,4,1]] ],
  [ [[1,1,3,1]], [[1,1],[3,1]], [[1,1,3,1],[3,1]] ] ]
],
[54,13,"C3 x ((C3 x C3) : C2)",[[3,1],[1,1,2,1],[3,1,4,1]],
[ [ [[1,1],[3,1],[3,1,4,1]], [[3,1],[1,1],[3,1,4,1]] ],
  [ [[4,1],[1,1,2,1]], [[],[1,1,2,1],[4,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1],[]] ],
  [ [[1,1],[4,1]], [[],[1,1],[4,1]] ],
  [ [[1,1]], [[],[1,1],[]] ] ],
[ [ [[4,1],[1,1,2,1]], [[],[1,1,2,1],[4,1]], [[4,2],[1,1,2,1],[]] ],
  [ [[1,1],[4,1]], [[4,1],[1,1],[4,2]], [[],[1,1],[4,1]] ] ]
],
[54,14,"(C3 x C3 x C3) : C2",[[1,1],[2,1],[3,1],[2,1,3,1,4,1]],
[ [ [[1,1],[2,1,3,1,4,1],[2,1,4,2]], 
      [[1,1],[2,1,4,2],[3,1,4,2],[2,1,3,1,4,1]] ],
  [ [[1,1],[2,1,3,2]], [[1,1],[2,1,3,2],[],[2,1,3,2]] ],
  [ [[1,1]], [[1,1],[],[],[]] ] ],
[ [ [[1,1],[2,2,3,1],[2,2,4,1]], [[1,1],[],[2,2,3,1],[2,1,3,1,4,1]],
      [[1,1],[2,1,4,2],[3,1,4,2],[2,1,3,1,4,1]] ],
  [ [[1,1],[2,1,3,2]], [[1,1],[2,1,3,2],[],[2,1,3,2]],
      [[1,1],[2,2,3,1],[2,1,3,2],[2,2,3,1]] ] ]
],
[54,15,"C6 x C3 x C3",[[3,1],[4,1],[1,1,2,1]],
[ [ [[2,1],[3,1],[4,1]], [[3,1],[4,1],[2,1]] ],
  [ [[3,1],[1,1,2,1]], [[3,1],[],[1,1,2,1]] ],
  [ [[3,1],[4,1]], [[3,1],[4,1],[]] ],
  [ [[1,1,2,1]], [[],[],[1,1,2,1]] ],
  [ [[3,1]], [[3,1],[],[]] ],
  [ [[1,1]], [[],[],[1,1]] ] ],
[ [ [[3,1],[1,1,2,1]], [[3,1],[],[1,1,2,1]], [[3,1],[3,1],[1,1,2,1]] ],
  [ [[3,1],[4,1]], [[3,1],[4,1],[]], [[3,1],[4,1],[4,1]] ],
  [ [[1,1,2,1]], [[],[],[1,1,2,1]], [[2,1],[],[1,1,2,1]] ],
  [ [[3,1]], [[3,1],[],[]], [[3,1],[3,1],[]] ] ]
],
[55,1,"C11 : C5",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[55,2,"C55",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[56,1,"C7 : C8",[[1,1],[4,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[56,2,"C56",[[1,1,2,1]],
[ [ [[1,1]], [[1,1]] ],
  [ [[2,1]], [[2,1]] ] ]
],
[56,3,"C7 : Q8",[[1,1],[2,1,4,1]],
[ [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[56,4,"C4 x D14",[[1,1],[2,1,4,1]],
[ [ [[4,1],[1,1,3,1]], [[1,1,3,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]] ] ]
],
[56,5,"D56",[[1,1],[2,1,4,1]],
[ [ [[4,1],[1,1,2,1]], [[1,1,2,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1],[]] ] ]
],
[56,6,"C2 x (C7 : C4)",[[1,1],[2,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ],
[ [ [[1,1],[4,1]], [[1,1],[4,1]], [[1,1],[3,1,4,1]] ],
  [ [[1,1]], [[1,1],[]], [[1,1],[3,1]] ] ]
],
[56,7,"(C14 x C2) : C2",[[1,1],[2,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[56,8,"C28 x C2",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1]], [[],[1,1,3,1]], [[4,1],[1,1,3,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]], [[2,1],[2,1,3,1]] ],
  [ [[1,1]], [[],[1,1]], [[4,1],[1,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
],
[56,9,"C7 x D8",[[2,1],[1,1,3,1]],
[ [ [[1,1,3,1]], [[],[1,1,3,1]] ],
  [ [[1,1,3,1]], [[1,1],[1,1,3,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ],
  [ [[1,1]], [[1,1],[1,1]] ] ]
],
[56,10,"C7 x Q8",[[2,1],[1,1,3,1]],
[ [[[1,1],[2,1]], [[2,1],[1,1]] ] ]
],
[56,11,"(C2 x C2 x C2) : C7",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[56,12,"C2 x C2 x D14",[[1,1],[3,1],[2,1,4,1]],
[ [ [[1,1],[3,1,4,1]], [[1,1],[3,1],[4,1]] ],
  [ [[1,1],[4,1]], [[1,1],[],[4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[1,1],[3,1],[2,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[]] ],
  [ [[1,1]], [[1,1],[],[]] ] ],
[ [ [[1,1],[3,1,4,1]], [[1,1],[3,1],[3,1,4,1]], [[1,1],[3,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1],[]], [[1,1],[3,1],[3,1]] ] ]
],
[56,13,"C14 x C2 x C2",[[2,1],[3,1],[1,1,4,1]],
[ [ [[2,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]] ],
  [ [[1,1],[2,1],[3,1]], [[2,1],[3,1],[1,1]] ],
  [ [[4,1]], [[],[],[4,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[]] ],
  [ [[2,1]], [[2,1],[],[]] ] ],
[ [ [[2,1],[1,1,4,1]], [[2,1],[],[1,1,4,1]], [[2,1],[2,1],[1,1,4,1]] ],
  [ [[1,1,4,1]], [[],[],[1,1,4,1]], [[1,1],[],[1,1,4,1]] ],
  [ [[2,1],[3,1]], [[2,1],[3,1],[]], [[2,1],[3,1],[3,1]] ],
  [ [[2,1]], [[2,1],[],[]], [[2,1],[2,1],[]] ] ]
],
[57,1,"C19 : C3",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[57,2,"C57",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[58,1,"D58",[[1,1],[2,1]],
[ [ [[1,1]], [[1,1],[]] ] ]
],
[58,2,"C58",[[1,1,2,1]],
[ [ [[2,1]], [[2,1]] ],
  [ [[1,1]], [[1,1]] ] ]
],
[59,1,"C59",[[1,1]],[]],
[60,1,"C5 x (C3 : C4)",[[4,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1],[4,1]], [[4,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[60,2,"C3 x (C5 : C4)",[[4,1],[1,1,2,1]],
[ [ [[1,1],[4,1]], [[4,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[60,3,"C15 : C4",[[1,1],[3,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[60,4,"C60",[[1,1,2,1,3,1]],
[ [ [[1,1,3,1]], [[1,1,3,1]] ],
  [ [[2,1,3,1]], [[2,1,3,1]] ],
  [ [[1,1,2,1]], [[1,1,2,1]] ],
  [ [[3,1]], [[3,1]] ],
  [ [[1,1]], [[1,1]] ],
  [ [[2,1]], [[2,1]] ] ]
],
[60,5,"A5",[ (1,2,3,4,5), (1,2,3) ],[]],
[60,6,"C3 x (C5 : C4)",[[4,1],[1,1,2,1]],
[ [ [[1,1],[4,1]], [[4,1],[1,1]] ],
  [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[60,7,"C15 : C4",[[1,1],[3,1,4,1]],
[ [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[60,8,"S3 x D10",[[1,1,3,1],[2,1,4,1]],
[ [ [[1,1],[2,1,4,1]], [[1,1],[2,1,4,1]] ],
  [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ] ]
],
[60,9,"C5 x A4",[[3,1],[1,1,2,1]],
[ [ [[1,1,2,1]], [[],[1,1,2,1]] ],
  [ [[1,1],[3,1]], [[3,1],[1,1]] ],
  [ [[1,1]], [[],[1,1]] ] ]
],
[60,10,"C6 x D10",[[1,1,3,1],[2,1,4,1]],
[ [ [[4,1],[1,1,3,1]], [[1,1,3,1],[4,1]] ],
  [ [[1,1],[2,1,4,1]], [[1,1],[2,1,4,1]] ],
  [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1]] ],
  [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[60,11,"C10 x S3",[[1,1,3,1],[2,1,4,1]],
[ [ [[4,1],[1,1,3,1]], [[1,1,3,1],[4,1]] ],
  [ [[2,1],[1,1,3,1]], [[1,1,3,1],[2,1]] ],
  [ [[1,1],[2,1,4,1]], [[1,1],[2,1,4,1]] ],
  [ [[1,1,3,1]], [[1,1,3,1],[]] ],
  [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[60,12,"D60",[[1,1],[2,1,3,1,4,1]],
[ [ [[1,1],[3,1,4,1]], [[1,1],[3,1,4,1]] ],
  [ [[1,1],[2,1,4,1]], [[1,1],[2,1,4,1]] ],
  [ [[1,1],[2,1,3,1]], [[1,1],[2,1,3,1]] ],
  [ [[1,1],[4,1]], [[1,1],[4,1]] ],
  [ [[1,1],[3,1]], [[1,1],[3,1]] ],
  [ [[1,1],[2,1]], [[1,1],[2,1]] ],
  [ [[1,1]], [[1,1],[]] ] ]
],
[60,13,"C30 x C2",[[2,1],[1,1,3,1,4,1]],
[ [ [[1,1,3,1,4,1]], [[],[1,1,3,1,4,1]] ],
  [ [[2,1],[1,1,4,1]], [[2,1],[1,1,4,1]] ],
  [ [[3,1,4,1]], [[],[3,1,4,1]] ],
  [ [[2,1],[1,1,3,1]], [[2,1],[1,1,3,1]] ],
  [ [[1,1,4,1]], [[],[1,1,4,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]] ],
  [ [[4,1]], [[],[4,1]] ],
  [ [[1,1],[2,1]], [[2,1],[1,1]] ],
  [ [[3,1]], [[],[3,1]] ],
  [ [[2,1]], [[2,1],[]] ] ],
[ [ [[1,1,3,1,4,1]], [[],[1,1,3,1,4,1]], [[1,1],[1,1,3,1,4,1]] ],
  [ [[1,1,4,1]], [[],[1,1,4,1]], [[1,1],[1,1,4,1]] ],
  [ [[2,1,3,1]], [[2,1],[3,1]], [[2,1],[2,1,3,1]] ],
  [ [[2,1]], [[2,1],[]], [[2,1],[2,1]] ] ]
] 
];
CAT1_LIST_LOADED := true;
