# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 Ilia Bozhinov
# Copyright © 2020 Isaac Freund
# Copyright © 2022 wb9688
# Copyright © 2023 i509VCB
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations


from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .ext_foreign_toplevel_handle_v1 import ExtForeignToplevelHandleV1


class ExtForeignToplevelListV1(Interface):
    """List toplevels

    A toplevel is defined as a surface with a role similar to
    :class:`~pywayland.protocol.xdg_shell.XdgToplevel`. XWayland surfaces may
    be treated like toplevels in this protocol.

    After a client binds the :class:`ExtForeignToplevelListV1`, each mapped
    toplevel window will be sent using the
    :func:`ExtForeignToplevelListV1.toplevel()` event.

    Clients which only care about the current state can perform a roundtrip
    after binding this global.

    For each instance of :class:`ExtForeignToplevelListV1`, the compositor must
    create a new
    :class:`~pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelHandleV1`
    object for each mapped toplevel.

    If a compositor implementation sends the
    :func:`ExtForeignToplevelListV1.finished()` event after the global is
    bound, the compositor must not send any
    :func:`ExtForeignToplevelListV1.toplevel()` events.
    """

    name = "ext_foreign_toplevel_list_v1"
    version = 1


class ExtForeignToplevelListV1Proxy(Proxy[ExtForeignToplevelListV1]):
    interface = ExtForeignToplevelListV1

    @ExtForeignToplevelListV1.request()
    def stop(self) -> None:
        """Stop sending events

        This request indicates that the client no longer wishes to receive
        events for new toplevels.

        The Wayland protocol is asynchronous, meaning the compositor may send
        further toplevel events until the stop request is processed. The client
        should wait for a :func:`ExtForeignToplevelListV1.finished()` event
        before destroying this object.
        """
        self._marshal(0)

    @ExtForeignToplevelListV1.request()
    def destroy(self) -> None:
        """Destroy the :class:`ExtForeignToplevelListV1` object

        This request should be called either when the client will no longer use
        the :class:`ExtForeignToplevelListV1` or after the finished event has
        been received to allow destruction of the object.

        If a client wishes to destroy this object it should send a
        :func:`ExtForeignToplevelListV1.stop()` request and wait for a
        :func:`ExtForeignToplevelListV1.finished()` event, then destroy the
        handles and then this object.
        """
        self._marshal(1)
        self._destroy()


class ExtForeignToplevelListV1Resource(Resource):
    interface = ExtForeignToplevelListV1

    @ExtForeignToplevelListV1.event(
        Argument(ArgumentType.NewId, interface=ExtForeignToplevelHandleV1),
    )
    def toplevel(self, toplevel: ExtForeignToplevelHandleV1) -> None:
        """A toplevel has been created

        This event is emitted whenever a new toplevel window is created. It is
        emitted for all toplevels, regardless of the app that has created them.

        All initial properties of the toplevel (identifier, title, app_id) will
        be sent immediately after this event using the corresponding events for
        :class:`~pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelHandleV1`.
        The compositor will use the :func:`ExtForeignToplevelHandleV1.done()
        <pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelHandleV1.done>`
        event to indicate when all data has been sent.

        :param toplevel:
        :type toplevel:
            :class:`~pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelHandleV1`
        """
        self._post_event(0, toplevel)

    @ExtForeignToplevelListV1.event()
    def finished(self) -> None:
        """The compositor has finished with the toplevel manager

        This event indicates that the compositor is done sending events to this
        object. The client should should destroy the object. See
        :func:`ExtForeignToplevelListV1.destroy()` for more information.

        The compositor must not send any more toplevel events after this event.
        """
        self._post_event(1)


class ExtForeignToplevelListV1Global(Global):
    interface = ExtForeignToplevelListV1


ExtForeignToplevelListV1._gen_c()
ExtForeignToplevelListV1.proxy_class = ExtForeignToplevelListV1Proxy
ExtForeignToplevelListV1.resource_class = ExtForeignToplevelListV1Resource
ExtForeignToplevelListV1.global_class = ExtForeignToplevelListV1Global
