/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.contributions.VersionComparator;
import com.thizzer.jtouchbar.JTouchBar;
import com.thizzer.jtouchbar.item.TouchBarItem;
import com.thizzer.jtouchbar.item.view.TouchBarButton;
import com.thizzer.jtouchbar.item.view.TouchBarView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Theme;
import processing.app.helpers.OSUtils;

public class EditorToolbar
extends JComponent
implements MouseInputListener,
KeyEventDispatcher {
    private static final String[] title = new String[]{I18n.tr((String)"Verify"), I18n.tr((String)"Upload"), I18n.tr((String)"New"), I18n.tr((String)"Open"), I18n.tr((String)"Save"), I18n.tr((String)"Serial Monitor")};
    private static final String[] titleShift = new String[]{I18n.tr((String)"Verify"), I18n.tr((String)"Upload Using Programmer"), I18n.tr((String)"New"), I18n.tr((String)"Open"), I18n.tr((String)"Save As..."), I18n.tr((String)"Serial Plotter")};
    private static final int BUTTON_COUNT = title.length;
    private static final int BUTTON_WIDTH = Theme.scale(27);
    private static final int BUTTON_HEIGHT = Theme.scale(32);
    private static final int BUTTON_GAP = Theme.scale(5);
    private static final int BUTTON_IMAGE_SIZE = Theme.scale(33);
    private static final int RUN = 0;
    private static final int EXPORT = 1;
    private static final int NEW = 2;
    private static final int OPEN = 3;
    private static final int SAVE = 4;
    private static final int SERIAL = 5;
    private static final int INACTIVE = 0;
    private static final int ROLLOVER = 1;
    private static final int ACTIVE = 2;
    private final Editor editor;
    private Image offscreen;
    private int width;
    private int height;
    private final Color bgcolor;
    private static Image[][] buttonImages;
    private static com.thizzer.jtouchbar.common.Image[][] touchBarImages;
    private int currentRollover;
    private JPopupMenu popup;
    private final JMenu menu;
    private JTouchBar touchBar;
    private TouchBarButton[] touchBarButtons;
    private int buttonCount;
    private int[] state = new int[BUTTON_COUNT];
    private Image[] stateImage;
    private final int[] which;
    private int[] x1;
    private int[] x2;
    private int y1;
    private int y2;
    private final Font statusFont;
    private final Color statusColor;
    private boolean shiftPressed;

    public EditorToolbar(final Editor editor, JMenu menu) {
        this.editor = editor;
        this.menu = menu;
        this.buttonCount = 0;
        this.which = new int[BUTTON_COUNT];
        this.which[this.buttonCount++] = 0;
        this.which[this.buttonCount++] = 1;
        this.which[this.buttonCount++] = 2;
        this.which[this.buttonCount++] = 3;
        this.which[this.buttonCount++] = 4;
        this.which[this.buttonCount++] = 5;
        this.currentRollover = -1;
        this.bgcolor = Theme.getColor("buttons.bgcolor");
        this.statusFont = Theme.getFont("buttons.status.font");
        this.statusColor = Theme.getColor("buttons.status.color");
        if (OSUtils.isMacOS() && VersionComparator.greaterThanOrEqual((String)OSUtils.version(), (String)"10.12")) {
            editor.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (EditorToolbar.this.touchBar == null) {
                        EditorToolbar.this.buildTouchBar();
                        EditorToolbar.this.touchBar.show((Component)editor);
                    }
                }
            });
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    private void buildTouchBar() {
        if (touchBarImages == null) {
            this.loadTouchBarImages();
        }
        this.touchBar = new JTouchBar();
        this.touchBarButtons = new TouchBarButton[BUTTON_COUNT];
        this.touchBar.setCustomizationIdentifier("Arduino");
        for (int i = 0; i < BUTTON_COUNT; ++i) {
            final int selection = i;
            if (i == 2) {
                this.touchBar.addItem(new TouchBarItem("NSTouchBarItemIdentifierFixedSpaceSmall"));
            } else if (i == 5) {
                this.touchBar.addItem(new TouchBarItem("NSTouchBarItemIdentifierFlexibleSpace"));
            }
            this.touchBarButtons[i] = new TouchBarButton();
            this.touchBarButtons[i].setImage(touchBarImages[i][1]);
            this.touchBarButtons[i].setAction(event -> EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorToolbar.this.handleSelectionPressed(selection);
                }
            }));
            TouchBarItem touchBarItem = new TouchBarItem(title[i], (TouchBarView)this.touchBarButtons[i], true);
            touchBarItem.setCustomizationLabel(title[i]);
            this.touchBar.addItem(touchBarItem);
        }
    }

    private void loadButtons() {
        Image allButtons = Theme.getThemeImage("buttons", this, BUTTON_IMAGE_SIZE * BUTTON_COUNT, BUTTON_IMAGE_SIZE * 3);
        buttonImages = new Image[BUTTON_COUNT][3];
        for (int i = 0; i < BUTTON_COUNT; ++i) {
            for (int state = 0; state < 3; ++state) {
                Image image = this.createImage(BUTTON_WIDTH, BUTTON_HEIGHT);
                Graphics g = image.getGraphics();
                g.setColor(this.bgcolor);
                g.fillRect(0, 0, BUTTON_WIDTH, BUTTON_HEIGHT);
                int offset = (BUTTON_IMAGE_SIZE - BUTTON_WIDTH) / 2;
                g.drawImage(allButtons, -(i * BUTTON_IMAGE_SIZE) - offset, (-2 + state) * BUTTON_IMAGE_SIZE, null);
                EditorToolbar.buttonImages[i][state] = image;
            }
        }
    }

    private void loadTouchBarImages() {
        Image allButtonsRetina = Theme.getThemeImage("buttons", this, BUTTON_IMAGE_SIZE * BUTTON_COUNT * 2, BUTTON_IMAGE_SIZE * 3 * 2);
        touchBarImages = new com.thizzer.jtouchbar.common.Image[BUTTON_COUNT][3];
        for (int i = 0; i < BUTTON_COUNT; ++i) {
            for (int state = 0; state < 3; ++state) {
                BufferedImage image = new BufferedImage(BUTTON_WIDTH * 2, BUTTON_HEIGHT * 2, 2);
                Graphics g = image.getGraphics();
                int offset = (BUTTON_IMAGE_SIZE * 2 - BUTTON_WIDTH * 2) / 2;
                g.drawImage(allButtonsRetina, -(i * BUTTON_IMAGE_SIZE * 2) - offset, (-2 + state) * BUTTON_IMAGE_SIZE * 2, null);
                ByteArrayOutputStream pngStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "PNG", pngStream);
                    EditorToolbar.touchBarImages[i][state] = new com.thizzer.jtouchbar.common.Image(pngStream.toByteArray());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics screen) {
        int i;
        if (buttonImages == null) {
            this.loadButtons();
        }
        if (this.stateImage == null) {
            this.state = new int[this.buttonCount];
            this.stateImage = new Image[this.buttonCount];
            for (int i2 = 0; i2 < this.buttonCount; ++i2) {
                this.setState(i2, 0, false);
            }
            this.y1 = 0;
            this.y2 = BUTTON_HEIGHT;
            this.x1 = new int[this.buttonCount];
            this.x2 = new int[this.buttonCount];
        }
        Dimension size = this.getSize();
        if (this.offscreen == null || size.width != this.width || size.height != this.height) {
            this.offscreen = this.createImage(size.width, size.height);
            this.width = size.width;
            this.height = size.height;
            int offsetX = 3;
            for (i = 0; i < this.buttonCount; ++i) {
                this.x1[i] = offsetX;
                if (i == 2 || i == 6) {
                    int n = i;
                    this.x1[n] = this.x1[n] + BUTTON_GAP;
                }
                this.x2[i] = this.x1[i] + BUTTON_WIDTH;
                offsetX = this.x2[i];
            }
            this.x1[5] = this.width - BUTTON_WIDTH - 14;
            this.x2[5] = this.width - 14;
        }
        Graphics2D g = Theme.setupGraphics2D(this.offscreen.getGraphics());
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.width, this.height);
        for (i = 0; i < this.buttonCount; ++i) {
            g.drawImage(this.stateImage[i], this.x1[i], this.y1, null);
        }
        g.setColor(this.statusColor);
        g.setFont(this.statusFont);
        if (this.currentRollover != -1) {
            String status;
            int statusY = (BUTTON_HEIGHT + g.getFontMetrics().getAscent()) / 2;
            String string = status = this.shiftPressed ? titleShift[this.currentRollover] : title[this.currentRollover];
            if (this.currentRollover != 5) {
                g.drawString(status, (this.buttonCount - 1) * BUTTON_WIDTH + 3 * BUTTON_GAP, statusY);
            } else {
                int statusX = this.x1[5] - BUTTON_GAP;
                g.drawString(status, statusX -= g.getFontMetrics().stringWidth(status), statusY);
            }
        }
        screen.drawImage(this.offscreen, 0, 0, null);
        if (!this.isEnabled()) {
            screen.setColor(new Color(0, 0, 0, 100));
            screen.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.state == null) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, false);
        }
        this.handleMouse(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private void handleMouse(MouseEvent e) {
        int sel;
        int x = e.getX();
        int y = e.getY();
        if (this.currentRollover != -1) {
            if (x > this.x1[this.currentRollover] && y > this.y1 && x < this.x2[this.currentRollover] && y < this.y2) {
                return;
            }
            this.setState(this.currentRollover, 0, true);
            this.currentRollover = -1;
        }
        if ((sel = this.findSelection(x, y)) == -1) {
            return;
        }
        if (this.state[sel] != 2) {
            this.setState(sel, 1, true);
            this.currentRollover = sel;
        }
    }

    private int findSelection(int x, int y) {
        if (this.x1 == null || this.x2 == null) {
            return -1;
        }
        for (int i = 0; i < this.buttonCount; ++i) {
            if (y <= this.y1 || x <= this.x1[i] || y >= this.y2 || x >= this.x2[i]) continue;
            return i;
        }
        return -1;
    }

    private void setState(int slot, int newState, boolean updateAfter) {
        this.state[slot] = newState;
        this.stateImage[slot] = buttonImages[this.which[slot]][newState];
        if (updateAfter) {
            this.repaint();
        }
        if (this.touchBarButtons != null) {
            if (newState == 0) {
                newState = 1;
            }
            this.touchBarButtons[slot].setImage(touchBarImages[slot][newState]);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.handleMouse(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, true);
        }
        this.handleMouse(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        if (!this.isEnabled()) {
            return;
        }
        int x = e.getX();
        int sel = this.findSelection(x, y = e.getY());
        if (sel == -1) {
            return;
        }
        this.currentRollover = -1;
        this.handleSelectionPressed(sel, e.isShiftDown(), x, y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void handleSelectionPressed(int sel) {
        this.handleSelectionPressed(sel, false, 0, 0);
    }

    private void handleSelectionPressed(int sel, boolean isShiftDown, int x, int y) {
        switch (sel) {
            case 0: {
                if (Editor.avoidMultipleOperations) break;
                this.editor.handleRun(false, this.editor.presentHandler, this.editor.runHandler);
                Editor.avoidMultipleOperations = true;
                break;
            }
            case 3: {
                this.popup = this.menu.getPopupMenu();
                this.popup.show(this, x, y);
                break;
            }
            case 2: {
                try {
                    this.editor.base.handleNew();
                    break;
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            case 4: {
                if (isShiftDown) {
                    this.editor.handleSaveAs();
                    break;
                }
                this.editor.handleSave(false);
                break;
            }
            case 1: {
                if (Editor.avoidMultipleOperations) break;
                this.editor.handleExport(isShiftDown);
                break;
            }
            case 5: {
                if (isShiftDown) {
                    this.editor.handlePlotter();
                    break;
                }
                this.editor.handleSerial();
                break;
            }
        }
    }

    private void activate(int what) {
        if (buttonImages != null) {
            this.setState(what, 2, true);
        }
    }

    public void activateRun() {
        this.activate(0);
    }

    public void activateSave() {
        this.activate(4);
    }

    public void activateExport() {
        this.activate(1);
    }

    private void deactivate(int what) {
        if (buttonImages != null) {
            this.setState(what, 0, true);
        }
    }

    public void deactivateRun() {
        this.deactivate(0);
    }

    public void deactivateSave() {
        this.deactivate(4);
    }

    public void deactivateExport() {
        this.deactivate(1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension((BUTTON_COUNT + 1) * BUTTON_WIDTH, BUTTON_HEIGHT);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Theme.scale(30000), BUTTON_HEIGHT);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.shiftPressed != e.isShiftDown()) {
            this.shiftPressed = !this.shiftPressed;
            this.repaint();
        }
        return false;
    }
}

