/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.transport.SearchTopAnomalyResultAction;
import org.opensearch.ad.transport.SearchTopAnomalyResultRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestSearchTopAnomalyResultAction
extends BaseRestHandler {
    private static final String URL_PATH = String.format(Locale.ROOT, "%s/{%s}/%s/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "results", "_topAnomalies");
    private final String SEARCH_TOP_ANOMALY_DETECTOR_ACTION = "search_top_anomaly_result";

    public String getName() {
        return "search_top_anomaly_result";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!EnabledSetting.isADPluginEnabled()) {
            throw new IllegalStateException("AD plugin is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        SearchTopAnomalyResultRequest searchTopAnomalyResultRequest = this.getSearchTopAnomalyResultRequest(request);
        return channel -> client.execute((ActionType)SearchTopAnomalyResultAction.INSTANCE, (ActionRequest)searchTopAnomalyResultRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private SearchTopAnomalyResultRequest getSearchTopAnomalyResultRequest(RestRequest request) throws IOException {
        if (!request.hasParam("detectorID")) {
            throw new IllegalStateException("AD ID is missing");
        }
        String detectorId = request.param("detectorID");
        boolean historical = request.paramAsBoolean("historical", false);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return SearchTopAnomalyResultRequest.parse(parser, detectorId, historical);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, URL_PATH), (Object)new RestHandler.Route(RestRequest.Method.GET, URL_PATH));
    }
}

