/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.util.Bwc;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class EntityResultRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger LOG = LogManager.getLogger(EntityResultRequest.class);
    private String detectorId;
    private Map<Entity, double[]> entities;
    private long start;
    private long end;

    public EntityResultRequest(StreamInput in) throws IOException {
        super(in);
        this.detectorId = in.readString();
        if (Bwc.supportMultiCategoryFields(in.getVersion())) {
            this.entities = in.readMap(Entity::new, StreamInput::readDoubleArray);
        } else {
            Map oldFormatEntities = in.readMap(StreamInput::readString, StreamInput::readDoubleArray);
            this.entities = new HashMap<Entity, double[]>();
            for (Map.Entry entry : oldFormatEntities.entrySet()) {
                this.entities.put(Entity.createSingleAttributeEntity("", (String)entry.getKey()), (double[])entry.getValue());
            }
        }
        this.start = in.readLong();
        this.end = in.readLong();
    }

    public EntityResultRequest(String detectorId, Map<Entity, double[]> entities, long start, long end) {
        this.detectorId = detectorId;
        this.entities = entities;
        this.start = start;
        this.end = end;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Map<Entity, double[]> getEntities() {
        return this.entities;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.detectorId);
        if (Bwc.supportMultiCategoryFields(out.getVersion())) {
            out.writeMap(this.entities, (s, e) -> e.writeTo(s), StreamOutput::writeDoubleArray);
        } else {
            HashMap<String, double[]> oldFormatEntities = new HashMap<String, double[]>();
            for (Map.Entry<Entity, double[]> entry : this.entities.entrySet()) {
                Map<String, String> attributes = entry.getKey().getAttributes();
                if (attributes.size() != 1) {
                    LOG.info("Skip sending multi-category entities to an incompatible node. Attributes: ", attributes);
                    break;
                }
                oldFormatEntities.put(entry.getKey().getAttributes().entrySet().iterator().next().getValue(), entry.getValue());
            }
            out.writeMap(oldFormatEntities, StreamOutput::writeString, StreamOutput::writeDoubleArray);
        }
        out.writeLong(this.start);
        out.writeLong(this.end);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.detectorId)) {
            validationException = ValidateActions.addValidationError((String)"AD ID is missing", validationException);
        }
        if (this.start <= 0L || this.end <= 0L || this.start > this.end) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "%s: start %d, end %d", "timestamp is invalid", this.start, this.end), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("adID", this.detectorId);
        builder.field("start", this.start);
        builder.field("end", this.end);
        builder.startArray("entities");
        for (Map.Entry<Entity, double[]> entry : this.entities.entrySet()) {
            if (entry.getKey() == null) continue;
            builder.startObject();
            builder.field("entity", (ToXContent)entry.getKey());
            builder.field("value", (Object)entry.getValue());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

