/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.AnomalyDetectorRunner;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.ClientException;
import org.opensearch.ad.common.exception.LimitExceededException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.PreviewAnomalyDetectorAction;
import org.opensearch.ad.transport.PreviewAnomalyDetectorRequest;
import org.opensearch.ad.transport.PreviewAnomalyDetectorResponse;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class PreviewAnomalyDetectorTransportAction
extends HandledTransportAction<PreviewAnomalyDetectorRequest, PreviewAnomalyDetectorResponse> {
    private final Logger logger = LogManager.getLogger(PreviewAnomalyDetectorTransportAction.class);
    private final AnomalyDetectorRunner anomalyDetectorRunner;
    private final ClusterService clusterService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private volatile Integer maxAnomalyFeatures;
    private volatile Boolean filterByEnabled;
    private final ADCircuitBreakerService adCircuitBreakerService;
    private Semaphore lock;

    @Inject
    public PreviewAnomalyDetectorTransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client, AnomalyDetectorRunner anomalyDetectorRunner, NamedXContentRegistry xContentRegistry, ADCircuitBreakerService adCircuitBreakerService) {
        super(PreviewAnomalyDetectorAction.NAME, transportService, actionFilters, PreviewAnomalyDetectorRequest::new);
        this.clusterService = clusterService;
        this.client = client;
        this.anomalyDetectorRunner = anomalyDetectorRunner;
        this.xContentRegistry = xContentRegistry;
        this.maxAnomalyFeatures = (Integer)AnomalyDetectorSettings.MAX_ANOMALY_FEATURES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_ANOMALY_FEATURES, it -> {
            this.maxAnomalyFeatures = it;
        });
        this.filterByEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
        this.adCircuitBreakerService = adCircuitBreakerService;
        this.lock = new Semaphore((Integer)AnomalyDetectorSettings.MAX_CONCURRENT_PREVIEW.get(settings), true);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_CONCURRENT_PREVIEW, it -> {
            this.lock = new Semaphore((int)it);
        });
    }

    protected void doExecute(Task task, PreviewAnomalyDetectorRequest request, ActionListener<PreviewAnomalyDetectorResponse> actionListener) {
        String detectorId = request.getDetectorId();
        User user = ParseUtils.getUserContext(this.client);
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonErrorMessages.FAIL_TO_PREVIEW_DETECTOR);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.resolveUserAndExecute(user, detectorId, this.filterByEnabled, listener, anomalyDetector -> this.previewExecute(request, context, (ActionListener<PreviewAnomalyDetectorResponse>)listener), this.client, this.clusterService, this.xContentRegistry);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    void previewExecute(PreviewAnomalyDetectorRequest request, ThreadContext.StoredContext context, ActionListener<PreviewAnomalyDetectorResponse> listener) {
        block8: {
            if (this.adCircuitBreakerService.isOpen().booleanValue()) {
                listener.onFailure((Exception)new LimitExceededException(request.getDetectorId(), "AD memory circuit is broken.", false));
                return;
            }
            try {
                if (!this.lock.tryAcquire()) {
                    listener.onFailure((Exception)new ClientException(request.getDetectorId(), "Request throttled. Please try again later."));
                    return;
                }
                try {
                    AnomalyDetector detector = request.getDetector();
                    String detectorId = request.getDetectorId();
                    Instant startTime = request.getStartTime();
                    Instant endTime = request.getEndTime();
                    ActionListener releaseListener = ActionListener.runAfter(listener, () -> this.lock.release());
                    if (detector != null) {
                        String error = this.validateDetector(detector);
                        if (StringUtils.isNotBlank((String)error)) {
                            listener.onFailure((Exception)new OpenSearchStatusException(error, RestStatus.BAD_REQUEST, new Object[0]));
                            this.lock.release();
                            return;
                        }
                        this.anomalyDetectorRunner.executeDetector(detector, startTime, endTime, context, this.getPreviewDetectorActionListener((ActionListener<PreviewAnomalyDetectorResponse>)releaseListener, detector));
                        break block8;
                    }
                    this.previewAnomalyDetector((ActionListener<PreviewAnomalyDetectorResponse>)releaseListener, detectorId, detector, startTime, endTime, context);
                }
                catch (Exception e) {
                    this.logger.error("Fail to preview", (Throwable)e);
                    this.lock.release();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                listener.onFailure(e);
            }
        }
    }

    private String validateDetector(AnomalyDetector detector) {
        if (detector.getFeatureAttributes().isEmpty()) {
            return "Can't preview detector without feature";
        }
        return RestHandlerUtils.checkAnomalyDetectorFeaturesSyntax(detector, this.maxAnomalyFeatures);
    }

    private ActionListener<List<AnomalyResult>> getPreviewDetectorActionListener(final ActionListener<PreviewAnomalyDetectorResponse> listener, final AnomalyDetector detector) {
        return ActionListener.wrap((CheckedConsumer)new CheckedConsumer<List<AnomalyResult>, Exception>(){

            public void accept(List<AnomalyResult> anomalyResult) throws Exception {
                PreviewAnomalyDetectorResponse response = new PreviewAnomalyDetectorResponse(anomalyResult, detector);
                listener.onResponse((Object)response);
            }
        }, exception -> {
            this.logger.error("Unexpected error running anomaly detector " + detector.getDetectorId(), (Throwable)exception);
            listener.onFailure((Exception)new OpenSearchStatusException("Unexpected error running anomaly detector " + detector.getDetectorId() + ". " + exception.getMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        });
    }

    private void previewAnomalyDetector(ActionListener<PreviewAnomalyDetectorResponse> listener, String detectorId, AnomalyDetector detector, Instant startTime, Instant endTime, ThreadContext.StoredContext context) throws IOException {
        if (!StringUtils.isBlank((String)detectorId)) {
            GetRequest getRequest = new GetRequest(".opendistro-anomaly-detectors").id(detectorId);
            this.client.get(getRequest, this.onGetAnomalyDetectorResponse(listener, startTime, endTime, context));
        } else {
            this.anomalyDetectorRunner.executeDetector(detector, startTime, endTime, context, this.getPreviewDetectorActionListener(listener, detector));
        }
    }

    private ActionListener<GetResponse> onGetAnomalyDetectorResponse(final ActionListener<PreviewAnomalyDetectorResponse> listener, final Instant startTime, final Instant endTime, final ThreadContext.StoredContext context) {
        return ActionListener.wrap((CheckedConsumer)new CheckedConsumer<GetResponse, Exception>(){

            public void accept(GetResponse response) throws Exception {
                if (!response.isExists()) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Can't find anomaly detector with id:" + response.getId(), RestStatus.NOT_FOUND, new Object[0]));
                    return;
                }
                try {
                    XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(PreviewAnomalyDetectorTransportAction.this.xContentRegistry, response.getSourceAsBytesRef());
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    AnomalyDetector detector = AnomalyDetector.parse(parser, response.getId(), response.getVersion());
                    PreviewAnomalyDetectorTransportAction.this.anomalyDetectorRunner.executeDetector(detector, startTime, endTime, context, PreviewAnomalyDetectorTransportAction.this.getPreviewDetectorActionListener((ActionListener<PreviewAnomalyDetectorResponse>)listener, detector));
                }
                catch (IOException e) {
                    listener.onFailure((Exception)e);
                }
            }
        }, exception -> listener.onFailure((Exception)new AnomalyDetectionException("Could not execute get query to find detector")));
    }
}

