/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.Requests;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.replication.action.update.UpdateIndexReplicationAction;
import org.opensearch.replication.action.update.UpdateIndexReplicationRequest;
import org.opensearch.replication.task.index.IndexReplicationExecutor;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/replication/rest/UpdateIndexHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-cross-cluster-replication"})
public final class UpdateIndexHandler
extends BaseRestHandler {
    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_replication/{index}/_update"));
    }

    @NotNull
    public String getName() {
        return "plugins_index_update_replicate_action";
    }

    @Nullable
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String followIndex = request.param("index");
        IndexReplicationExecutor.Companion.getLog().info(Intrinsics.stringPlus((String)"Update Setting requested for ", (Object)followIndex));
        String[] stringArray = Strings.splitStringByCommaToArray((String)request.param("index"));
        UpdateSettingsRequest updateSettingsRequest = Requests.updateSettingsRequest((String[])Arrays.copyOf(stringArray, stringArray.length));
        updateSettingsRequest.timeout(request.paramAsTime("timeout", updateSettingsRequest.timeout()));
        updateSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", updateSettingsRequest.masterNodeTimeout()));
        updateSettingsRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)updateSettingsRequest.indicesOptions()));
        updateSettingsRequest.fromXContent(request.contentParser());
        Intrinsics.checkNotNullExpressionValue((Object)followIndex, (String)"followIndex");
        Settings settings = updateSettingsRequest.settings();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"updateSettingsRequest.settings()");
        UpdateIndexReplicationRequest updateIndexReplicationRequest = new UpdateIndexReplicationRequest(followIndex, settings);
        return arg_0 -> UpdateIndexHandler.prepareRequest$lambda-0(client, updateIndexReplicationRequest, arg_0);
    }

    private static final void prepareRequest$lambda-0(NodeClient $client, UpdateIndexReplicationRequest $updateIndexReplicationRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)$updateIndexReplicationRequest), (String)"$updateIndexReplicationRequest");
        $client.admin().cluster().execute((ActionType)UpdateIndexReplicationAction.Companion.getINSTANCE(), (ActionRequest)$updateIndexReplicationRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

