/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.common.model.dimension;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BE\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0006H\u00c6\u0003JK\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0014\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020\u001aH\u0016J\u0014\u0010.\u001a\u0006\u0012\u0002\b\u00030/2\u0006\u00100\u001a\u00020\u0017H\u0016J\t\u00101\u001a\u00020\u0006H\u00d6\u0001J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006<"}, d2={"Lorg/opensearch/indexmanagement/common/model/dimension/DateHistogram;", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "sourceField", "", "targetField", "fixedInterval", "calendarInterval", "timezone", "Ljava/time/ZoneId;", "format", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/ZoneId;Ljava/lang/String;)V", "getCalendarInterval", "()Ljava/lang/String;", "getFixedInterval", "getFormat", "getSourceField", "getTargetField", "getTimezone", "()Ljava/time/ZoneId;", "canBeRealizedInMappings", "", "mappings", "", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "getRewrittenAggregation", "Lorg/opensearch/search/aggregations/bucket/histogram/DateHistogramAggregationBuilder;", "aggregationBuilder", "subAggregations", "Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;", "hashCode", "", "toBucketQuery", "Lorg/opensearch/index/query/AbstractQueryBuilder;", "bucketKey", "toSourceBuilder", "Lorg/opensearch/search/aggregations/bucket/composite/CompositeValuesSourceBuilder;", "appendType", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nDateHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateHistogram.kt\norg/opensearch/indexmanagement/common/model/dimension/DateHistogram\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class DateHistogram
extends Dimension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sourceField;
    @NotNull
    private final String targetField;
    @Nullable
    private final String fixedInterval;
    @Nullable
    private final String calendarInterval;
    @NotNull
    private final ZoneId timezone;
    @Nullable
    private final String format;
    @NotNull
    public static final String UTC = "UTC";
    @NotNull
    public static final String FIXED_INTERVAL_FIELD = "fixed_interval";
    @NotNull
    public static final String CALENDAR_INTERVAL_FIELD = "calendar_interval";
    @NotNull
    public static final String DATE_HISTOGRAM_TIMEZONE_FIELD = "timezone";
    @NotNull
    public static final String FORMAT = "format";

    public DateHistogram(@NotNull String sourceField, @NotNull String targetField, @Nullable String fixedInterval, @Nullable String calendarInterval, @NotNull ZoneId timezone, @Nullable String format) {
        Intrinsics.checkNotNullParameter((Object)sourceField, (String)"sourceField");
        Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)DATE_HISTOGRAM_TIMEZONE_FIELD);
        super(Dimension.Type.DATE_HISTOGRAM, sourceField, targetField);
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.fixedInterval = fixedInterval;
        this.calendarInterval = calendarInterval;
        this.timezone = timezone;
        this.format = format;
        if (!(((CharSequence)this.getSourceField()).length() > 0 && ((CharSequence)this.getTargetField()).length() > 0)) {
            boolean $i$a$-require-DateHistogram$42 = false;
            String $i$a$-require-DateHistogram$42 = "Source and target field must not be empty";
            throw new IllegalArgumentException($i$a$-require-DateHistogram$42.toString());
        }
        if (!(this.fixedInterval != null || this.calendarInterval != null)) {
            boolean $i$a$-require-DateHistogram$52 = false;
            String $i$a$-require-DateHistogram$52 = "Must specify a fixed or calendar interval";
            throw new IllegalArgumentException($i$a$-require-DateHistogram$52.toString());
        }
        if (!(this.fixedInterval == null || this.calendarInterval == null)) {
            boolean bl = false;
            String string = "Can only specify a fixed or calendar interval";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ DateHistogram(String string, String string2, String string3, String string4, ZoneId zoneId, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            ZoneId zoneId2 = ZoneId.of(UTC);
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(UTC)");
            zoneId = zoneId2;
        }
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        this(string, string2, string3, string4, zoneId, string5);
    }

    @Override
    @NotNull
    public String getSourceField() {
        return this.sourceField;
    }

    @Override
    @NotNull
    public String getTargetField() {
        return this.targetField;
    }

    @Nullable
    public final String getFixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final String getCalendarInterval() {
        return this.calendarInterval;
    }

    @NotNull
    public final ZoneId getTimezone() {
        return this.timezone;
    }

    @Nullable
    public final String getFormat() {
        return this.format;
    }

    public DateHistogram(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        String string3 = sin.readOptionalString();
        String string4 = sin.readOptionalString();
        ZoneId zoneId = sin.readZoneId();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"sin.readZoneId()");
        this(string, string2, string3, string4, zoneId, null, 32, null);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().startObject(this.getType().getType());
        if (this.fixedInterval != null) {
            builder.field(FIXED_INTERVAL_FIELD, this.fixedInterval);
        }
        if (this.calendarInterval != null) {
            builder.field(CALENDAR_INTERVAL_FIELD, this.calendarInterval);
        }
        XContentBuilder xContentBuilder = builder.field("source_field", this.getSourceField()).field("target_field", this.getTargetField()).field(DATE_HISTOGRAM_TIMEZONE_FIELD, this.timezone.getId()).field(FORMAT, this.format).endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(DIMENSION_\u2026\n            .endObject()");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getSourceField());
        out.writeString(this.getTargetField());
        out.writeOptionalString(this.fixedInterval);
        out.writeOptionalString(this.calendarInterval);
        out.writeZoneId(this.timezone);
    }

    @Override
    @NotNull
    public CompositeValuesSourceBuilder<?> toSourceBuilder(boolean appendType) {
        String it;
        DateHistogramValuesSourceBuilder dateHistogramValuesSourceBuilder;
        String calendarInterval = this.calendarInterval;
        String fixedInterval = this.fixedInterval;
        String name = appendType ? this.getTargetField() + "." + Dimension.Type.DATE_HISTOGRAM.getType() : this.getTargetField();
        DateHistogramValuesSourceBuilder $this$toSourceBuilder_u24lambda_u246 = dateHistogramValuesSourceBuilder = ((DateHistogramValuesSourceBuilder)((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder(name).missingBucket(true)).field(this.getSourceField())).timeZone(this.timezone);
        boolean bl = false;
        String string = calendarInterval;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$toSourceBuilder_u24lambda_u246.calendarInterval(new DateHistogramInterval(it));
        }
        String string2 = fixedInterval;
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$toSourceBuilder_u24lambda_u246.fixedInterval(new DateHistogramInterval(it));
        }
        String string3 = this.format;
        if (string3 != null) {
            String it2 = string3;
            boolean bl4 = false;
            $this$toSourceBuilder_u24lambda_u246.format(it2);
        }
        DateHistogramValuesSourceBuilder dateHistogramValuesSourceBuilder2 = dateHistogramValuesSourceBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)dateHistogramValuesSourceBuilder2, (String)"DateHistogramValuesSourc\u2026          }\n            }");
        return (CompositeValuesSourceBuilder)dateHistogramValuesSourceBuilder2;
    }

    @Override
    @NotNull
    public AbstractQueryBuilder<?> toBucketQuery(@NotNull Object bucketKey) {
        Intrinsics.checkNotNullParameter((Object)bucketKey, (String)"bucketKey");
        if (!(bucketKey instanceof Long)) {
            throw new IllegalArgumentException("Received invalid date histogram bucket key type [" + Reflection.getOrCreateKotlinClass(bucketKey.getClass()) + "] when Long is expected.");
        }
        String string = this.fixedInterval;
        if (string == null) {
            string = this.calendarInterval;
        }
        long interval = new DateHistogramInterval(string).estimateMillis();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(this.getSourceField()).from(bucketKey, true).to((Object)(((Number)bucketKey).longValue() + interval), false).timeZone(this.timezone.toString()).format("epoch_millis");
        Intrinsics.checkNotNullExpressionValue((Object)rangeQueryBuilder, (String)"RangeQueryBuilder(source\u2026  .format(\"epoch_millis\")");
        return (AbstractQueryBuilder)rangeQueryBuilder;
    }

    @Override
    public boolean canBeRealizedInMappings(@NotNull Map<String, ? extends Object> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Map<?, ?> map = IndexUtils.Companion.getFieldFromMappings(this.getSourceField(), mappings);
        if (map == null || (map = map.get("type")) == null) {
            return false;
        }
        Map<?, ?> fieldType = map;
        return Intrinsics.areEqual((Object)"date", fieldType);
    }

    @NotNull
    public final DateHistogramAggregationBuilder getRewrittenAggregation(@NotNull DateHistogramAggregationBuilder aggregationBuilder, @NotNull AggregatorFactories.Builder subAggregations) {
        DateHistogramInterval dateHistogramInterval;
        DateHistogramInterval dateHistogramInterval2;
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder;
        Intrinsics.checkNotNullParameter((Object)aggregationBuilder, (String)"aggregationBuilder");
        Intrinsics.checkNotNullParameter((Object)subAggregations, (String)"subAggregations");
        DateHistogramAggregationBuilder it = dateHistogramAggregationBuilder = new DateHistogramAggregationBuilder(aggregationBuilder.getName());
        boolean bl = false;
        DateHistogramInterval dateHistogramInterval3 = dateHistogramInterval2 = aggregationBuilder.getCalendarInterval();
        if (dateHistogramInterval3 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)dateHistogramInterval3, (String)"calendarInterval");
            DateHistogramInterval $this$getRewrittenAggregation_u24lambda_u248_u24lambda_u247 = dateHistogramInterval = dateHistogramInterval2;
            boolean bl2 = false;
            it.calendarInterval($this$getRewrittenAggregation_u24lambda_u248_u24lambda_u247);
        }
        it = dateHistogramAggregationBuilder;
        boolean bl3 = false;
        DateHistogramInterval dateHistogramInterval4 = dateHistogramInterval2 = aggregationBuilder.getFixedInterval();
        if (dateHistogramInterval4 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)dateHistogramInterval4, (String)"fixedInterval");
            DateHistogramInterval $this$getRewrittenAggregation_u24lambda_u2410_u24lambda_u249 = dateHistogramInterval = dateHistogramInterval2;
            boolean bl4 = false;
            it.fixedInterval($this$getRewrittenAggregation_u24lambda_u2410_u24lambda_u249);
        }
        it = dateHistogramAggregationBuilder;
        boolean bl5 = false;
        DateHistogramInterval dateHistogramInterval5 = dateHistogramInterval2 = aggregationBuilder.extendedBounds();
        if (dateHistogramInterval5 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)dateHistogramInterval5, (String)"extendedBounds()");
            DateHistogramInterval $this$getRewrittenAggregation_u24lambda_u2412_u24lambda_u2411 = dateHistogramInterval = dateHistogramInterval2;
            boolean bl6 = false;
            it.extendedBounds((LongBounds)$this$getRewrittenAggregation_u24lambda_u2412_u24lambda_u2411);
        }
        it = dateHistogramAggregationBuilder = dateHistogramAggregationBuilder.keyed(aggregationBuilder.keyed());
        boolean bl7 = false;
        if (aggregationBuilder.minDocCount() >= 0L) {
            it.minDocCount(aggregationBuilder.minDocCount());
        }
        it = dateHistogramAggregationBuilder = dateHistogramAggregationBuilder.offset(aggregationBuilder.offset());
        boolean bl8 = false;
        DateHistogramInterval dateHistogramInterval6 = dateHistogramInterval2 = aggregationBuilder.order();
        if (dateHistogramInterval6 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)dateHistogramInterval6, (String)"order()");
            DateHistogramInterval $this$getRewrittenAggregation_u24lambda_u2415_u24lambda_u2414 = dateHistogramInterval = dateHistogramInterval2;
            boolean bl9 = false;
            it.order((BucketOrder)$this$getRewrittenAggregation_u24lambda_u2415_u24lambda_u2414);
        }
        AbstractAggregationBuilder abstractAggregationBuilder = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)dateHistogramAggregationBuilder.field(this.getTargetField() + ".date_histogram")).timeZone(this.timezone)).subAggregations(subAggregations);
        Intrinsics.checkNotNullExpressionValue((Object)abstractAggregationBuilder, (String)"DateHistogramAggregation\u2026egations(subAggregations)");
        return (DateHistogramAggregationBuilder)abstractAggregationBuilder;
    }

    @NotNull
    public final String component1() {
        return this.sourceField;
    }

    @NotNull
    public final String component2() {
        return this.targetField;
    }

    @Nullable
    public final String component3() {
        return this.fixedInterval;
    }

    @Nullable
    public final String component4() {
        return this.calendarInterval;
    }

    @NotNull
    public final ZoneId component5() {
        return this.timezone;
    }

    @Nullable
    public final String component6() {
        return this.format;
    }

    @NotNull
    public final DateHistogram copy(@NotNull String sourceField, @NotNull String targetField, @Nullable String fixedInterval, @Nullable String calendarInterval, @NotNull ZoneId timezone, @Nullable String format) {
        Intrinsics.checkNotNullParameter((Object)sourceField, (String)"sourceField");
        Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)DATE_HISTOGRAM_TIMEZONE_FIELD);
        return new DateHistogram(sourceField, targetField, fixedInterval, calendarInterval, timezone, format);
    }

    public static /* synthetic */ DateHistogram copy$default(DateHistogram dateHistogram, String string, String string2, String string3, String string4, ZoneId zoneId, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = dateHistogram.sourceField;
        }
        if ((n & 2) != 0) {
            string2 = dateHistogram.targetField;
        }
        if ((n & 4) != 0) {
            string3 = dateHistogram.fixedInterval;
        }
        if ((n & 8) != 0) {
            string4 = dateHistogram.calendarInterval;
        }
        if ((n & 0x10) != 0) {
            zoneId = dateHistogram.timezone;
        }
        if ((n & 0x20) != 0) {
            string5 = dateHistogram.format;
        }
        return dateHistogram.copy(string, string2, string3, string4, zoneId, string5);
    }

    @NotNull
    public String toString() {
        return "DateHistogram(sourceField=" + this.sourceField + ", targetField=" + this.targetField + ", fixedInterval=" + this.fixedInterval + ", calendarInterval=" + this.calendarInterval + ", timezone=" + this.timezone + ", format=" + this.format + ")";
    }

    public int hashCode() {
        int result2 = this.sourceField.hashCode();
        result2 = result2 * 31 + this.targetField.hashCode();
        result2 = result2 * 31 + (this.fixedInterval == null ? 0 : this.fixedInterval.hashCode());
        result2 = result2 * 31 + (this.calendarInterval == null ? 0 : this.calendarInterval.hashCode());
        result2 = result2 * 31 + this.timezone.hashCode();
        result2 = result2 * 31 + (this.format == null ? 0 : this.format.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateHistogram)) {
            return false;
        }
        DateHistogram dateHistogram = (DateHistogram)other;
        if (!Intrinsics.areEqual((Object)this.sourceField, (Object)dateHistogram.sourceField)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetField, (Object)dateHistogram.targetField)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fixedInterval, (Object)dateHistogram.fixedInterval)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.calendarInterval, (Object)dateHistogram.calendarInterval)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timezone, (Object)dateHistogram.timezone)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.format, (Object)dateHistogram.format);
    }

    @JvmStatic
    @NotNull
    public static final DateHistogram parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final DateHistogram readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/indexmanagement/common/model/dimension/DateHistogram$Companion;", "", "()V", "CALENDAR_INTERVAL_FIELD", "", "DATE_HISTOGRAM_TIMEZONE_FIELD", "FIXED_INTERVAL_FIELD", "FORMAT", "UTC", "parse", "Lorg/opensearch/indexmanagement/common/model/dimension/DateHistogram;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nDateHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateHistogram.kt\norg/opensearch/indexmanagement/common/model/dimension/DateHistogram$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DateHistogram parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String sourceField = null;
            String targetField = null;
            String fixedInterval = null;
            String calendarInterval = null;
            ZoneId timezone = ZoneId.of(DateHistogram.UTC);
            String format = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block26: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block26;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1078898384: {
                            if (string.equals(DateHistogram.FIXED_INTERVAL_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case 1658170326: {
                            if (string.equals("source_field")) {
                                n = 2;
                            }
                            break;
                        }
                        case -210221876: {
                            if (string.equals("target_field")) {
                                n = 3;
                            }
                            break;
                        }
                        case -2076227591: {
                            if (string.equals(DateHistogram.DATE_HISTOGRAM_TIMEZONE_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case -1268779017: {
                            if (string.equals(DateHistogram.FORMAT)) {
                                n = 5;
                            }
                            break;
                        }
                        case -2022055770: {
                            if (string.equals(DateHistogram.CALENDAR_INTERVAL_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            fixedInterval = xcp.text();
                            continue block16;
                        }
                        case 6: {
                            calendarInterval = xcp.text();
                            continue block16;
                        }
                        case 4: {
                            timezone = ZoneId.of(xcp.text());
                            continue block16;
                        }
                        case 2: {
                            sourceField = xcp.text();
                            continue block16;
                        }
                        case 3: {
                            targetField = xcp.text();
                            continue block16;
                        }
                        case 5: {
                            format = xcp.textOrNull();
                            continue block16;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in date histogram");
            }
            if (targetField == null) {
                targetField = sourceField;
            }
            String string = sourceField;
            if (string == null) {
                boolean $i$a$-requireNotNull-DateHistogram$Companion$parse$32 = false;
                String $i$a$-requireNotNull-DateHistogram$Companion$parse$32 = "Source field must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-DateHistogram$Companion$parse$32.toString());
            }
            String string2 = targetField;
            if (string2 == null) {
                String string3 = string;
                boolean bl = false;
                String string4 = string3;
                String string5 = "Target field must not be null";
                throw new IllegalArgumentException(string5.toString());
            }
            ZoneId zoneId = timezone;
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)DateHistogram.DATE_HISTOGRAM_TIMEZONE_FIELD);
            String string6 = format;
            ZoneId zoneId2 = zoneId;
            String string7 = calendarInterval;
            String string8 = fixedInterval;
            String string9 = string2;
            String string10 = string;
            return new DateHistogram(string10, string9, string8, string7, zoneId2, string6);
        }

        @JvmStatic
        @NotNull
        public final DateHistogram readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new DateHistogram(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

